// ****************************************************************************
//
//          Aevol - An in silico experimental evolution platform
//
// ****************************************************************************
//
// Copyright: See the AUTHORS file provided with the package or <www.aevol.fr>
// Web: http://www.aevol.fr/
// E-mail: See <http://www.aevol.fr/contact/>
// Original Authors : Guillaume Beslon, Carole Knibbe, David Parsons
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
// ****************************************************************************

#ifndef AEVOL_GENOME_LIMITS_H_
#define AEVOL_GENOME_LIMITS_H_

#include "ae_types.h"

namespace aevol {

class GenomeLimits {
 public:
  GenomeLimits()                               = default;
  GenomeLimits(const GenomeLimits&)            = default;
  GenomeLimits(GenomeLimits&&)                 = default;
  GenomeLimits& operator=(const GenomeLimits&) = default;
  GenomeLimits& operator=(GenomeLimits&&)      = default;
  virtual ~GenomeLimits()                      = default;

  GenomeLimits(aevol::dna_size_type min_genome_size, aevol::dna_size_type max_genome_size)
      : min_genome_size_(min_genome_size), max_genome_size_(max_genome_size) {}

  auto min_genome_size() const { return min_genome_size_; };
  auto max_genome_size() const { return max_genome_size_; };

 protected:
  aevol::dna_size_type min_genome_size_;
  aevol::dna_size_type max_genome_size_;
};

}  // namespace aevol

#endif  // AEVOL_GENOME_LIMITS_H_
