// ****************************************************************************
//
//          Aevol - An in silico experimental evolution platform
//
// ****************************************************************************
//
// Copyright: See the AUTHORS file provided with the package or <www.aevol.fr>
// Web: http://www.aevol.fr/
// E-mail: See <http://www.aevol.fr/contact/>
// Original Authors : Guillaume Beslon, Carole Knibbe, David Parsons
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
// ****************************************************************************

#ifndef AEVOL_EUKARYOTE_INDIVIDUAL_MUTATOR_H_
#define AEVOL_EUKARYOTE_INDIVIDUAL_MUTATOR_H_

#include "IndividualMutator.h"

#include "biochemistry/GenomeLimits.h"

namespace aevol {

class EukaryoteIndividualMutator: public IndividualMutator {
 public:
  EukaryoteIndividualMutator()                                             = delete;
  EukaryoteIndividualMutator(const EukaryoteIndividualMutator&)            = delete;
  EukaryoteIndividualMutator(EukaryoteIndividualMutator&&)                 = delete;
  EukaryoteIndividualMutator& operator=(const EukaryoteIndividualMutator&) = delete;
  EukaryoteIndividualMutator& operator=(EukaryoteIndividualMutator&&)      = delete;
  virtual ~EukaryoteIndividualMutator()                                    = default;

  EukaryoteIndividualMutator(const Individual& indiv,
                             std::shared_ptr<MutationParams> mut_params,
                             const GenomeLimits& genome_limits);

  auto has_mutations() const -> bool override;

  void generate_mutations(JumpingMT& prng) override;

  auto apply_mutations(Individual& indiv) -> std::list<std::unique_ptr<MutationReport>> override;
  void apply_mutations(Individual& indiv, indiv_id_type, PhylogeneticTreeHandler*) override;

 protected:
  std::array<std::unique_ptr<DnaMutator>, 2> dna_mutator_;
};

}  // namespace aevol

#endif  // AEVOL_EUKARYOTE_INDIVIDUAL_MUTATOR_H_
