#include <gtest/gtest.h>

#include <filesystem>

#include "aevol.h"

namespace fs = std::filesystem;
using namespace aevol;

TEST(EvolutionRunnerTest, OpenDefaultFromTime) {
  auto checkpoint_explorer = EvolutionRunner::make_from_checkpoint(100);
}

TEST(EvolutionRunnerTest, OpenDefaultFromFileName) {
  auto checkpoint_explorer =
      EvolutionRunner::make_from_checkpoint_path("./checkpoints/checkpoint_000000100/checkpoint_000000100.ae");
}

TEST(EvolutionRunnerTest, OpenCustomYetCanonical) {
  auto checkpoint_explorer =
      EvolutionRunner::make_from_checkpoint_path("./ckpts/ckpt/my_checkpoint_100.ae");
}

TEST(EvolutionRunnerTest, OpenCustom) {
  auto checkpoint_explorer =
      EvolutionRunner::make_from_checkpoint_path("./ckpts/custom_ckpt/foo.ae");
}
