#
# Script designed to be tested from inside the CamiTK Python interpreter using PythonManager::runScript
# See TestPythonScript.cpp
# 
# The requirements (if any) must defined in the the QRC file
#
# To test from outside the CamiTK interpreter
# - cd build
# - tmpDir=$(mktemp -d)
# - python -m venv $tmpDir/.venv
# - ln -s /usr/lib/python3/dist-packages/vtkmodules $tmpDir/.venv/lib/python3.12/site-packages
# - ln -s /usr/lib/python3/dist-packages/vtk.py $tmpDir/.venv/lib/python3.12/site-packages
# - $tmpDir/.venv/bin/pip install numpy setuptools
# - cp ../sdk/libraries/core/testing/resources/test_vtk.py $tmpDir
# - PYTHONPATH=lib LD_PRELOAD=/lib/x86_64-linux-gnu/libpython3.12.so.1.0 $tmpDir/.venv/bin/python -m $tmpDir/test_vtk.py
#
# To test from ctest:
# - ctest -VV -R test-pythonscript-vtk
#
# WARNING: do NOT call the script just vtk.py, otherwise python will not be able to load the vtk package!
#
import camitk
import vtkmodules.all as vtk
from vtk.util import numpy_support

camitk.info("CamiTK version: " + camitk.__version__)

sphere = vtk.vtkSphereSource()
sphere.SetRadius(50.0)
sphere.SetThetaResolution(32)
sphere.SetPhiResolution(32)
sphere.Update()

polydata = sphere.GetOutput()

points = numpy_support.vtk_to_numpy(polydata.GetPoints().GetData())

# Each row = [3, p0, p1, p2] -> meaning "triangle with 3 points"
# Here no cell type, only count + point ids
polys = numpy_support.vtk_to_numpy(polydata.GetPolys().GetData()).reshape(-1, 4) # (n_triangles, 4)

expected_points_size = 962 # (theta-1)*(phi-1) + 1
actual_points_size = len(points.tolist())
assert actual_points_size == expected_points_size, f"There must be {expected_points_size} points not {actual_points_size}"

expected_polys_size = 1920
actual_polys_size = len(polys.tolist())
assert actual_polys_size == expected_polys_size, f"There must be {expected_polys_size} triangles not {actual_polys_size}"

msh = camitk.newMeshComponentFromNumpy("Sphere from VTK", points, polys)

msh_points_size = len(msh.getPointSetAsNumpy())
assert msh_points_size == expected_points_size, f"The component mesh must have {expected_points_size} points not {msh_points_size}"
