/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2025 Univ. Grenoble Alpes, CNRS, Grenoble INP - UGA, TIMC, 38000 Grenoble, France
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/

#include "SplashScreen.h"

#include "Core.h"

#include <QCoreApplication>
#include <QVBoxLayout>
#include <QRegularExpression>

using namespace camitk;

// -------------------- Constructor --------------------
SplashScreen::SplashScreen(QWidget* parent) : QWidget(parent) {
    setFixedSize(450, 200);
    setWindowFlags(Qt::FramelessWindowHint);

    // full background (so it does not look like a regular widget)
    // note: using the same gradient as the 3D viewer
    setStyleSheet(R"(
        QWidget {
            background: qlineargradient(
                spread:pad,
                x1:0, y1:0, x2:0, y2:1,
                stop:0 white,
                stop:1 rgb(210, 210, 235)
            );
        }
    )");

    // Main layout
    QVBoxLayout* mainLayout = new QVBoxLayout(this);
    mainLayout->setSpacing(10);
    mainLayout->setContentsMargins(20, 30, 20, 20);

    // Top widget for gradient + logo/text
    QWidget* titleWidget = new QWidget(this);
    titleWidget->setFixedHeight(100);
    // topHalf->setSizePolicy(QSizePolicy::Expanding, QSizePolicy::Fixed);
    titleWidget->setAttribute(Qt::WA_TranslucentBackground); // so that the full background gradient is not visible

    // App name + version and logo layout
    QLabel* appNameLabel = new QLabel(QCoreApplication::applicationName());
    QFont appNameFont = appNameLabel->font();
    appNameFont.setPointSize(24);
    appNameFont.setBold(true);
    appNameLabel->setFont(appNameFont);
    appNameLabel->setAlignment(Qt::AlignCenter);
    appNameLabel->setAttribute(Qt::WA_TranslucentBackground);
    QString version = QString(Core::version()).replace(QRegularExpression(R"(\w+ ([0-9]+\.[0-9]+\.\w+).*)"), R"(\1)");
    QLabel* versionLabel = new QLabel(version);
    QFont versionFont = versionLabel->font();
    versionFont.setPointSize(11);
    versionLabel->setFont(versionFont);
    versionLabel->setAlignment(Qt::AlignCenter);
    versionLabel->setAttribute(Qt::WA_TranslucentBackground);
    QVBoxLayout* appNameLayout = new QVBoxLayout();
    appNameLayout->setContentsMargins(20, 15, 20, 15); // Set margins to add space at the top and bottom
    appNameLayout->setSpacing(5);  // Small spacing between title and subtitle
    appNameLayout->setAlignment(Qt::AlignCenter);
    appNameLayout->addWidget(appNameLabel);
    appNameLayout->addWidget(versionLabel);

    QLabel* logo = new QLabel;
    QPixmap pixmap(":/camiTKSmallIcon");
    logo->setPixmap(pixmap.scaled(50, 50, Qt::KeepAspectRatio, Qt::SmoothTransformation));
    logo->setAttribute(Qt::WA_TranslucentBackground);

    QHBoxLayout* titleLayout = new QHBoxLayout();
    titleLayout->setAlignment(Qt::AlignCenter);
    titleLayout->addLayout(appNameLayout);
    titleLayout->addSpacing(10);
    titleLayout->addWidget(logo);
    titleWidget->setLayout(titleLayout);

    // Progress bar
    progressBar = new QProgressBar();
    progressBar->setFixedHeight(30);
    progressBar->setFixedWidth(int(width() * 0.8));
    progressBar->setRange(0, 100);
    progressBar->setValue(0);

    // Message label
    messageLabel = new QLabel("Starting...");
    messageLabel->setAlignment(Qt::AlignCenter);
    messageLabel->setAttribute(Qt::WA_TranslucentBackground);
    messageLabel->setWordWrap(true);

    mainLayout->addWidget(titleWidget);
    mainLayout->addWidget(progressBar, 0, Qt::AlignCenter);
    mainLayout->addWidget(messageLabel);
}

// -------------------- setProgress --------------------
void SplashScreen::setProgress(int value) {
    progressBar->setValue(value);
    QCoreApplication::processEvents();
}

/// -------------------- showMessage --------------------
void SplashScreen::showMessage(const QString& message) {
    messageLabel->setText(message);
    QCoreApplication::processEvents();
}
