//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armdatamigration

import "time"

// APIError - Error information.
type APIError struct {
	// Error information in OData format
	Error *ODataError

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData
}

// AvailableServiceSKU - Describes the available service SKU.
type AvailableServiceSKU struct {
	// A description of the scaling capacities of the SKU
	Capacity *AvailableServiceSKUCapacity

	// The resource type, including the provider namespace
	ResourceType *string

	// SKU name, tier, etc.
	SKU *AvailableServiceSKUSKU
}

// AvailableServiceSKUCapacity - A description of the scaling capacities of the SKU
type AvailableServiceSKUCapacity struct {
	// The default capacity
	Default *int32

	// The maximum capacity
	Maximum *int32

	// The minimum capacity, usually 0 or 1.
	Minimum *int32

	// The scalability approach
	ScaleType *ServiceScalability
}

// AvailableServiceSKUSKU - SKU name, tier, etc.
type AvailableServiceSKUSKU struct {
	// SKU family
	Family *string

	// The name of the SKU
	Name *string

	// SKU size
	Size *string

	// The tier of the SKU, such as "Basic", "General Purpose", or "Business Critical"
	Tier *string
}

// AzureActiveDirectoryApp - Azure Active Directory Application
type AzureActiveDirectoryApp struct {
	// REQUIRED; Key used to authenticate to the Azure Active Directory Application
	AppKey *string

	// REQUIRED; Application ID of the Azure Active Directory Application
	ApplicationID *string

	// REQUIRED; Tenant id of the customer
	TenantID *string
}

// BackupFileInfo - Information of the backup file
type BackupFileInfo struct {
	// Sequence number of the backup file in the backup set
	FamilySequenceNumber *int32

	// Location of the backup file in shared folder
	FileLocation *string

	// Status of the backup file during migration
	Status *BackupFileStatus
}

// BackupSetInfo - Information of backup set
type BackupSetInfo struct {
	// Date and time that the backup operation finished
	BackupFinishedDate *time.Time

	// Id for the set of backup files
	BackupSetID *string

	// Date and time that the backup operation began
	BackupStartDate *time.Time

	// Enum of the different backup types
	BackupType *BackupType

	// Name of the database to which the backup set belongs
	DatabaseName *string

	// First log sequence number of the backup file
	FirstLsn *string

	// Whether the backup set is restored or not
	IsBackupRestored *bool

	// Last log sequence number of the backup file
	LastLsn *string

	// Last modified time of the backup file in share location
	LastModifiedTime *time.Time

	// List of files in the backup set
	ListOfBackupFiles []*BackupFileInfo
}

// BlobShare - Blob container storage information.
type BlobShare struct {
	// REQUIRED; SAS URI of Azure Storage Account Container.
	SasURI *string
}

// CheckOCIDriverTaskInput - Input for the service task to check for OCI drivers.
type CheckOCIDriverTaskInput struct {
	// Version of the source server to check against. Optional.
	ServerVersion *string
}

// CheckOCIDriverTaskOutput - Output for the service task to check for OCI drivers.
type CheckOCIDriverTaskOutput struct {
	// Information about the installed driver if found and valid.
	InstalledDriver *OracleOCIDriverInfo

	// READ-ONLY; Validation errors
	ValidationErrors []*ReportableException
}

// CheckOCIDriverTaskProperties - Properties for the task that checks for OCI drivers.
type CheckOCIDriverTaskProperties struct {
	// REQUIRED; Task type.
	TaskType *string

	// Key value pairs of client data to attach meta data information to task
	ClientData map[string]*string

	// Input for the service task to check for OCI drivers.
	Input *CheckOCIDriverTaskInput

	// READ-ONLY; Array of command properties.
	Commands []CommandPropertiesClassification

	// READ-ONLY; Array of errors. This is ignored if submitted.
	Errors []*ODataError

	// READ-ONLY; Task output. This is ignored if submitted.
	Output []*CheckOCIDriverTaskOutput

	// READ-ONLY; The state of the task. This is ignored if submitted.
	State *TaskState
}

// GetProjectTaskProperties implements the ProjectTaskPropertiesClassification interface for type CheckOCIDriverTaskProperties.
func (c *CheckOCIDriverTaskProperties) GetProjectTaskProperties() *ProjectTaskProperties {
	return &ProjectTaskProperties{
		ClientData: c.ClientData,
		Commands:   c.Commands,
		Errors:     c.Errors,
		State:      c.State,
		TaskType:   c.TaskType,
	}
}

// CommandProperties - Base class for all types of DMS command properties. If command is not supported by current client,
// this object is returned.
type CommandProperties struct {
	// REQUIRED; Command type.
	CommandType *string

	// READ-ONLY; Array of errors. This is ignored if submitted.
	Errors []*ODataError

	// READ-ONLY; The state of the command. This is ignored if submitted.
	State *CommandState
}

// GetCommandProperties implements the CommandPropertiesClassification interface for type CommandProperties.
func (c *CommandProperties) GetCommandProperties() *CommandProperties { return c }

// ConnectToMongoDbTaskProperties - Properties for the task that validates the connection to and provides information about
// a MongoDB server
type ConnectToMongoDbTaskProperties struct {
	// REQUIRED; Task type.
	TaskType *string

	// Key value pairs of client data to attach meta data information to task
	ClientData map[string]*string

	// Describes a connection to a MongoDB data source
	Input *MongoDbConnectionInfo

	// READ-ONLY; Array of command properties.
	Commands []CommandPropertiesClassification

	// READ-ONLY; Array of errors. This is ignored if submitted.
	Errors []*ODataError

	// READ-ONLY; An array containing a single MongoDbClusterInfo object
	Output []*MongoDbClusterInfo

	// READ-ONLY; The state of the task. This is ignored if submitted.
	State *TaskState
}

// GetProjectTaskProperties implements the ProjectTaskPropertiesClassification interface for type ConnectToMongoDbTaskProperties.
func (c *ConnectToMongoDbTaskProperties) GetProjectTaskProperties() *ProjectTaskProperties {
	return &ProjectTaskProperties{
		ClientData: c.ClientData,
		Commands:   c.Commands,
		Errors:     c.Errors,
		State:      c.State,
		TaskType:   c.TaskType,
	}
}

// ConnectToSourceMySQLTaskInput - Input for the task that validates MySQL database connection
type ConnectToSourceMySQLTaskInput struct {
	// REQUIRED; Information for connecting to MySQL source
	SourceConnectionInfo *MySQLConnectionInfo

	// Permission group for validations
	CheckPermissionsGroup *ServerLevelPermissionsGroup

	// Flag for whether or not the migration is offline
	IsOfflineMigration *bool

	// Target Platform for the migration
	TargetPlatform *MySQLTargetPlatformType
}

// ConnectToSourceMySQLTaskProperties - Properties for the task that validates MySQL database connection
type ConnectToSourceMySQLTaskProperties struct {
	// REQUIRED; Task type.
	TaskType *string

	// Key value pairs of client data to attach meta data information to task
	ClientData map[string]*string

	// Task input
	Input *ConnectToSourceMySQLTaskInput

	// READ-ONLY; Array of command properties.
	Commands []CommandPropertiesClassification

	// READ-ONLY; Array of errors. This is ignored if submitted.
	Errors []*ODataError

	// READ-ONLY; Task output. This is ignored if submitted.
	Output []*ConnectToSourceNonSQLTaskOutput

	// READ-ONLY; The state of the task. This is ignored if submitted.
	State *TaskState
}

// GetProjectTaskProperties implements the ProjectTaskPropertiesClassification interface for type ConnectToSourceMySQLTaskProperties.
func (c *ConnectToSourceMySQLTaskProperties) GetProjectTaskProperties() *ProjectTaskProperties {
	return &ProjectTaskProperties{
		ClientData: c.ClientData,
		Commands:   c.Commands,
		Errors:     c.Errors,
		State:      c.State,
		TaskType:   c.TaskType,
	}
}

// ConnectToSourceNonSQLTaskOutput - Output for connect to MySQL type source
type ConnectToSourceNonSQLTaskOutput struct {
	// READ-ONLY; List of databases on the server
	Databases []*string

	// READ-ONLY; Result identifier
	ID *string

	// READ-ONLY; Server properties
	ServerProperties *ServerProperties

	// READ-ONLY; Server brand version
	SourceServerBrandVersion *string

	// READ-ONLY; Validation errors associated with the task
	ValidationErrors []*ReportableException
}

// ConnectToSourceOracleSyncTaskInput - Input for the task that validates Oracle database connection
type ConnectToSourceOracleSyncTaskInput struct {
	// REQUIRED; Information for connecting to Oracle source
	SourceConnectionInfo *OracleConnectionInfo
}

// ConnectToSourceOracleSyncTaskOutput - Output for the task that validates Oracle database connection
type ConnectToSourceOracleSyncTaskOutput struct {
	// READ-ONLY; List of schemas on source server
	Databases []*string

	// READ-ONLY; Source server brand version
	SourceServerBrandVersion *string

	// READ-ONLY; Version of the source server
	SourceServerVersion *string

	// READ-ONLY; Validation errors associated with the task
	ValidationErrors []*ReportableException
}

// ConnectToSourceOracleSyncTaskProperties - Properties for the task that validates Oracle database connection
type ConnectToSourceOracleSyncTaskProperties struct {
	// REQUIRED; Task type.
	TaskType *string

	// Key value pairs of client data to attach meta data information to task
	ClientData map[string]*string

	// Task input
	Input *ConnectToSourceOracleSyncTaskInput

	// READ-ONLY; Array of command properties.
	Commands []CommandPropertiesClassification

	// READ-ONLY; Array of errors. This is ignored if submitted.
	Errors []*ODataError

	// READ-ONLY; Task output. This is ignored if submitted.
	Output []*ConnectToSourceOracleSyncTaskOutput

	// READ-ONLY; The state of the task. This is ignored if submitted.
	State *TaskState
}

// GetProjectTaskProperties implements the ProjectTaskPropertiesClassification interface for type ConnectToSourceOracleSyncTaskProperties.
func (c *ConnectToSourceOracleSyncTaskProperties) GetProjectTaskProperties() *ProjectTaskProperties {
	return &ProjectTaskProperties{
		ClientData: c.ClientData,
		Commands:   c.Commands,
		Errors:     c.Errors,
		State:      c.State,
		TaskType:   c.TaskType,
	}
}

// ConnectToSourcePostgreSQLSyncTaskInput - Input for the task that validates connection to PostgreSQL and source server requirements
type ConnectToSourcePostgreSQLSyncTaskInput struct {
	// REQUIRED; Connection information for source PostgreSQL server
	SourceConnectionInfo *PostgreSQLConnectionInfo
}

// ConnectToSourcePostgreSQLSyncTaskOutput - Output for the task that validates connection to PostgreSQL and source server
// requirements
type ConnectToSourcePostgreSQLSyncTaskOutput struct {
	// READ-ONLY; List of databases on source server
	Databases []*string

	// READ-ONLY; Result identifier
	ID *string

	// READ-ONLY; Source server brand version
	SourceServerBrandVersion *string

	// READ-ONLY; Version of the source server
	SourceServerVersion *string

	// READ-ONLY; Validation errors associated with the task
	ValidationErrors []*ReportableException
}

// ConnectToSourcePostgreSQLSyncTaskProperties - Properties for the task that validates connection to PostgreSQL server and
// source server requirements for online migration
type ConnectToSourcePostgreSQLSyncTaskProperties struct {
	// REQUIRED; Task type.
	TaskType *string

	// Key value pairs of client data to attach meta data information to task
	ClientData map[string]*string

	// Task input
	Input *ConnectToSourcePostgreSQLSyncTaskInput

	// READ-ONLY; Array of command properties.
	Commands []CommandPropertiesClassification

	// READ-ONLY; Array of errors. This is ignored if submitted.
	Errors []*ODataError

	// READ-ONLY; Task output. This is ignored if submitted.
	Output []*ConnectToSourcePostgreSQLSyncTaskOutput

	// READ-ONLY; The state of the task. This is ignored if submitted.
	State *TaskState
}

// GetProjectTaskProperties implements the ProjectTaskPropertiesClassification interface for type ConnectToSourcePostgreSQLSyncTaskProperties.
func (c *ConnectToSourcePostgreSQLSyncTaskProperties) GetProjectTaskProperties() *ProjectTaskProperties {
	return &ProjectTaskProperties{
		ClientData: c.ClientData,
		Commands:   c.Commands,
		Errors:     c.Errors,
		State:      c.State,
		TaskType:   c.TaskType,
	}
}

// ConnectToSourceSQLServerSyncTaskProperties - Properties for the task that validates connection to SQL Server and source
// server requirements for online migration
type ConnectToSourceSQLServerSyncTaskProperties struct {
	// REQUIRED; Task type.
	TaskType *string

	// Key value pairs of client data to attach meta data information to task
	ClientData map[string]*string

	// Task input
	Input *ConnectToSourceSQLServerTaskInput

	// READ-ONLY; Array of command properties.
	Commands []CommandPropertiesClassification

	// READ-ONLY; Array of errors. This is ignored if submitted.
	Errors []*ODataError

	// READ-ONLY; Task output. This is ignored if submitted.
	Output []ConnectToSourceSQLServerTaskOutputClassification

	// READ-ONLY; The state of the task. This is ignored if submitted.
	State *TaskState
}

// GetProjectTaskProperties implements the ProjectTaskPropertiesClassification interface for type ConnectToSourceSQLServerSyncTaskProperties.
func (c *ConnectToSourceSQLServerSyncTaskProperties) GetProjectTaskProperties() *ProjectTaskProperties {
	return &ProjectTaskProperties{
		ClientData: c.ClientData,
		Commands:   c.Commands,
		Errors:     c.Errors,
		State:      c.State,
		TaskType:   c.TaskType,
	}
}

// ConnectToSourceSQLServerTaskInput - Input for the task that validates connection to SQL Server and also validates source
// server requirements
type ConnectToSourceSQLServerTaskInput struct {
	// REQUIRED; Connection information for Source SQL Server
	SourceConnectionInfo *SQLConnectionInfo

	// Permission group for validations
	CheckPermissionsGroup *ServerLevelPermissionsGroup

	// Flag for whether to collect agent jobs from source server.
	CollectAgentJobs *bool

	// Flag for whether to collect databases from source server.
	CollectDatabases *bool

	// Flag for whether to collect logins from source server.
	CollectLogins *bool

	// Flag for whether to collect TDE Certificate names from source server.
	CollectTdeCertificateInfo *bool

	// Flag for whether to validate SSIS catalog is reachable on the source server.
	ValidateSsisCatalogOnly *bool
}

// ConnectToSourceSQLServerTaskOutput - Output for the task that validates connection to SQL Server and also validates source
// server requirements
type ConnectToSourceSQLServerTaskOutput struct {
	// REQUIRED; Type of result - database level or task level
	ResultType *string

	// READ-ONLY; Result identifier
	ID *string
}

// GetConnectToSourceSQLServerTaskOutput implements the ConnectToSourceSQLServerTaskOutputClassification interface for type
// ConnectToSourceSQLServerTaskOutput.
func (c *ConnectToSourceSQLServerTaskOutput) GetConnectToSourceSQLServerTaskOutput() *ConnectToSourceSQLServerTaskOutput {
	return c
}

// ConnectToSourceSQLServerTaskOutputAgentJobLevel - Agent Job level output for the task that validates connection to SQL
// Server and also validates source server requirements
type ConnectToSourceSQLServerTaskOutputAgentJobLevel struct {
	// REQUIRED; Type of result - database level or task level
	ResultType *string

	// READ-ONLY; Result identifier
	ID *string

	// READ-ONLY; The state of the original Agent Job.
	IsEnabled *bool

	// READ-ONLY; The type of Agent Job.
	JobCategory *string

	// READ-ONLY; The owner of the Agent Job
	JobOwner *string

	// READ-ONLY; UTC Date and time when the Agent Job was last executed.
	LastExecutedOn *time.Time

	// READ-ONLY; Information about eligibility of agent job for migration.
	MigrationEligibility *MigrationEligibilityInfo

	// READ-ONLY; Agent Job name
	Name *string

	// READ-ONLY; Validation errors
	ValidationErrors []*ReportableException
}

// GetConnectToSourceSQLServerTaskOutput implements the ConnectToSourceSQLServerTaskOutputClassification interface for type
// ConnectToSourceSQLServerTaskOutputAgentJobLevel.
func (c *ConnectToSourceSQLServerTaskOutputAgentJobLevel) GetConnectToSourceSQLServerTaskOutput() *ConnectToSourceSQLServerTaskOutput {
	return &ConnectToSourceSQLServerTaskOutput{
		ID:         c.ID,
		ResultType: c.ResultType,
	}
}

// ConnectToSourceSQLServerTaskOutputDatabaseLevel - Database level output for the task that validates connection to SQL Server
// and also validates source server requirements
type ConnectToSourceSQLServerTaskOutputDatabaseLevel struct {
	// REQUIRED; Type of result - database level or task level
	ResultType *string

	// READ-ONLY; SQL Server compatibility level of database
	CompatibilityLevel *DatabaseCompatLevel

	// READ-ONLY; The list of database files
	DatabaseFiles []*DatabaseFileInfo

	// READ-ONLY; State of the database
	DatabaseState *DatabaseState

	// READ-ONLY; Result identifier
	ID *string

	// READ-ONLY; Database name
	Name *string

	// READ-ONLY; Size of the file in megabytes
	SizeMB *float64
}

// GetConnectToSourceSQLServerTaskOutput implements the ConnectToSourceSQLServerTaskOutputClassification interface for type
// ConnectToSourceSQLServerTaskOutputDatabaseLevel.
func (c *ConnectToSourceSQLServerTaskOutputDatabaseLevel) GetConnectToSourceSQLServerTaskOutput() *ConnectToSourceSQLServerTaskOutput {
	return &ConnectToSourceSQLServerTaskOutput{
		ID:         c.ID,
		ResultType: c.ResultType,
	}
}

// ConnectToSourceSQLServerTaskOutputLoginLevel - Login level output for the task that validates connection to SQL Server
// and also validates source server requirements
type ConnectToSourceSQLServerTaskOutputLoginLevel struct {
	// REQUIRED; Type of result - database level or task level
	ResultType *string

	// READ-ONLY; The default database for the login.
	DefaultDatabase *string

	// READ-ONLY; Result identifier
	ID *string

	// READ-ONLY; The state of the login.
	IsEnabled *bool

	// READ-ONLY; The type of login.
	LoginType *LoginType

	// READ-ONLY; Information about eligibility of login for migration.
	MigrationEligibility *MigrationEligibilityInfo

	// READ-ONLY; Login name.
	Name *string
}

// GetConnectToSourceSQLServerTaskOutput implements the ConnectToSourceSQLServerTaskOutputClassification interface for type
// ConnectToSourceSQLServerTaskOutputLoginLevel.
func (c *ConnectToSourceSQLServerTaskOutputLoginLevel) GetConnectToSourceSQLServerTaskOutput() *ConnectToSourceSQLServerTaskOutput {
	return &ConnectToSourceSQLServerTaskOutput{
		ID:         c.ID,
		ResultType: c.ResultType,
	}
}

// ConnectToSourceSQLServerTaskOutputTaskLevel - Task level output for the task that validates connection to SQL Server and
// also validates source server requirements
type ConnectToSourceSQLServerTaskOutputTaskLevel struct {
	// REQUIRED; Type of result - database level or task level
	ResultType *string

	// READ-ONLY; Source agent jobs as a map from agent job name to id.
	AgentJobs *string

	// READ-ONLY; Mapping from database name to TDE certificate name, if applicable
	DatabaseTdeCertificateMapping *string

	// READ-ONLY; Source databases as a map from database name to database id
	Databases *string

	// READ-ONLY; Result identifier
	ID *string

	// READ-ONLY; Source logins as a map from login name to login id.
	Logins *string

	// READ-ONLY; Source server brand version
	SourceServerBrandVersion *string

	// READ-ONLY; Source server version
	SourceServerVersion *string

	// READ-ONLY; Validation errors
	ValidationErrors []*ReportableException
}

// GetConnectToSourceSQLServerTaskOutput implements the ConnectToSourceSQLServerTaskOutputClassification interface for type
// ConnectToSourceSQLServerTaskOutputTaskLevel.
func (c *ConnectToSourceSQLServerTaskOutputTaskLevel) GetConnectToSourceSQLServerTaskOutput() *ConnectToSourceSQLServerTaskOutput {
	return &ConnectToSourceSQLServerTaskOutput{
		ID:         c.ID,
		ResultType: c.ResultType,
	}
}

// ConnectToSourceSQLServerTaskProperties - Properties for the task that validates connection to SQL Server and also validates
// source server requirements
type ConnectToSourceSQLServerTaskProperties struct {
	// REQUIRED; Task type.
	TaskType *string

	// Key value pairs of client data to attach meta data information to task
	ClientData map[string]*string

	// Task input
	Input *ConnectToSourceSQLServerTaskInput

	// READ-ONLY; Array of command properties.
	Commands []CommandPropertiesClassification

	// READ-ONLY; Array of errors. This is ignored if submitted.
	Errors []*ODataError

	// READ-ONLY; Task output. This is ignored if submitted.
	Output []ConnectToSourceSQLServerTaskOutputClassification

	// READ-ONLY; The state of the task. This is ignored if submitted.
	State *TaskState
}

// GetProjectTaskProperties implements the ProjectTaskPropertiesClassification interface for type ConnectToSourceSQLServerTaskProperties.
func (c *ConnectToSourceSQLServerTaskProperties) GetProjectTaskProperties() *ProjectTaskProperties {
	return &ProjectTaskProperties{
		ClientData: c.ClientData,
		Commands:   c.Commands,
		Errors:     c.Errors,
		State:      c.State,
		TaskType:   c.TaskType,
	}
}

// ConnectToTargetAzureDbForMySQLTaskInput - Input for the task that validates connection to Azure Database for MySQL and
// target server requirements
type ConnectToTargetAzureDbForMySQLTaskInput struct {
	// REQUIRED; Connection information for source MySQL server
	SourceConnectionInfo *MySQLConnectionInfo

	// REQUIRED; Connection information for target Azure Database for MySQL server
	TargetConnectionInfo *MySQLConnectionInfo

	// Flag for whether or not the migration is offline
	IsOfflineMigration *bool
}

// ConnectToTargetAzureDbForMySQLTaskOutput - Output for the task that validates connection to Azure Database for MySQL and
// target server requirements
type ConnectToTargetAzureDbForMySQLTaskOutput struct {
	// READ-ONLY; List of databases on target server
	Databases []*string

	// READ-ONLY; Result identifier
	ID *string

	// READ-ONLY; Version of the target server
	ServerVersion *string

	// READ-ONLY; Target server brand version
	TargetServerBrandVersion *string

	// READ-ONLY; Validation errors associated with the task
	ValidationErrors []*ReportableException
}

// ConnectToTargetAzureDbForMySQLTaskProperties - Properties for the task that validates connection to Azure Database for
// MySQL and target server requirements
type ConnectToTargetAzureDbForMySQLTaskProperties struct {
	// REQUIRED; Task type.
	TaskType *string

	// Key value pairs of client data to attach meta data information to task
	ClientData map[string]*string

	// Task input
	Input *ConnectToTargetAzureDbForMySQLTaskInput

	// READ-ONLY; Array of command properties.
	Commands []CommandPropertiesClassification

	// READ-ONLY; Array of errors. This is ignored if submitted.
	Errors []*ODataError

	// READ-ONLY; Task output. This is ignored if submitted.
	Output []*ConnectToTargetAzureDbForMySQLTaskOutput

	// READ-ONLY; The state of the task. This is ignored if submitted.
	State *TaskState
}

// GetProjectTaskProperties implements the ProjectTaskPropertiesClassification interface for type ConnectToTargetAzureDbForMySQLTaskProperties.
func (c *ConnectToTargetAzureDbForMySQLTaskProperties) GetProjectTaskProperties() *ProjectTaskProperties {
	return &ProjectTaskProperties{
		ClientData: c.ClientData,
		Commands:   c.Commands,
		Errors:     c.Errors,
		State:      c.State,
		TaskType:   c.TaskType,
	}
}

// ConnectToTargetAzureDbForPostgreSQLSyncTaskInput - Input for the task that validates connection to Azure Database for PostgreSQL
// and target server requirements
type ConnectToTargetAzureDbForPostgreSQLSyncTaskInput struct {
	// REQUIRED; Connection information for source PostgreSQL server
	SourceConnectionInfo *PostgreSQLConnectionInfo

	// REQUIRED; Connection information for target Azure Database for PostgreSQL server
	TargetConnectionInfo *PostgreSQLConnectionInfo
}

// ConnectToTargetAzureDbForPostgreSQLSyncTaskOutput - Output for the task that validates connection to Azure Database for
// PostgreSQL and target server requirements
type ConnectToTargetAzureDbForPostgreSQLSyncTaskOutput struct {
	// READ-ONLY; List of databases on target server
	Databases []*string

	// READ-ONLY; Result identifier
	ID *string

	// READ-ONLY; Target server brand version
	TargetServerBrandVersion *string

	// READ-ONLY; Version of the target server
	TargetServerVersion *string

	// READ-ONLY; Validation errors associated with the task
	ValidationErrors []*ReportableException
}

// ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties - Properties for the task that validates connection to Azure Database
// For PostgreSQL server and target server requirements for online migration
type ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties struct {
	// REQUIRED; Task type.
	TaskType *string

	// Key value pairs of client data to attach meta data information to task
	ClientData map[string]*string

	// Task input
	Input *ConnectToTargetAzureDbForPostgreSQLSyncTaskInput

	// READ-ONLY; Array of command properties.
	Commands []CommandPropertiesClassification

	// READ-ONLY; Array of errors. This is ignored if submitted.
	Errors []*ODataError

	// READ-ONLY; Task output. This is ignored if submitted.
	Output []*ConnectToTargetAzureDbForPostgreSQLSyncTaskOutput

	// READ-ONLY; The state of the task. This is ignored if submitted.
	State *TaskState
}

// GetProjectTaskProperties implements the ProjectTaskPropertiesClassification interface for type ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties.
func (c *ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties) GetProjectTaskProperties() *ProjectTaskProperties {
	return &ProjectTaskProperties{
		ClientData: c.ClientData,
		Commands:   c.Commands,
		Errors:     c.Errors,
		State:      c.State,
		TaskType:   c.TaskType,
	}
}

// ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskInput - Input for the task that validates connection to Azure Database
// for PostgreSQL and target server requirements for Oracle source.
type ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskInput struct {
	// REQUIRED; Connection information for target Azure Database for PostgreSQL server
	TargetConnectionInfo *PostgreSQLConnectionInfo
}

// ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskOutput - Output for the task that validates connection to Azure Database
// for PostgreSQL and target server requirements for Oracle source.
type ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskOutput struct {
	// Mapping of schemas per database
	DatabaseSchemaMap []*ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskOutputDatabaseSchemaMapItem

	// READ-ONLY; List of databases on target server
	Databases []*string

	// READ-ONLY; Target server brand version
	TargetServerBrandVersion *string

	// READ-ONLY; Version of the target server
	TargetServerVersion *string

	// READ-ONLY; Validation errors associated with the task
	ValidationErrors []*ReportableException
}

type ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskOutputDatabaseSchemaMapItem struct {
	Database *string
	Schemas  []*string
}

// ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties - Properties for the task that validates connection to Azure
// Database For PostgreSQL server and target server requirements for online migration for Oracle source.
type ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties struct {
	// REQUIRED; Task type.
	TaskType *string

	// Key value pairs of client data to attach meta data information to task
	ClientData map[string]*string

	// Task input
	Input *ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskInput

	// READ-ONLY; Array of command properties.
	Commands []CommandPropertiesClassification

	// READ-ONLY; Array of errors. This is ignored if submitted.
	Errors []*ODataError

	// READ-ONLY; Task output. This is ignored if submitted.
	Output []*ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskOutput

	// READ-ONLY; The state of the task. This is ignored if submitted.
	State *TaskState
}

// GetProjectTaskProperties implements the ProjectTaskPropertiesClassification interface for type ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties.
func (c *ConnectToTargetOracleAzureDbForPostgreSQLSyncTaskProperties) GetProjectTaskProperties() *ProjectTaskProperties {
	return &ProjectTaskProperties{
		ClientData: c.ClientData,
		Commands:   c.Commands,
		Errors:     c.Errors,
		State:      c.State,
		TaskType:   c.TaskType,
	}
}

// ConnectToTargetSQLDbSyncTaskInput - Input for the task that validates connection to Azure SQL DB and target server requirements
type ConnectToTargetSQLDbSyncTaskInput struct {
	// REQUIRED; Connection information for source SQL Server
	SourceConnectionInfo *SQLConnectionInfo

	// REQUIRED; Connection information for target SQL DB
	TargetConnectionInfo *SQLConnectionInfo
}

// ConnectToTargetSQLDbSyncTaskProperties - Properties for the task that validates connection to SQL DB and target server
// requirements for online migration
type ConnectToTargetSQLDbSyncTaskProperties struct {
	// REQUIRED; Task type.
	TaskType *string

	// Key value pairs of client data to attach meta data information to task
	ClientData map[string]*string

	// Task input
	Input *ConnectToTargetSQLDbSyncTaskInput

	// READ-ONLY; Array of command properties.
	Commands []CommandPropertiesClassification

	// READ-ONLY; Array of errors. This is ignored if submitted.
	Errors []*ODataError

	// READ-ONLY; Task output. This is ignored if submitted.
	Output []*ConnectToTargetSQLDbTaskOutput

	// READ-ONLY; The state of the task. This is ignored if submitted.
	State *TaskState
}

// GetProjectTaskProperties implements the ProjectTaskPropertiesClassification interface for type ConnectToTargetSQLDbSyncTaskProperties.
func (c *ConnectToTargetSQLDbSyncTaskProperties) GetProjectTaskProperties() *ProjectTaskProperties {
	return &ProjectTaskProperties{
		ClientData: c.ClientData,
		Commands:   c.Commands,
		Errors:     c.Errors,
		State:      c.State,
		TaskType:   c.TaskType,
	}
}

// ConnectToTargetSQLDbTaskInput - Input for the task that validates connection to SQL DB and target server requirements
type ConnectToTargetSQLDbTaskInput struct {
	// REQUIRED; Connection information for target SQL DB
	TargetConnectionInfo *SQLConnectionInfo
}

// ConnectToTargetSQLDbTaskOutput - Output for the task that validates connection to SQL DB and target server requirements
type ConnectToTargetSQLDbTaskOutput struct {
	// READ-ONLY; Source databases as a map from database name to database id
	Databases *string

	// READ-ONLY; Result identifier
	ID *string

	// READ-ONLY; Target server brand version
	TargetServerBrandVersion *string

	// READ-ONLY; Version of the target server
	TargetServerVersion *string
}

// ConnectToTargetSQLDbTaskProperties - Properties for the task that validates connection to SQL DB and target server requirements
type ConnectToTargetSQLDbTaskProperties struct {
	// REQUIRED; Task type.
	TaskType *string

	// Key value pairs of client data to attach meta data information to task
	ClientData map[string]*string

	// Task input
	Input *ConnectToTargetSQLDbTaskInput

	// READ-ONLY; Array of command properties.
	Commands []CommandPropertiesClassification

	// READ-ONLY; Array of errors. This is ignored if submitted.
	Errors []*ODataError

	// READ-ONLY; Task output. This is ignored if submitted.
	Output []*ConnectToTargetSQLDbTaskOutput

	// READ-ONLY; The state of the task. This is ignored if submitted.
	State *TaskState
}

// GetProjectTaskProperties implements the ProjectTaskPropertiesClassification interface for type ConnectToTargetSQLDbTaskProperties.
func (c *ConnectToTargetSQLDbTaskProperties) GetProjectTaskProperties() *ProjectTaskProperties {
	return &ProjectTaskProperties{
		ClientData: c.ClientData,
		Commands:   c.Commands,
		Errors:     c.Errors,
		State:      c.State,
		TaskType:   c.TaskType,
	}
}

// ConnectToTargetSQLMISyncTaskInput - Input for the task that validates connection to Azure SQL Database Managed Instance
// online scenario.
type ConnectToTargetSQLMISyncTaskInput struct {
	// REQUIRED; Azure Active Directory Application the DMS instance will use to connect to the target instance of Azure SQL Database
	// Managed Instance and the Azure Storage Account
	AzureApp *AzureActiveDirectoryApp

	// REQUIRED; Connection information for Azure SQL Database Managed Instance
	TargetConnectionInfo *MiSQLConnectionInfo
}

// ConnectToTargetSQLMISyncTaskOutput - Output for the task that validates connection to Azure SQL Database Managed Instance.
type ConnectToTargetSQLMISyncTaskOutput struct {
	// READ-ONLY; Target server brand version
	TargetServerBrandVersion *string

	// READ-ONLY; Target server version
	TargetServerVersion *string

	// READ-ONLY; Validation errors
	ValidationErrors []*ReportableException
}

// ConnectToTargetSQLMISyncTaskProperties - Properties for the task that validates connection to Azure SQL Database Managed
// Instance
type ConnectToTargetSQLMISyncTaskProperties struct {
	// REQUIRED; Task type.
	TaskType *string

	// Key value pairs of client data to attach meta data information to task
	ClientData map[string]*string

	// Task input
	Input *ConnectToTargetSQLMISyncTaskInput

	// READ-ONLY; Array of command properties.
	Commands []CommandPropertiesClassification

	// READ-ONLY; Array of errors. This is ignored if submitted.
	Errors []*ODataError

	// READ-ONLY; Task output. This is ignored if submitted.
	Output []*ConnectToTargetSQLMISyncTaskOutput

	// READ-ONLY; The state of the task. This is ignored if submitted.
	State *TaskState
}

// GetProjectTaskProperties implements the ProjectTaskPropertiesClassification interface for type ConnectToTargetSQLMISyncTaskProperties.
func (c *ConnectToTargetSQLMISyncTaskProperties) GetProjectTaskProperties() *ProjectTaskProperties {
	return &ProjectTaskProperties{
		ClientData: c.ClientData,
		Commands:   c.Commands,
		Errors:     c.Errors,
		State:      c.State,
		TaskType:   c.TaskType,
	}
}

// ConnectToTargetSQLMITaskInput - Input for the task that validates connection to Azure SQL Database Managed Instance.
type ConnectToTargetSQLMITaskInput struct {
	// REQUIRED; Connection information for target SQL Server
	TargetConnectionInfo *SQLConnectionInfo

	// Flag for whether to collect agent jobs from target SQL MI server.
	CollectAgentJobs *bool

	// Flag for whether to collect logins from target SQL MI server.
	CollectLogins *bool

	// Flag for whether to validate SSIS catalog is reachable on the target SQL MI server.
	ValidateSsisCatalogOnly *bool
}

// ConnectToTargetSQLMITaskOutput - Output for the task that validates connection to Azure SQL Database Managed Instance.
type ConnectToTargetSQLMITaskOutput struct {
	// READ-ONLY; List of agent jobs on the target server.
	AgentJobs []*string

	// READ-ONLY; Result identifier
	ID *string

	// READ-ONLY; List of logins on the target server.
	Logins []*string

	// READ-ONLY; Target server brand version
	TargetServerBrandVersion *string

	// READ-ONLY; Target server version
	TargetServerVersion *string

	// READ-ONLY; Validation errors
	ValidationErrors []*ReportableException
}

// ConnectToTargetSQLMITaskProperties - Properties for the task that validates connection to Azure SQL Database Managed Instance
type ConnectToTargetSQLMITaskProperties struct {
	// REQUIRED; Task type.
	TaskType *string

	// Key value pairs of client data to attach meta data information to task
	ClientData map[string]*string

	// Task input
	Input *ConnectToTargetSQLMITaskInput

	// READ-ONLY; Array of command properties.
	Commands []CommandPropertiesClassification

	// READ-ONLY; Array of errors. This is ignored if submitted.
	Errors []*ODataError

	// READ-ONLY; Task output. This is ignored if submitted.
	Output []*ConnectToTargetSQLMITaskOutput

	// READ-ONLY; The state of the task. This is ignored if submitted.
	State *TaskState
}

// GetProjectTaskProperties implements the ProjectTaskPropertiesClassification interface for type ConnectToTargetSQLMITaskProperties.
func (c *ConnectToTargetSQLMITaskProperties) GetProjectTaskProperties() *ProjectTaskProperties {
	return &ProjectTaskProperties{
		ClientData: c.ClientData,
		Commands:   c.Commands,
		Errors:     c.Errors,
		State:      c.State,
		TaskType:   c.TaskType,
	}
}

// ConnectionInfo - Defines the connection properties of a server
type ConnectionInfo struct {
	// REQUIRED; Type of connection info
	Type *string

	// Password credential.
	Password *string

	// User name
	UserName *string
}

// GetConnectionInfo implements the ConnectionInfoClassification interface for type ConnectionInfo.
func (c *ConnectionInfo) GetConnectionInfo() *ConnectionInfo { return c }

// DataIntegrityValidationResult - Results for checksum based Data Integrity validation results
type DataIntegrityValidationResult struct {
	// List of failed table names of source and target pair
	FailedObjects map[string]*string

	// List of errors that happened while performing data integrity validation
	ValidationErrors *ValidationError
}

// DataItemMigrationSummaryResult - Basic summary of a data item migration
type DataItemMigrationSummaryResult struct {
	// READ-ONLY; Migration end time
	EndedOn *time.Time

	// READ-ONLY; Wildcard string prefix to use for querying all errors of the item
	ErrorPrefix *string

	// READ-ONLY; Number of successfully completed items
	ItemsCompletedCount *int64

	// READ-ONLY; Number of items
	ItemsCount *int64

	// READ-ONLY; Name of the item
	Name *string

	// READ-ONLY; Wildcard string prefix to use for querying all sub-tem results of the item
	ResultPrefix *string

	// READ-ONLY; Migration start time
	StartedOn *time.Time

	// READ-ONLY; Current state of migration
	State *MigrationState

	// READ-ONLY; Status message
	StatusMessage *string
}

// Database - Information about a single database
type Database struct {
	// Collation name of the database
	Collation *string

	// SQL Server compatibility level of database
	CompatibilityLevel *DatabaseCompatLevel

	// State of the database
	DatabaseState *DatabaseState

	// Fully qualified name
	Fqdn *string

	// Unique identifier for the database
	ID *string

	// Install id of the database
	InstallID *string

	// Name of the database
	Name *string

	// Number of cores on the server
	ServerCoreCount *int32

	// Default path of the backup folder
	ServerDefaultBackupPath *string

	// Default path of the data files
	ServerDefaultDataPath *string

	// Default path of the log files
	ServerDefaultLogPath *string

	// Edition of the server
	ServerEdition *string

	// The unique Server Id
	ServerID *string

	// Product level of the server (RTM, SP, CTP).
	ServerLevel *string

	// Name of the server
	ServerName *string

	// Version of the server
	ServerVersion *string

	// Number of cores on the server that have VISIBLE ONLINE status
	ServerVisibleOnlineCoreCount *int32
}

// DatabaseBackupInfo - Information about backup files when existing backup mode is used.
type DatabaseBackupInfo struct {
	// READ-ONLY; The list of backup files for the current database.
	BackupFiles []*string

	// READ-ONLY; Date and time when the backup operation finished.
	BackupFinishDate *time.Time

	// READ-ONLY; Backup Type.
	BackupType *BackupType

	// READ-ONLY; Database name.
	DatabaseName *string

	// READ-ONLY; Number of files in the backup set.
	FamilyCount *int32

	// READ-ONLY; Whether the backup set is compressed
	IsCompressed *bool

	// READ-ONLY; Database was damaged when backed up, but the backup operation was requested to continue despite errors.
	IsDamaged *bool

	// READ-ONLY; Position of current database backup in the file.
	Position *int32
}

// DatabaseFileInfo - Database file specific information
type DatabaseFileInfo struct {
	// Name of the database
	DatabaseName *string

	// Database file type
	FileType *DatabaseFileType

	// Unique identifier for database file
	ID *string

	// Logical name of the file
	LogicalName *string

	// Operating-system full path of the file
	PhysicalFullName *string

	// Suggested full path of the file for restoring
	RestoreFullName *string

	// Size of the file in megabytes
	SizeMB *float64
}

// DatabaseFileInput - Database file specific information for input
type DatabaseFileInput struct {
	// Database file type
	FileType *DatabaseFileType

	// Unique identifier for database file
	ID *string

	// Logical name of the file
	LogicalName *string

	// Operating-system full path of the file
	PhysicalFullName *string

	// Suggested full path of the file for restoring
	RestoreFullName *string
}

// DatabaseInfo - Project Database Details
type DatabaseInfo struct {
	// REQUIRED; Name of the database
	SourceDatabaseName *string
}

// DatabaseObjectName - A representation of the name of an object in a database
type DatabaseObjectName struct {
	// Type of the object in the database
	ObjectType *ObjectType

	// READ-ONLY; The unescaped name of the database containing the object
	DatabaseName *string

	// READ-ONLY; The unescaped name of the object
	ObjectName *string

	// READ-ONLY; The unescaped name of the schema containing the object
	SchemaName *string
}

// DatabaseSummaryResult - Summary of database results in the migration
type DatabaseSummaryResult struct {
	// READ-ONLY; Migration end time
	EndedOn *time.Time

	// READ-ONLY; Wildcard string prefix to use for querying all errors of the item
	ErrorPrefix *string

	// READ-ONLY; Number of successfully completed items
	ItemsCompletedCount *int64

	// READ-ONLY; Number of items
	ItemsCount *int64

	// READ-ONLY; Name of the item
	Name *string

	// READ-ONLY; Wildcard string prefix to use for querying all sub-tem results of the item
	ResultPrefix *string

	// READ-ONLY; Size of the database in megabytes
	SizeMB *float64

	// READ-ONLY; Migration start time
	StartedOn *time.Time

	// READ-ONLY; Current state of migration
	State *MigrationState

	// READ-ONLY; Status message
	StatusMessage *string
}

// DatabaseTable - Table properties
type DatabaseTable struct {
	// READ-ONLY; Indicates whether table is empty or not
	HasRows *bool

	// READ-ONLY; Schema-qualified name of the table
	Name *string
}

// Error - Migration Task errors
type Error struct {
	// Error type
	Type *ErrorType

	// READ-ONLY; Error description
	Message *string
}

// ExecutionStatistics - Description about the errors happen while performing migration validation
type ExecutionStatistics struct {
	// CPU Time in millisecond(s) for the query execution
	CPUTimeMs *float32

	// Time taken in millisecond(s) for executing the query
	ElapsedTimeMs *float32

	// No. of query executions
	ExecutionCount *int64

	// Indicates whether the query resulted in an error
	HasErrors *bool

	// List of sql Errors
	SQLErrors []*string

	// Dictionary of sql query execution wait types and the respective statistics
	WaitStats map[string]*WaitStatistics
}

// FileList - OData page of files
type FileList struct {
	// URL to load the next page of files
	NextLink *string

	// List of files
	Value []*ProjectFile
}

// FileShare - File share information with Path, Username, and Password.
type FileShare struct {
	// REQUIRED; The folder path for this share.
	Path *string

	// Password credential used to connect to the share location.
	Password *string

	// User name credential to connect to the share location
	UserName *string
}

// FileStorageInfo - File storage information.
type FileStorageInfo struct {
	// Dictionary of
	Headers map[string]*string

	// A URI that can be used to access the file content.
	URI *string
}

// GetProjectDetailsNonSQLTaskInput - Input for the task that reads configuration from project artifacts
type GetProjectDetailsNonSQLTaskInput struct {
	// REQUIRED; A URL that points to the location to access project artifacts
	ProjectLocation *string

	// REQUIRED; Name of the migration project
	ProjectName *string
}

// GetTdeCertificatesSQLTaskInput - Input for the task that gets TDE certificates in Base64 encoded format.
type GetTdeCertificatesSQLTaskInput struct {
	// REQUIRED; Backup file share information for file share to be used for temporarily storing files.
	BackupFileShare *FileShare

	// REQUIRED; Connection information for SQL Server
	ConnectionInfo *SQLConnectionInfo

	// REQUIRED; List containing certificate names and corresponding password to use for encrypting the exported certificate.
	SelectedCertificates []*SelectedCertificateInput
}

// GetTdeCertificatesSQLTaskOutput - Output of the task that gets TDE certificates in Base64 encoded format.
type GetTdeCertificatesSQLTaskOutput struct {
	// READ-ONLY; Mapping from certificate name to base 64 encoded format.
	Base64EncodedCertificates *string

	// READ-ONLY; Validation errors
	ValidationErrors []*ReportableException
}

// GetTdeCertificatesSQLTaskProperties - Properties for the task that gets TDE certificates in Base64 encoded format.
type GetTdeCertificatesSQLTaskProperties struct {
	// REQUIRED; Task type.
	TaskType *string

	// Key value pairs of client data to attach meta data information to task
	ClientData map[string]*string

	// Task input
	Input *GetTdeCertificatesSQLTaskInput

	// READ-ONLY; Array of command properties.
	Commands []CommandPropertiesClassification

	// READ-ONLY; Array of errors. This is ignored if submitted.
	Errors []*ODataError

	// READ-ONLY; Task output. This is ignored if submitted.
	Output []*GetTdeCertificatesSQLTaskOutput

	// READ-ONLY; The state of the task. This is ignored if submitted.
	State *TaskState
}

// GetProjectTaskProperties implements the ProjectTaskPropertiesClassification interface for type GetTdeCertificatesSQLTaskProperties.
func (g *GetTdeCertificatesSQLTaskProperties) GetProjectTaskProperties() *ProjectTaskProperties {
	return &ProjectTaskProperties{
		ClientData: g.ClientData,
		Commands:   g.Commands,
		Errors:     g.Errors,
		State:      g.State,
		TaskType:   g.TaskType,
	}
}

// GetUserTablesMySQLTaskInput - Input for the task that collects user tables for the given list of databases
type GetUserTablesMySQLTaskInput struct {
	// REQUIRED; Connection information for SQL Server
	ConnectionInfo *MySQLConnectionInfo

	// REQUIRED; List of database names to collect tables for
	SelectedDatabases []*string
}

// GetUserTablesMySQLTaskOutput - Output of the task that collects user tables for the given list of databases
type GetUserTablesMySQLTaskOutput struct {
	// READ-ONLY; Mapping from database name to list of tables
	DatabasesToTables *string

	// READ-ONLY; Result identifier
	ID *string

	// READ-ONLY; Validation errors
	ValidationErrors []*ReportableException
}

// GetUserTablesMySQLTaskProperties - Properties for the task that collects user tables for the given list of databases
type GetUserTablesMySQLTaskProperties struct {
	// REQUIRED; Task type.
	TaskType *string

	// Key value pairs of client data to attach meta data information to task
	ClientData map[string]*string

	// Task input
	Input *GetUserTablesMySQLTaskInput

	// READ-ONLY; Array of command properties.
	Commands []CommandPropertiesClassification

	// READ-ONLY; Array of errors. This is ignored if submitted.
	Errors []*ODataError

	// READ-ONLY; Task output. This is ignored if submitted.
	Output []*GetUserTablesMySQLTaskOutput

	// READ-ONLY; The state of the task. This is ignored if submitted.
	State *TaskState
}

// GetProjectTaskProperties implements the ProjectTaskPropertiesClassification interface for type GetUserTablesMySQLTaskProperties.
func (g *GetUserTablesMySQLTaskProperties) GetProjectTaskProperties() *ProjectTaskProperties {
	return &ProjectTaskProperties{
		ClientData: g.ClientData,
		Commands:   g.Commands,
		Errors:     g.Errors,
		State:      g.State,
		TaskType:   g.TaskType,
	}
}

// GetUserTablesOracleTaskInput - Input for the task that gets the list of tables contained within a provided list of Oracle
// schemas.
type GetUserTablesOracleTaskInput struct {
	// REQUIRED; Information for connecting to Oracle source
	ConnectionInfo *OracleConnectionInfo

	// REQUIRED; List of Oracle schemas for which to collect tables
	SelectedSchemas []*string
}

// GetUserTablesOracleTaskOutput - Output for the task that gets the list of tables contained within a provided list of Oracle
// schemas.
type GetUserTablesOracleTaskOutput struct {
	// READ-ONLY; The schema this result is for
	SchemaName *string

	// READ-ONLY; List of valid tables found for this schema
	Tables []*DatabaseTable

	// READ-ONLY; Validation errors associated with the task
	ValidationErrors []*ReportableException
}

// GetUserTablesOracleTaskProperties - Properties for the task that collects user tables for the given list of Oracle schemas
type GetUserTablesOracleTaskProperties struct {
	// REQUIRED; Task type.
	TaskType *string

	// Key value pairs of client data to attach meta data information to task
	ClientData map[string]*string

	// Task input
	Input *GetUserTablesOracleTaskInput

	// READ-ONLY; Array of command properties.
	Commands []CommandPropertiesClassification

	// READ-ONLY; Array of errors. This is ignored if submitted.
	Errors []*ODataError

	// READ-ONLY; Task output. This is ignored if submitted.
	Output []*GetUserTablesOracleTaskOutput

	// READ-ONLY; The state of the task. This is ignored if submitted.
	State *TaskState
}

// GetProjectTaskProperties implements the ProjectTaskPropertiesClassification interface for type GetUserTablesOracleTaskProperties.
func (g *GetUserTablesOracleTaskProperties) GetProjectTaskProperties() *ProjectTaskProperties {
	return &ProjectTaskProperties{
		ClientData: g.ClientData,
		Commands:   g.Commands,
		Errors:     g.Errors,
		State:      g.State,
		TaskType:   g.TaskType,
	}
}

// GetUserTablesPostgreSQLTaskInput - Input for the task that gets the list of tables for a provided list of PostgreSQL databases.
type GetUserTablesPostgreSQLTaskInput struct {
	// REQUIRED; Information for connecting to PostgreSQL source
	ConnectionInfo *PostgreSQLConnectionInfo

	// REQUIRED; List of PostgreSQL databases for which to collect tables
	SelectedDatabases []*string
}

// GetUserTablesPostgreSQLTaskOutput - Output for the task that gets the list of tables for a provided list of PostgreSQL
// databases.
type GetUserTablesPostgreSQLTaskOutput struct {
	// READ-ONLY; The database this result is for
	DatabaseName *string

	// READ-ONLY; List of valid tables found for this database
	Tables []*DatabaseTable

	// READ-ONLY; Validation errors associated with the task
	ValidationErrors []*ReportableException
}

// GetUserTablesPostgreSQLTaskProperties - Properties for the task that collects user tables for the given list of databases
type GetUserTablesPostgreSQLTaskProperties struct {
	// REQUIRED; Task type.
	TaskType *string

	// Key value pairs of client data to attach meta data information to task
	ClientData map[string]*string

	// Task input
	Input *GetUserTablesPostgreSQLTaskInput

	// READ-ONLY; Array of command properties.
	Commands []CommandPropertiesClassification

	// READ-ONLY; Array of errors. This is ignored if submitted.
	Errors []*ODataError

	// READ-ONLY; Task output. This is ignored if submitted.
	Output []*GetUserTablesPostgreSQLTaskOutput

	// READ-ONLY; The state of the task. This is ignored if submitted.
	State *TaskState
}

// GetProjectTaskProperties implements the ProjectTaskPropertiesClassification interface for type GetUserTablesPostgreSQLTaskProperties.
func (g *GetUserTablesPostgreSQLTaskProperties) GetProjectTaskProperties() *ProjectTaskProperties {
	return &ProjectTaskProperties{
		ClientData: g.ClientData,
		Commands:   g.Commands,
		Errors:     g.Errors,
		State:      g.State,
		TaskType:   g.TaskType,
	}
}

// GetUserTablesSQLSyncTaskInput - Input for the task that collects user tables for the given list of databases
type GetUserTablesSQLSyncTaskInput struct {
	// REQUIRED; List of source database names to collect tables for
	SelectedSourceDatabases []*string

	// REQUIRED; List of target database names to collect tables for
	SelectedTargetDatabases []*string

	// REQUIRED; Connection information for SQL Server
	SourceConnectionInfo *SQLConnectionInfo

	// REQUIRED; Connection information for SQL DB
	TargetConnectionInfo *SQLConnectionInfo
}

// GetUserTablesSQLSyncTaskOutput - Output of the task that collects user tables for the given list of databases
type GetUserTablesSQLSyncTaskOutput struct {
	// READ-ONLY; Mapping from database name to list of source tables
	DatabasesToSourceTables *string

	// READ-ONLY; Mapping from database name to list of target tables
	DatabasesToTargetTables *string

	// READ-ONLY; Mapping from database name to list of validation errors
	TableValidationErrors *string

	// READ-ONLY; Validation errors
	ValidationErrors []*ReportableException
}

// GetUserTablesSQLSyncTaskProperties - Properties for the task that collects user tables for the given list of databases
type GetUserTablesSQLSyncTaskProperties struct {
	// REQUIRED; Task type.
	TaskType *string

	// Key value pairs of client data to attach meta data information to task
	ClientData map[string]*string

	// Task input
	Input *GetUserTablesSQLSyncTaskInput

	// READ-ONLY; Array of command properties.
	Commands []CommandPropertiesClassification

	// READ-ONLY; Array of errors. This is ignored if submitted.
	Errors []*ODataError

	// READ-ONLY; Task output. This is ignored if submitted.
	Output []*GetUserTablesSQLSyncTaskOutput

	// READ-ONLY; The state of the task. This is ignored if submitted.
	State *TaskState
}

// GetProjectTaskProperties implements the ProjectTaskPropertiesClassification interface for type GetUserTablesSQLSyncTaskProperties.
func (g *GetUserTablesSQLSyncTaskProperties) GetProjectTaskProperties() *ProjectTaskProperties {
	return &ProjectTaskProperties{
		ClientData: g.ClientData,
		Commands:   g.Commands,
		Errors:     g.Errors,
		State:      g.State,
		TaskType:   g.TaskType,
	}
}

// GetUserTablesSQLTaskInput - Input for the task that collects user tables for the given list of databases
type GetUserTablesSQLTaskInput struct {
	// REQUIRED; Connection information for SQL Server
	ConnectionInfo *SQLConnectionInfo

	// REQUIRED; List of database names to collect tables for
	SelectedDatabases []*string
}

// GetUserTablesSQLTaskOutput - Output of the task that collects user tables for the given list of databases
type GetUserTablesSQLTaskOutput struct {
	// READ-ONLY; Mapping from database name to list of tables
	DatabasesToTables *string

	// READ-ONLY; Result identifier
	ID *string

	// READ-ONLY; Validation errors
	ValidationErrors []*ReportableException
}

// GetUserTablesSQLTaskProperties - Properties for the task that collects user tables for the given list of databases
type GetUserTablesSQLTaskProperties struct {
	// REQUIRED; Task type.
	TaskType *string

	// Key value pairs of client data to attach meta data information to task
	ClientData map[string]*string

	// Task input
	Input *GetUserTablesSQLTaskInput

	// READ-ONLY; Array of command properties.
	Commands []CommandPropertiesClassification

	// READ-ONLY; Array of errors. This is ignored if submitted.
	Errors []*ODataError

	// READ-ONLY; Task output. This is ignored if submitted.
	Output []*GetUserTablesSQLTaskOutput

	// READ-ONLY; The state of the task. This is ignored if submitted.
	State *TaskState
}

// GetProjectTaskProperties implements the ProjectTaskPropertiesClassification interface for type GetUserTablesSQLTaskProperties.
func (g *GetUserTablesSQLTaskProperties) GetProjectTaskProperties() *ProjectTaskProperties {
	return &ProjectTaskProperties{
		ClientData: g.ClientData,
		Commands:   g.Commands,
		Errors:     g.Errors,
		State:      g.State,
		TaskType:   g.TaskType,
	}
}

// InstallOCIDriverTaskInput - Input for the service task to install an OCI driver.
type InstallOCIDriverTaskInput struct {
	// Name of the uploaded driver package to install.
	DriverPackageName *string
}

// InstallOCIDriverTaskOutput - Output for the service task to install an OCI driver.
type InstallOCIDriverTaskOutput struct {
	// READ-ONLY; Validation errors
	ValidationErrors []*ReportableException
}

// InstallOCIDriverTaskProperties - Properties for the task that installs an OCI driver.
type InstallOCIDriverTaskProperties struct {
	// REQUIRED; Task type.
	TaskType *string

	// Key value pairs of client data to attach meta data information to task
	ClientData map[string]*string

	// Input for the service task to install an OCI driver.
	Input *InstallOCIDriverTaskInput

	// READ-ONLY; Array of command properties.
	Commands []CommandPropertiesClassification

	// READ-ONLY; Array of errors. This is ignored if submitted.
	Errors []*ODataError

	// READ-ONLY; Task output. This is ignored if submitted.
	Output []*InstallOCIDriverTaskOutput

	// READ-ONLY; The state of the task. This is ignored if submitted.
	State *TaskState
}

// GetProjectTaskProperties implements the ProjectTaskPropertiesClassification interface for type InstallOCIDriverTaskProperties.
func (i *InstallOCIDriverTaskProperties) GetProjectTaskProperties() *ProjectTaskProperties {
	return &ProjectTaskProperties{
		ClientData: i.ClientData,
		Commands:   i.Commands,
		Errors:     i.Errors,
		State:      i.State,
		TaskType:   i.TaskType,
	}
}

// MiSQLConnectionInfo - Properties required to create a connection to Azure SQL database Managed instance
type MiSQLConnectionInfo struct {
	// REQUIRED; Resource id for Azure SQL database Managed instance
	ManagedInstanceResourceID *string

	// REQUIRED; Type of connection info
	Type *string

	// Password credential.
	Password *string

	// User name
	UserName *string
}

// GetConnectionInfo implements the ConnectionInfoClassification interface for type MiSQLConnectionInfo.
func (m *MiSQLConnectionInfo) GetConnectionInfo() *ConnectionInfo {
	return &ConnectionInfo{
		Password: m.Password,
		Type:     m.Type,
		UserName: m.UserName,
	}
}

// MigrateMISyncCompleteCommandInput - Input for command that completes online migration for an Azure SQL Database Managed
// Instance.
type MigrateMISyncCompleteCommandInput struct {
	// REQUIRED; Name of managed instance database
	SourceDatabaseName *string
}

// MigrateMISyncCompleteCommandOutput - Output for command that completes online migration for an Azure SQL Database Managed
// Instance.
type MigrateMISyncCompleteCommandOutput struct {
	// List of errors that happened during the command execution
	Errors []*ReportableException
}

// MigrateMISyncCompleteCommandProperties - Properties for the command that completes online migration for an Azure SQL Database
// Managed Instance.
type MigrateMISyncCompleteCommandProperties struct {
	// REQUIRED; Command type.
	CommandType *string

	// Command input
	Input *MigrateMISyncCompleteCommandInput

	// READ-ONLY; Array of errors. This is ignored if submitted.
	Errors []*ODataError

	// READ-ONLY; Command output. This is ignored if submitted.
	Output *MigrateMISyncCompleteCommandOutput

	// READ-ONLY; The state of the command. This is ignored if submitted.
	State *CommandState
}

// GetCommandProperties implements the CommandPropertiesClassification interface for type MigrateMISyncCompleteCommandProperties.
func (m *MigrateMISyncCompleteCommandProperties) GetCommandProperties() *CommandProperties {
	return &CommandProperties{
		CommandType: m.CommandType,
		Errors:      m.Errors,
		State:       m.State,
	}
}

// MigrateMongoDbTaskProperties - Properties for the task that migrates data between MongoDB data sources
type MigrateMongoDbTaskProperties struct {
	// REQUIRED; Task type.
	TaskType *string

	// Key value pairs of client data to attach meta data information to task
	ClientData map[string]*string

	// Describes how a MongoDB data migration should be performed
	Input *MongoDbMigrationSettings

	// READ-ONLY; Array of command properties.
	Commands []CommandPropertiesClassification

	// READ-ONLY; Array of errors. This is ignored if submitted.
	Errors []*ODataError

	// READ-ONLY
	Output []MongoDbProgressClassification

	// READ-ONLY; The state of the task. This is ignored if submitted.
	State *TaskState
}

// GetProjectTaskProperties implements the ProjectTaskPropertiesClassification interface for type MigrateMongoDbTaskProperties.
func (m *MigrateMongoDbTaskProperties) GetProjectTaskProperties() *ProjectTaskProperties {
	return &ProjectTaskProperties{
		ClientData: m.ClientData,
		Commands:   m.Commands,
		Errors:     m.Errors,
		State:      m.State,
		TaskType:   m.TaskType,
	}
}

// MigrateMySQLAzureDbForMySQLOfflineDatabaseInput - Database specific information for offline MySQL to Azure Database for
// MySQL migration task inputs
type MigrateMySQLAzureDbForMySQLOfflineDatabaseInput struct {
	// Name of the database
	Name *string

	// Mapping of source to target tables
	TableMap map[string]*string

	// Name of target database. Note: Target database will be truncated before starting migration.
	TargetDatabaseName *string
}

// MigrateMySQLAzureDbForMySQLOfflineTaskInput - Input for the task that migrates MySQL databases to Azure Database for MySQL
// for offline migrations
type MigrateMySQLAzureDbForMySQLOfflineTaskInput struct {
	// REQUIRED; Databases to migrate
	SelectedDatabases []*MigrateMySQLAzureDbForMySQLOfflineDatabaseInput

	// REQUIRED; Connection information for source MySQL
	SourceConnectionInfo *MySQLConnectionInfo

	// REQUIRED; Connection information for target Azure Database for MySQL
	TargetConnectionInfo *MySQLConnectionInfo

	// Setting to set the source server read only
	MakeSourceServerReadOnly *bool

	// Optional parameters for fine tuning the data transfer rate during migration
	OptionalAgentSettings map[string]*string

	// Parameter to specify when the migration started
	StartedOn *time.Time
}

// MigrateMySQLAzureDbForMySQLOfflineTaskOutput - Output for the task that migrates MySQL databases to Azure Database for
// MySQL for offline migrations
type MigrateMySQLAzureDbForMySQLOfflineTaskOutput struct {
	// REQUIRED; Result type
	ResultType *string

	// READ-ONLY; Result identifier
	ID *string
}

// GetMigrateMySQLAzureDbForMySQLOfflineTaskOutput implements the MigrateMySQLAzureDbForMySQLOfflineTaskOutputClassification
// interface for type MigrateMySQLAzureDbForMySQLOfflineTaskOutput.
func (m *MigrateMySQLAzureDbForMySQLOfflineTaskOutput) GetMigrateMySQLAzureDbForMySQLOfflineTaskOutput() *MigrateMySQLAzureDbForMySQLOfflineTaskOutput {
	return m
}

type MigrateMySQLAzureDbForMySQLOfflineTaskOutputDatabaseLevel struct {
	// REQUIRED; Result type
	ResultType *string

	// READ-ONLY; Name of the database
	DatabaseName *string

	// READ-ONLY; Migration end time
	EndedOn *time.Time

	// READ-ONLY; Number of database/object errors.
	ErrorCount *int64

	// READ-ONLY; Wildcard string prefix to use for querying all errors of the item
	ErrorPrefix *string

	// READ-ONLY; Migration exceptions and warnings.
	ExceptionsAndWarnings []*ReportableException

	// READ-ONLY; Result identifier
	ID *string

	// READ-ONLY; Last time the storage was updated
	LastStorageUpdate *time.Time

	// READ-ONLY; Migration progress message
	Message *string

	// READ-ONLY; Number of objects
	NumberOfObjects *int64

	// READ-ONLY; Number of successfully completed objects
	NumberOfObjectsCompleted *int64

	// READ-ONLY; Summary of object results in the migration
	ObjectSummary *string

	// READ-ONLY; Wildcard string prefix to use for querying all sub-tem results of the item
	ResultPrefix *string

	// READ-ONLY; Migration stage that this database is in
	Stage *DatabaseMigrationStage

	// READ-ONLY; Migration start time
	StartedOn *time.Time

	// READ-ONLY; Current state of migration
	State *MigrationState

	// READ-ONLY; Status message
	StatusMessage *string
}

// GetMigrateMySQLAzureDbForMySQLOfflineTaskOutput implements the MigrateMySQLAzureDbForMySQLOfflineTaskOutputClassification
// interface for type MigrateMySQLAzureDbForMySQLOfflineTaskOutputDatabaseLevel.
func (m *MigrateMySQLAzureDbForMySQLOfflineTaskOutputDatabaseLevel) GetMigrateMySQLAzureDbForMySQLOfflineTaskOutput() *MigrateMySQLAzureDbForMySQLOfflineTaskOutput {
	return &MigrateMySQLAzureDbForMySQLOfflineTaskOutput{
		ID:         m.ID,
		ResultType: m.ResultType,
	}
}

type MigrateMySQLAzureDbForMySQLOfflineTaskOutputError struct {
	// REQUIRED; Result type
	ResultType *string

	// READ-ONLY; Migration error
	Error *ReportableException

	// READ-ONLY; Result identifier
	ID *string
}

// GetMigrateMySQLAzureDbForMySQLOfflineTaskOutput implements the MigrateMySQLAzureDbForMySQLOfflineTaskOutputClassification
// interface for type MigrateMySQLAzureDbForMySQLOfflineTaskOutputError.
func (m *MigrateMySQLAzureDbForMySQLOfflineTaskOutputError) GetMigrateMySQLAzureDbForMySQLOfflineTaskOutput() *MigrateMySQLAzureDbForMySQLOfflineTaskOutput {
	return &MigrateMySQLAzureDbForMySQLOfflineTaskOutput{
		ID:         m.ID,
		ResultType: m.ResultType,
	}
}

type MigrateMySQLAzureDbForMySQLOfflineTaskOutputMigrationLevel struct {
	// REQUIRED; Result type
	ResultType *string

	// Selected databases as a map from database name to database id
	Databases *string

	// Migration Report Result, provides unique url for downloading your migration report.
	MigrationReportResult *MigrationReportResult

	// READ-ONLY; Summary of database results in the migration
	DatabaseSummary *string

	// READ-ONLY; Duration of task execution in seconds.
	DurationInSeconds *int64

	// READ-ONLY; Migration end time
	EndedOn *time.Time

	// READ-ONLY; Migration exceptions and warnings.
	ExceptionsAndWarnings []*ReportableException

	// READ-ONLY; Result identifier
	ID *string

	// READ-ONLY; Last time the storage was updated
	LastStorageUpdate *time.Time

	// READ-ONLY; Migration progress message
	Message *string

	// READ-ONLY; Source server brand version
	SourceServerBrandVersion *string

	// READ-ONLY; Source server version
	SourceServerVersion *string

	// READ-ONLY; Migration start time
	StartedOn *time.Time

	// READ-ONLY; Current status of migration
	Status *MigrationStatus

	// READ-ONLY; Migration status message
	StatusMessage *string

	// READ-ONLY; Target server brand version
	TargetServerBrandVersion *string

	// READ-ONLY; Target server version
	TargetServerVersion *string
}

// GetMigrateMySQLAzureDbForMySQLOfflineTaskOutput implements the MigrateMySQLAzureDbForMySQLOfflineTaskOutputClassification
// interface for type MigrateMySQLAzureDbForMySQLOfflineTaskOutputMigrationLevel.
func (m *MigrateMySQLAzureDbForMySQLOfflineTaskOutputMigrationLevel) GetMigrateMySQLAzureDbForMySQLOfflineTaskOutput() *MigrateMySQLAzureDbForMySQLOfflineTaskOutput {
	return &MigrateMySQLAzureDbForMySQLOfflineTaskOutput{
		ID:         m.ID,
		ResultType: m.ResultType,
	}
}

type MigrateMySQLAzureDbForMySQLOfflineTaskOutputTableLevel struct {
	// REQUIRED; Result type
	ResultType *string

	// READ-ONLY; Migration end time
	EndedOn *time.Time

	// READ-ONLY; Wildcard string prefix to use for querying all errors of the item
	ErrorPrefix *string

	// READ-ONLY; Result identifier
	ID *string

	// READ-ONLY; Number of successfully completed items
	ItemsCompletedCount *int64

	// READ-ONLY; Number of items
	ItemsCount *int64

	// READ-ONLY; Last time the storage was updated
	LastStorageUpdate *time.Time

	// READ-ONLY; Name of the item
	ObjectName *string

	// READ-ONLY; Wildcard string prefix to use for querying all sub-tem results of the item
	ResultPrefix *string

	// READ-ONLY; Migration start time
	StartedOn *time.Time

	// READ-ONLY; Current state of migration
	State *MigrationState

	// READ-ONLY; Status message
	StatusMessage *string
}

// GetMigrateMySQLAzureDbForMySQLOfflineTaskOutput implements the MigrateMySQLAzureDbForMySQLOfflineTaskOutputClassification
// interface for type MigrateMySQLAzureDbForMySQLOfflineTaskOutputTableLevel.
func (m *MigrateMySQLAzureDbForMySQLOfflineTaskOutputTableLevel) GetMigrateMySQLAzureDbForMySQLOfflineTaskOutput() *MigrateMySQLAzureDbForMySQLOfflineTaskOutput {
	return &MigrateMySQLAzureDbForMySQLOfflineTaskOutput{
		ID:         m.ID,
		ResultType: m.ResultType,
	}
}

// MigrateMySQLAzureDbForMySQLOfflineTaskProperties - Properties for the task that migrates MySQL databases to Azure Database
// for MySQL for offline migrations
type MigrateMySQLAzureDbForMySQLOfflineTaskProperties struct {
	// REQUIRED; Task type.
	TaskType *string

	// Key value pairs of client data to attach meta data information to task
	ClientData map[string]*string

	// Task input
	Input *MigrateMySQLAzureDbForMySQLOfflineTaskInput

	// READ-ONLY; Array of command properties.
	Commands []CommandPropertiesClassification

	// READ-ONLY; Array of errors. This is ignored if submitted.
	Errors []*ODataError

	// READ-ONLY; Task output. This is ignored if submitted.
	Output []MigrateMySQLAzureDbForMySQLOfflineTaskOutputClassification

	// READ-ONLY; The state of the task. This is ignored if submitted.
	State *TaskState
}

// GetProjectTaskProperties implements the ProjectTaskPropertiesClassification interface for type MigrateMySQLAzureDbForMySQLOfflineTaskProperties.
func (m *MigrateMySQLAzureDbForMySQLOfflineTaskProperties) GetProjectTaskProperties() *ProjectTaskProperties {
	return &ProjectTaskProperties{
		ClientData: m.ClientData,
		Commands:   m.Commands,
		Errors:     m.Errors,
		State:      m.State,
		TaskType:   m.TaskType,
	}
}

// MigrateMySQLAzureDbForMySQLSyncDatabaseInput - Database specific information for MySQL to Azure Database for MySQL migration
// task inputs
type MigrateMySQLAzureDbForMySQLSyncDatabaseInput struct {
	// Migration settings which tune the migration behavior
	MigrationSetting map[string]*string

	// Name of the database
	Name *string

	// Source settings to tune source endpoint migration behavior
	SourceSetting map[string]*string

	// Mapping of source to target tables
	TableMap map[string]*string

	// Name of target database. Note: Target database will be truncated before starting migration.
	TargetDatabaseName *string

	// Target settings to tune target endpoint migration behavior
	TargetSetting map[string]*string
}

// MigrateMySQLAzureDbForMySQLSyncTaskInput - Input for the task that migrates MySQL databases to Azure Database for MySQL
// for online migrations
type MigrateMySQLAzureDbForMySQLSyncTaskInput struct {
	// REQUIRED; Databases to migrate
	SelectedDatabases []*MigrateMySQLAzureDbForMySQLSyncDatabaseInput

	// REQUIRED; Connection information for source MySQL
	SourceConnectionInfo *MySQLConnectionInfo

	// REQUIRED; Connection information for target Azure Database for MySQL
	TargetConnectionInfo *MySQLConnectionInfo
}

// MigrateMySQLAzureDbForMySQLSyncTaskOutput - Output for the task that migrates MySQL databases to Azure Database for MySQL
// for online migrations
type MigrateMySQLAzureDbForMySQLSyncTaskOutput struct {
	// REQUIRED; Result type
	ResultType *string

	// READ-ONLY; Result identifier
	ID *string
}

// GetMigrateMySQLAzureDbForMySQLSyncTaskOutput implements the MigrateMySQLAzureDbForMySQLSyncTaskOutputClassification interface
// for type MigrateMySQLAzureDbForMySQLSyncTaskOutput.
func (m *MigrateMySQLAzureDbForMySQLSyncTaskOutput) GetMigrateMySQLAzureDbForMySQLSyncTaskOutput() *MigrateMySQLAzureDbForMySQLSyncTaskOutput {
	return m
}

type MigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseError struct {
	// REQUIRED; Result type
	ResultType *string

	// Error message
	ErrorMessage *string

	// List of error events.
	Events []*SyncMigrationDatabaseErrorEvent

	// READ-ONLY; Result identifier
	ID *string
}

// GetMigrateMySQLAzureDbForMySQLSyncTaskOutput implements the MigrateMySQLAzureDbForMySQLSyncTaskOutputClassification interface
// for type MigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseError.
func (m *MigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseError) GetMigrateMySQLAzureDbForMySQLSyncTaskOutput() *MigrateMySQLAzureDbForMySQLSyncTaskOutput {
	return &MigrateMySQLAzureDbForMySQLSyncTaskOutput{
		ID:         m.ID,
		ResultType: m.ResultType,
	}
}

type MigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseLevel struct {
	// REQUIRED; Result type
	ResultType *string

	// READ-ONLY; Number of applied changes
	AppliedChanges *int64

	// READ-ONLY; Number of cdc deletes
	CdcDeleteCounter *int64

	// READ-ONLY; Number of cdc inserts
	CdcInsertCounter *int64

	// READ-ONLY; Number of cdc updates
	CdcUpdateCounter *int64

	// READ-ONLY; Name of the database
	DatabaseName *string

	// READ-ONLY; Migration end time
	EndedOn *time.Time

	// READ-ONLY; Number of tables completed in full load
	FullLoadCompletedTables *int64

	// READ-ONLY; Number of tables errored in full load
	FullLoadErroredTables *int64

	// READ-ONLY; Number of tables loading in full load
	FullLoadLoadingTables *int64

	// READ-ONLY; Number of tables queued in full load
	FullLoadQueuedTables *int64

	// READ-ONLY; Result identifier
	ID *string

	// READ-ONLY; Number of incoming changes
	IncomingChanges *int64

	// READ-ONLY; Indicates if initial load (full load) has been completed
	InitializationCompleted *bool

	// READ-ONLY; CDC apply latency
	Latency *int64

	// READ-ONLY; Migration state that this database is in
	MigrationState *SyncDatabaseMigrationReportingState

	// READ-ONLY; Migration start time
	StartedOn *time.Time
}

// GetMigrateMySQLAzureDbForMySQLSyncTaskOutput implements the MigrateMySQLAzureDbForMySQLSyncTaskOutputClassification interface
// for type MigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseLevel.
func (m *MigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseLevel) GetMigrateMySQLAzureDbForMySQLSyncTaskOutput() *MigrateMySQLAzureDbForMySQLSyncTaskOutput {
	return &MigrateMySQLAzureDbForMySQLSyncTaskOutput{
		ID:         m.ID,
		ResultType: m.ResultType,
	}
}

type MigrateMySQLAzureDbForMySQLSyncTaskOutputError struct {
	// REQUIRED; Result type
	ResultType *string

	// READ-ONLY; Migration error
	Error *ReportableException

	// READ-ONLY; Result identifier
	ID *string
}

// GetMigrateMySQLAzureDbForMySQLSyncTaskOutput implements the MigrateMySQLAzureDbForMySQLSyncTaskOutputClassification interface
// for type MigrateMySQLAzureDbForMySQLSyncTaskOutputError.
func (m *MigrateMySQLAzureDbForMySQLSyncTaskOutputError) GetMigrateMySQLAzureDbForMySQLSyncTaskOutput() *MigrateMySQLAzureDbForMySQLSyncTaskOutput {
	return &MigrateMySQLAzureDbForMySQLSyncTaskOutput{
		ID:         m.ID,
		ResultType: m.ResultType,
	}
}

type MigrateMySQLAzureDbForMySQLSyncTaskOutputMigrationLevel struct {
	// REQUIRED; Result type
	ResultType *string

	// READ-ONLY; Migration end time
	EndedOn *time.Time

	// READ-ONLY; Result identifier
	ID *string

	// READ-ONLY; Source server name
	SourceServer *string

	// READ-ONLY; Source server version
	SourceServerVersion *string

	// READ-ONLY; Migration start time
	StartedOn *time.Time

	// READ-ONLY; Target server name
	TargetServer *string

	// READ-ONLY; Target server version
	TargetServerVersion *string
}

// GetMigrateMySQLAzureDbForMySQLSyncTaskOutput implements the MigrateMySQLAzureDbForMySQLSyncTaskOutputClassification interface
// for type MigrateMySQLAzureDbForMySQLSyncTaskOutputMigrationLevel.
func (m *MigrateMySQLAzureDbForMySQLSyncTaskOutputMigrationLevel) GetMigrateMySQLAzureDbForMySQLSyncTaskOutput() *MigrateMySQLAzureDbForMySQLSyncTaskOutput {
	return &MigrateMySQLAzureDbForMySQLSyncTaskOutput{
		ID:         m.ID,
		ResultType: m.ResultType,
	}
}

type MigrateMySQLAzureDbForMySQLSyncTaskOutputTableLevel struct {
	// REQUIRED; Result type
	ResultType *string

	// READ-ONLY; Number of applied deletes
	CdcDeleteCounter *string

	// READ-ONLY; Number of applied inserts
	CdcInsertCounter *string

	// READ-ONLY; Number of applied updates
	CdcUpdateCounter *string

	// READ-ONLY; Number of data errors occurred
	DataErrorsCounter *int64

	// READ-ONLY; Name of the database
	DatabaseName *string

	// READ-ONLY; Full load end time
	FullLoadEndedOn *time.Time

	// READ-ONLY; Estimate to finish full load
	FullLoadEstFinishTime *time.Time

	// READ-ONLY; Full load start time
	FullLoadStartedOn *time.Time

	// READ-ONLY; Number of rows applied in full load
	FullLoadTotalRows *int64

	// READ-ONLY; Result identifier
	ID *string

	// READ-ONLY; Last modified time on target
	LastModifiedTime *time.Time

	// READ-ONLY; Current state of the table migration
	State *SyncTableMigrationState

	// READ-ONLY; Name of the table
	TableName *string

	// READ-ONLY; Total number of applied changes
	TotalChangesApplied *int64
}

// GetMigrateMySQLAzureDbForMySQLSyncTaskOutput implements the MigrateMySQLAzureDbForMySQLSyncTaskOutputClassification interface
// for type MigrateMySQLAzureDbForMySQLSyncTaskOutputTableLevel.
func (m *MigrateMySQLAzureDbForMySQLSyncTaskOutputTableLevel) GetMigrateMySQLAzureDbForMySQLSyncTaskOutput() *MigrateMySQLAzureDbForMySQLSyncTaskOutput {
	return &MigrateMySQLAzureDbForMySQLSyncTaskOutput{
		ID:         m.ID,
		ResultType: m.ResultType,
	}
}

// MigrateMySQLAzureDbForMySQLSyncTaskProperties - Properties for the task that migrates MySQL databases to Azure Database
// for MySQL for online migrations
type MigrateMySQLAzureDbForMySQLSyncTaskProperties struct {
	// REQUIRED; Task type.
	TaskType *string

	// Key value pairs of client data to attach meta data information to task
	ClientData map[string]*string

	// Task input
	Input *MigrateMySQLAzureDbForMySQLSyncTaskInput

	// READ-ONLY; Array of command properties.
	Commands []CommandPropertiesClassification

	// READ-ONLY; Array of errors. This is ignored if submitted.
	Errors []*ODataError

	// READ-ONLY; Task output. This is ignored if submitted.
	Output []MigrateMySQLAzureDbForMySQLSyncTaskOutputClassification

	// READ-ONLY; The state of the task. This is ignored if submitted.
	State *TaskState
}

// GetProjectTaskProperties implements the ProjectTaskPropertiesClassification interface for type MigrateMySQLAzureDbForMySQLSyncTaskProperties.
func (m *MigrateMySQLAzureDbForMySQLSyncTaskProperties) GetProjectTaskProperties() *ProjectTaskProperties {
	return &ProjectTaskProperties{
		ClientData: m.ClientData,
		Commands:   m.Commands,
		Errors:     m.Errors,
		State:      m.State,
		TaskType:   m.TaskType,
	}
}

// MigrateOracleAzureDbForPostgreSQLSyncTaskProperties - Properties for the task that migrates Oracle to Azure Database for
// PostgreSQL for online migrations
type MigrateOracleAzureDbForPostgreSQLSyncTaskProperties struct {
	// REQUIRED; Task type.
	TaskType *string

	// Key value pairs of client data to attach meta data information to task
	ClientData map[string]*string

	// Task input
	Input *MigrateOracleAzureDbPostgreSQLSyncTaskInput

	// READ-ONLY; Array of command properties.
	Commands []CommandPropertiesClassification

	// READ-ONLY; Array of errors. This is ignored if submitted.
	Errors []*ODataError

	// READ-ONLY; Task output. This is ignored if submitted.
	Output []MigrateOracleAzureDbPostgreSQLSyncTaskOutputClassification

	// READ-ONLY; The state of the task. This is ignored if submitted.
	State *TaskState
}

// GetProjectTaskProperties implements the ProjectTaskPropertiesClassification interface for type MigrateOracleAzureDbForPostgreSQLSyncTaskProperties.
func (m *MigrateOracleAzureDbForPostgreSQLSyncTaskProperties) GetProjectTaskProperties() *ProjectTaskProperties {
	return &ProjectTaskProperties{
		ClientData: m.ClientData,
		Commands:   m.Commands,
		Errors:     m.Errors,
		State:      m.State,
		TaskType:   m.TaskType,
	}
}

// MigrateOracleAzureDbPostgreSQLSyncDatabaseInput - Database specific information for Oracle to Azure Database for PostgreSQL
// migration task inputs
type MigrateOracleAzureDbPostgreSQLSyncDatabaseInput struct {
	// How to handle object name casing: either Preserve or ToLower
	CaseManipulation *string

	// Migration settings which tune the migration behavior
	MigrationSetting map[string]*string

	// Name of the migration pipeline
	Name *string

	// Name of the source schema
	SchemaName *string

	// Source settings to tune source endpoint migration behavior
	SourceSetting map[string]*string

	// Mapping of source to target tables
	TableMap map[string]*string

	// Name of target database. Note: Target database will be truncated before starting migration.
	TargetDatabaseName *string

	// Target settings to tune target endpoint migration behavior
	TargetSetting map[string]*string
}

// MigrateOracleAzureDbPostgreSQLSyncTaskInput - Input for the task that migrates Oracle databases to Azure Database for PostgreSQL
// for online migrations
type MigrateOracleAzureDbPostgreSQLSyncTaskInput struct {
	// REQUIRED; Databases to migrate
	SelectedDatabases []*MigrateOracleAzureDbPostgreSQLSyncDatabaseInput

	// REQUIRED; Connection information for source Oracle
	SourceConnectionInfo *OracleConnectionInfo

	// REQUIRED; Connection information for target Azure Database for PostgreSQL
	TargetConnectionInfo *PostgreSQLConnectionInfo
}

// MigrateOracleAzureDbPostgreSQLSyncTaskOutput - Output for the task that migrates Oracle databases to Azure Database for
// PostgreSQL for online migrations
type MigrateOracleAzureDbPostgreSQLSyncTaskOutput struct {
	// REQUIRED; Result type
	ResultType *string

	// READ-ONLY; Result identifier
	ID *string
}

// GetMigrateOracleAzureDbPostgreSQLSyncTaskOutput implements the MigrateOracleAzureDbPostgreSQLSyncTaskOutputClassification
// interface for type MigrateOracleAzureDbPostgreSQLSyncTaskOutput.
func (m *MigrateOracleAzureDbPostgreSQLSyncTaskOutput) GetMigrateOracleAzureDbPostgreSQLSyncTaskOutput() *MigrateOracleAzureDbPostgreSQLSyncTaskOutput {
	return m
}

type MigrateOracleAzureDbPostgreSQLSyncTaskOutputDatabaseError struct {
	// REQUIRED; Result type
	ResultType *string

	// Error message
	ErrorMessage *string

	// List of error events.
	Events []*SyncMigrationDatabaseErrorEvent

	// READ-ONLY; Result identifier
	ID *string
}

// GetMigrateOracleAzureDbPostgreSQLSyncTaskOutput implements the MigrateOracleAzureDbPostgreSQLSyncTaskOutputClassification
// interface for type MigrateOracleAzureDbPostgreSQLSyncTaskOutputDatabaseError.
func (m *MigrateOracleAzureDbPostgreSQLSyncTaskOutputDatabaseError) GetMigrateOracleAzureDbPostgreSQLSyncTaskOutput() *MigrateOracleAzureDbPostgreSQLSyncTaskOutput {
	return &MigrateOracleAzureDbPostgreSQLSyncTaskOutput{
		ID:         m.ID,
		ResultType: m.ResultType,
	}
}

type MigrateOracleAzureDbPostgreSQLSyncTaskOutputDatabaseLevel struct {
	// REQUIRED; Result type
	ResultType *string

	// READ-ONLY; Number of applied changes
	AppliedChanges *int64

	// READ-ONLY; Number of cdc deletes
	CdcDeleteCounter *int64

	// READ-ONLY; Number of cdc inserts
	CdcInsertCounter *int64

	// READ-ONLY; Number of cdc updates
	CdcUpdateCounter *int64

	// READ-ONLY; Name of the database
	DatabaseName *string

	// READ-ONLY; Migration end time
	EndedOn *time.Time

	// READ-ONLY; Number of tables completed in full load
	FullLoadCompletedTables *int64

	// READ-ONLY; Number of tables errored in full load
	FullLoadErroredTables *int64

	// READ-ONLY; Number of tables loading in full load
	FullLoadLoadingTables *int64

	// READ-ONLY; Number of tables queued in full load
	FullLoadQueuedTables *int64

	// READ-ONLY; Result identifier
	ID *string

	// READ-ONLY; Number of incoming changes
	IncomingChanges *int64

	// READ-ONLY; Indicates if initial load (full load) has been completed
	InitializationCompleted *bool

	// READ-ONLY; CDC apply latency
	Latency *int64

	// READ-ONLY; Migration state that this database is in
	MigrationState *SyncDatabaseMigrationReportingState

	// READ-ONLY; Migration start time
	StartedOn *time.Time
}

// GetMigrateOracleAzureDbPostgreSQLSyncTaskOutput implements the MigrateOracleAzureDbPostgreSQLSyncTaskOutputClassification
// interface for type MigrateOracleAzureDbPostgreSQLSyncTaskOutputDatabaseLevel.
func (m *MigrateOracleAzureDbPostgreSQLSyncTaskOutputDatabaseLevel) GetMigrateOracleAzureDbPostgreSQLSyncTaskOutput() *MigrateOracleAzureDbPostgreSQLSyncTaskOutput {
	return &MigrateOracleAzureDbPostgreSQLSyncTaskOutput{
		ID:         m.ID,
		ResultType: m.ResultType,
	}
}

type MigrateOracleAzureDbPostgreSQLSyncTaskOutputError struct {
	// REQUIRED; Result type
	ResultType *string

	// READ-ONLY; Migration error
	Error *ReportableException

	// READ-ONLY; Result identifier
	ID *string
}

// GetMigrateOracleAzureDbPostgreSQLSyncTaskOutput implements the MigrateOracleAzureDbPostgreSQLSyncTaskOutputClassification
// interface for type MigrateOracleAzureDbPostgreSQLSyncTaskOutputError.
func (m *MigrateOracleAzureDbPostgreSQLSyncTaskOutputError) GetMigrateOracleAzureDbPostgreSQLSyncTaskOutput() *MigrateOracleAzureDbPostgreSQLSyncTaskOutput {
	return &MigrateOracleAzureDbPostgreSQLSyncTaskOutput{
		ID:         m.ID,
		ResultType: m.ResultType,
	}
}

type MigrateOracleAzureDbPostgreSQLSyncTaskOutputMigrationLevel struct {
	// REQUIRED; Result type
	ResultType *string

	// READ-ONLY; Migration end time
	EndedOn *time.Time

	// READ-ONLY; Result identifier
	ID *string

	// READ-ONLY; Source server name
	SourceServer *string

	// READ-ONLY; Source server version
	SourceServerVersion *string

	// READ-ONLY; Migration start time
	StartedOn *time.Time

	// READ-ONLY; Target server name
	TargetServer *string

	// READ-ONLY; Target server version
	TargetServerVersion *string
}

// GetMigrateOracleAzureDbPostgreSQLSyncTaskOutput implements the MigrateOracleAzureDbPostgreSQLSyncTaskOutputClassification
// interface for type MigrateOracleAzureDbPostgreSQLSyncTaskOutputMigrationLevel.
func (m *MigrateOracleAzureDbPostgreSQLSyncTaskOutputMigrationLevel) GetMigrateOracleAzureDbPostgreSQLSyncTaskOutput() *MigrateOracleAzureDbPostgreSQLSyncTaskOutput {
	return &MigrateOracleAzureDbPostgreSQLSyncTaskOutput{
		ID:         m.ID,
		ResultType: m.ResultType,
	}
}

type MigrateOracleAzureDbPostgreSQLSyncTaskOutputTableLevel struct {
	// REQUIRED; Result type
	ResultType *string

	// READ-ONLY; Number of applied deletes
	CdcDeleteCounter *int64

	// READ-ONLY; Number of applied inserts
	CdcInsertCounter *int64

	// READ-ONLY; Number of applied updates
	CdcUpdateCounter *int64

	// READ-ONLY; Number of data errors occurred
	DataErrorsCounter *int64

	// READ-ONLY; Name of the database
	DatabaseName *string

	// READ-ONLY; Full load end time
	FullLoadEndedOn *time.Time

	// READ-ONLY; Estimate to finish full load
	FullLoadEstFinishTime *time.Time

	// READ-ONLY; Full load start time
	FullLoadStartedOn *time.Time

	// READ-ONLY; Number of rows applied in full load
	FullLoadTotalRows *int64

	// READ-ONLY; Result identifier
	ID *string

	// READ-ONLY; Last modified time on target
	LastModifiedTime *time.Time

	// READ-ONLY; Current state of the table migration
	State *SyncTableMigrationState

	// READ-ONLY; Name of the table
	TableName *string

	// READ-ONLY; Total number of applied changes
	TotalChangesApplied *int64
}

// GetMigrateOracleAzureDbPostgreSQLSyncTaskOutput implements the MigrateOracleAzureDbPostgreSQLSyncTaskOutputClassification
// interface for type MigrateOracleAzureDbPostgreSQLSyncTaskOutputTableLevel.
func (m *MigrateOracleAzureDbPostgreSQLSyncTaskOutputTableLevel) GetMigrateOracleAzureDbPostgreSQLSyncTaskOutput() *MigrateOracleAzureDbPostgreSQLSyncTaskOutput {
	return &MigrateOracleAzureDbPostgreSQLSyncTaskOutput{
		ID:         m.ID,
		ResultType: m.ResultType,
	}
}

// MigratePostgreSQLAzureDbForPostgreSQLSyncDatabaseInput - Database specific information for PostgreSQL to Azure Database
// for PostgreSQL migration task inputs
type MigratePostgreSQLAzureDbForPostgreSQLSyncDatabaseInput struct {
	// Migration settings which tune the migration behavior
	MigrationSetting map[string]*string

	// Name of the database
	Name *string

	// Tables selected for migration
	SelectedTables []*MigratePostgreSQLAzureDbForPostgreSQLSyncDatabaseTableInput

	// Source settings to tune source endpoint migration behavior
	SourceSetting map[string]*string

	// Name of target database. Note: Target database will be truncated before starting migration.
	TargetDatabaseName *string

	// Target settings to tune target endpoint migration behavior
	TargetSetting map[string]*string
}

// MigratePostgreSQLAzureDbForPostgreSQLSyncDatabaseTableInput - Selected tables for the migration
type MigratePostgreSQLAzureDbForPostgreSQLSyncDatabaseTableInput struct {
	// Name of the table to migrate
	Name *string
}

// MigratePostgreSQLAzureDbForPostgreSQLSyncTaskInput - Input for the task that migrates PostgreSQL databases to Azure Database
// for PostgreSQL for online migrations
type MigratePostgreSQLAzureDbForPostgreSQLSyncTaskInput struct {
	// REQUIRED; Databases to migrate
	SelectedDatabases []*MigratePostgreSQLAzureDbForPostgreSQLSyncDatabaseInput

	// REQUIRED; Connection information for source PostgreSQL
	SourceConnectionInfo *PostgreSQLConnectionInfo

	// REQUIRED; Connection information for target Azure Database for PostgreSQL
	TargetConnectionInfo *PostgreSQLConnectionInfo
}

// MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput - Output for the task that migrates PostgreSQL databases to Azure Database
// for PostgreSQL for online migrations
type MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput struct {
	// REQUIRED; Result type
	ResultType *string

	// READ-ONLY; Result identifier
	ID *string
}

// GetMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput implements the MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputClassification
// interface for type MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput.
func (m *MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput) GetMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput() *MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput {
	return m
}

type MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseError struct {
	// REQUIRED; Result type
	ResultType *string

	// Error message
	ErrorMessage *string

	// List of error events.
	Events []*SyncMigrationDatabaseErrorEvent

	// READ-ONLY; Result identifier
	ID *string
}

// GetMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput implements the MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputClassification
// interface for type MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseError.
func (m *MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseError) GetMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput() *MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput {
	return &MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput{
		ID:         m.ID,
		ResultType: m.ResultType,
	}
}

type MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseLevel struct {
	// REQUIRED; Result type
	ResultType *string

	// READ-ONLY; Number of applied changes
	AppliedChanges *int64

	// READ-ONLY; Number of cdc deletes
	CdcDeleteCounter *int64

	// READ-ONLY; Number of cdc inserts
	CdcInsertCounter *int64

	// READ-ONLY; Number of cdc updates
	CdcUpdateCounter *int64

	// READ-ONLY; Name of the database
	DatabaseName *string

	// READ-ONLY; Migration end time
	EndedOn *time.Time

	// READ-ONLY; Number of tables completed in full load
	FullLoadCompletedTables *int64

	// READ-ONLY; Number of tables errored in full load
	FullLoadErroredTables *int64

	// READ-ONLY; Number of tables loading in full load
	FullLoadLoadingTables *int64

	// READ-ONLY; Number of tables queued in full load
	FullLoadQueuedTables *int64

	// READ-ONLY; Result identifier
	ID *string

	// READ-ONLY; Number of incoming changes
	IncomingChanges *int64

	// READ-ONLY; Indicates if initial load (full load) has been completed
	InitializationCompleted *bool

	// READ-ONLY; CDC apply latency
	Latency *int64

	// READ-ONLY; Migration state that this database is in
	MigrationState *SyncDatabaseMigrationReportingState

	// READ-ONLY; Migration start time
	StartedOn *time.Time
}

// GetMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput implements the MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputClassification
// interface for type MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseLevel.
func (m *MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseLevel) GetMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput() *MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput {
	return &MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput{
		ID:         m.ID,
		ResultType: m.ResultType,
	}
}

type MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputError struct {
	// REQUIRED; Result type
	ResultType *string

	// READ-ONLY; Migration error
	Error *ReportableException

	// READ-ONLY; Result identifier
	ID *string
}

// GetMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput implements the MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputClassification
// interface for type MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputError.
func (m *MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputError) GetMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput() *MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput {
	return &MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput{
		ID:         m.ID,
		ResultType: m.ResultType,
	}
}

type MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputMigrationLevel struct {
	// REQUIRED; Result type
	ResultType *string

	// READ-ONLY; Migration end time
	EndedOn *time.Time

	// READ-ONLY; Result identifier
	ID *string

	// READ-ONLY; Source server name
	SourceServer *string

	// READ-ONLY; Source server type.
	SourceServerType *ScenarioSource

	// READ-ONLY; Source server version
	SourceServerVersion *string

	// READ-ONLY; Migration start time
	StartedOn *time.Time

	// READ-ONLY; Migration status
	State *ReplicateMigrationState

	// READ-ONLY; Target server name
	TargetServer *string

	// READ-ONLY; Target server type.
	TargetServerType *ScenarioTarget

	// READ-ONLY; Target server version
	TargetServerVersion *string
}

// GetMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput implements the MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputClassification
// interface for type MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputMigrationLevel.
func (m *MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputMigrationLevel) GetMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput() *MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput {
	return &MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput{
		ID:         m.ID,
		ResultType: m.ResultType,
	}
}

type MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputTableLevel struct {
	// REQUIRED; Result type
	ResultType *string

	// READ-ONLY; Number of applied deletes
	CdcDeleteCounter *int64

	// READ-ONLY; Number of applied inserts
	CdcInsertCounter *int64

	// READ-ONLY; Number of applied updates
	CdcUpdateCounter *int64

	// READ-ONLY; Number of data errors occurred
	DataErrorsCounter *int64

	// READ-ONLY; Name of the database
	DatabaseName *string

	// READ-ONLY; Full load end time
	FullLoadEndedOn *time.Time

	// READ-ONLY; Estimate to finish full load
	FullLoadEstFinishTime *time.Time

	// READ-ONLY; Full load start time
	FullLoadStartedOn *time.Time

	// READ-ONLY; Number of rows applied in full load
	FullLoadTotalRows *int64

	// READ-ONLY; Result identifier
	ID *string

	// READ-ONLY; Last modified time on target
	LastModifiedTime *time.Time

	// READ-ONLY; Current state of the table migration
	State *SyncTableMigrationState

	// READ-ONLY; Name of the table
	TableName *string

	// READ-ONLY; Total number of applied changes
	TotalChangesApplied *int64
}

// GetMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput implements the MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputClassification
// interface for type MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputTableLevel.
func (m *MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputTableLevel) GetMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput() *MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput {
	return &MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput{
		ID:         m.ID,
		ResultType: m.ResultType,
	}
}

// MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties - Properties for the task that migrates PostgreSQL databases to
// Azure Database for PostgreSQL for online migrations
type MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties struct {
	// REQUIRED; Task type.
	TaskType *string

	// Key value pairs of client data to attach meta data information to task
	ClientData map[string]*string

	// Task input
	Input *MigratePostgreSQLAzureDbForPostgreSQLSyncTaskInput

	// READ-ONLY; Array of command properties.
	Commands []CommandPropertiesClassification

	// READ-ONLY; Array of errors. This is ignored if submitted.
	Errors []*ODataError

	// READ-ONLY; Task output. This is ignored if submitted.
	Output []MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputClassification

	// READ-ONLY; The state of the task. This is ignored if submitted.
	State *TaskState
}

// GetProjectTaskProperties implements the ProjectTaskPropertiesClassification interface for type MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties.
func (m *MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties) GetProjectTaskProperties() *ProjectTaskProperties {
	return &ProjectTaskProperties{
		ClientData: m.ClientData,
		Commands:   m.Commands,
		Errors:     m.Errors,
		State:      m.State,
		TaskType:   m.TaskType,
	}
}

// MigrateSQLServerDatabaseInput - Database specific information for SQL to SQL migration task inputs
type MigrateSQLServerDatabaseInput struct {
	// The backup and restore folder
	BackupAndRestoreFolder *string

	// The list of database files
	DatabaseFiles []*DatabaseFileInput

	// Name of the database
	Name *string

	// Name of the database at destination
	RestoreDatabaseName *string
}

// MigrateSQLServerSQLDbDatabaseInput - Database specific information for SQL to Azure SQL DB migration task inputs
type MigrateSQLServerSQLDbDatabaseInput struct {
	// Whether to set database read only before migration
	MakeSourceDbReadOnly *bool

	// Name of the database
	Name *string

	// Mapping of source to target tables
	TableMap map[string]*string

	// Name of target database. Note: Target database will be truncated before starting migration.
	TargetDatabaseName *string
}

// MigrateSQLServerSQLDbSyncDatabaseInput - Database specific information for SQL to Azure SQL DB sync migration task inputs
type MigrateSQLServerSQLDbSyncDatabaseInput struct {
	// Unique identifier for database
	ID *string

	// Migration settings which tune the migration behavior
	MigrationSetting map[string]*string

	// Name of database
	Name *string

	// Schema name to be migrated
	SchemaName *string

	// Source settings to tune source endpoint migration behavior
	SourceSetting map[string]*string

	// Mapping of source to target tables
	TableMap map[string]*string

	// Target database name
	TargetDatabaseName *string

	// Target settings to tune target endpoint migration behavior
	TargetSetting map[string]*string
}

// MigrateSQLServerSQLDbSyncTaskInput - Input for the task that migrates on-prem SQL Server databases to Azure SQL Database
// for online migrations
type MigrateSQLServerSQLDbSyncTaskInput struct {
	// REQUIRED; Databases to migrate
	SelectedDatabases []*MigrateSQLServerSQLDbSyncDatabaseInput

	// REQUIRED; Information for connecting to source
	SourceConnectionInfo *SQLConnectionInfo

	// REQUIRED; Information for connecting to target
	TargetConnectionInfo *SQLConnectionInfo

	// Validation options
	ValidationOptions *MigrationValidationOptions
}

// MigrateSQLServerSQLDbSyncTaskOutput - Output for the task that migrates on-prem SQL Server databases to Azure SQL Database
// for online migrations
type MigrateSQLServerSQLDbSyncTaskOutput struct {
	// REQUIRED; Result type
	ResultType *string

	// READ-ONLY; Result identifier
	ID *string
}

// GetMigrateSQLServerSQLDbSyncTaskOutput implements the MigrateSQLServerSQLDbSyncTaskOutputClassification interface for type
// MigrateSQLServerSQLDbSyncTaskOutput.
func (m *MigrateSQLServerSQLDbSyncTaskOutput) GetMigrateSQLServerSQLDbSyncTaskOutput() *MigrateSQLServerSQLDbSyncTaskOutput {
	return m
}

type MigrateSQLServerSQLDbSyncTaskOutputDatabaseError struct {
	// REQUIRED; Result type
	ResultType *string

	// Error message
	ErrorMessage *string

	// List of error events.
	Events []*SyncMigrationDatabaseErrorEvent

	// READ-ONLY; Result identifier
	ID *string
}

// GetMigrateSQLServerSQLDbSyncTaskOutput implements the MigrateSQLServerSQLDbSyncTaskOutputClassification interface for type
// MigrateSQLServerSQLDbSyncTaskOutputDatabaseError.
func (m *MigrateSQLServerSQLDbSyncTaskOutputDatabaseError) GetMigrateSQLServerSQLDbSyncTaskOutput() *MigrateSQLServerSQLDbSyncTaskOutput {
	return &MigrateSQLServerSQLDbSyncTaskOutput{
		ID:         m.ID,
		ResultType: m.ResultType,
	}
}

type MigrateSQLServerSQLDbSyncTaskOutputDatabaseLevel struct {
	// REQUIRED; Result type
	ResultType *string

	// READ-ONLY; Number of applied changes
	AppliedChanges *int64

	// READ-ONLY; Number of cdc deletes
	CdcDeleteCounter *int64

	// READ-ONLY; Number of cdc inserts
	CdcInsertCounter *int64

	// READ-ONLY; Number of cdc updates
	CdcUpdateCounter *int64

	// READ-ONLY; Name of the database
	DatabaseName *string

	// READ-ONLY; Migration end time
	EndedOn *time.Time

	// READ-ONLY; Number of tables completed in full load
	FullLoadCompletedTables *int64

	// READ-ONLY; Number of tables errored in full load
	FullLoadErroredTables *int64

	// READ-ONLY; Number of tables loading in full load
	FullLoadLoadingTables *int64

	// READ-ONLY; Number of tables queued in full load
	FullLoadQueuedTables *int64

	// READ-ONLY; Result identifier
	ID *string

	// READ-ONLY; Number of incoming changes
	IncomingChanges *int64

	// READ-ONLY; Indicates if initial load (full load) has been completed
	InitializationCompleted *bool

	// READ-ONLY; CDC apply latency
	Latency *int64

	// READ-ONLY; Migration state that this database is in
	MigrationState *SyncDatabaseMigrationReportingState

	// READ-ONLY; Migration start time
	StartedOn *time.Time
}

// GetMigrateSQLServerSQLDbSyncTaskOutput implements the MigrateSQLServerSQLDbSyncTaskOutputClassification interface for type
// MigrateSQLServerSQLDbSyncTaskOutputDatabaseLevel.
func (m *MigrateSQLServerSQLDbSyncTaskOutputDatabaseLevel) GetMigrateSQLServerSQLDbSyncTaskOutput() *MigrateSQLServerSQLDbSyncTaskOutput {
	return &MigrateSQLServerSQLDbSyncTaskOutput{
		ID:         m.ID,
		ResultType: m.ResultType,
	}
}

type MigrateSQLServerSQLDbSyncTaskOutputError struct {
	// REQUIRED; Result type
	ResultType *string

	// READ-ONLY; Migration error
	Error *ReportableException

	// READ-ONLY; Result identifier
	ID *string
}

// GetMigrateSQLServerSQLDbSyncTaskOutput implements the MigrateSQLServerSQLDbSyncTaskOutputClassification interface for type
// MigrateSQLServerSQLDbSyncTaskOutputError.
func (m *MigrateSQLServerSQLDbSyncTaskOutputError) GetMigrateSQLServerSQLDbSyncTaskOutput() *MigrateSQLServerSQLDbSyncTaskOutput {
	return &MigrateSQLServerSQLDbSyncTaskOutput{
		ID:         m.ID,
		ResultType: m.ResultType,
	}
}

type MigrateSQLServerSQLDbSyncTaskOutputMigrationLevel struct {
	// REQUIRED; Result type
	ResultType *string

	// READ-ONLY; Count of databases
	DatabaseCount *int32

	// READ-ONLY; Migration end time
	EndedOn *time.Time

	// READ-ONLY; Result identifier
	ID *string

	// READ-ONLY; Source server name
	SourceServer *string

	// READ-ONLY; Source server version
	SourceServerVersion *string

	// READ-ONLY; Migration start time
	StartedOn *time.Time

	// READ-ONLY; Target server name
	TargetServer *string

	// READ-ONLY; Target server version
	TargetServerVersion *string
}

// GetMigrateSQLServerSQLDbSyncTaskOutput implements the MigrateSQLServerSQLDbSyncTaskOutputClassification interface for type
// MigrateSQLServerSQLDbSyncTaskOutputMigrationLevel.
func (m *MigrateSQLServerSQLDbSyncTaskOutputMigrationLevel) GetMigrateSQLServerSQLDbSyncTaskOutput() *MigrateSQLServerSQLDbSyncTaskOutput {
	return &MigrateSQLServerSQLDbSyncTaskOutput{
		ID:         m.ID,
		ResultType: m.ResultType,
	}
}

type MigrateSQLServerSQLDbSyncTaskOutputTableLevel struct {
	// REQUIRED; Result type
	ResultType *string

	// READ-ONLY; Number of applied deletes
	CdcDeleteCounter *int64

	// READ-ONLY; Number of applied inserts
	CdcInsertCounter *int64

	// READ-ONLY; Number of applied updates
	CdcUpdateCounter *int64

	// READ-ONLY; Number of data errors occurred
	DataErrorsCounter *int64

	// READ-ONLY; Name of the database
	DatabaseName *string

	// READ-ONLY; Full load end time
	FullLoadEndedOn *time.Time

	// READ-ONLY; Estimate to finish full load
	FullLoadEstFinishTime *time.Time

	// READ-ONLY; Full load start time
	FullLoadStartedOn *time.Time

	// READ-ONLY; Number of rows applied in full load
	FullLoadTotalRows *int64

	// READ-ONLY; Result identifier
	ID *string

	// READ-ONLY; Last modified time on target
	LastModifiedTime *time.Time

	// READ-ONLY; Current state of the table migration
	State *SyncTableMigrationState

	// READ-ONLY; Name of the table
	TableName *string

	// READ-ONLY; Total number of applied changes
	TotalChangesApplied *int64
}

// GetMigrateSQLServerSQLDbSyncTaskOutput implements the MigrateSQLServerSQLDbSyncTaskOutputClassification interface for type
// MigrateSQLServerSQLDbSyncTaskOutputTableLevel.
func (m *MigrateSQLServerSQLDbSyncTaskOutputTableLevel) GetMigrateSQLServerSQLDbSyncTaskOutput() *MigrateSQLServerSQLDbSyncTaskOutput {
	return &MigrateSQLServerSQLDbSyncTaskOutput{
		ID:         m.ID,
		ResultType: m.ResultType,
	}
}

// MigrateSQLServerSQLDbSyncTaskProperties - Properties for the task that migrates on-prem SQL Server databases to Azure SQL
// Database for online migrations
type MigrateSQLServerSQLDbSyncTaskProperties struct {
	// REQUIRED; Task type.
	TaskType *string

	// Key value pairs of client data to attach meta data information to task
	ClientData map[string]*string

	// Task input
	Input *MigrateSQLServerSQLDbSyncTaskInput

	// READ-ONLY; Array of command properties.
	Commands []CommandPropertiesClassification

	// READ-ONLY; Array of errors. This is ignored if submitted.
	Errors []*ODataError

	// READ-ONLY; Task output. This is ignored if submitted.
	Output []MigrateSQLServerSQLDbSyncTaskOutputClassification

	// READ-ONLY; The state of the task. This is ignored if submitted.
	State *TaskState
}

// GetProjectTaskProperties implements the ProjectTaskPropertiesClassification interface for type MigrateSQLServerSQLDbSyncTaskProperties.
func (m *MigrateSQLServerSQLDbSyncTaskProperties) GetProjectTaskProperties() *ProjectTaskProperties {
	return &ProjectTaskProperties{
		ClientData: m.ClientData,
		Commands:   m.Commands,
		Errors:     m.Errors,
		State:      m.State,
		TaskType:   m.TaskType,
	}
}

// MigrateSQLServerSQLDbTaskInput - Input for the task that migrates on-prem SQL Server databases to Azure SQL Database
type MigrateSQLServerSQLDbTaskInput struct {
	// REQUIRED; Databases to migrate
	SelectedDatabases []*MigrateSQLServerSQLDbDatabaseInput

	// REQUIRED; Information for connecting to source
	SourceConnectionInfo *SQLConnectionInfo

	// REQUIRED; Information for connecting to target
	TargetConnectionInfo *SQLConnectionInfo

	// Options for enabling various post migration validations. Available options, 1.) Data Integrity Check: Performs a checksum
	// based comparison on source and target tables after the migration to ensure the
	// correctness of the data. 2.) Schema Validation: Performs a thorough schema comparison between the source and target tables
	// and provides a list of differences between the source and target database,
	// 3.) Query Analysis: Executes a set of queries picked up automatically either from the Query Plan Cache or Query Store and
	// execute them and compares the execution time between the source and target
	// database.
	ValidationOptions *MigrationValidationOptions
}

// MigrateSQLServerSQLDbTaskOutput - Output for the task that migrates on-prem SQL Server databases to Azure SQL Database
type MigrateSQLServerSQLDbTaskOutput struct {
	// REQUIRED; Result type
	ResultType *string

	// READ-ONLY; Result identifier
	ID *string
}

// GetMigrateSQLServerSQLDbTaskOutput implements the MigrateSQLServerSQLDbTaskOutputClassification interface for type MigrateSQLServerSQLDbTaskOutput.
func (m *MigrateSQLServerSQLDbTaskOutput) GetMigrateSQLServerSQLDbTaskOutput() *MigrateSQLServerSQLDbTaskOutput {
	return m
}

type MigrateSQLServerSQLDbTaskOutputDatabaseLevel struct {
	// REQUIRED; Result type
	ResultType *string

	// READ-ONLY; Name of the item
	DatabaseName *string

	// READ-ONLY; Migration end time
	EndedOn *time.Time

	// READ-ONLY; Number of database/object errors.
	ErrorCount *int64

	// READ-ONLY; Wildcard string prefix to use for querying all errors of the item
	ErrorPrefix *string

	// READ-ONLY; Migration exceptions and warnings.
	ExceptionsAndWarnings []*ReportableException

	// READ-ONLY; Result identifier
	ID *string

	// READ-ONLY; Migration progress message
	Message *string

	// READ-ONLY; Number of objects
	NumberOfObjects *int64

	// READ-ONLY; Number of successfully completed objects
	NumberOfObjectsCompleted *int64

	// READ-ONLY; Summary of object results in the migration
	ObjectSummary *string

	// READ-ONLY; Wildcard string prefix to use for querying all sub-tem results of the item
	ResultPrefix *string

	// READ-ONLY; Migration stage that this database is in
	Stage *DatabaseMigrationStage

	// READ-ONLY; Migration start time
	StartedOn *time.Time

	// READ-ONLY; Current state of migration
	State *MigrationState

	// READ-ONLY; Status message
	StatusMessage *string
}

// GetMigrateSQLServerSQLDbTaskOutput implements the MigrateSQLServerSQLDbTaskOutputClassification interface for type MigrateSQLServerSQLDbTaskOutputDatabaseLevel.
func (m *MigrateSQLServerSQLDbTaskOutputDatabaseLevel) GetMigrateSQLServerSQLDbTaskOutput() *MigrateSQLServerSQLDbTaskOutput {
	return &MigrateSQLServerSQLDbTaskOutput{
		ID:         m.ID,
		ResultType: m.ResultType,
	}
}

type MigrateSQLServerSQLDbTaskOutputDatabaseLevelValidationResult struct {
	// REQUIRED; Result type
	ResultType *string

	// READ-ONLY; Provides data integrity validation result between the source and target tables that are migrated.
	DataIntegrityValidationResult *DataIntegrityValidationResult

	// READ-ONLY; Validation end time
	EndedOn *time.Time

	// READ-ONLY; Result identifier
	ID *string

	// READ-ONLY; Migration Identifier
	MigrationID *string

	// READ-ONLY; Results of some of the query execution result between source and target database
	QueryAnalysisValidationResult *QueryAnalysisValidationResult

	// READ-ONLY; Provides schema comparison result between source and target database
	SchemaValidationResult *SchemaComparisonValidationResult

	// READ-ONLY; Name of the source database
	SourceDatabaseName *string

	// READ-ONLY; Validation start time
	StartedOn *time.Time

	// READ-ONLY; Current status of validation at the database level
	Status *ValidationStatus

	// READ-ONLY; Name of the target database
	TargetDatabaseName *string
}

// GetMigrateSQLServerSQLDbTaskOutput implements the MigrateSQLServerSQLDbTaskOutputClassification interface for type MigrateSQLServerSQLDbTaskOutputDatabaseLevelValidationResult.
func (m *MigrateSQLServerSQLDbTaskOutputDatabaseLevelValidationResult) GetMigrateSQLServerSQLDbTaskOutput() *MigrateSQLServerSQLDbTaskOutput {
	return &MigrateSQLServerSQLDbTaskOutput{
		ID:         m.ID,
		ResultType: m.ResultType,
	}
}

type MigrateSQLServerSQLDbTaskOutputError struct {
	// REQUIRED; Result type
	ResultType *string

	// READ-ONLY; Migration error
	Error *ReportableException

	// READ-ONLY; Result identifier
	ID *string
}

// GetMigrateSQLServerSQLDbTaskOutput implements the MigrateSQLServerSQLDbTaskOutputClassification interface for type MigrateSQLServerSQLDbTaskOutputError.
func (m *MigrateSQLServerSQLDbTaskOutputError) GetMigrateSQLServerSQLDbTaskOutput() *MigrateSQLServerSQLDbTaskOutput {
	return &MigrateSQLServerSQLDbTaskOutput{
		ID:         m.ID,
		ResultType: m.ResultType,
	}
}

type MigrateSQLServerSQLDbTaskOutputMigrationLevel struct {
	// REQUIRED; Result type
	ResultType *string

	// Migration Report Result, provides unique url for downloading your migration report.
	MigrationReportResult *MigrationReportResult

	// Migration Validation Results
	MigrationValidationResult *MigrationValidationResult

	// READ-ONLY; Summary of database results in the migration
	DatabaseSummary *string

	// READ-ONLY; Selected databases as a map from database name to database id
	Databases *string

	// READ-ONLY; Duration of task execution in seconds.
	DurationInSeconds *int64

	// READ-ONLY; Migration end time
	EndedOn *time.Time

	// READ-ONLY; Migration exceptions and warnings.
	ExceptionsAndWarnings []*ReportableException

	// READ-ONLY; Result identifier
	ID *string

	// READ-ONLY; Migration progress message
	Message *string

	// READ-ONLY; Source server brand version
	SourceServerBrandVersion *string

	// READ-ONLY; Source server version
	SourceServerVersion *string

	// READ-ONLY; Migration start time
	StartedOn *time.Time

	// READ-ONLY; Current status of migration
	Status *MigrationStatus

	// READ-ONLY; Migration status message
	StatusMessage *string

	// READ-ONLY; Target server brand version
	TargetServerBrandVersion *string

	// READ-ONLY; Target server version
	TargetServerVersion *string
}

// GetMigrateSQLServerSQLDbTaskOutput implements the MigrateSQLServerSQLDbTaskOutputClassification interface for type MigrateSQLServerSQLDbTaskOutputMigrationLevel.
func (m *MigrateSQLServerSQLDbTaskOutputMigrationLevel) GetMigrateSQLServerSQLDbTaskOutput() *MigrateSQLServerSQLDbTaskOutput {
	return &MigrateSQLServerSQLDbTaskOutput{
		ID:         m.ID,
		ResultType: m.ResultType,
	}
}

type MigrateSQLServerSQLDbTaskOutputTableLevel struct {
	// REQUIRED; Result type
	ResultType *string

	// READ-ONLY; Migration end time
	EndedOn *time.Time

	// READ-ONLY; Wildcard string prefix to use for querying all errors of the item
	ErrorPrefix *string

	// READ-ONLY; Result identifier
	ID *string

	// READ-ONLY; Number of successfully completed items
	ItemsCompletedCount *int64

	// READ-ONLY; Number of items
	ItemsCount *int64

	// READ-ONLY; Name of the item
	ObjectName *string

	// READ-ONLY; Wildcard string prefix to use for querying all sub-tem results of the item
	ResultPrefix *string

	// READ-ONLY; Migration start time
	StartedOn *time.Time

	// READ-ONLY; Current state of migration
	State *MigrationState

	// READ-ONLY; Status message
	StatusMessage *string
}

// GetMigrateSQLServerSQLDbTaskOutput implements the MigrateSQLServerSQLDbTaskOutputClassification interface for type MigrateSQLServerSQLDbTaskOutputTableLevel.
func (m *MigrateSQLServerSQLDbTaskOutputTableLevel) GetMigrateSQLServerSQLDbTaskOutput() *MigrateSQLServerSQLDbTaskOutput {
	return &MigrateSQLServerSQLDbTaskOutput{
		ID:         m.ID,
		ResultType: m.ResultType,
	}
}

type MigrateSQLServerSQLDbTaskOutputValidationResult struct {
	// REQUIRED; Result type
	ResultType *string

	// Validation summary results for each database
	SummaryResults map[string]*MigrationValidationDatabaseSummaryResult

	// READ-ONLY; Result identifier
	ID *string

	// READ-ONLY; Migration Identifier
	MigrationID *string

	// READ-ONLY; Current status of validation at the migration level. Status from the database validation result status will
	// be aggregated here.
	Status *ValidationStatus
}

// GetMigrateSQLServerSQLDbTaskOutput implements the MigrateSQLServerSQLDbTaskOutputClassification interface for type MigrateSQLServerSQLDbTaskOutputValidationResult.
func (m *MigrateSQLServerSQLDbTaskOutputValidationResult) GetMigrateSQLServerSQLDbTaskOutput() *MigrateSQLServerSQLDbTaskOutput {
	return &MigrateSQLServerSQLDbTaskOutput{
		ID:         m.ID,
		ResultType: m.ResultType,
	}
}

// MigrateSQLServerSQLDbTaskProperties - Properties for the task that migrates on-prem SQL Server databases to Azure SQL Database
type MigrateSQLServerSQLDbTaskProperties struct {
	// REQUIRED; Task type.
	TaskType *string

	// Key value pairs of client data to attach meta data information to task
	ClientData map[string]*string

	// Task input
	Input *MigrateSQLServerSQLDbTaskInput

	// READ-ONLY; Array of command properties.
	Commands []CommandPropertiesClassification

	// READ-ONLY; Array of errors. This is ignored if submitted.
	Errors []*ODataError

	// READ-ONLY; Task output. This is ignored if submitted.
	Output []MigrateSQLServerSQLDbTaskOutputClassification

	// READ-ONLY; The state of the task. This is ignored if submitted.
	State *TaskState
}

// GetProjectTaskProperties implements the ProjectTaskPropertiesClassification interface for type MigrateSQLServerSQLDbTaskProperties.
func (m *MigrateSQLServerSQLDbTaskProperties) GetProjectTaskProperties() *ProjectTaskProperties {
	return &ProjectTaskProperties{
		ClientData: m.ClientData,
		Commands:   m.Commands,
		Errors:     m.Errors,
		State:      m.State,
		TaskType:   m.TaskType,
	}
}

// MigrateSQLServerSQLMIDatabaseInput - Database specific information for SQL to Azure SQL DB Managed Instance migration task
// inputs
type MigrateSQLServerSQLMIDatabaseInput struct {
	// REQUIRED; Name of the database
	Name *string

	// REQUIRED; Name of the database at destination
	RestoreDatabaseName *string

	// The list of backup files to be used in case of existing backups.
	BackupFilePaths []*string

	// Backup file share information for backing up this database.
	BackupFileShare *FileShare
}

// MigrateSQLServerSQLMISyncTaskInput - Input for task that migrates SQL Server databases to Azure SQL Database Managed Instance
// online scenario.
type MigrateSQLServerSQLMISyncTaskInput struct {
	// REQUIRED; Azure Active Directory Application the DMS instance will use to connect to the target instance of Azure SQL Database
	// Managed Instance and the Azure Storage Account
	AzureApp *AzureActiveDirectoryApp

	// REQUIRED; Databases to migrate
	SelectedDatabases []*MigrateSQLServerSQLMIDatabaseInput

	// REQUIRED; Connection information for source SQL Server
	SourceConnectionInfo *SQLConnectionInfo

	// REQUIRED; Fully qualified resourceId of storage
	StorageResourceID *string

	// REQUIRED; Connection information for Azure SQL Database Managed Instance
	TargetConnectionInfo *MiSQLConnectionInfo

	// Backup file share information for all selected databases.
	BackupFileShare *FileShare
}

// MigrateSQLServerSQLMISyncTaskOutput - Output for task that migrates SQL Server databases to Azure SQL Database Managed
// Instance using Log Replay Service.
type MigrateSQLServerSQLMISyncTaskOutput struct {
	// REQUIRED; Result type
	ResultType *string

	// READ-ONLY; Result identifier
	ID *string
}

// GetMigrateSQLServerSQLMISyncTaskOutput implements the MigrateSQLServerSQLMISyncTaskOutputClassification interface for type
// MigrateSQLServerSQLMISyncTaskOutput.
func (m *MigrateSQLServerSQLMISyncTaskOutput) GetMigrateSQLServerSQLMISyncTaskOutput() *MigrateSQLServerSQLMISyncTaskOutput {
	return m
}

type MigrateSQLServerSQLMISyncTaskOutputDatabaseLevel struct {
	// REQUIRED; Result type
	ResultType *string

	// READ-ONLY; Backup sets that are currently active (Either being uploaded or getting restored)
	ActiveBackupSets []*BackupSetInfo

	// READ-ONLY; Name of container created in the Azure Storage account where backups are copied to
	ContainerName *string

	// READ-ONLY; Database migration end time
	EndedOn *time.Time

	// READ-ONLY; prefix string to use for querying errors for this database
	ErrorPrefix *string

	// READ-ONLY; Migration exceptions and warnings
	ExceptionsAndWarnings []*ReportableException

	// READ-ONLY; Details of full backup set
	FullBackupSetInfo *BackupSetInfo

	// READ-ONLY; Result identifier
	ID *string

	// READ-ONLY; Whether full backup has been applied to the target database or not
	IsFullBackupRestored *bool

	// READ-ONLY; Last applied backup set information
	LastRestoredBackupSetInfo *BackupSetInfo

	// READ-ONLY; Current state of database
	MigrationState *DatabaseMigrationState

	// READ-ONLY; Name of the database
	SourceDatabaseName *string

	// READ-ONLY; Database migration start time
	StartedOn *time.Time
}

// GetMigrateSQLServerSQLMISyncTaskOutput implements the MigrateSQLServerSQLMISyncTaskOutputClassification interface for type
// MigrateSQLServerSQLMISyncTaskOutputDatabaseLevel.
func (m *MigrateSQLServerSQLMISyncTaskOutputDatabaseLevel) GetMigrateSQLServerSQLMISyncTaskOutput() *MigrateSQLServerSQLMISyncTaskOutput {
	return &MigrateSQLServerSQLMISyncTaskOutput{
		ID:         m.ID,
		ResultType: m.ResultType,
	}
}

type MigrateSQLServerSQLMISyncTaskOutputError struct {
	// REQUIRED; Result type
	ResultType *string

	// READ-ONLY; Migration error
	Error *ReportableException

	// READ-ONLY; Result identifier
	ID *string
}

// GetMigrateSQLServerSQLMISyncTaskOutput implements the MigrateSQLServerSQLMISyncTaskOutputClassification interface for type
// MigrateSQLServerSQLMISyncTaskOutputError.
func (m *MigrateSQLServerSQLMISyncTaskOutputError) GetMigrateSQLServerSQLMISyncTaskOutput() *MigrateSQLServerSQLMISyncTaskOutput {
	return &MigrateSQLServerSQLMISyncTaskOutput{
		ID:         m.ID,
		ResultType: m.ResultType,
	}
}

type MigrateSQLServerSQLMISyncTaskOutputMigrationLevel struct {
	// REQUIRED; Result type
	ResultType *string

	// READ-ONLY; Count of databases
	DatabaseCount *int32

	// READ-ONLY; Number of database level errors
	DatabaseErrorCount *int32

	// READ-ONLY; Migration end time
	EndedOn *time.Time

	// READ-ONLY; Result identifier
	ID *string

	// READ-ONLY; Source server brand version
	SourceServerBrandVersion *string

	// READ-ONLY; Source server name
	SourceServerName *string

	// READ-ONLY; Source server version
	SourceServerVersion *string

	// READ-ONLY; Migration start time
	StartedOn *time.Time

	// READ-ONLY; Current state of migration
	State *MigrationState

	// READ-ONLY; Target server brand version
	TargetServerBrandVersion *string

	// READ-ONLY; Target server name
	TargetServerName *string

	// READ-ONLY; Target server version
	TargetServerVersion *string
}

// GetMigrateSQLServerSQLMISyncTaskOutput implements the MigrateSQLServerSQLMISyncTaskOutputClassification interface for type
// MigrateSQLServerSQLMISyncTaskOutputMigrationLevel.
func (m *MigrateSQLServerSQLMISyncTaskOutputMigrationLevel) GetMigrateSQLServerSQLMISyncTaskOutput() *MigrateSQLServerSQLMISyncTaskOutput {
	return &MigrateSQLServerSQLMISyncTaskOutput{
		ID:         m.ID,
		ResultType: m.ResultType,
	}
}

// MigrateSQLServerSQLMISyncTaskProperties - Properties for task that migrates SQL Server databases to Azure SQL Database
// Managed Instance sync scenario
type MigrateSQLServerSQLMISyncTaskProperties struct {
	// REQUIRED; Task type.
	TaskType *string

	// Key value pairs of client data to attach meta data information to task
	ClientData map[string]*string

	// Task input
	Input *MigrateSQLServerSQLMISyncTaskInput

	// READ-ONLY; Array of command properties.
	Commands []CommandPropertiesClassification

	// READ-ONLY; Array of errors. This is ignored if submitted.
	Errors []*ODataError

	// READ-ONLY; Task output. This is ignored if submitted.
	Output []MigrateSQLServerSQLMISyncTaskOutputClassification

	// READ-ONLY; The state of the task. This is ignored if submitted.
	State *TaskState
}

// GetProjectTaskProperties implements the ProjectTaskPropertiesClassification interface for type MigrateSQLServerSQLMISyncTaskProperties.
func (m *MigrateSQLServerSQLMISyncTaskProperties) GetProjectTaskProperties() *ProjectTaskProperties {
	return &ProjectTaskProperties{
		ClientData: m.ClientData,
		Commands:   m.Commands,
		Errors:     m.Errors,
		State:      m.State,
		TaskType:   m.TaskType,
	}
}

// MigrateSQLServerSQLMITaskInput - Input for task that migrates SQL Server databases to Azure SQL Database Managed Instance.
type MigrateSQLServerSQLMITaskInput struct {
	// REQUIRED; SAS URI of Azure Storage Account Container to be used for storing backup files.
	BackupBlobShare *BlobShare

	// REQUIRED; Databases to migrate
	SelectedDatabases []*MigrateSQLServerSQLMIDatabaseInput

	// REQUIRED; Information for connecting to source
	SourceConnectionInfo *SQLConnectionInfo

	// REQUIRED; Information for connecting to target
	TargetConnectionInfo *SQLConnectionInfo

	// Azure Active Directory domain name in the format of 'contoso.com' for federated Azure AD or 'contoso.onmicrosoft.com' for
	// managed domain, required if and only if Windows logins are selected
	AADDomainName *string

	// Backup file share information for all selected databases.
	BackupFileShare *FileShare

	// Backup Mode to specify whether to use existing backup or create new backup. If using existing backups, backup file paths
	// are required to be provided in selectedDatabases.
	BackupMode *BackupMode

	// Agent Jobs to migrate.
	SelectedAgentJobs []*string

	// Logins to migrate.
	SelectedLogins []*string
}

// MigrateSQLServerSQLMITaskOutput - Output for task that migrates SQL Server databases to Azure SQL Database Managed Instance.
type MigrateSQLServerSQLMITaskOutput struct {
	// REQUIRED; Result type
	ResultType *string

	// READ-ONLY; Result identifier
	ID *string
}

// GetMigrateSQLServerSQLMITaskOutput implements the MigrateSQLServerSQLMITaskOutputClassification interface for type MigrateSQLServerSQLMITaskOutput.
func (m *MigrateSQLServerSQLMITaskOutput) GetMigrateSQLServerSQLMITaskOutput() *MigrateSQLServerSQLMITaskOutput {
	return m
}

type MigrateSQLServerSQLMITaskOutputAgentJobLevel struct {
	// REQUIRED; Result type
	ResultType *string

	// READ-ONLY; Migration end time
	EndedOn *time.Time

	// READ-ONLY; Migration errors and warnings per job
	ExceptionsAndWarnings []*ReportableException

	// READ-ONLY; Result identifier
	ID *string

	// READ-ONLY; The state of the original Agent Job.
	IsEnabled *bool

	// READ-ONLY; Migration progress message
	Message *string

	// READ-ONLY; Agent Job name.
	Name *string

	// READ-ONLY; Migration start time
	StartedOn *time.Time

	// READ-ONLY; Current state of migration
	State *MigrationState
}

// GetMigrateSQLServerSQLMITaskOutput implements the MigrateSQLServerSQLMITaskOutputClassification interface for type MigrateSQLServerSQLMITaskOutputAgentJobLevel.
func (m *MigrateSQLServerSQLMITaskOutputAgentJobLevel) GetMigrateSQLServerSQLMITaskOutput() *MigrateSQLServerSQLMITaskOutput {
	return &MigrateSQLServerSQLMITaskOutput{
		ID:         m.ID,
		ResultType: m.ResultType,
	}
}

type MigrateSQLServerSQLMITaskOutputDatabaseLevel struct {
	// REQUIRED; Result type
	ResultType *string

	// READ-ONLY; Name of the database
	DatabaseName *string

	// READ-ONLY; Migration end time
	EndedOn *time.Time

	// READ-ONLY; Migration exceptions and warnings
	ExceptionsAndWarnings []*ReportableException

	// READ-ONLY; Result identifier
	ID *string

	// READ-ONLY; Migration progress message
	Message *string

	// READ-ONLY; Size of the database in megabytes
	SizeMB *float64

	// READ-ONLY; Current stage of migration
	Stage *DatabaseMigrationStage

	// READ-ONLY; Migration start time
	StartedOn *time.Time

	// READ-ONLY; Current state of migration
	State *MigrationState
}

// GetMigrateSQLServerSQLMITaskOutput implements the MigrateSQLServerSQLMITaskOutputClassification interface for type MigrateSQLServerSQLMITaskOutputDatabaseLevel.
func (m *MigrateSQLServerSQLMITaskOutputDatabaseLevel) GetMigrateSQLServerSQLMITaskOutput() *MigrateSQLServerSQLMITaskOutput {
	return &MigrateSQLServerSQLMITaskOutput{
		ID:         m.ID,
		ResultType: m.ResultType,
	}
}

type MigrateSQLServerSQLMITaskOutputError struct {
	// REQUIRED; Result type
	ResultType *string

	// READ-ONLY; Migration error
	Error *ReportableException

	// READ-ONLY; Result identifier
	ID *string
}

// GetMigrateSQLServerSQLMITaskOutput implements the MigrateSQLServerSQLMITaskOutputClassification interface for type MigrateSQLServerSQLMITaskOutputError.
func (m *MigrateSQLServerSQLMITaskOutputError) GetMigrateSQLServerSQLMITaskOutput() *MigrateSQLServerSQLMITaskOutput {
	return &MigrateSQLServerSQLMITaskOutput{
		ID:         m.ID,
		ResultType: m.ResultType,
	}
}

type MigrateSQLServerSQLMITaskOutputLoginLevel struct {
	// REQUIRED; Result type
	ResultType *string

	// READ-ONLY; Login migration end time
	EndedOn *time.Time

	// READ-ONLY; Login migration errors and warnings per login
	ExceptionsAndWarnings []*ReportableException

	// READ-ONLY; Result identifier
	ID *string

	// READ-ONLY; Login name.
	LoginName *string

	// READ-ONLY; Login migration progress message
	Message *string

	// READ-ONLY; Current stage of login
	Stage *LoginMigrationStage

	// READ-ONLY; Login migration start time
	StartedOn *time.Time

	// READ-ONLY; Current state of login
	State *MigrationState
}

// GetMigrateSQLServerSQLMITaskOutput implements the MigrateSQLServerSQLMITaskOutputClassification interface for type MigrateSQLServerSQLMITaskOutputLoginLevel.
func (m *MigrateSQLServerSQLMITaskOutputLoginLevel) GetMigrateSQLServerSQLMITaskOutput() *MigrateSQLServerSQLMITaskOutput {
	return &MigrateSQLServerSQLMITaskOutput{
		ID:         m.ID,
		ResultType: m.ResultType,
	}
}

type MigrateSQLServerSQLMITaskOutputMigrationLevel struct {
	// REQUIRED; Result type
	ResultType *string

	// READ-ONLY; Selected agent jobs as a map from name to id
	AgentJobs *string

	// READ-ONLY; Selected databases as a map from database name to database id
	Databases *string

	// READ-ONLY; Migration end time
	EndedOn *time.Time

	// READ-ONLY; Migration exceptions and warnings.
	ExceptionsAndWarnings []*ReportableException

	// READ-ONLY; Result identifier
	ID *string

	// READ-ONLY; Selected logins as a map from name to id
	Logins *string

	// READ-ONLY; Migration progress message
	Message *string

	// READ-ONLY; List of orphaned users.
	OrphanedUsersInfo []*OrphanedUserInfo

	// READ-ONLY; Map of server role migration results.
	ServerRoleResults *string

	// READ-ONLY; Source server brand version
	SourceServerBrandVersion *string

	// READ-ONLY; Source server version
	SourceServerVersion *string

	// READ-ONLY; Migration start time
	StartedOn *time.Time

	// READ-ONLY; Current state of migration
	State *MigrationState

	// READ-ONLY; Current status of migration
	Status *MigrationStatus

	// READ-ONLY; Target server brand version
	TargetServerBrandVersion *string

	// READ-ONLY; Target server version
	TargetServerVersion *string
}

// GetMigrateSQLServerSQLMITaskOutput implements the MigrateSQLServerSQLMITaskOutputClassification interface for type MigrateSQLServerSQLMITaskOutputMigrationLevel.
func (m *MigrateSQLServerSQLMITaskOutputMigrationLevel) GetMigrateSQLServerSQLMITaskOutput() *MigrateSQLServerSQLMITaskOutput {
	return &MigrateSQLServerSQLMITaskOutput{
		ID:         m.ID,
		ResultType: m.ResultType,
	}
}

// MigrateSQLServerSQLMITaskProperties - Properties for task that migrates SQL Server databases to Azure SQL Database Managed
// Instance
type MigrateSQLServerSQLMITaskProperties struct {
	// REQUIRED; Task type.
	TaskType *string

	// Key value pairs of client data to attach meta data information to task
	ClientData map[string]*string

	// Task input
	Input *MigrateSQLServerSQLMITaskInput

	// READ-ONLY; Array of command properties.
	Commands []CommandPropertiesClassification

	// READ-ONLY; Array of errors. This is ignored if submitted.
	Errors []*ODataError

	// READ-ONLY; Task output. This is ignored if submitted.
	Output []MigrateSQLServerSQLMITaskOutputClassification

	// READ-ONLY; The state of the task. This is ignored if submitted.
	State *TaskState
}

// GetProjectTaskProperties implements the ProjectTaskPropertiesClassification interface for type MigrateSQLServerSQLMITaskProperties.
func (m *MigrateSQLServerSQLMITaskProperties) GetProjectTaskProperties() *ProjectTaskProperties {
	return &ProjectTaskProperties{
		ClientData: m.ClientData,
		Commands:   m.Commands,
		Errors:     m.Errors,
		State:      m.State,
		TaskType:   m.TaskType,
	}
}

// MigrateSchemaSQLServerSQLDbDatabaseInput - Database input for migrate schema Sql Server to Azure SQL Server scenario
type MigrateSchemaSQLServerSQLDbDatabaseInput struct {
	// Name of source database
	Name *string

	// Database schema migration settings
	SchemaSetting *SchemaMigrationSetting

	// Name of target database
	TargetDatabaseName *string
}

// MigrateSchemaSQLServerSQLDbTaskInput - Input for task that migrates Schema for SQL Server databases to Azure SQL databases
type MigrateSchemaSQLServerSQLDbTaskInput struct {
	// REQUIRED; Databases to migrate
	SelectedDatabases []*MigrateSchemaSQLServerSQLDbDatabaseInput

	// REQUIRED; Information for connecting to source
	SourceConnectionInfo *SQLConnectionInfo

	// REQUIRED; Information for connecting to target
	TargetConnectionInfo *SQLConnectionInfo
}

// MigrateSchemaSQLServerSQLDbTaskOutput - Output for the task that migrates Schema for SQL Server databases to Azure SQL
// databases
type MigrateSchemaSQLServerSQLDbTaskOutput struct {
	// REQUIRED; Result type
	ResultType *string

	// READ-ONLY; Result identifier
	ID *string
}

// GetMigrateSchemaSQLServerSQLDbTaskOutput implements the MigrateSchemaSQLServerSQLDbTaskOutputClassification interface for
// type MigrateSchemaSQLServerSQLDbTaskOutput.
func (m *MigrateSchemaSQLServerSQLDbTaskOutput) GetMigrateSchemaSQLServerSQLDbTaskOutput() *MigrateSchemaSQLServerSQLDbTaskOutput {
	return m
}

type MigrateSchemaSQLServerSQLDbTaskOutputDatabaseLevel struct {
	// REQUIRED; Result type
	ResultType *string

	// READ-ONLY; Prefix string to use for querying errors for this database
	DatabaseErrorResultPrefix *string

	// READ-ONLY; The name of the database
	DatabaseName *string

	// READ-ONLY; Migration end time
	EndedOn *time.Time

	// READ-ONLY; Identifier for the file resource containing the schema of this database
	FileID *string

	// READ-ONLY; Result identifier
	ID *string

	// READ-ONLY; Number of failed operations for this database
	NumberOfFailedOperations *int64

	// READ-ONLY; Number of successful operations for this database
	NumberOfSuccessfulOperations *int64

	// READ-ONLY; Prefix string to use for querying schema errors for this database
	SchemaErrorResultPrefix *string

	// READ-ONLY; Schema migration stage for this database
	Stage *SchemaMigrationStage

	// READ-ONLY; Migration start time
	StartedOn *time.Time

	// READ-ONLY; State of the schema migration for this database
	State *MigrationState
}

// GetMigrateSchemaSQLServerSQLDbTaskOutput implements the MigrateSchemaSQLServerSQLDbTaskOutputClassification interface for
// type MigrateSchemaSQLServerSQLDbTaskOutputDatabaseLevel.
func (m *MigrateSchemaSQLServerSQLDbTaskOutputDatabaseLevel) GetMigrateSchemaSQLServerSQLDbTaskOutput() *MigrateSchemaSQLServerSQLDbTaskOutput {
	return &MigrateSchemaSQLServerSQLDbTaskOutput{
		ID:         m.ID,
		ResultType: m.ResultType,
	}
}

type MigrateSchemaSQLServerSQLDbTaskOutputError struct {
	// REQUIRED; Result type
	ResultType *string

	// READ-ONLY; Schema command which failed
	CommandText *string

	// READ-ONLY; Reason of failure
	ErrorText *string

	// READ-ONLY; Result identifier
	ID *string
}

// GetMigrateSchemaSQLServerSQLDbTaskOutput implements the MigrateSchemaSQLServerSQLDbTaskOutputClassification interface for
// type MigrateSchemaSQLServerSQLDbTaskOutputError.
func (m *MigrateSchemaSQLServerSQLDbTaskOutputError) GetMigrateSchemaSQLServerSQLDbTaskOutput() *MigrateSchemaSQLServerSQLDbTaskOutput {
	return &MigrateSchemaSQLServerSQLDbTaskOutput{
		ID:         m.ID,
		ResultType: m.ResultType,
	}
}

type MigrateSchemaSQLServerSQLDbTaskOutputMigrationLevel struct {
	// REQUIRED; Result type
	ResultType *string

	// READ-ONLY; Migration end time
	EndedOn *time.Time

	// READ-ONLY; Result identifier
	ID *string

	// READ-ONLY; Source server brand version
	SourceServerBrandVersion *string

	// READ-ONLY; Source server version
	SourceServerVersion *string

	// READ-ONLY; Migration start time
	StartedOn *time.Time

	// READ-ONLY; Overall state of the schema migration
	State *MigrationState

	// READ-ONLY; Target server brand version
	TargetServerBrandVersion *string

	// READ-ONLY; Target server version
	TargetServerVersion *string
}

// GetMigrateSchemaSQLServerSQLDbTaskOutput implements the MigrateSchemaSQLServerSQLDbTaskOutputClassification interface for
// type MigrateSchemaSQLServerSQLDbTaskOutputMigrationLevel.
func (m *MigrateSchemaSQLServerSQLDbTaskOutputMigrationLevel) GetMigrateSchemaSQLServerSQLDbTaskOutput() *MigrateSchemaSQLServerSQLDbTaskOutput {
	return &MigrateSchemaSQLServerSQLDbTaskOutput{
		ID:         m.ID,
		ResultType: m.ResultType,
	}
}

// MigrateSchemaSQLServerSQLDbTaskProperties - Properties for task that migrates Schema for SQL Server databases to Azure
// SQL databases
type MigrateSchemaSQLServerSQLDbTaskProperties struct {
	// REQUIRED; Task type.
	TaskType *string

	// Key value pairs of client data to attach meta data information to task
	ClientData map[string]*string

	// Task input
	Input *MigrateSchemaSQLServerSQLDbTaskInput

	// READ-ONLY; Array of command properties.
	Commands []CommandPropertiesClassification

	// READ-ONLY; Array of errors. This is ignored if submitted.
	Errors []*ODataError

	// READ-ONLY; Task output. This is ignored if submitted.
	Output []MigrateSchemaSQLServerSQLDbTaskOutputClassification

	// READ-ONLY; The state of the task. This is ignored if submitted.
	State *TaskState
}

// GetProjectTaskProperties implements the ProjectTaskPropertiesClassification interface for type MigrateSchemaSQLServerSQLDbTaskProperties.
func (m *MigrateSchemaSQLServerSQLDbTaskProperties) GetProjectTaskProperties() *ProjectTaskProperties {
	return &ProjectTaskProperties{
		ClientData: m.ClientData,
		Commands:   m.Commands,
		Errors:     m.Errors,
		State:      m.State,
		TaskType:   m.TaskType,
	}
}

type MigrateSchemaSQLTaskOutputError struct {
	// REQUIRED; Result type
	ResultType *string

	// READ-ONLY; Migration error
	Error *ReportableException

	// READ-ONLY; Result identifier
	ID *string
}

// GetMigrateSchemaSQLServerSQLDbTaskOutput implements the MigrateSchemaSQLServerSQLDbTaskOutputClassification interface for
// type MigrateSchemaSQLTaskOutputError.
func (m *MigrateSchemaSQLTaskOutputError) GetMigrateSchemaSQLServerSQLDbTaskOutput() *MigrateSchemaSQLServerSQLDbTaskOutput {
	return &MigrateSchemaSQLServerSQLDbTaskOutput{
		ID:         m.ID,
		ResultType: m.ResultType,
	}
}

// MigrateSsisTaskInput - Input for task that migrates SSIS packages from SQL Server to Azure SQL Database Managed Instance.
type MigrateSsisTaskInput struct {
	// REQUIRED; Information for connecting to source
	SourceConnectionInfo *SQLConnectionInfo

	// REQUIRED; SSIS package migration information.
	SsisMigrationInfo *SsisMigrationInfo

	// REQUIRED; Information for connecting to target
	TargetConnectionInfo *SQLConnectionInfo
}

// MigrateSsisTaskOutput - Output for task that migrates SSIS packages from SQL Server to Azure SQL Database Managed Instance.
type MigrateSsisTaskOutput struct {
	// REQUIRED; Result type
	ResultType *string

	// READ-ONLY; Result identifier
	ID *string
}

// GetMigrateSsisTaskOutput implements the MigrateSsisTaskOutputClassification interface for type MigrateSsisTaskOutput.
func (m *MigrateSsisTaskOutput) GetMigrateSsisTaskOutput() *MigrateSsisTaskOutput { return m }

type MigrateSsisTaskOutputMigrationLevel struct {
	// REQUIRED; Result type
	ResultType *string

	// READ-ONLY; Migration end time
	EndedOn *time.Time

	// READ-ONLY; Migration exceptions and warnings.
	ExceptionsAndWarnings []*ReportableException

	// READ-ONLY; Result identifier
	ID *string

	// READ-ONLY; Migration progress message
	Message *string

	// READ-ONLY; Source server brand version
	SourceServerBrandVersion *string

	// READ-ONLY; Source server version
	SourceServerVersion *string

	// READ-ONLY; Stage of SSIS migration.
	Stage *SsisMigrationStage

	// READ-ONLY; Migration start time
	StartedOn *time.Time

	// READ-ONLY; Current status of migration
	Status *MigrationStatus

	// READ-ONLY; Target server brand version
	TargetServerBrandVersion *string

	// READ-ONLY; Target server version
	TargetServerVersion *string
}

// GetMigrateSsisTaskOutput implements the MigrateSsisTaskOutputClassification interface for type MigrateSsisTaskOutputMigrationLevel.
func (m *MigrateSsisTaskOutputMigrationLevel) GetMigrateSsisTaskOutput() *MigrateSsisTaskOutput {
	return &MigrateSsisTaskOutput{
		ID:         m.ID,
		ResultType: m.ResultType,
	}
}

type MigrateSsisTaskOutputProjectLevel struct {
	// REQUIRED; Result type
	ResultType *string

	// READ-ONLY; Migration end time
	EndedOn *time.Time

	// READ-ONLY; Migration exceptions and warnings
	ExceptionsAndWarnings []*ReportableException

	// READ-ONLY; Name of the folder
	FolderName *string

	// READ-ONLY; Result identifier
	ID *string

	// READ-ONLY; Migration progress message
	Message *string

	// READ-ONLY; Name of the project
	ProjectName *string

	// READ-ONLY; Stage of SSIS migration.
	Stage *SsisMigrationStage

	// READ-ONLY; Migration start time
	StartedOn *time.Time

	// READ-ONLY; Current state of migration
	State *MigrationState
}

// GetMigrateSsisTaskOutput implements the MigrateSsisTaskOutputClassification interface for type MigrateSsisTaskOutputProjectLevel.
func (m *MigrateSsisTaskOutputProjectLevel) GetMigrateSsisTaskOutput() *MigrateSsisTaskOutput {
	return &MigrateSsisTaskOutput{
		ID:         m.ID,
		ResultType: m.ResultType,
	}
}

// MigrateSsisTaskProperties - Properties for task that migrates SSIS packages from SQL Server databases to Azure SQL Database
// Managed Instance.
type MigrateSsisTaskProperties struct {
	// REQUIRED; Task type.
	TaskType *string

	// Key value pairs of client data to attach meta data information to task
	ClientData map[string]*string

	// Task input
	Input *MigrateSsisTaskInput

	// READ-ONLY; Array of command properties.
	Commands []CommandPropertiesClassification

	// READ-ONLY; Array of errors. This is ignored if submitted.
	Errors []*ODataError

	// READ-ONLY; Task output. This is ignored if submitted.
	Output []MigrateSsisTaskOutputClassification

	// READ-ONLY; The state of the task. This is ignored if submitted.
	State *TaskState
}

// GetProjectTaskProperties implements the ProjectTaskPropertiesClassification interface for type MigrateSsisTaskProperties.
func (m *MigrateSsisTaskProperties) GetProjectTaskProperties() *ProjectTaskProperties {
	return &ProjectTaskProperties{
		ClientData: m.ClientData,
		Commands:   m.Commands,
		Errors:     m.Errors,
		State:      m.State,
		TaskType:   m.TaskType,
	}
}

// MigrateSyncCompleteCommandInput - Input for command that completes sync migration for a database.
type MigrateSyncCompleteCommandInput struct {
	// REQUIRED; Name of database
	DatabaseName *string

	// Time stamp to complete
	CommitTimeStamp *time.Time
}

// MigrateSyncCompleteCommandOutput - Output for command that completes sync migration for a database.
type MigrateSyncCompleteCommandOutput struct {
	// READ-ONLY; List of errors that happened during the command execution
	Errors []*ReportableException

	// READ-ONLY; Result identifier
	ID *string
}

// MigrateSyncCompleteCommandProperties - Properties for the command that completes sync migration for a database.
type MigrateSyncCompleteCommandProperties struct {
	// REQUIRED; Command type.
	CommandType *string

	// Command input
	Input *MigrateSyncCompleteCommandInput

	// READ-ONLY; Array of errors. This is ignored if submitted.
	Errors []*ODataError

	// READ-ONLY; Command output. This is ignored if submitted.
	Output *MigrateSyncCompleteCommandOutput

	// READ-ONLY; The state of the command. This is ignored if submitted.
	State *CommandState
}

// GetCommandProperties implements the CommandPropertiesClassification interface for type MigrateSyncCompleteCommandProperties.
func (m *MigrateSyncCompleteCommandProperties) GetCommandProperties() *CommandProperties {
	return &CommandProperties{
		CommandType: m.CommandType,
		Errors:      m.Errors,
		State:       m.State,
	}
}

// MigrationEligibilityInfo - Information about migration eligibility of a server object
type MigrationEligibilityInfo struct {
	// READ-ONLY; Whether object is eligible for migration or not.
	IsEligibleForMigration *bool

	// READ-ONLY; Information about eligibility failure for the server object.
	ValidationMessages []*string
}

// MigrationReportResult - Migration validation report result, contains the url for downloading the generated report.
type MigrationReportResult struct {
	// Migration validation result identifier
	ID *string

	// The url of the report.
	ReportURL *string
}

// MigrationTableMetadata - Metadata for tables selected in migration project
type MigrationTableMetadata struct {
	// READ-ONLY; Source table name
	SourceTableName *string

	// READ-ONLY; Target table name
	TargetTableName *string
}

// MigrationValidationDatabaseLevelResult - Database level validation results
type MigrationValidationDatabaseLevelResult struct {
	// READ-ONLY; Provides data integrity validation result between the source and target tables that are migrated.
	DataIntegrityValidationResult *DataIntegrityValidationResult

	// READ-ONLY; Validation end time
	EndedOn *time.Time

	// READ-ONLY; Result identifier
	ID *string

	// READ-ONLY; Migration Identifier
	MigrationID *string

	// READ-ONLY; Results of some of the query execution result between source and target database
	QueryAnalysisValidationResult *QueryAnalysisValidationResult

	// READ-ONLY; Provides schema comparison result between source and target database
	SchemaValidationResult *SchemaComparisonValidationResult

	// READ-ONLY; Name of the source database
	SourceDatabaseName *string

	// READ-ONLY; Validation start time
	StartedOn *time.Time

	// READ-ONLY; Current status of validation at the database level
	Status *ValidationStatus

	// READ-ONLY; Name of the target database
	TargetDatabaseName *string
}

// MigrationValidationDatabaseSummaryResult - Migration Validation Database level summary result
type MigrationValidationDatabaseSummaryResult struct {
	// READ-ONLY; Validation end time
	EndedOn *time.Time

	// READ-ONLY; Result identifier
	ID *string

	// READ-ONLY; Migration Identifier
	MigrationID *string

	// READ-ONLY; Name of the source database
	SourceDatabaseName *string

	// READ-ONLY; Validation start time
	StartedOn *time.Time

	// READ-ONLY; Current status of validation at the database level
	Status *ValidationStatus

	// READ-ONLY; Name of the target database
	TargetDatabaseName *string
}

// MigrationValidationOptions - Types of validations to run after the migration
type MigrationValidationOptions struct {
	// Allows to perform a checksum based data integrity validation between source and target for the selected database / tables
	// .
	EnableDataIntegrityValidation *bool

	// Allows to perform a quick and intelligent query analysis by retrieving queries from the source database and executes them
	// in the target. The result will have execution statistics for executions in
	// source and target databases for the extracted queries.
	EnableQueryAnalysisValidation *bool

	// Allows to compare the schema information between source and target.
	EnableSchemaValidation *bool
}

// MigrationValidationResult - Migration Validation Result
type MigrationValidationResult struct {
	// Validation summary results for each database
	SummaryResults map[string]*MigrationValidationDatabaseSummaryResult

	// READ-ONLY; Migration validation result identifier
	ID *string

	// READ-ONLY; Migration Identifier
	MigrationID *string

	// READ-ONLY; Current status of validation at the migration level. Status from the database validation result status will
	// be aggregated here.
	Status *ValidationStatus
}

// MongoDbCancelCommand - Properties for the command that cancels a migration in whole or in part
type MongoDbCancelCommand struct {
	// REQUIRED; Command type.
	CommandType *string

	// Command input
	Input *MongoDbCommandInput

	// READ-ONLY; Array of errors. This is ignored if submitted.
	Errors []*ODataError

	// READ-ONLY; The state of the command. This is ignored if submitted.
	State *CommandState
}

// GetCommandProperties implements the CommandPropertiesClassification interface for type MongoDbCancelCommand.
func (m *MongoDbCancelCommand) GetCommandProperties() *CommandProperties {
	return &CommandProperties{
		CommandType: m.CommandType,
		Errors:      m.Errors,
		State:       m.State,
	}
}

// MongoDbClusterInfo - Describes a MongoDB data source
type MongoDbClusterInfo struct {
	// REQUIRED; A list of non-system databases in the cluster
	Databases []*MongoDbDatabaseInfo

	// REQUIRED; Whether the cluster supports sharded collections
	SupportsSharding *bool

	// REQUIRED; The type of data source
	Type *MongoDbClusterType

	// REQUIRED; The version of the data source in the form x.y.z (e.g. 3.6.7). Not used if Type is BlobContainer.
	Version *string
}

// MongoDbCollectionInfo - Describes a supported collection within a MongoDB database
type MongoDbCollectionInfo struct {
	// REQUIRED; The average document size, or -1 if the average size is unknown
	AverageDocumentSize *int64

	// REQUIRED; The estimated total data size, in bytes, or -1 if the size is unknown.
	DataSize *int64

	// REQUIRED; The name of the database containing the collection
	DatabaseName *string

	// REQUIRED; The estimated total number of documents, or -1 if the document count is unknown
	DocumentCount *int64

	// REQUIRED; Whether the collection is a capped collection (i.e. whether it has a fixed size and acts like a circular buffer)
	IsCapped *bool

	// REQUIRED; Whether the collection is system collection
	IsSystemCollection *bool

	// REQUIRED; Whether the collection is a view of another collection
	IsView *bool

	// REQUIRED; The unqualified name of the database or collection
	Name *string

	// REQUIRED; The qualified name of the database or collection. For a collection, this is the database-qualified name.
	QualifiedName *string

	// REQUIRED; Whether the database has sharding enabled. Note that the migration task will enable sharding on the target if
	// necessary.
	SupportsSharding *bool

	// The shard key on the collection, or null if the collection is not sharded
	ShardKey *MongoDbShardKeyInfo

	// The name of the collection that this is a view of, if IsView is true
	ViewOf *string
}

// MongoDbCollectionProgress - Describes the progress of a collection
type MongoDbCollectionProgress struct {
	// REQUIRED; The number of document bytes copied during the Copying stage
	BytesCopied *int64

	// REQUIRED; The number of documents copied during the Copying stage
	DocumentsCopied *int64

	// REQUIRED; The elapsed time in the format [ddd.]hh:mm:ss[.fffffff] (i.e. TimeSpan format)
	ElapsedTime *string

	// REQUIRED; The errors and warnings that have occurred for the current object. The keys are the error codes.
	Errors map[string]*MongoDbError

	// REQUIRED; The number of oplog events awaiting replay
	EventsPending *int64

	// REQUIRED; The number of oplog events replayed so far
	EventsReplayed *int64

	// REQUIRED; The type of progress object
	ResultType *MongoDbProgressResultType

	// REQUIRED
	State *MongoDbMigrationState

	// REQUIRED; The total number of document bytes on the source at the beginning of the Copying stage, or -1 if the total size
	// was unknown
	TotalBytes *int64

	// REQUIRED; The total number of documents on the source at the beginning of the Copying stage, or -1 if the total count was
	// unknown
	TotalDocuments *int64

	// The timestamp of the last oplog event received, or null if no oplog event has been received yet
	LastEventTime *time.Time

	// The timestamp of the last oplog event replayed, or null if no oplog event has been replayed yet
	LastReplayTime *time.Time

	// The name of the progress object. For a collection, this is the unqualified collection name. For a database, this is the
	// database name. For the overall migration, this is null.
	Name *string

	// The qualified name of the progress object. For a collection, this is the database-qualified name. For a database, this
	// is the database name. For the overall migration, this is null.
	QualifiedName *string
}

// GetMongoDbProgress implements the MongoDbProgressClassification interface for type MongoDbCollectionProgress.
func (m *MongoDbCollectionProgress) GetMongoDbProgress() *MongoDbProgress {
	return &MongoDbProgress{
		BytesCopied:     m.BytesCopied,
		DocumentsCopied: m.DocumentsCopied,
		ElapsedTime:     m.ElapsedTime,
		Errors:          m.Errors,
		EventsPending:   m.EventsPending,
		EventsReplayed:  m.EventsReplayed,
		LastEventTime:   m.LastEventTime,
		LastReplayTime:  m.LastReplayTime,
		Name:            m.Name,
		QualifiedName:   m.QualifiedName,
		ResultType:      m.ResultType,
		State:           m.State,
		TotalBytes:      m.TotalBytes,
		TotalDocuments:  m.TotalDocuments,
	}
}

// MongoDbCollectionSettings - Describes how an individual MongoDB collection should be migrated
type MongoDbCollectionSettings struct {
	// Whether the migrator is allowed to drop the target collection in the course of performing a migration. The default is true.
	CanDelete *bool

	// Describes a MongoDB shard key
	ShardKey *MongoDbShardKeySetting

	// The RUs that should be configured on a CosmosDB target, or null to use the default. This has no effect on non-CosmosDB
	// targets.
	TargetRUs *int32
}

// MongoDbCommandInput - Describes the input to the 'cancel' and 'restart' MongoDB migration commands
type MongoDbCommandInput struct {
	// The qualified name of a database or collection to act upon, or null to act upon the entire migration
	ObjectName *string
}

// MongoDbConnectionInfo - Describes a connection to a MongoDB data source
type MongoDbConnectionInfo struct {
	// REQUIRED; A MongoDB connection string or blob container URL. The user name and password can be specified here or in the
	// userName and password properties
	ConnectionString *string

	// REQUIRED; Type of connection info
	Type *string

	// Password credential.
	Password *string

	// User name
	UserName *string
}

// GetConnectionInfo implements the ConnectionInfoClassification interface for type MongoDbConnectionInfo.
func (m *MongoDbConnectionInfo) GetConnectionInfo() *ConnectionInfo {
	return &ConnectionInfo{
		Password: m.Password,
		Type:     m.Type,
		UserName: m.UserName,
	}
}

// MongoDbDatabaseInfo - Describes a database within a MongoDB data source
type MongoDbDatabaseInfo struct {
	// REQUIRED; The average document size, or -1 if the average size is unknown
	AverageDocumentSize *int64

	// REQUIRED; A list of supported collections in a MongoDB database
	Collections []*MongoDbCollectionInfo

	// REQUIRED; The estimated total data size, in bytes, or -1 if the size is unknown.
	DataSize *int64

	// REQUIRED; The estimated total number of documents, or -1 if the document count is unknown
	DocumentCount *int64

	// REQUIRED; The unqualified name of the database or collection
	Name *string

	// REQUIRED; The qualified name of the database or collection. For a collection, this is the database-qualified name.
	QualifiedName *string

	// REQUIRED; Whether the database has sharding enabled. Note that the migration task will enable sharding on the target if
	// necessary.
	SupportsSharding *bool
}

// MongoDbDatabaseProgress - Describes the progress of a database
type MongoDbDatabaseProgress struct {
	// REQUIRED; The number of document bytes copied during the Copying stage
	BytesCopied *int64

	// REQUIRED; The number of documents copied during the Copying stage
	DocumentsCopied *int64

	// REQUIRED; The elapsed time in the format [ddd.]hh:mm:ss[.fffffff] (i.e. TimeSpan format)
	ElapsedTime *string

	// REQUIRED; The errors and warnings that have occurred for the current object. The keys are the error codes.
	Errors map[string]*MongoDbError

	// REQUIRED; The number of oplog events awaiting replay
	EventsPending *int64

	// REQUIRED; The number of oplog events replayed so far
	EventsReplayed *int64

	// REQUIRED; The type of progress object
	ResultType *MongoDbProgressResultType

	// REQUIRED
	State *MongoDbMigrationState

	// REQUIRED; The total number of document bytes on the source at the beginning of the Copying stage, or -1 if the total size
	// was unknown
	TotalBytes *int64

	// REQUIRED; The total number of documents on the source at the beginning of the Copying stage, or -1 if the total count was
	// unknown
	TotalDocuments *int64

	// The progress of the collections in the database. The keys are the unqualified names of the collections
	Collections map[string]*MongoDbCollectionProgress

	// The timestamp of the last oplog event received, or null if no oplog event has been received yet
	LastEventTime *time.Time

	// The timestamp of the last oplog event replayed, or null if no oplog event has been replayed yet
	LastReplayTime *time.Time

	// The name of the progress object. For a collection, this is the unqualified collection name. For a database, this is the
	// database name. For the overall migration, this is null.
	Name *string

	// The qualified name of the progress object. For a collection, this is the database-qualified name. For a database, this
	// is the database name. For the overall migration, this is null.
	QualifiedName *string
}

// GetMongoDbProgress implements the MongoDbProgressClassification interface for type MongoDbDatabaseProgress.
func (m *MongoDbDatabaseProgress) GetMongoDbProgress() *MongoDbProgress {
	return &MongoDbProgress{
		BytesCopied:     m.BytesCopied,
		DocumentsCopied: m.DocumentsCopied,
		ElapsedTime:     m.ElapsedTime,
		Errors:          m.Errors,
		EventsPending:   m.EventsPending,
		EventsReplayed:  m.EventsReplayed,
		LastEventTime:   m.LastEventTime,
		LastReplayTime:  m.LastReplayTime,
		Name:            m.Name,
		QualifiedName:   m.QualifiedName,
		ResultType:      m.ResultType,
		State:           m.State,
		TotalBytes:      m.TotalBytes,
		TotalDocuments:  m.TotalDocuments,
	}
}

// MongoDbDatabaseSettings - Describes how an individual MongoDB database should be migrated
type MongoDbDatabaseSettings struct {
	// REQUIRED; The collections on the source database to migrate to the target. The keys are the unqualified names of the collections.
	Collections map[string]*MongoDbCollectionSettings

	// The RUs that should be configured on a CosmosDB target, or null to use the default, or 0 if throughput should not be provisioned
	// for the database. This has no effect on non-CosmosDB targets.
	TargetRUs *int32
}

// MongoDbError - Describes an error or warning that occurred during a MongoDB migration
type MongoDbError struct {
	// The non-localized, machine-readable code that describes the error or warning
	Code *string

	// The number of times the error or warning has occurred
	Count *int32

	// The localized, human-readable message that describes the error or warning
	Message *string

	// The type of error or warning
	Type *MongoDbErrorType
}

// MongoDbFinishCommand - Properties for the command that finishes a migration in whole or in part
type MongoDbFinishCommand struct {
	// REQUIRED; Command type.
	CommandType *string

	// Command input
	Input *MongoDbFinishCommandInput

	// READ-ONLY; Array of errors. This is ignored if submitted.
	Errors []*ODataError

	// READ-ONLY; The state of the command. This is ignored if submitted.
	State *CommandState
}

// GetCommandProperties implements the CommandPropertiesClassification interface for type MongoDbFinishCommand.
func (m *MongoDbFinishCommand) GetCommandProperties() *CommandProperties {
	return &CommandProperties{
		CommandType: m.CommandType,
		Errors:      m.Errors,
		State:       m.State,
	}
}

// MongoDbFinishCommandInput - Describes the input to the 'finish' MongoDB migration command
type MongoDbFinishCommandInput struct {
	// REQUIRED; If true, replication for the affected objects will be stopped immediately. If false, the migrator will finish
	// replaying queued events before finishing the replication.
	Immediate *bool

	// The qualified name of a database or collection to act upon, or null to act upon the entire migration
	ObjectName *string
}

// MongoDbMigrationProgress - Describes the progress of the overall migration
type MongoDbMigrationProgress struct {
	// REQUIRED; The number of document bytes copied during the Copying stage
	BytesCopied *int64

	// REQUIRED; The number of documents copied during the Copying stage
	DocumentsCopied *int64

	// REQUIRED; The elapsed time in the format [ddd.]hh:mm:ss[.fffffff] (i.e. TimeSpan format)
	ElapsedTime *string

	// REQUIRED; The errors and warnings that have occurred for the current object. The keys are the error codes.
	Errors map[string]*MongoDbError

	// REQUIRED; The number of oplog events awaiting replay
	EventsPending *int64

	// REQUIRED; The number of oplog events replayed so far
	EventsReplayed *int64

	// REQUIRED; The type of progress object
	ResultType *MongoDbProgressResultType

	// REQUIRED
	State *MongoDbMigrationState

	// REQUIRED; The total number of document bytes on the source at the beginning of the Copying stage, or -1 if the total size
	// was unknown
	TotalBytes *int64

	// REQUIRED; The total number of documents on the source at the beginning of the Copying stage, or -1 if the total count was
	// unknown
	TotalDocuments *int64

	// The progress of the databases in the migration. The keys are the names of the databases
	Databases map[string]*MongoDbDatabaseProgress

	// The timestamp of the last oplog event received, or null if no oplog event has been received yet
	LastEventTime *time.Time

	// The timestamp of the last oplog event replayed, or null if no oplog event has been replayed yet
	LastReplayTime *time.Time

	// The name of the progress object. For a collection, this is the unqualified collection name. For a database, this is the
	// database name. For the overall migration, this is null.
	Name *string

	// The qualified name of the progress object. For a collection, this is the database-qualified name. For a database, this
	// is the database name. For the overall migration, this is null.
	QualifiedName *string
}

// GetMongoDbProgress implements the MongoDbProgressClassification interface for type MongoDbMigrationProgress.
func (m *MongoDbMigrationProgress) GetMongoDbProgress() *MongoDbProgress {
	return &MongoDbProgress{
		BytesCopied:     m.BytesCopied,
		DocumentsCopied: m.DocumentsCopied,
		ElapsedTime:     m.ElapsedTime,
		Errors:          m.Errors,
		EventsPending:   m.EventsPending,
		EventsReplayed:  m.EventsReplayed,
		LastEventTime:   m.LastEventTime,
		LastReplayTime:  m.LastReplayTime,
		Name:            m.Name,
		QualifiedName:   m.QualifiedName,
		ResultType:      m.ResultType,
		State:           m.State,
		TotalBytes:      m.TotalBytes,
		TotalDocuments:  m.TotalDocuments,
	}
}

// MongoDbMigrationSettings - Describes how a MongoDB data migration should be performed
type MongoDbMigrationSettings struct {
	// REQUIRED; The databases on the source cluster to migrate to the target. The keys are the names of the databases.
	Databases map[string]*MongoDbDatabaseSettings

	// REQUIRED; Settings used to connect to the source cluster
	Source *MongoDbConnectionInfo

	// REQUIRED; Settings used to connect to the target cluster
	Target *MongoDbConnectionInfo

	// The RU limit on a CosmosDB target that collections will be temporarily increased to (if lower) during the initial copy
	// of a migration, from 10,000 to 1,000,000, or 0 to use the default boost (which is
	// generally the maximum), or null to not boost the RUs. This setting has no effect on non-CosmosDB targets.
	BoostRUs *int32

	// Describes how changes will be replicated from the source to the target. The default is OneTime.
	Replication *MongoDbReplication

	// Settings used to limit the resource usage of the migration
	Throttling *MongoDbThrottlingSettings
}

// MongoDbObjectInfo - Describes a database or collection within a MongoDB data source
type MongoDbObjectInfo struct {
	// REQUIRED; The average document size, or -1 if the average size is unknown
	AverageDocumentSize *int64

	// REQUIRED; The estimated total data size, in bytes, or -1 if the size is unknown.
	DataSize *int64

	// REQUIRED; The estimated total number of documents, or -1 if the document count is unknown
	DocumentCount *int64

	// REQUIRED; The unqualified name of the database or collection
	Name *string

	// REQUIRED; The qualified name of the database or collection. For a collection, this is the database-qualified name.
	QualifiedName *string
}

// MongoDbProgress - Base class for MongoDB migration outputs
type MongoDbProgress struct {
	// REQUIRED; The number of document bytes copied during the Copying stage
	BytesCopied *int64

	// REQUIRED; The number of documents copied during the Copying stage
	DocumentsCopied *int64

	// REQUIRED; The elapsed time in the format [ddd.]hh:mm:ss[.fffffff] (i.e. TimeSpan format)
	ElapsedTime *string

	// REQUIRED; The errors and warnings that have occurred for the current object. The keys are the error codes.
	Errors map[string]*MongoDbError

	// REQUIRED; The number of oplog events awaiting replay
	EventsPending *int64

	// REQUIRED; The number of oplog events replayed so far
	EventsReplayed *int64

	// REQUIRED; The type of progress object
	ResultType *MongoDbProgressResultType

	// REQUIRED
	State *MongoDbMigrationState

	// REQUIRED; The total number of document bytes on the source at the beginning of the Copying stage, or -1 if the total size
	// was unknown
	TotalBytes *int64

	// REQUIRED; The total number of documents on the source at the beginning of the Copying stage, or -1 if the total count was
	// unknown
	TotalDocuments *int64

	// The timestamp of the last oplog event received, or null if no oplog event has been received yet
	LastEventTime *time.Time

	// The timestamp of the last oplog event replayed, or null if no oplog event has been replayed yet
	LastReplayTime *time.Time

	// The name of the progress object. For a collection, this is the unqualified collection name. For a database, this is the
	// database name. For the overall migration, this is null.
	Name *string

	// The qualified name of the progress object. For a collection, this is the database-qualified name. For a database, this
	// is the database name. For the overall migration, this is null.
	QualifiedName *string
}

// GetMongoDbProgress implements the MongoDbProgressClassification interface for type MongoDbProgress.
func (m *MongoDbProgress) GetMongoDbProgress() *MongoDbProgress { return m }

// MongoDbRestartCommand - Properties for the command that restarts a migration in whole or in part
type MongoDbRestartCommand struct {
	// REQUIRED; Command type.
	CommandType *string

	// Command input
	Input *MongoDbCommandInput

	// READ-ONLY; Array of errors. This is ignored if submitted.
	Errors []*ODataError

	// READ-ONLY; The state of the command. This is ignored if submitted.
	State *CommandState
}

// GetCommandProperties implements the CommandPropertiesClassification interface for type MongoDbRestartCommand.
func (m *MongoDbRestartCommand) GetCommandProperties() *CommandProperties {
	return &CommandProperties{
		CommandType: m.CommandType,
		Errors:      m.Errors,
		State:       m.State,
	}
}

// MongoDbShardKeyField - Describes a field reference within a MongoDB shard key
type MongoDbShardKeyField struct {
	// REQUIRED; The name of the field
	Name *string

	// REQUIRED; The field ordering
	Order *MongoDbShardKeyOrder
}

// MongoDbShardKeyInfo - Describes a MongoDB shard key
type MongoDbShardKeyInfo struct {
	// REQUIRED; The fields within the shard key
	Fields []*MongoDbShardKeyField

	// REQUIRED; Whether the shard key is unique
	IsUnique *bool
}

// MongoDbShardKeySetting - Describes a MongoDB shard key
type MongoDbShardKeySetting struct {
	// REQUIRED; The fields within the shard key
	Fields []*MongoDbShardKeyField

	// REQUIRED; Whether the shard key is unique
	IsUnique *bool
}

// MongoDbThrottlingSettings - Specifies resource limits for the migration
type MongoDbThrottlingSettings struct {
	// The maximum number of work items (e.g. collection copies) that will be processed in parallel
	MaxParallelism *int32

	// The percentage of CPU time that the migrator will try to avoid using, from 0 to 100
	MinFreeCPU *int32

	// The number of megabytes of RAM that the migrator will try to avoid using
	MinFreeMemoryMb *int32
}

// MySQLConnectionInfo - Information for connecting to MySQL server
type MySQLConnectionInfo struct {
	// REQUIRED; Port for Server
	Port *int32

	// REQUIRED; Name of the server
	ServerName *string

	// REQUIRED; Type of connection info
	Type *string

	// Whether to encrypt the connection
	EncryptConnection *bool

	// Password credential.
	Password *string

	// User name
	UserName *string
}

// GetConnectionInfo implements the ConnectionInfoClassification interface for type MySQLConnectionInfo.
func (m *MySQLConnectionInfo) GetConnectionInfo() *ConnectionInfo {
	return &ConnectionInfo{
		Password: m.Password,
		Type:     m.Type,
		UserName: m.UserName,
	}
}

// NameAvailabilityRequest - A resource type and proposed name
type NameAvailabilityRequest struct {
	// The proposed resource name
	Name *string

	// The resource type chain (e.g. virtualMachines/extensions)
	Type *string
}

// NameAvailabilityResponse - Indicates whether a proposed resource name is available
type NameAvailabilityResponse struct {
	// The localized reason why the name is not available, if nameAvailable is false
	Message *string

	// If true, the name is valid and available. If false, 'reason' describes why not.
	NameAvailable *bool

	// The reason why the name is not available, if nameAvailable is false
	Reason *NameCheckFailureReason
}

// NonSQLDataMigrationTable - Defines metadata for table to be migrated
type NonSQLDataMigrationTable struct {
	// Source table name
	SourceName *string
}

// NonSQLDataMigrationTableResult - Object used to report the data migration results of a table
type NonSQLDataMigrationTableResult struct {
	// READ-ONLY; Time taken to migrate the data
	ElapsedTimeInMiliseconds *float64

	// READ-ONLY; List of errors, if any, during migration
	Errors []*Error

	// READ-ONLY; Result code of the data migration
	ResultCode *DataMigrationResultCode

	// READ-ONLY; Name of the source table
	SourceName *string

	// READ-ONLY; Number of rows in the source table
	SourceRowCount *int64

	// READ-ONLY; Name of the target table
	TargetName *string

	// READ-ONLY; Number of rows in the target table
	TargetRowCount *int64
}

// NonSQLMigrationTaskInput - Base class for non sql migration task input
type NonSQLMigrationTaskInput struct {
	// REQUIRED; A URL that points to the drop location to access project artifacts
	ProjectLocation *string

	// REQUIRED; Name of the migration project
	ProjectName *string

	// REQUIRED; Metadata of the tables selected for migration
	SelectedTables []*NonSQLDataMigrationTable

	// REQUIRED; Information for connecting to target
	TargetConnectionInfo *SQLConnectionInfo

	// REQUIRED; Target database name
	TargetDatabaseName *string
}

// NonSQLMigrationTaskOutput - Base class for non sql migration task output
type NonSQLMigrationTaskOutput struct {
	// READ-ONLY; Results of the migration. The key contains the table name and the value the table result object
	DataMigrationTableResults *string

	// READ-ONLY; Migration end time
	EndedOn *time.Time

	// READ-ONLY; Result identifier
	ID *string

	// READ-ONLY; Message about the progress of the migration
	ProgressMessage *string

	// READ-ONLY; Name of source server
	SourceServerName *string

	// READ-ONLY; Migration start time
	StartedOn *time.Time

	// READ-ONLY; Current state of migration
	Status *MigrationStatus

	// READ-ONLY; Name of target server
	TargetServerName *string
}

// ODataError - Error information in OData format.
type ODataError struct {
	// The machine-readable description of the error, such as 'InvalidRequest' or 'InternalServerError'
	Code *string

	// Inner errors that caused this error
	Details []*ODataError

	// The human-readable description of the error
	Message *string
}

// OracleConnectionInfo - Information for connecting to Oracle server
type OracleConnectionInfo struct {
	// REQUIRED; EZConnect or TNSName connection string.
	DataSource *string

	// REQUIRED; Type of connection info
	Type *string

	// Password credential.
	Password *string

	// User name
	UserName *string
}

// GetConnectionInfo implements the ConnectionInfoClassification interface for type OracleConnectionInfo.
func (o *OracleConnectionInfo) GetConnectionInfo() *ConnectionInfo {
	return &ConnectionInfo{
		Password: o.Password,
		Type:     o.Type,
		UserName: o.UserName,
	}
}

// OracleOCIDriverInfo - Information about an Oracle OCI driver.
type OracleOCIDriverInfo struct {
	// READ-ONLY; The MD5 Base64 encoded checksum for the driver package.
	ArchiveChecksum *string

	// READ-ONLY; Version listed in the OCI assembly 'oci.dll'
	AssemblyVersion *string

	// READ-ONLY; The name of the driver package
	DriverName *string

	// READ-ONLY; The size in bytes of the driver package
	DriverSize *string

	// READ-ONLY; The checksum for the driver package provided by Oracle.
	OracleChecksum *string

	// READ-ONLY; List of Oracle database versions supported by this driver. Only major minor of the version is listed.
	SupportedOracleVersions []*string
}

// OrphanedUserInfo - Information of orphaned users on the SQL server database.
type OrphanedUserInfo struct {
	// Parent database of the user
	DatabaseName *string

	// Name of the orphaned user
	Name *string
}

// PostgreSQLConnectionInfo - Information for connecting to PostgreSQL server
type PostgreSQLConnectionInfo struct {
	// REQUIRED; Port for Server
	Port *int32

	// REQUIRED; Name of the server
	ServerName *string

	// REQUIRED; Type of connection info
	Type *string

	// Name of the database
	DatabaseName *string

	// Whether to encrypt the connection
	EncryptConnection *bool

	// Password credential.
	Password *string

	// Whether to trust the server certificate
	TrustServerCertificate *bool

	// User name
	UserName *string
}

// GetConnectionInfo implements the ConnectionInfoClassification interface for type PostgreSQLConnectionInfo.
func (p *PostgreSQLConnectionInfo) GetConnectionInfo() *ConnectionInfo {
	return &ConnectionInfo{
		Password: p.Password,
		Type:     p.Type,
		UserName: p.UserName,
	}
}

// Project - A project resource
type Project struct {
	// REQUIRED; Resource location.
	Location *string

	// Project properties
	Properties *ProjectProperties

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Resource ID.
	ID *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData

	// READ-ONLY; Resource type.
	Type *string
}

// ProjectFile - A file resource
type ProjectFile struct {
	// HTTP strong entity tag value. This is ignored if submitted.
	Etag *string

	// Custom file properties
	Properties *ProjectFileProperties

	// READ-ONLY; Resource ID.
	ID *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData

	// READ-ONLY; Resource type.
	Type *string
}

// ProjectFileProperties - Base class for file properties.
type ProjectFileProperties struct {
	// Optional File extension. If submitted it should not have a leading period and must match the extension from filePath.
	Extension *string

	// Relative path of this file resource. This property can be set when creating or updating the file resource.
	FilePath *string

	// File content type. This property can be modified to reflect the file content type.
	MediaType *string

	// READ-ONLY; Modification DateTime.
	LastModified *time.Time

	// READ-ONLY; File size.
	Size *int64
}

// ProjectList - OData page of project resources
type ProjectList struct {
	// URL to load the next page of projects
	NextLink *string

	// List of projects
	Value []*Project
}

// ProjectMetadata - Common metadata for migration projects
type ProjectMetadata struct {
	// READ-ONLY; List of tables selected for migration
	SelectedMigrationTables []*MigrationTableMetadata

	// READ-ONLY; Source server name
	SourceServerName *string

	// READ-ONLY; Source server port number
	SourceServerPort *string

	// READ-ONLY; Source username
	SourceUsername *string

	// READ-ONLY; Target database name
	TargetDbName *string

	// READ-ONLY; Target server name
	TargetServerName *string

	// READ-ONLY; Target username
	TargetUsername *string

	// READ-ONLY; Whether target connection is Windows authentication
	TargetUsingWinAuth *bool
}

// ProjectProperties - Project-specific properties
type ProjectProperties struct {
	// REQUIRED; Source platform for the project
	SourcePlatform *ProjectSourcePlatform

	// REQUIRED; Target platform for the project
	TargetPlatform *ProjectTargetPlatform

	// List of DatabaseInfo
	DatabasesInfo []*DatabaseInfo

	// Information for connecting to source
	SourceConnectionInfo ConnectionInfoClassification

	// Information for connecting to target
	TargetConnectionInfo ConnectionInfoClassification

	// READ-ONLY; UTC Date and time when project was created
	CreationTime *time.Time

	// READ-ONLY; The project's provisioning state
	ProvisioningState *ProjectProvisioningState
}

// ProjectTask - A task resource
type ProjectTask struct {
	// HTTP strong entity tag value. This is ignored if submitted.
	Etag *string

	// Custom task properties
	Properties ProjectTaskPropertiesClassification

	// READ-ONLY; Resource ID.
	ID *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData

	// READ-ONLY; Resource type.
	Type *string
}

// ProjectTaskProperties - Base class for all types of DMS task properties. If task is not supported by current client, this
// object is returned.
type ProjectTaskProperties struct {
	// REQUIRED; Task type.
	TaskType *string

	// Key value pairs of client data to attach meta data information to task
	ClientData map[string]*string

	// READ-ONLY; Array of command properties.
	Commands []CommandPropertiesClassification

	// READ-ONLY; Array of errors. This is ignored if submitted.
	Errors []*ODataError

	// READ-ONLY; The state of the task. This is ignored if submitted.
	State *TaskState
}

// GetProjectTaskProperties implements the ProjectTaskPropertiesClassification interface for type ProjectTaskProperties.
func (p *ProjectTaskProperties) GetProjectTaskProperties() *ProjectTaskProperties { return p }

// QueryAnalysisValidationResult - Results for query analysis comparison between the source and target
type QueryAnalysisValidationResult struct {
	// List of queries executed and it's execution results in source and target
	QueryResults *QueryExecutionResult

	// Errors that are part of the execution
	ValidationErrors *ValidationError
}

// QueryExecutionResult - Describes query analysis results for execution in source and target
type QueryExecutionResult struct {
	// Query text retrieved from the source server
	QueryText *string

	// Query analysis result from the source
	SourceResult *ExecutionStatistics

	// Total no. of statements in the batch
	StatementsInBatch *int64

	// Query analysis result from the target
	TargetResult *ExecutionStatistics
}

// Quota - Describes a quota for or usage details about a resource
type Quota struct {
	// The current value of the quota. If null or missing, the current value cannot be determined in the context of the request.
	CurrentValue *float64

	// The resource ID of the quota object
	ID *string

	// The maximum value of the quota. If null or missing, the quota has no maximum, in which case it merely tracks usage.
	Limit *float64

	// The name of the quota
	Name *QuotaName

	// The unit for the quota, such as Count, Bytes, BytesPerSecond, etc.
	Unit *string
}

// QuotaList - OData page of quota objects
type QuotaList struct {
	// URL to load the next page of quotas, or null or missing if this is the last page
	NextLink *string

	// List of quotas
	Value []*Quota
}

// QuotaName - The name of the quota
type QuotaName struct {
	// The localized name of the quota
	LocalizedValue *string

	// The unlocalized name (or ID) of the quota
	Value *string
}

// ReportableException - Exception object for all custom exceptions
type ReportableException struct {
	// Actionable steps for this exception
	ActionableMessage *string

	// The path to the file where exception occurred
	FilePath *string

	// Coded numerical value that is assigned to a specific exception
	HResult *int32

	// The line number where exception occurred
	LineNumber *string

	// Error message
	Message *string

	// Stack trace
	StackTrace *string
}

// Resource - ARM resource.
type Resource struct {
	// READ-ONLY; Resource ID.
	ID *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// ResourceSKU - Describes an available DMS SKU.
type ResourceSKU struct {
	// READ-ONLY; The api versions that support this SKU.
	APIVersions []*string

	// READ-ONLY; A name value pair to describe the capability.
	Capabilities []*ResourceSKUCapabilities

	// READ-ONLY; Not used.
	Capacity *ResourceSKUCapacity

	// READ-ONLY; Metadata for retrieving price info.
	Costs []*ResourceSKUCosts

	// READ-ONLY; The Family of this particular SKU.
	Family *string

	// READ-ONLY; The Kind of resources that are supported in this SKU.
	Kind *string

	// READ-ONLY; The set of locations that the SKU is available.
	Locations []*string

	// READ-ONLY; The name of SKU.
	Name *string

	// READ-ONLY; The type of resource the SKU applies to.
	ResourceType *string

	// READ-ONLY; The restrictions because of which SKU cannot be used. This is empty if there are no restrictions.
	Restrictions []*ResourceSKURestrictions

	// READ-ONLY; The Size of the SKU.
	Size *string

	// READ-ONLY; Specifies the tier of DMS in a scale set.
	Tier *string
}

// ResourceSKUCapabilities - Describes The SKU capabilities object.
type ResourceSKUCapabilities struct {
	// READ-ONLY; An invariant to describe the feature.
	Name *string

	// READ-ONLY; An invariant if the feature is measured by quantity.
	Value *string
}

// ResourceSKUCapacity - Describes scaling information of a SKU.
type ResourceSKUCapacity struct {
	// READ-ONLY; The default capacity.
	Default *int64

	// READ-ONLY; The maximum capacity.
	Maximum *int64

	// READ-ONLY; The minimum capacity.
	Minimum *int64

	// READ-ONLY; The scale type applicable to the SKU.
	ScaleType *ResourceSKUCapacityScaleType
}

// ResourceSKUCosts - Describes metadata for retrieving price info.
type ResourceSKUCosts struct {
	// READ-ONLY; An invariant to show the extended unit.
	ExtendedUnit *string

	// READ-ONLY; Used for querying price from commerce.
	MeterID *string

	// READ-ONLY; The multiplier is needed to extend the base metered cost.
	Quantity *int64
}

// ResourceSKURestrictions - Describes scaling information of a SKU.
type ResourceSKURestrictions struct {
	// READ-ONLY; The reason code for restriction.
	ReasonCode *ResourceSKURestrictionsReasonCode

	// READ-ONLY; The type of restrictions.
	Type *ResourceSKURestrictionsType

	// READ-ONLY; The value of restrictions. If the restriction type is set to location. This would be different locations where
	// the SKU is restricted.
	Values []*string
}

// ResourceSKUsResult - The DMS List SKUs operation response.
type ResourceSKUsResult struct {
	// REQUIRED; The list of SKUs available for the subscription.
	Value []*ResourceSKU

	// The uri to fetch the next page of DMS SKUs. Call ListNext() with this to fetch the next page of DMS SKUs.
	NextLink *string
}

// SQLConnectionInfo - Information for connecting to SQL database server
type SQLConnectionInfo struct {
	// REQUIRED; Data source in the format Protocol:MachineName\SQLServerInstanceName,PortNumber
	DataSource *string

	// REQUIRED; Type of connection info
	Type *string

	// Additional connection settings
	AdditionalSettings *string

	// Authentication type to use for connection
	Authentication *AuthenticationType

	// Whether to encrypt the connection
	EncryptConnection *bool

	// Password credential.
	Password *string

	// Server platform type for connection
	Platform *SQLSourcePlatform

	// Whether to trust the server certificate
	TrustServerCertificate *bool

	// User name
	UserName *string
}

// GetConnectionInfo implements the ConnectionInfoClassification interface for type SQLConnectionInfo.
func (s *SQLConnectionInfo) GetConnectionInfo() *ConnectionInfo {
	return &ConnectionInfo{
		Password: s.Password,
		Type:     s.Type,
		UserName: s.UserName,
	}
}

// SQLMigrationTaskInput - Base class for migration task input
type SQLMigrationTaskInput struct {
	// REQUIRED; Information for connecting to source
	SourceConnectionInfo *SQLConnectionInfo

	// REQUIRED; Information for connecting to target
	TargetConnectionInfo *SQLConnectionInfo
}

// SQLServerSQLMISyncTaskInput - Input for task that migrates SQL Server databases to Azure SQL Database Managed Instance
// online scenario.
type SQLServerSQLMISyncTaskInput struct {
	// REQUIRED; Azure Active Directory Application the DMS instance will use to connect to the target instance of Azure SQL Database
	// Managed Instance and the Azure Storage Account
	AzureApp *AzureActiveDirectoryApp

	// REQUIRED; Databases to migrate
	SelectedDatabases []*MigrateSQLServerSQLMIDatabaseInput

	// REQUIRED; Connection information for source SQL Server
	SourceConnectionInfo *SQLConnectionInfo

	// REQUIRED; Fully qualified resourceId of storage
	StorageResourceID *string

	// REQUIRED; Connection information for Azure SQL Database Managed Instance
	TargetConnectionInfo *MiSQLConnectionInfo

	// Backup file share information for all selected databases.
	BackupFileShare *FileShare
}

// SchemaComparisonValidationResult - Results for schema comparison between the source and target
type SchemaComparisonValidationResult struct {
	// List of schema differences between the source and target databases
	SchemaDifferences *SchemaComparisonValidationResultType

	// Count of source database objects
	SourceDatabaseObjectCount map[string]*int64

	// Count of target database objects
	TargetDatabaseObjectCount map[string]*int64

	// List of errors that happened while performing schema compare validation
	ValidationErrors *ValidationError
}

// SchemaComparisonValidationResultType - Description about the errors happen while performing migration validation
type SchemaComparisonValidationResultType struct {
	// Name of the object that has the difference
	ObjectName *string

	// Type of the object that has the difference. e.g (Table/View/StoredProcedure)
	ObjectType *ObjectType

	// Update action type with respect to target
	UpdateAction *UpdateActionType
}

// SchemaMigrationSetting - Settings for migrating schema from source to target
type SchemaMigrationSetting struct {
	// Resource Identifier of a file resource containing the uploaded schema file
	FileID *string

	// Option on how to migrate the schema
	SchemaOption *SchemaMigrationOption
}

// SelectedCertificateInput - Info for certificate to be exported for TDE enabled databases.
type SelectedCertificateInput struct {
	// REQUIRED; Name of certificate to be exported.
	CertificateName *string

	// REQUIRED; Password to use for encrypting the exported certificate.
	Password *string
}

// ServerProperties - Server properties for MySQL type source
type ServerProperties struct {
	// READ-ONLY; Number of databases in the server
	ServerDatabaseCount *int32

	// READ-ONLY; Edition of the database server
	ServerEdition *string

	// READ-ONLY; Name of the server
	ServerName *string

	// READ-ONLY; Version of the operating system
	ServerOperatingSystemVersion *string

	// READ-ONLY; Name of the server platform
	ServerPlatform *string

	// READ-ONLY; Version of the database server
	ServerVersion *string
}

// Service - A Database Migration Service resource
type Service struct {
	// REQUIRED; Resource location.
	Location *string

	// HTTP strong entity tag value. Ignored if submitted
	Etag *string

	// The resource kind. Only 'vm' (the default) is supported.
	Kind *string

	// Custom service properties
	Properties *ServiceProperties

	// Service SKU
	SKU *ServiceSKU

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Resource ID.
	ID *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData

	// READ-ONLY; Resource type.
	Type *string
}

// ServiceList - OData page of service objects
type ServiceList struct {
	// URL to load the next page of services
	NextLink *string

	// List of services
	Value []*Service
}

// ServiceOperation - Description of an action supported by the Database Migration Service
type ServiceOperation struct {
	// Localized display text
	Display *ServiceOperationDisplay

	// The fully qualified action name, e.g. Microsoft.DataMigration/services/read
	Name *string
}

// ServiceOperationDisplay - Localized display text
type ServiceOperationDisplay struct {
	// The localized operation description
	Description *string

	// The localized operation name
	Operation *string

	// The localized resource provider name
	Provider *string

	// The localized resource type name
	Resource *string
}

// ServiceOperationList - OData page of action (operation) objects
type ServiceOperationList struct {
	// URL to load the next page of actions
	NextLink *string

	// List of actions
	Value []*ServiceOperation
}

// ServiceProperties - Properties of the Database Migration Service instance
type ServiceProperties struct {
	// REQUIRED; The ID of the Microsoft.Network/virtualNetworks/subnets resource to which the service should be joined
	VirtualSubnetID *string

	// The public key of the service, used to encrypt secrets sent to the service
	PublicKey *string

	// The ID of the Microsoft.Network/networkInterfaces resource which the service have
	VirtualNicID *string

	// READ-ONLY; The resource's provisioning state
	ProvisioningState *ServiceProvisioningState
}

// ServiceSKU - An Azure SKU instance
type ServiceSKU struct {
	// The capacity of the SKU, if it supports scaling
	Capacity *int32

	// The SKU family, used when the service has multiple performance classes within a tier, such as 'A', 'D', etc. for virtual
	// machines
	Family *string

	// The unique name of the SKU, such as 'P3'
	Name *string

	// The size of the SKU, used when the name alone does not denote a service size or when a SKU has multiple performance classes
	// within a family, e.g. 'A1' for virtual machines
	Size *string

	// The tier of the SKU, such as 'Basic', 'General Purpose', or 'Business Critical'
	Tier *string
}

// ServiceSKUList - OData page of available SKUs
type ServiceSKUList struct {
	// URL to load the next page of service SKUs
	NextLink *string

	// List of service SKUs
	Value []*AvailableServiceSKU
}

// ServiceStatusResponse - Service health status
type ServiceStatusResponse struct {
	// The DMS instance agent version
	AgentVersion *string

	// The machine-readable status, such as 'Initializing', 'Offline', 'Online', 'Deploying', 'Deleting', 'Stopped', 'Stopping',
	// 'Starting', 'FailedToStart', 'FailedToStop' or 'Failed'
	Status *string

	// The list of supported task types
	SupportedTaskTypes []*string

	// The services virtual machine size, such as 'StandardD2v2'
	VMSize *string
}

// SsisMigrationInfo - SSIS migration info with SSIS store type, overwrite policy.
type SsisMigrationInfo struct {
	// The overwrite option for the SSIS environment migration
	EnvironmentOverwriteOption *SsisMigrationOverwriteOption

	// The overwrite option for the SSIS project migration
	ProjectOverwriteOption *SsisMigrationOverwriteOption

	// The SSIS store type of source, only SSIS catalog is supported now in DMS
	SsisStoreType *SsisStoreType
}

// StartMigrationScenarioServerRoleResult - Server role migration result
type StartMigrationScenarioServerRoleResult struct {
	// READ-ONLY; Migration exceptions and warnings.
	ExceptionsAndWarnings []*ReportableException

	// READ-ONLY; Name of server role.
	Name *string

	// READ-ONLY; Current state of migration
	State *MigrationState
}

// SyncMigrationDatabaseErrorEvent - Database migration errors for online migration
type SyncMigrationDatabaseErrorEvent struct {
	// READ-ONLY; Event text.
	EventText *string

	// READ-ONLY; Event type.
	EventTypeString *string

	// READ-ONLY; String value of timestamp.
	TimestampString *string
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time

	// The identity that created the resource.
	CreatedBy *string

	// The type of identity that created the resource.
	CreatedByType *CreatedByType

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time

	// The identity that last modified the resource.
	LastModifiedBy *string

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType
}

// TaskList - OData page of tasks
type TaskList struct {
	// URL to load the next page of tasks
	NextLink *string

	// List of tasks
	Value []*ProjectTask
}

// TrackedResource - ARM tracked top level resource.
type TrackedResource struct {
	// REQUIRED; Resource location.
	Location *string

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Resource ID.
	ID *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData

	// READ-ONLY; Resource type.
	Type *string
}

// UploadOCIDriverTaskInput - Input for the service task to upload an OCI driver.
type UploadOCIDriverTaskInput struct {
	// File share information for the OCI driver archive.
	DriverShare *FileShare
}

// UploadOCIDriverTaskOutput - Output for the service task to upload an OCI driver.
type UploadOCIDriverTaskOutput struct {
	// READ-ONLY; The name of the driver package that was validated and uploaded.
	DriverPackageName *string

	// READ-ONLY; Validation errors
	ValidationErrors []*ReportableException
}

// UploadOCIDriverTaskProperties - Properties for the task that uploads an OCI driver.
type UploadOCIDriverTaskProperties struct {
	// REQUIRED; Task type.
	TaskType *string

	// Key value pairs of client data to attach meta data information to task
	ClientData map[string]*string

	// Input for the service task to upload an OCI driver.
	Input *UploadOCIDriverTaskInput

	// READ-ONLY; Array of command properties.
	Commands []CommandPropertiesClassification

	// READ-ONLY; Array of errors. This is ignored if submitted.
	Errors []*ODataError

	// READ-ONLY; Task output. This is ignored if submitted.
	Output []*UploadOCIDriverTaskOutput

	// READ-ONLY; The state of the task. This is ignored if submitted.
	State *TaskState
}

// GetProjectTaskProperties implements the ProjectTaskPropertiesClassification interface for type UploadOCIDriverTaskProperties.
func (u *UploadOCIDriverTaskProperties) GetProjectTaskProperties() *ProjectTaskProperties {
	return &ProjectTaskProperties{
		ClientData: u.ClientData,
		Commands:   u.Commands,
		Errors:     u.Errors,
		State:      u.State,
		TaskType:   u.TaskType,
	}
}

// ValidateMigrationInputSQLServerSQLDbSyncTaskProperties - Properties for task that validates migration input for SQL to
// Azure SQL DB sync migrations
type ValidateMigrationInputSQLServerSQLDbSyncTaskProperties struct {
	// REQUIRED; Task type.
	TaskType *string

	// Key value pairs of client data to attach meta data information to task
	ClientData map[string]*string

	// Task input
	Input *ValidateSyncMigrationInputSQLServerTaskInput

	// READ-ONLY; Array of command properties.
	Commands []CommandPropertiesClassification

	// READ-ONLY; Array of errors. This is ignored if submitted.
	Errors []*ODataError

	// READ-ONLY; Task output. This is ignored if submitted.
	Output []*ValidateSyncMigrationInputSQLServerTaskOutput

	// READ-ONLY; The state of the task. This is ignored if submitted.
	State *TaskState
}

// GetProjectTaskProperties implements the ProjectTaskPropertiesClassification interface for type ValidateMigrationInputSQLServerSQLDbSyncTaskProperties.
func (v *ValidateMigrationInputSQLServerSQLDbSyncTaskProperties) GetProjectTaskProperties() *ProjectTaskProperties {
	return &ProjectTaskProperties{
		ClientData: v.ClientData,
		Commands:   v.Commands,
		Errors:     v.Errors,
		State:      v.State,
		TaskType:   v.TaskType,
	}
}

// ValidateMigrationInputSQLServerSQLMISyncTaskInput - Input for task that migrates SQL Server databases to Azure SQL Database
// Managed Instance online scenario.
type ValidateMigrationInputSQLServerSQLMISyncTaskInput struct {
	// REQUIRED; Azure Active Directory Application the DMS instance will use to connect to the target instance of Azure SQL Database
	// Managed Instance and the Azure Storage Account
	AzureApp *AzureActiveDirectoryApp

	// REQUIRED; Databases to migrate
	SelectedDatabases []*MigrateSQLServerSQLMIDatabaseInput

	// REQUIRED; Connection information for source SQL Server
	SourceConnectionInfo *SQLConnectionInfo

	// REQUIRED; Fully qualified resourceId of storage
	StorageResourceID *string

	// REQUIRED; Connection information for Azure SQL Database Managed Instance
	TargetConnectionInfo *MiSQLConnectionInfo

	// Backup file share information for all selected databases.
	BackupFileShare *FileShare
}

// ValidateMigrationInputSQLServerSQLMISyncTaskOutput - Output for task that validates migration input for Azure SQL Database
// Managed Instance online migration
type ValidateMigrationInputSQLServerSQLMISyncTaskOutput struct {
	// READ-ONLY; Database identifier
	ID *string

	// READ-ONLY; Name of database
	Name *string

	// READ-ONLY; Errors associated with a selected database object
	ValidationErrors []*ReportableException
}

// ValidateMigrationInputSQLServerSQLMISyncTaskProperties - Properties for task that validates migration input for SQL to
// Azure SQL Database Managed Instance sync scenario
type ValidateMigrationInputSQLServerSQLMISyncTaskProperties struct {
	// REQUIRED; Task type.
	TaskType *string

	// Key value pairs of client data to attach meta data information to task
	ClientData map[string]*string

	// Task input
	Input *ValidateMigrationInputSQLServerSQLMISyncTaskInput

	// READ-ONLY; Array of command properties.
	Commands []CommandPropertiesClassification

	// READ-ONLY; Array of errors. This is ignored if submitted.
	Errors []*ODataError

	// READ-ONLY; Task output. This is ignored if submitted.
	Output []*ValidateMigrationInputSQLServerSQLMISyncTaskOutput

	// READ-ONLY; The state of the task. This is ignored if submitted.
	State *TaskState
}

// GetProjectTaskProperties implements the ProjectTaskPropertiesClassification interface for type ValidateMigrationInputSQLServerSQLMISyncTaskProperties.
func (v *ValidateMigrationInputSQLServerSQLMISyncTaskProperties) GetProjectTaskProperties() *ProjectTaskProperties {
	return &ProjectTaskProperties{
		ClientData: v.ClientData,
		Commands:   v.Commands,
		Errors:     v.Errors,
		State:      v.State,
		TaskType:   v.TaskType,
	}
}

// ValidateMigrationInputSQLServerSQLMITaskInput - Input for task that validates migration input for SQL to Azure SQL Managed
// Instance
type ValidateMigrationInputSQLServerSQLMITaskInput struct {
	// REQUIRED; SAS URI of Azure Storage Account Container to be used for storing backup files.
	BackupBlobShare *BlobShare

	// REQUIRED; Databases to migrate
	SelectedDatabases []*MigrateSQLServerSQLMIDatabaseInput

	// REQUIRED; Information for connecting to source
	SourceConnectionInfo *SQLConnectionInfo

	// REQUIRED; Information for connecting to target
	TargetConnectionInfo *SQLConnectionInfo

	// Backup file share information for all selected databases.
	BackupFileShare *FileShare

	// Backup Mode to specify whether to use existing backup or create new backup.
	BackupMode *BackupMode

	// Logins to migrate
	SelectedLogins []*string
}

// ValidateMigrationInputSQLServerSQLMITaskOutput - Output for task that validates migration input for SQL to Azure SQL Managed
// Instance migrations
type ValidateMigrationInputSQLServerSQLMITaskOutput struct {
	// Information about backup files when existing backup mode is used.
	DatabaseBackupInfo *DatabaseBackupInfo

	// READ-ONLY; Errors associated with the BackupFolder path
	BackupFolderErrors []*ReportableException

	// READ-ONLY; Errors associated with backup share user name and password credentials
	BackupShareCredentialsErrors []*ReportableException

	// READ-ONLY; Errors associated with the storage account provided.
	BackupStorageAccountErrors []*ReportableException

	// READ-ONLY; Errors associated with existing backup files.
	ExistingBackupErrors []*ReportableException

	// READ-ONLY; Result identifier
	ID *string

	// READ-ONLY; Name of database
	Name *string

	// READ-ONLY; Errors associated with the RestoreDatabaseName
	RestoreDatabaseNameErrors []*ReportableException
}

// ValidateMigrationInputSQLServerSQLMITaskProperties - Properties for task that validates migration input for SQL to Azure
// SQL Database Managed Instance
type ValidateMigrationInputSQLServerSQLMITaskProperties struct {
	// REQUIRED; Task type.
	TaskType *string

	// Key value pairs of client data to attach meta data information to task
	ClientData map[string]*string

	// Task input
	Input *ValidateMigrationInputSQLServerSQLMITaskInput

	// READ-ONLY; Array of command properties.
	Commands []CommandPropertiesClassification

	// READ-ONLY; Array of errors. This is ignored if submitted.
	Errors []*ODataError

	// READ-ONLY; Task output. This is ignored if submitted.
	Output []*ValidateMigrationInputSQLServerSQLMITaskOutput

	// READ-ONLY; The state of the task. This is ignored if submitted.
	State *TaskState
}

// GetProjectTaskProperties implements the ProjectTaskPropertiesClassification interface for type ValidateMigrationInputSQLServerSQLMITaskProperties.
func (v *ValidateMigrationInputSQLServerSQLMITaskProperties) GetProjectTaskProperties() *ProjectTaskProperties {
	return &ProjectTaskProperties{
		ClientData: v.ClientData,
		Commands:   v.Commands,
		Errors:     v.Errors,
		State:      v.State,
		TaskType:   v.TaskType,
	}
}

// ValidateMongoDbTaskProperties - Properties for the task that validates a migration between MongoDB data sources
type ValidateMongoDbTaskProperties struct {
	// REQUIRED; Task type.
	TaskType *string

	// Key value pairs of client data to attach meta data information to task
	ClientData map[string]*string

	// Describes how a MongoDB data migration should be performed
	Input *MongoDbMigrationSettings

	// READ-ONLY; Array of command properties.
	Commands []CommandPropertiesClassification

	// READ-ONLY; Array of errors. This is ignored if submitted.
	Errors []*ODataError

	// READ-ONLY; An array containing a single MongoDbMigrationProgress object
	Output []*MongoDbMigrationProgress

	// READ-ONLY; The state of the task. This is ignored if submitted.
	State *TaskState
}

// GetProjectTaskProperties implements the ProjectTaskPropertiesClassification interface for type ValidateMongoDbTaskProperties.
func (v *ValidateMongoDbTaskProperties) GetProjectTaskProperties() *ProjectTaskProperties {
	return &ProjectTaskProperties{
		ClientData: v.ClientData,
		Commands:   v.Commands,
		Errors:     v.Errors,
		State:      v.State,
		TaskType:   v.TaskType,
	}
}

// ValidateOracleAzureDbForPostgreSQLSyncTaskProperties - Properties for the task that validates a migration for Oracle to
// Azure Database for PostgreSQL for online migrations
type ValidateOracleAzureDbForPostgreSQLSyncTaskProperties struct {
	// REQUIRED; Task type.
	TaskType *string

	// Key value pairs of client data to attach meta data information to task
	ClientData map[string]*string

	// Input for the task that migrates Oracle databases to Azure Database for PostgreSQL for online migrations
	Input *MigrateOracleAzureDbPostgreSQLSyncTaskInput

	// READ-ONLY; Array of command properties.
	Commands []CommandPropertiesClassification

	// READ-ONLY; Array of errors. This is ignored if submitted.
	Errors []*ODataError

	// READ-ONLY; An array containing a single validation error response object
	Output []*ValidateOracleAzureDbPostgreSQLSyncTaskOutput

	// READ-ONLY; The state of the task. This is ignored if submitted.
	State *TaskState
}

// GetProjectTaskProperties implements the ProjectTaskPropertiesClassification interface for type ValidateOracleAzureDbForPostgreSQLSyncTaskProperties.
func (v *ValidateOracleAzureDbForPostgreSQLSyncTaskProperties) GetProjectTaskProperties() *ProjectTaskProperties {
	return &ProjectTaskProperties{
		ClientData: v.ClientData,
		Commands:   v.Commands,
		Errors:     v.Errors,
		State:      v.State,
		TaskType:   v.TaskType,
	}
}

// ValidateOracleAzureDbPostgreSQLSyncTaskOutput - Output for task that validates migration input for Oracle to Azure Database
// for PostgreSQL for online migrations
type ValidateOracleAzureDbPostgreSQLSyncTaskOutput struct {
	// READ-ONLY; Errors associated with a selected database object
	ValidationErrors []*ReportableException
}

// ValidateSyncMigrationInputSQLServerTaskInput - Input for task that validates migration input for SQL sync migrations
type ValidateSyncMigrationInputSQLServerTaskInput struct {
	// REQUIRED; Databases to migrate
	SelectedDatabases []*MigrateSQLServerSQLDbSyncDatabaseInput

	// REQUIRED; Information for connecting to source SQL server
	SourceConnectionInfo *SQLConnectionInfo

	// REQUIRED; Information for connecting to target
	TargetConnectionInfo *SQLConnectionInfo
}

// ValidateSyncMigrationInputSQLServerTaskOutput - Output for task that validates migration input for SQL sync migrations
type ValidateSyncMigrationInputSQLServerTaskOutput struct {
	// READ-ONLY; Database identifier
	ID *string

	// READ-ONLY; Name of database
	Name *string

	// READ-ONLY; Errors associated with a selected database object
	ValidationErrors []*ReportableException
}

// ValidationError - Description about the errors happen while performing migration validation
type ValidationError struct {
	// Severity of the error
	Severity *Severity

	// Error Text
	Text *string
}

// WaitStatistics - Wait statistics gathered during query batch execution
type WaitStatistics struct {
	// Total no. of waits
	WaitCount *int64

	// Total wait time in millisecond(s)
	WaitTimeMs *float32

	// Type of the Wait
	WaitType *string
}
