; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 6
; RUN: llc -mtriple=armv7-- < %s | FileCheck -check-prefix=NOFP16 %s

declare void @f16_user(half)
declare half @f16_result()

declare void @v2f16_user(<2 x half>)
declare <2 x half> @v2f16_result()

declare void @v4f16_user(<4 x half>)
declare <4 x half> @v4f16_result()

declare void @v8f16_user(<8 x half>)
declare <8 x half> @v8f16_result()

define void @f16_arg(half %arg, ptr %ptr) #0 {
; NOFP16-LABEL: f16_arg:
; NOFP16:       @ %bb.0:
; NOFP16-NEXT:    push {r4, lr}
; NOFP16-NEXT:    uxth r0, r0
; NOFP16-NEXT:    mov r4, r1
; NOFP16-NEXT:    bl __gnu_h2f_ieee
; NOFP16-NEXT:    str r0, [r4]
; NOFP16-NEXT:    pop {r4, pc}
  %fpext = call float @llvm.experimental.constrained.fpext.f32.f16(half %arg, metadata !"fpexcept.strict")
  store float %fpext, ptr %ptr
  ret void
}

define void @v2f16_arg(<2 x half> %arg, ptr %ptr) #0 {
; NOFP16-LABEL: v2f16_arg:
; NOFP16:       @ %bb.0:
; NOFP16-NEXT:    push {r4, r5, r11, lr}
; NOFP16-NEXT:    vpush {d8}
; NOFP16-NEXT:    mov r5, r0
; NOFP16-NEXT:    uxth r0, r1
; NOFP16-NEXT:    mov r4, r2
; NOFP16-NEXT:    bl __gnu_h2f_ieee
; NOFP16-NEXT:    uxth r1, r5
; NOFP16-NEXT:    vmov s17, r0
; NOFP16-NEXT:    mov r0, r1
; NOFP16-NEXT:    bl __gnu_h2f_ieee
; NOFP16-NEXT:    vmov s16, r0
; NOFP16-NEXT:    vstr d8, [r4]
; NOFP16-NEXT:    vpop {d8}
; NOFP16-NEXT:    pop {r4, r5, r11, pc}
  %fpext = call <2 x float> @llvm.experimental.constrained.fpext.v2f32.v2f16(<2 x half> %arg, metadata !"fpexcept.strict")
  store <2 x float> %fpext, ptr %ptr
  ret void
}

define void @v3f16_arg(<3 x half> %arg, ptr %ptr) #0 {
; NOFP16-LABEL: v3f16_arg:
; NOFP16:       @ %bb.0:
; NOFP16-NEXT:    push {r4, r5, r6, lr}
; NOFP16-NEXT:    vpush {d8}
; NOFP16-NEXT:    mov r6, r0
; NOFP16-NEXT:    uxth r0, r1
; NOFP16-NEXT:    mov r4, r3
; NOFP16-NEXT:    mov r5, r2
; NOFP16-NEXT:    bl __gnu_h2f_ieee
; NOFP16-NEXT:    uxth r1, r6
; NOFP16-NEXT:    vmov s17, r0
; NOFP16-NEXT:    mov r0, r1
; NOFP16-NEXT:    bl __gnu_h2f_ieee
; NOFP16-NEXT:    vmov s16, r0
; NOFP16-NEXT:    uxth r0, r5
; NOFP16-NEXT:    vst1.32 {d8}, [r4:64]!
; NOFP16-NEXT:    bl __gnu_h2f_ieee
; NOFP16-NEXT:    str r0, [r4]
; NOFP16-NEXT:    vpop {d8}
; NOFP16-NEXT:    pop {r4, r5, r6, pc}
  %fpext = call <3 x float> @llvm.experimental.constrained.fpext.v3f32.v3f16(<3 x half> %arg, metadata !"fpexcept.strict")
  store <3 x float> %fpext, ptr %ptr
  ret void
}

define void @v4f16_arg(<4 x half> %arg, ptr %ptr) #0 {
; NOFP16-LABEL: v4f16_arg:
; NOFP16:       @ %bb.0:
; NOFP16-NEXT:    push {r4, r5, r6, r7, r11, lr}
; NOFP16-NEXT:    vpush {d8, d9}
; NOFP16-NEXT:    mov r6, r0
; NOFP16-NEXT:    uxth r0, r1
; NOFP16-NEXT:    mov r4, r3
; NOFP16-NEXT:    mov r5, r2
; NOFP16-NEXT:    bl __gnu_h2f_ieee
; NOFP16-NEXT:    mov r7, r0
; NOFP16-NEXT:    uxth r0, r4
; NOFP16-NEXT:    bl __gnu_h2f_ieee
; NOFP16-NEXT:    vmov s19, r0
; NOFP16-NEXT:    uxth r0, r5
; NOFP16-NEXT:    ldr r4, [sp, #40]
; NOFP16-NEXT:    bl __gnu_h2f_ieee
; NOFP16-NEXT:    vmov s18, r0
; NOFP16-NEXT:    uxth r0, r6
; NOFP16-NEXT:    vmov s17, r7
; NOFP16-NEXT:    bl __gnu_h2f_ieee
; NOFP16-NEXT:    vmov s16, r0
; NOFP16-NEXT:    vst1.64 {d8, d9}, [r4]
; NOFP16-NEXT:    vpop {d8, d9}
; NOFP16-NEXT:    pop {r4, r5, r6, r7, r11, pc}
  %fpext = call <4 x float> @llvm.experimental.constrained.fpext.v4f32.v4f16(<4 x half> %arg, metadata !"fpexcept.strict")
  store <4 x float> %fpext, ptr %ptr
  ret void
}

 define half @f16_return(float %arg) #0 {
; NOFP16-LABEL: f16_return:
; NOFP16:       @ %bb.0:
; NOFP16-NEXT:    push {r11, lr}
; NOFP16-NEXT:    bl __gnu_f2h_ieee
; NOFP16-NEXT:    pop {r11, pc}
   %fptrunc = call half @llvm.experimental.constrained.fptrunc.f16.f32(float %arg, metadata !"round.tonearest", metadata !"fpexcept.strict")
   ret half %fptrunc
 }

 define <2 x half> @v2f16_return(<2 x float> %arg) #0 {
; NOFP16-LABEL: v2f16_return:
; NOFP16:       @ %bb.0:
; NOFP16-NEXT:    push {r11, lr}
; NOFP16-NEXT:    vpush {d8}
; NOFP16-NEXT:    sub sp, sp, #8
; NOFP16-NEXT:    vmov d8, r0, r1
; NOFP16-NEXT:    vmov r0, s17
; NOFP16-NEXT:    bl __gnu_f2h_ieee
; NOFP16-NEXT:    vmov r1, s16
; NOFP16-NEXT:    strh r0, [sp, #6]
; NOFP16-NEXT:    mov r0, r1
; NOFP16-NEXT:    bl __gnu_f2h_ieee
; NOFP16-NEXT:    strh r0, [sp, #4]
; NOFP16-NEXT:    add r0, sp, #4
; NOFP16-NEXT:    vld1.32 {d16[0]}, [r0:32]
; NOFP16-NEXT:    vmovl.u16 q8, d16
; NOFP16-NEXT:    vmov.32 r0, d16[0]
; NOFP16-NEXT:    vmov.32 r1, d16[1]
; NOFP16-NEXT:    add sp, sp, #8
; NOFP16-NEXT:    vpop {d8}
; NOFP16-NEXT:    pop {r11, pc}
   %fptrunc = call <2 x half> @llvm.experimental.constrained.fptrunc.v2f16.v2f32(<2 x float> %arg, metadata !"round.tonearest", metadata !"fpexcept.strict")
   ret <2 x half> %fptrunc
 }

 define <3 x half> @v3f16_return(<3 x float> %arg) #0 {
; NOFP16-LABEL: v3f16_return:
; NOFP16:       @ %bb.0:
; NOFP16-NEXT:    push {r4, r5, r6, lr}
; NOFP16-NEXT:    vmov d1, r2, r3
; NOFP16-NEXT:    mov r5, r0
; NOFP16-NEXT:    vmov d0, r0, r1
; NOFP16-NEXT:    mov r4, r1
; NOFP16-NEXT:    vmov r0, s2
; NOFP16-NEXT:    bl __gnu_f2h_ieee
; NOFP16-NEXT:    uxth r6, r0
; NOFP16-NEXT:    mov r0, r4
; NOFP16-NEXT:    bl __gnu_f2h_ieee
; NOFP16-NEXT:    mov r4, r0
; NOFP16-NEXT:    mov r0, r5
; NOFP16-NEXT:    bl __gnu_f2h_ieee
; NOFP16-NEXT:    pkhbt r0, r0, r4, lsl #16
; NOFP16-NEXT:    vmov d16, r0, r6
; NOFP16-NEXT:    vmov.u16 r0, d16[0]
; NOFP16-NEXT:    vmov.u16 r1, d16[1]
; NOFP16-NEXT:    vmov.u16 r2, d16[2]
; NOFP16-NEXT:    pop {r4, r5, r6, pc}
   %fptrunc = call <3 x half> @llvm.experimental.constrained.fptrunc.v3f16.v3f32(<3 x float> %arg, metadata !"round.tonearest", metadata !"fpexcept.strict")
   ret <3 x half> %fptrunc
 }

 define <4 x half> @v4f16_return(<4 x float> %arg) #0 {
; NOFP16-LABEL: v4f16_return:
; NOFP16:       @ %bb.0:
; NOFP16-NEXT:    push {r4, r5, r11, lr}
; NOFP16-NEXT:    vpush {d8, d9}
; NOFP16-NEXT:    vmov d8, r2, r3
; NOFP16-NEXT:    vmov d9, r0, r1
; NOFP16-NEXT:    vmov r2, s17
; NOFP16-NEXT:    mov r0, r2
; NOFP16-NEXT:    bl __gnu_f2h_ieee
; NOFP16-NEXT:    mov r4, r0
; NOFP16-NEXT:    vmov r0, s16
; NOFP16-NEXT:    bl __gnu_f2h_ieee
; NOFP16-NEXT:    vmov r1, s19
; NOFP16-NEXT:    pkhbt r5, r0, r4, lsl #16
; NOFP16-NEXT:    mov r0, r1
; NOFP16-NEXT:    bl __gnu_f2h_ieee
; NOFP16-NEXT:    mov r4, r0
; NOFP16-NEXT:    vmov r0, s18
; NOFP16-NEXT:    bl __gnu_f2h_ieee
; NOFP16-NEXT:    pkhbt r0, r0, r4, lsl #16
; NOFP16-NEXT:    vmov d16, r0, r5
; NOFP16-NEXT:    vmov.u16 r0, d16[0]
; NOFP16-NEXT:    vmov.u16 r1, d16[1]
; NOFP16-NEXT:    vmov.u16 r2, d16[2]
; NOFP16-NEXT:    vmov.u16 r3, d16[3]
; NOFP16-NEXT:    vpop {d8, d9}
; NOFP16-NEXT:    pop {r4, r5, r11, pc}
   %fptrunc = call <4 x half> @llvm.experimental.constrained.fptrunc.v4f16.v4f32(<4 x float> %arg, metadata !"round.tonearest", metadata !"fpexcept.strict")
   ret <4 x half> %fptrunc
 }

define void @outgoing_v4f16_return(ptr %ptr) #0 {
; NOFP16-LABEL: outgoing_v4f16_return:
; NOFP16:       @ %bb.0:
; NOFP16-NEXT:    push {r4, lr}
; NOFP16-NEXT:    mov r4, r0
; NOFP16-NEXT:    bl v4f16_result
; NOFP16-NEXT:    strh r3, [r4, #6]
; NOFP16-NEXT:    strh r2, [r4, #4]
; NOFP16-NEXT:    strh r1, [r4, #2]
; NOFP16-NEXT:    strh r0, [r4]
; NOFP16-NEXT:    pop {r4, pc}
  %val = call <4 x half> @v4f16_result() #0
  store <4 x half> %val, ptr %ptr
  ret void
}

define void @outgoing_v8f16_return(ptr %ptr) #0 {
; NOFP16-LABEL: outgoing_v8f16_return:
; NOFP16:       @ %bb.0:
; NOFP16-NEXT:    push {r4, r10, r11, lr}
; NOFP16-NEXT:    add r11, sp, #8
; NOFP16-NEXT:    sub sp, sp, #16
; NOFP16-NEXT:    bfc sp, #0, #4
; NOFP16-NEXT:    mov r4, r0
; NOFP16-NEXT:    mov r0, sp
; NOFP16-NEXT:    bl v8f16_result
; NOFP16-NEXT:    ldm sp, {r0, r1, r2, r3}
; NOFP16-NEXT:    stm r4, {r0, r1, r2, r3}
; NOFP16-NEXT:    sub sp, r11, #8
; NOFP16-NEXT:    pop {r4, r10, r11, pc}
  %val = call <8 x half> @v8f16_result() #0
  store <8 x half> %val, ptr %ptr
  ret void
}

define half @call_split_type_used_outside_block_v8f16() #0 {
; NOFP16-LABEL: call_split_type_used_outside_block_v8f16:
; NOFP16:       @ %bb.0: @ %bb0
; NOFP16-NEXT:    push {r4, r10, r11, lr}
; NOFP16-NEXT:    add r11, sp, #8
; NOFP16-NEXT:    sub sp, sp, #16
; NOFP16-NEXT:    bfc sp, #0, #4
; NOFP16-NEXT:    mov r4, sp
; NOFP16-NEXT:    mov r0, r4
; NOFP16-NEXT:    bl v8f16_result
; NOFP16-NEXT:    vld1.32 {d16[0]}, [r4:32]
; NOFP16-NEXT:    vmov.u16 r0, d16[0]
; NOFP16-NEXT:    sub sp, r11, #8
; NOFP16-NEXT:    pop {r4, r10, r11, pc}
bb0:
  %split.ret.type = call <8 x half> @v8f16_result() #0
  br label %bb1

bb1:
  %extract = extractelement <8 x half> %split.ret.type, i32 0
  ret half %extract
}

declare float @llvm.experimental.constrained.fpext.f32.f16(half, metadata) #0
declare <2 x float> @llvm.experimental.constrained.fpext.v2f32.v2f16(<2 x half>, metadata) #0
declare <3 x float> @llvm.experimental.constrained.fpext.v3f32.v3f16(<3 x half>, metadata) #0
declare <4 x float> @llvm.experimental.constrained.fpext.v4f32.v4f16(<4 x half>, metadata) #0

declare half @llvm.experimental.constrained.fptrunc.f16.f32(float, metadata, metadata) #0
declare <2 x half> @llvm.experimental.constrained.fptrunc.v2f16.v2f32(<2 x float>, metadata, metadata) #0
declare <3 x half> @llvm.experimental.constrained.fptrunc.v3f16.v3f32(<3 x float>, metadata, metadata) #0
declare <4 x half> @llvm.experimental.constrained.fptrunc.v4f16.v4f32(<4 x float>, metadata, metadata) #0

attributes #0 = { strictfp }
