# Read game version
function(read_game_version OUT_GAME_VERSION_STRING OUT_GAME_VERSION_MAJOR OUT_GAME_VERSION_MINOR OUT_GAME_VERSION_PATCH OUT_GAME_VERSION_BUILD)
  set(VERSION_FILE "${CMAKE_CURRENT_SOURCE_DIR}/src/core/global.h")
  set(VERSION_MAJOR_REGEX "#define[ \t]+GAME_VERSION_SUP[ \t]+(.+)")
  set(VERSION_MINOR_REGEX "#define[ \t]+GAME_VERSION_SUB[ \t]+(.+)")
  set(VERSION_PATCH_REGEX "#define[ \t]+GAME_VERSION_WIP[ \t]+(.+)")
  set(VERSION_BUILD_REGEX "#define[ \t]+GAME_VERSION_FIX[ \t]+(.+)")
  file(STRINGS "${VERSION_FILE}" GAME_VERSION_MAJOR REGEX "${VERSION_MAJOR_REGEX}")
  file(STRINGS "${VERSION_FILE}" GAME_VERSION_MINOR REGEX "${VERSION_MINOR_REGEX}")
  file(STRINGS "${VERSION_FILE}" GAME_VERSION_PATCH REGEX "${VERSION_PATCH_REGEX}")
  file(STRINGS "${VERSION_FILE}" GAME_VERSION_BUILD REGEX "${VERSION_BUILD_REGEX}")
  string(REGEX REPLACE ${VERSION_MAJOR_REGEX} "\\1" GAME_VERSION_MAJOR "${GAME_VERSION_MAJOR}")
  string(REGEX REPLACE ${VERSION_MINOR_REGEX} "\\1" GAME_VERSION_MINOR "${GAME_VERSION_MINOR}")
  string(REGEX REPLACE ${VERSION_PATCH_REGEX} "\\1" GAME_VERSION_PATCH "${GAME_VERSION_PATCH}")
  string(REGEX REPLACE ${VERSION_BUILD_REGEX} "\\1" GAME_VERSION_BUILD "${GAME_VERSION_BUILD}")
  set(${OUT_GAME_VERSION_STRING} "${GAME_VERSION_MAJOR}.${GAME_VERSION_MINOR}.${GAME_VERSION_PATCH}.${GAME_VERSION_BUILD}" PARENT_SCOPE)
  set(${OUT_GAME_VERSION_MAJOR} "${GAME_VERSION_MAJOR}" PARENT_SCOPE)
  set(${OUT_GAME_VERSION_MINOR} "${GAME_VERSION_MINOR}" PARENT_SCOPE)
  set(${OUT_GAME_VERSION_PATCH} "${GAME_VERSION_PATCH}" PARENT_SCOPE)
  set(${OUT_GAME_VERSION_BUILD} "${GAME_VERSION_BUILD}" PARENT_SCOPE)
endfunction()

# Read game years
function(read_game_years OUT_GAME_YEARS)
  set(YEARS_FILE "${CMAKE_CURRENT_SOURCE_DIR}/src/core/global.h")
  set(YEARS_REGEX "#define[ \t]+GAME_YEAR[S]?[ \t]+\"(.+)\"")
  file(STRINGS "${YEARS_FILE}" GAME_YEARS REGEX "${YEARS_REGEX}")
  string(REGEX REPLACE ${YEARS_REGEX} "\\1" GAME_YEARS "${GAME_YEARS}")
  set(${OUT_GAME_YEARS} "${GAME_YEARS}" PARENT_SCOPE)
endfunction()

# Convert a .csv file to a C string
function(csv_to_cstr OUT_CSTR PATH_TO_CSV)
  set(CSTR "")
  file(STRINGS "${CMAKE_CURRENT_SOURCE_DIR}/${PATH_TO_CSV}" CSV_FILE ENCODING UTF-8)
  foreach(LINE IN LISTS CSV_FILE)
    set(CSTR "${CSTR}\n\"${LINE}\\n\"")
  endforeach()
  set(${OUT_CSTR} "${CSTR}" PARENT_SCOPE)
endfunction()

# Generate a file from a template
function(generate_from_template TEMPLATE)
  configure_file("${CMAKE_CURRENT_SOURCE_DIR}/src/misc/${TEMPLATE}.in" "src/misc/${TEMPLATE}" @ONLY)
endfunction()