%feature("docstring") OT::Dirac
R"RAW(Dirac distribution.


Parameters
----------
x : float, sequence of float, :math:`\vect{x} \in \Rset^n`
    The deterministic value.

    Default is 0.0.

Notes
-----
Its probability distribution function is defined as:

.. math::

    \Prob{\vect{X} = \vect{x}} = 1

with :math:`\vect{x} \in \Rset^n`.

Its first moments are:

.. math::
    :nowrap:

    \begin{eqnarray*}
        \Expect{\vect{X}} & = & \vect{x} \\
        \Var{X_i} & = & 0, \quad i = 1, \ldots, n
    \end{eqnarray*}

This distribution can be used to model deterministic parameters.

Examples
--------
Create a distribution:

>>> import openturns as ot
>>> distribution = ot.Dirac([1.0, 2.0, 3.0])

Draw a sample:

>>> sample = distribution.getSample(2)
>>> sample[0] == sample[1]
True)RAW"

// ---------------------------------------------------------------------

%feature("docstring") OT::Dirac::getPoint
"Accessor to the distribution's unique value.

Returns
-------
x : float, :class:`~openturns.Point`
    The deterministic value."

// ---------------------------------------------------------------------

%feature("docstring") OT::Dirac::setPoint
R"RAW(Accessor to the distribution's unique value.

Parameters
----------
x : float, sequence of float, :math:`\vect{x} \in \Rset^n`
    The deterministic value.)RAW"
