% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CFCalendarJulian.R
\docType{class}
\name{CFCalendarJulian}
\alias{CFCalendarJulian}
\title{Julian CF calendar}
\description{
This class represents a Julian calendar of 365 days per year,
with every fourth year being a leap year of 366 days. The months and the
year align with the standard calendar. This calendar is not compatible with
the standard POSIXt calendar.

This calendar starts on 1 January of year 1: 0001-01-01 00:00:00. Any dates
before this will generate an error.
}
\section{Super class}{
\code{\link[CFtime:CFCalendar]{CFtime::CFCalendar}} -> \code{CFCalendarJulian}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-CFCalendarJulian-new}{\code{CFCalendarJulian$new()}}
\item \href{#method-CFCalendarJulian-valid_days}{\code{CFCalendarJulian$valid_days()}}
\item \href{#method-CFCalendarJulian-month_days}{\code{CFCalendarJulian$month_days()}}
\item \href{#method-CFCalendarJulian-leap_year}{\code{CFCalendarJulian$leap_year()}}
\item \href{#method-CFCalendarJulian-date2offset}{\code{CFCalendarJulian$date2offset()}}
\item \href{#method-CFCalendarJulian-offset2date}{\code{CFCalendarJulian$offset2date()}}
\item \href{#method-CFCalendarJulian-clone}{\code{CFCalendarJulian$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="CFtime" data-topic="CFCalendar" data-id="POSIX_compatible"><a href='../../CFtime/html/CFCalendar.html#method-CFCalendar-POSIX_compatible'><code>CFtime::CFCalendar$POSIX_compatible()</code></a></span></li>
<li><span class="pkg-link" data-pkg="CFtime" data-topic="CFCalendar" data-id="is_compatible"><a href='../../CFtime/html/CFCalendar.html#method-CFCalendar-is_compatible'><code>CFtime::CFCalendar$is_compatible()</code></a></span></li>
<li><span class="pkg-link" data-pkg="CFtime" data-topic="CFCalendar" data-id="is_equivalent"><a href='../../CFtime/html/CFCalendar.html#method-CFCalendar-is_equivalent'><code>CFtime::CFCalendar$is_equivalent()</code></a></span></li>
<li><span class="pkg-link" data-pkg="CFtime" data-topic="CFCalendar" data-id="offsets2time"><a href='../../CFtime/html/CFCalendar.html#method-CFCalendar-offsets2time'><code>CFtime::CFCalendar$offsets2time()</code></a></span></li>
<li><span class="pkg-link" data-pkg="CFtime" data-topic="CFCalendar" data-id="parse"><a href='../../CFtime/html/CFCalendar.html#method-CFCalendar-parse'><code>CFtime::CFCalendar$parse()</code></a></span></li>
<li><span class="pkg-link" data-pkg="CFtime" data-topic="CFCalendar" data-id="print"><a href='../../CFtime/html/CFCalendar.html#method-CFCalendar-print'><code>CFtime::CFCalendar$print()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CFCalendarJulian-new"></a>}}
\if{latex}{\out{\hypertarget{method-CFCalendarJulian-new}{}}}
\subsection{Method \code{new()}}{
Create a new CF calendar.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CFCalendarJulian$new(nm, definition)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{nm}}{The name of the calendar. This must be "julian". This argument
is superfluous but maintained to be consistent with the initialization
methods of the parent and sibling classes.}

\item{\code{definition}}{The string that defines the units and the origin, as
per the CF Metadata Conventions.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new instance of this class.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CFCalendarJulian-valid_days"></a>}}
\if{latex}{\out{\hypertarget{method-CFCalendarJulian-valid_days}{}}}
\subsection{Method \code{valid_days()}}{
Indicate which of the supplied dates are valid.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CFCalendarJulian$valid_days(ymd)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ymd}}{\code{data.frame} with dates parsed into their parts in columns
\code{year}, \code{month} and \code{day}. Any other columns are disregarded.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Logical vector with the same length as argument \code{ymd} has rows
with \code{TRUE} for valid days and \code{FALSE} for invalid days, or \code{NA} where
the row in argument \code{ymd} has \code{NA} values.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CFCalendarJulian-month_days"></a>}}
\if{latex}{\out{\hypertarget{method-CFCalendarJulian-month_days}{}}}
\subsection{Method \code{month_days()}}{
Determine the number of days in the month of the calendar.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CFCalendarJulian$month_days(ymd = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ymd}}{\code{data.frame}, optional, with dates parsed into their parts.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A vector indicating the number of days in each month for the
dates supplied as argument \code{ymd}. If no dates are supplied, the number
of days per month for the calendar as a vector of length 12, for a
regular year without a leap day.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CFCalendarJulian-leap_year"></a>}}
\if{latex}{\out{\hypertarget{method-CFCalendarJulian-leap_year}{}}}
\subsection{Method \code{leap_year()}}{
Indicate which years are leap years.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CFCalendarJulian$leap_year(yr)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{yr}}{Integer vector of years to test.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Logical vector with the same length as argument \code{yr}. \code{NA} is
returned where elements in argument \code{yr} are \code{NA}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CFCalendarJulian-date2offset"></a>}}
\if{latex}{\out{\hypertarget{method-CFCalendarJulian-date2offset}{}}}
\subsection{Method \code{date2offset()}}{
Calculate difference in days between a \code{data.frame} of time
parts and the origin.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CFCalendarJulian$date2offset(x)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{\code{data.frame}. Dates to calculate the difference for.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Integer vector of a length equal to the number of rows in
argument \code{x} indicating the number of days between \code{x} and the origin
of the calendar, or \code{NA} for rows in \code{x} with \code{NA} values.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CFCalendarJulian-offset2date"></a>}}
\if{latex}{\out{\hypertarget{method-CFCalendarJulian-offset2date}{}}}
\subsection{Method \code{offset2date()}}{
Calculate date parts from day differences from the origin. This
only deals with days as these are impacted by the calendar.
Hour-minute-second timestamp parts are handled in \link{CFCalendar}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CFCalendarJulian$offset2date(x)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{Integer vector of days to add to the origin.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{data.frame} with columns 'year', 'month' and 'day' and as many
rows as the length of vector \code{x}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CFCalendarJulian-clone"></a>}}
\if{latex}{\out{\hypertarget{method-CFCalendarJulian-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CFCalendarJulian$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
