% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_interactions.R
\name{find_interactions}
\alias{find_interactions}
\title{Find interaction terms from models}
\usage{
find_interactions(
  x,
  component = c("all", "conditional", "zi", "zero_inflated", "dispersion", "instruments"),
  flatten = FALSE
)
}
\arguments{
\item{x}{A fitted model.}

\item{component}{Which type of parameters to return, such as parameters for
the conditional model, the zero-inflated part of the model, the dispersion
term, the instrumental variables or marginal effects be returned? Applies to
models with zero-inflated and/or dispersion formula, or to models with
instrumental variables (so called fixed-effects regressions), or models with
marginal effects (from \strong{mfx}). See details in section \emph{Model Components}
.May be abbreviated. Note that the \emph{conditional} component also refers to the
\emph{count} or \emph{mean} component - names may differ, depending on the modeling
package. There are three convenient shortcuts (not applicable to \emph{all} model
classes):
\itemize{
\item \code{component = "all"} returns all possible parameters.
\item If \code{component = "location"}, location parameters such as \code{conditional},
\code{zero_inflated}, \code{smooth_terms}, or \code{instruments} are returned (everything
that are fixed or random effects - depending on the \code{effects} argument -
but no auxiliary parameters).
\item For \code{component = "distributional"} (or \code{"auxiliary"}), components like
\code{sigma}, \code{dispersion}, \code{beta} or \code{precision} (and other auxiliary
parameters) are returned.
}}

\item{flatten}{Logical, if \code{TRUE}, the values are returned as character
vector, not as list. Duplicated values are removed.}
}
\value{
A list of character vectors that represent the interaction terms.
Depending on \code{component}, the returned list has following
elements (or \code{NULL}, if model has no interaction term):
\itemize{
\item \code{conditional}, interaction terms that belong to the "fixed
effects" terms from the model
\item \code{zero_inflated}, interaction terms that belong to the "fixed
effects" terms from the zero-inflation component of the model
\item \code{instruments}, for fixed-effects regressions like \code{ivreg},
\code{felm} or \code{plm}, interaction terms that belong to the
instrumental variables
}
}
\description{
Returns all lowest to highest order interaction terms from a model.
}
\examples{
data(mtcars)

m <- lm(mpg ~ wt + cyl + vs, data = mtcars)
find_interactions(m)

m <- lm(mpg ~ wt * cyl + vs * hp * gear + carb, data = mtcars)
find_interactions(m)
}
