% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotation.R
\name{add_labels}
\alias{add_labels}
\title{Annotated Violin Plot}
\usage{
add_labels(variable, categories, cex = par()$cex, col = par()$fg, height = 0.5)
}
\arguments{
\item{variable}{continuous variable to to plot on y-axis (numeric or integer)}

\item{categories}{discrete variable to break down groups (factor or string).}

\item{cex}{size of text.}

\item{col}{colour of text}

\item{height}{adjust placement of text.}
}
\description{
Annotate violin plots with custom labels
}
\examples{

# box- vs violin-plot
par(mfrow=c(2,1))
mu<-2
si<-0.6
bimodal<-c(rnorm(1000,-mu,si),rnorm(1000,mu,si))
uniform<-runif(2000,-4,4)
normal<-rnorm(2000,0,3)

# annotate a violin plot
group <- rep(c("bimodal", "uniform", "normal"),
             sapply(list(bimodal, uniform, normal), length))
table(group)
vioplot(bimodal,uniform,normal)
add_labels(c(bimodal,uniform,normal), group, height = -2.5, cex = 0.8)

# boxplots are also supported
boxplot(bimodal,uniform,normal)
add_labels(c(bimodal,uniform,normal), group, height = -2.5, cex = 0.8)


# formula input
data("iris")
vioplot(Sepal.Length~Species, data = iris, main = "Sepal Length",
        col=c("lightgreen", "lightblue", "palevioletred"))
legend("bottomright", legend=c("setosa", "versicolor", "virginica"),
       fill=c("lightgreen", "lightblue", "palevioletred"), cex = 0.6)
add_labels(unlist(iris$Sepal.Length), iris$Species, height = 0, cex = 0.8)

# demo with outliers
iris2 <- iris
iris2 <- rbind(iris2, c(7, 0, 0, 0, "setosa"))
iris2 <- rbind(iris2, c(0, 0, 0, 0, "setosa"))
iris2 <- rbind(iris2, c(9, 0, 0, 0, "versicolor"))
iris2 <- rbind(iris2, c(2, 0, 0, 0, "versicolor"))
iris2 <- rbind(iris2, c(10, 0, 0, 0, "virginica"))
iris2 <- rbind(iris2, c(12, 0, 0, 0, "virginica"))
iris2$Species <- factor(iris2$Species)
iris2$Sepal.Length <- as.numeric(iris2$Sepal.Length)

vioplot(Sepal.Length~Species, data = iris2, main = "Sepal Length",
        col=c("lightgreen", "lightblue", "palevioletred"))
add_outliers(unlist(iris2$Sepal.Length), iris2$Species,
             col = "grey50", fill = "red", bars = "grey85")
legend("bottomright", legend=c("setosa", "versicolor", "virginica"),
       fill=c("lightgreen", "lightblue", "palevioletred"), cex = 0.6)
add_labels(unlist(iris2$Sepal.Length), iris2$Species, height = 0, cex = 0.8)

}
\keyword{annotation.}
\keyword{graphics}
\keyword{plot}
\keyword{violin}
