// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2025 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from GatewaySensorManager.idl.

using System;
using System.Linq;
using LightJson;
using Com.Raritan.Idl;
using Com.Raritan.JsonRpc;
using Com.Raritan.Util;

#pragma warning disable 0108, 0219, 0414, 1591

namespace Com.Raritan.Idl.peripheral {
  public class GatewaySensorManager : ObjectProxy {

    static public readonly new TypeInfo typeInfo = new TypeInfo("peripheral.GatewaySensorManager:1.0.0", null);

    public GatewaySensorManager(Agent agent, string rid, TypeInfo ti) : base(agent, rid, ti) {}
    public GatewaySensorManager(Agent agent, string rid) : this(agent, rid, typeInfo) {}

    public static new GatewaySensorManager StaticCast(ObjectProxy proxy) {
      return proxy == null ? null : new GatewaySensorManager(proxy.Agent, proxy.Rid, proxy.StaticTypeInfo);
    }

    public class SensorClass : ValueObject {
      static public readonly new TypeInfo typeInfo = new TypeInfo("peripheral.GatewaySensorManager.SensorClass:1.0.0", ValueObject.typeInfo);

      public string classId = "";
    }

    public class NumericSensorClass : Com.Raritan.Idl.peripheral.GatewaySensorManager.SensorClass {
      static public readonly new TypeInfo typeInfo = new TypeInfo("peripheral.GatewaySensorManager.NumericSensorClass:1.0.0", Com.Raritan.Idl.peripheral.GatewaySensorManager.SensorClass.typeInfo);

      public Com.Raritan.Idl.sensors.NumericSensor_4_0_6.MetaData metadata = new Com.Raritan.Idl.sensors.NumericSensor_4_0_6.MetaData();
      public Com.Raritan.Idl.sensors.NumericSensor_4_0_6.Thresholds defaultThresholds = new Com.Raritan.Idl.sensors.NumericSensor_4_0_6.Thresholds();
      public bool preferCommonThresholds = false;
    }

    public class StateSensorClass : Com.Raritan.Idl.peripheral.GatewaySensorManager.SensorClass {
      static public readonly new TypeInfo typeInfo = new TypeInfo("peripheral.GatewaySensorManager.StateSensorClass:1.0.0", Com.Raritan.Idl.peripheral.GatewaySensorManager.SensorClass.typeInfo);

      public Com.Raritan.Idl.sensors.Sensor_4_0_5.TypeSpec type = new Com.Raritan.Idl.sensors.Sensor_4_0_5.TypeSpec();
    }

    public class SwitchSensorClass : Com.Raritan.Idl.peripheral.GatewaySensorManager.StateSensorClass {
      static public readonly new TypeInfo typeInfo = new TypeInfo("peripheral.GatewaySensorManager.SwitchSensorClass:1.0.0", Com.Raritan.Idl.peripheral.GatewaySensorManager.StateSensorClass.typeInfo);

    }

    public class RemoteDevice : ValueObject {
      static public readonly new TypeInfo typeInfo = new TypeInfo("peripheral.GatewaySensorManager.RemoteDevice:1.0.0", ValueObject.typeInfo);

      public string deviceId = "";
      public bool disabled = false;
      public string name = "";
      public int timeoutMs = 0;
      public int retry = 0;
    }

    public const int MODBUS_VENDOR_NAME = 0;

    public const int MODBUS_PRODUCT_CODE = 1;

    public const int MODBUS_REVISION = 2;

    public const int MODBUS_VENDOR_URL = 3;

    public const int MODBUS_PRODUCT_NAME = 5;

    public const int MODBUS_MODEL_NAME = 6;

    public const int MODBUS_APP_NAME = 7;

    public class RemoteModbusDevice : Com.Raritan.Idl.peripheral.GatewaySensorManager.RemoteDevice {
      static public readonly new TypeInfo typeInfo = new TypeInfo("peripheral.GatewaySensorManager.RemoteModbusDevice:1.0.0", Com.Raritan.Idl.peripheral.GatewaySensorManager.RemoteDevice.typeInfo);

      public System.Collections.Generic.IDictionary<int, string> detectionIdentifiers = new System.Collections.Generic.Dictionary<int, string>();
      public int unitId = 0;
    }

    public class RemoteModbusRTUDevice : Com.Raritan.Idl.peripheral.GatewaySensorManager.RemoteModbusDevice {
      static public readonly new TypeInfo typeInfo = new TypeInfo("peripheral.GatewaySensorManager.RemoteModbusRTUDevice:1.0.0", Com.Raritan.Idl.peripheral.GatewaySensorManager.RemoteModbusDevice.typeInfo);

      public string busInterface = "";
      public Com.Raritan.Idl.peripheral.ModbusCfg.SerialSettings busSettings = new Com.Raritan.Idl.peripheral.ModbusCfg.SerialSettings();
      public int interframeDelayDeciChars = 0;
    }

    public class RemoteModbusTCPDevice : Com.Raritan.Idl.peripheral.GatewaySensorManager.RemoteModbusDevice {
      static public readonly new TypeInfo typeInfo = new TypeInfo("peripheral.GatewaySensorManager.RemoteModbusTCPDevice:1.0.0", Com.Raritan.Idl.peripheral.GatewaySensorManager.RemoteModbusDevice.typeInfo);

      public string ipAddress = "";
      public int tcpPort = 0;
    }

    public enum EncodingType {
      BOOL,
      INT,
      UINT,
      IEEE754,
    }

    public enum Interpretation {
      DEFAULT,
      REJECT_DEVICE,
      REJECT_SENSOR,
      IGNORE,
      UNAVAILABLE,
      NUMERIC_INVALID,
      STATE_ON,
      STATE_OFF,
    }

    public class InterpretationRule : ValueObject {
      static public readonly new TypeInfo typeInfo = new TypeInfo("peripheral.GatewaySensorManager.InterpretationRule:1.0.0", ValueObject.typeInfo);

      public Com.Raritan.Idl.peripheral.GatewaySensorManager.Interpretation interpretation = Com.Raritan.Idl.peripheral.GatewaySensorManager.Interpretation.DEFAULT;
      public int ignoreTimeout = 0;
    }

    public class InterpretationRuleInvertable : Com.Raritan.Idl.peripheral.GatewaySensorManager.InterpretationRule {
      static public readonly new TypeInfo typeInfo = new TypeInfo("peripheral.GatewaySensorManager.InterpretationRuleInvertable:1.0.0", Com.Raritan.Idl.peripheral.GatewaySensorManager.InterpretationRule.typeInfo);

      public bool invertCondition = false;
    }

    public class InterpretationRuleModbusException : Com.Raritan.Idl.peripheral.GatewaySensorManager.InterpretationRuleInvertable {
      static public readonly new TypeInfo typeInfo = new TypeInfo("peripheral.GatewaySensorManager.InterpretationRuleModbusException:1.0.0", Com.Raritan.Idl.peripheral.GatewaySensorManager.InterpretationRuleInvertable.typeInfo);

      public System.Collections.Generic.IEnumerable<int> exceptions = new System.Collections.Generic.List<int>();
    }

    public class InterpretationRuleModbusSystemError : Com.Raritan.Idl.peripheral.GatewaySensorManager.InterpretationRuleInvertable {
      static public readonly new TypeInfo typeInfo = new TypeInfo("peripheral.GatewaySensorManager.InterpretationRuleModbusSystemError:1.0.0", Com.Raritan.Idl.peripheral.GatewaySensorManager.InterpretationRuleInvertable.typeInfo);

      public System.Collections.Generic.IEnumerable<int> errnos = new System.Collections.Generic.List<int>();
    }

    public class InterpretationRuleModbusSpecificError : Com.Raritan.Idl.peripheral.GatewaySensorManager.InterpretationRuleInvertable {
      static public readonly new TypeInfo typeInfo = new TypeInfo("peripheral.GatewaySensorManager.InterpretationRuleModbusSpecificError:1.0.0", Com.Raritan.Idl.peripheral.GatewaySensorManager.InterpretationRuleInvertable.typeInfo);

      public System.Collections.Generic.IEnumerable<Com.Raritan.Idl.peripheral.ModbusCfg.SpecificModbusErrors> errors = new System.Collections.Generic.List<Com.Raritan.Idl.peripheral.ModbusCfg.SpecificModbusErrors>();
    }

    public class InterpretationRuleRAW : Com.Raritan.Idl.peripheral.GatewaySensorManager.InterpretationRuleInvertable {
      static public readonly new TypeInfo typeInfo = new TypeInfo("peripheral.GatewaySensorManager.InterpretationRuleRAW:1.0.0", Com.Raritan.Idl.peripheral.GatewaySensorManager.InterpretationRuleInvertable.typeInfo);

      public long value = 0;
      public long mask = 0;
    }

    public class InterpretationRuleRangeRAW : Com.Raritan.Idl.peripheral.GatewaySensorManager.InterpretationRuleInvertable {
      static public readonly new TypeInfo typeInfo = new TypeInfo("peripheral.GatewaySensorManager.InterpretationRuleRangeRAW:1.0.0", Com.Raritan.Idl.peripheral.GatewaySensorManager.InterpretationRuleInvertable.typeInfo);

      public long min = 0;
      public long max = 0;
      public long mask = 0;
    }

    public class InterpretationRuleIEEE754INF : Com.Raritan.Idl.peripheral.GatewaySensorManager.InterpretationRuleInvertable {
      static public readonly new TypeInfo typeInfo = new TypeInfo("peripheral.GatewaySensorManager.InterpretationRuleIEEE754INF:1.0.0", Com.Raritan.Idl.peripheral.GatewaySensorManager.InterpretationRuleInvertable.typeInfo);

    }

    public class InterpretationRuleIEEE754NAN : Com.Raritan.Idl.peripheral.GatewaySensorManager.InterpretationRuleInvertable {
      static public readonly new TypeInfo typeInfo = new TypeInfo("peripheral.GatewaySensorManager.InterpretationRuleIEEE754NAN:1.0.0", Com.Raritan.Idl.peripheral.GatewaySensorManager.InterpretationRuleInvertable.typeInfo);

    }

    public class InterpretationRuleCatchAll : Com.Raritan.Idl.peripheral.GatewaySensorManager.InterpretationRule {
      static public readonly new TypeInfo typeInfo = new TypeInfo("peripheral.GatewaySensorManager.InterpretationRuleCatchAll:1.0.0", Com.Raritan.Idl.peripheral.GatewaySensorManager.InterpretationRule.typeInfo);

    }

    public class ValueEncoding : ValueObject {
      static public readonly new TypeInfo typeInfo = new TypeInfo("peripheral.GatewaySensorManager.ValueEncoding:1.0.0", ValueObject.typeInfo);

      public string encodingId = "";
      public Com.Raritan.Idl.peripheral.GatewaySensorManager.EncodingType type = Com.Raritan.Idl.peripheral.GatewaySensorManager.EncodingType.BOOL;
      public bool invertState = false;
      public System.Collections.Generic.IEnumerable<Com.Raritan.Idl.peripheral.GatewaySensorManager.InterpretationRule> interpretationRules = new System.Collections.Generic.List<Com.Raritan.Idl.peripheral.GatewaySensorManager.InterpretationRule>();
    }

    public class NumericValueEncoding : Com.Raritan.Idl.peripheral.GatewaySensorManager.ValueEncoding {
      static public readonly new TypeInfo typeInfo = new TypeInfo("peripheral.GatewaySensorManager.NumericValueEncoding:1.0.0", Com.Raritan.Idl.peripheral.GatewaySensorManager.ValueEncoding.typeInfo);

      public float scalingFactor = 0.0f;
      public float offset = 0.0f;
    }

    public class ModbusValueEncodingBit : Com.Raritan.Idl.peripheral.GatewaySensorManager.ValueEncoding {
      static public readonly new TypeInfo typeInfo = new TypeInfo("peripheral.GatewaySensorManager.ModbusValueEncodingBit:1.0.0", Com.Raritan.Idl.peripheral.GatewaySensorManager.ValueEncoding.typeInfo);

    }

    public class ModbusValueEncoding8 : Com.Raritan.Idl.peripheral.GatewaySensorManager.NumericValueEncoding {
      static public readonly new TypeInfo typeInfo = new TypeInfo("peripheral.GatewaySensorManager.ModbusValueEncoding8:1.0.0", Com.Raritan.Idl.peripheral.GatewaySensorManager.NumericValueEncoding.typeInfo);

      public bool byteSwap = false;
      public long mask = 0;
    }

    public class ModbusValueEncoding16 : Com.Raritan.Idl.peripheral.GatewaySensorManager.ModbusValueEncoding8 {
      static public readonly new TypeInfo typeInfo = new TypeInfo("peripheral.GatewaySensorManager.ModbusValueEncoding16:1.0.0", Com.Raritan.Idl.peripheral.GatewaySensorManager.ModbusValueEncoding8.typeInfo);

    }

    public enum ModbusEndianness {
      MODBUS_BIG_ENDIAN,
      MODBUS_LITTLE_ENDIAN,
    }

    public class ModbusValueEncoding32 : Com.Raritan.Idl.peripheral.GatewaySensorManager.ModbusValueEncoding16 {
      static public readonly new TypeInfo typeInfo = new TypeInfo("peripheral.GatewaySensorManager.ModbusValueEncoding32:1.0.0", Com.Raritan.Idl.peripheral.GatewaySensorManager.ModbusValueEncoding16.typeInfo);

      public Com.Raritan.Idl.peripheral.GatewaySensorManager.ModbusEndianness endianness = Com.Raritan.Idl.peripheral.GatewaySensorManager.ModbusEndianness.MODBUS_BIG_ENDIAN;
    }

    public class ModbusValueEncoding64 : Com.Raritan.Idl.peripheral.GatewaySensorManager.ModbusValueEncoding32 {
      static public readonly new TypeInfo typeInfo = new TypeInfo("peripheral.GatewaySensorManager.ModbusValueEncoding64:1.0.0", Com.Raritan.Idl.peripheral.GatewaySensorManager.ModbusValueEncoding32.typeInfo);

    }

    public class Sensor : ValueObject {
      static public readonly new TypeInfo typeInfo = new TypeInfo("peripheral.GatewaySensorManager.Sensor:1.0.0", ValueObject.typeInfo);

      public string sensorId = "";
      public bool disabled = false;
      public string deviceId = "";
      public string classId = "";
      public string encodingId = "";
      public string defaultName = "";
    }

    public class ModbusSensor : Com.Raritan.Idl.peripheral.GatewaySensorManager.Sensor {
      static public readonly new TypeInfo typeInfo = new TypeInfo("peripheral.GatewaySensorManager.ModbusSensor:1.0.0", Com.Raritan.Idl.peripheral.GatewaySensorManager.Sensor.typeInfo);

      public Com.Raritan.Idl.peripheral.ModbusCfg.ModbusFunction function = Com.Raritan.Idl.peripheral.ModbusCfg.ModbusFunction.COIL;
      public int regAddr = 0;
    }

    public class ConfigurationPackage : ICloneable {
      public object Clone() {
        ConfigurationPackage copy = new ConfigurationPackage();
        copy.disabled = this.disabled;
        copy.name = this.name;
        copy.classes = this.classes;
        copy.devices = this.devices;
        copy.encodings = this.encodings;
        copy.sensors = this.sensors;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["disabled"] = this.disabled;
        json["name"] = this.name;
        json["classes"] = new JsonArray(this.classes.Select(
          _value => (JsonValue)(ValueObjectCodec.Encode(_value))));
        json["devices"] = new JsonArray(this.devices.Select(
          _value => (JsonValue)(ValueObjectCodec.Encode(_value))));
        json["encodings"] = new JsonArray(this.encodings.Select(
          _value => (JsonValue)(ValueObjectCodec.Encode(_value))));
        json["sensors"] = new JsonArray(this.sensors.Select(
          _value => (JsonValue)(ValueObjectCodec.Encode(_value))));
        return json;
      }

      public static ConfigurationPackage Decode(LightJson.JsonObject json, Agent agent) {
        ConfigurationPackage inst = new ConfigurationPackage();
        inst.disabled = (bool)json["disabled"];
        inst.name = (string)json["name"];
        inst.classes = new System.Collections.Generic.List<Com.Raritan.Idl.peripheral.GatewaySensorManager.SensorClass>(json["classes"].AsJsonArray.Select(
          _value => ((Com.Raritan.Idl.peripheral.GatewaySensorManager.SensorClass)ValueObjectCodec.DecodeAs(_value, agent, Com.Raritan.Idl.peripheral.GatewaySensorManager.SensorClass.typeInfo))));
        inst.devices = new System.Collections.Generic.List<Com.Raritan.Idl.peripheral.GatewaySensorManager.RemoteDevice>(json["devices"].AsJsonArray.Select(
          _value => ((Com.Raritan.Idl.peripheral.GatewaySensorManager.RemoteDevice)ValueObjectCodec.DecodeAs(_value, agent, Com.Raritan.Idl.peripheral.GatewaySensorManager.RemoteDevice.typeInfo))));
        inst.encodings = new System.Collections.Generic.List<Com.Raritan.Idl.peripheral.GatewaySensorManager.ValueEncoding>(json["encodings"].AsJsonArray.Select(
          _value => ((Com.Raritan.Idl.peripheral.GatewaySensorManager.ValueEncoding)ValueObjectCodec.DecodeAs(_value, agent, Com.Raritan.Idl.peripheral.GatewaySensorManager.ValueEncoding.typeInfo))));
        inst.sensors = new System.Collections.Generic.List<Com.Raritan.Idl.peripheral.GatewaySensorManager.Sensor>(json["sensors"].AsJsonArray.Select(
          _value => ((Com.Raritan.Idl.peripheral.GatewaySensorManager.Sensor)ValueObjectCodec.DecodeAs(_value, agent, Com.Raritan.Idl.peripheral.GatewaySensorManager.Sensor.typeInfo))));
        return inst;
      }

      public bool disabled = false;
      public string name = "";
      public System.Collections.Generic.IEnumerable<Com.Raritan.Idl.peripheral.GatewaySensorManager.SensorClass> classes = new System.Collections.Generic.List<Com.Raritan.Idl.peripheral.GatewaySensorManager.SensorClass>();
      public System.Collections.Generic.IEnumerable<Com.Raritan.Idl.peripheral.GatewaySensorManager.RemoteDevice> devices = new System.Collections.Generic.List<Com.Raritan.Idl.peripheral.GatewaySensorManager.RemoteDevice>();
      public System.Collections.Generic.IEnumerable<Com.Raritan.Idl.peripheral.GatewaySensorManager.ValueEncoding> encodings = new System.Collections.Generic.List<Com.Raritan.Idl.peripheral.GatewaySensorManager.ValueEncoding>();
      public System.Collections.Generic.IEnumerable<Com.Raritan.Idl.peripheral.GatewaySensorManager.Sensor> sensors = new System.Collections.Generic.List<Com.Raritan.Idl.peripheral.GatewaySensorManager.Sensor>();
    }

    public class GetConfigurationResult {
      public System.Collections.Generic.IDictionary<string, Com.Raritan.Idl.peripheral.GatewaySensorManager.ConfigurationPackage> _ret_;
    }

    public GetConfigurationResult getConfiguration() {
      JsonObject _parameters = null;
      var _result = RpcCall("getConfiguration", _parameters);
      var _ret = new GetConfigurationResult();
      _ret._ret_ = DictionaryHelper.Create(_result["_ret_"].AsJsonArray.Select(
        _value => new System.Collections.Generic.KeyValuePair<string, Com.Raritan.Idl.peripheral.GatewaySensorManager.ConfigurationPackage>(_value["key"], Com.Raritan.Idl.peripheral.GatewaySensorManager.ConfigurationPackage.Decode(_value["value"], agent))));
      return _ret;
    }

    public AsyncRequest getConfiguration(AsyncRpcResponse<GetConfigurationResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getConfiguration(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getConfiguration(AsyncRpcResponse<GetConfigurationResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getConfiguration", _parameters,
        _result => {
          try {
            var _ret = new GetConfigurationResult();
            _ret._ret_ = DictionaryHelper.Create(_result["_ret_"].AsJsonArray.Select(
              _value => new System.Collections.Generic.KeyValuePair<string, Com.Raritan.Idl.peripheral.GatewaySensorManager.ConfigurationPackage>(_value["key"], Com.Raritan.Idl.peripheral.GatewaySensorManager.ConfigurationPackage.Decode(_value["value"], agent))));
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public const int ERR_CONFIG_INCONSISTENT = 1;

    public const int ERR_CONFIG_STORAGE_FAILED = 2;

    public class SetConfigurationResult {
      public int _ret_;
    }

    public SetConfigurationResult setConfiguration(System.Collections.Generic.IDictionary<string, Com.Raritan.Idl.peripheral.GatewaySensorManager.ConfigurationPackage> cfg) {
      var _parameters = new LightJson.JsonObject();
      _parameters["cfg"] = new JsonArray(cfg.Select(_entry => (JsonValue) new JsonObject(new System.Collections.Generic.List<System.Collections.Generic.KeyValuePair<string, LightJson.JsonValue>> {
        new System.Collections.Generic.KeyValuePair<string, JsonValue>("key", _entry.Key),
        new System.Collections.Generic.KeyValuePair<string, JsonValue>("value", _entry.Value.Encode())
      })));

      var _result = RpcCall("setConfiguration", _parameters);
      var _ret = new SetConfigurationResult();
      _ret._ret_ = (int)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest setConfiguration(System.Collections.Generic.IDictionary<string, Com.Raritan.Idl.peripheral.GatewaySensorManager.ConfigurationPackage> cfg, AsyncRpcResponse<SetConfigurationResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return setConfiguration(cfg, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest setConfiguration(System.Collections.Generic.IDictionary<string, Com.Raritan.Idl.peripheral.GatewaySensorManager.ConfigurationPackage> cfg, AsyncRpcResponse<SetConfigurationResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["cfg"] = new JsonArray(cfg.Select(_entry => (JsonValue) new JsonObject(new System.Collections.Generic.List<System.Collections.Generic.KeyValuePair<string, LightJson.JsonValue>> {
          new System.Collections.Generic.KeyValuePair<string, JsonValue>("key", _entry.Key),
          new System.Collections.Generic.KeyValuePair<string, JsonValue>("value", _entry.Value.Encode())
        })));
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("setConfiguration", _parameters,
        _result => {
          try {
            var _ret = new SetConfigurationResult();
            _ret._ret_ = (int)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class ConfigurationChangedEvent : Com.Raritan.Idl.idl.Event {
      static public readonly new TypeInfo typeInfo = new TypeInfo("peripheral.GatewaySensorManager.ConfigurationChangedEvent:1.0.0", Com.Raritan.Idl.idl.Event.typeInfo);

      public System.Collections.Generic.IDictionary<string, Com.Raritan.Idl.peripheral.GatewaySensorManager.ConfigurationPackage> configuration = new System.Collections.Generic.Dictionary<string, Com.Raritan.Idl.peripheral.GatewaySensorManager.ConfigurationPackage>();
    }

    public class FeedbackObject : ICloneable {
      public object Clone() {
        FeedbackObject copy = new FeedbackObject();
        copy.key = this.key;
        copy.value = this.value;
        copy.stateTansitionTo = this.stateTansitionTo;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["key"] = this.key;
        json["value"] = this.value;
        json["stateTansitionTo"] = (int)this.stateTansitionTo;
        return json;
      }

      public static FeedbackObject Decode(LightJson.JsonObject json, Agent agent) {
        FeedbackObject inst = new FeedbackObject();
        inst.key = (string)json["key"];
        inst.value = (string)json["value"];
        inst.stateTansitionTo = (Com.Raritan.Idl.peripheral.GatewaySensorManager.FeedbackObject.FeedbackState)(int)json["stateTansitionTo"];
        return inst;
      }


      public enum FeedbackState {
        UNSPECIFIED,
        INTENTIONALLY_UNUSED,
        FAILED_PRECONDITIONS_UNUSED,
        FAILED,
        GOOD,
      }
      public string key = "";
      public string value = "";
      public Com.Raritan.Idl.peripheral.GatewaySensorManager.FeedbackObject.FeedbackState stateTansitionTo = Com.Raritan.Idl.peripheral.GatewaySensorManager.FeedbackObject.FeedbackState.UNSPECIFIED;
    }

    public class Feedback : ValueObject {
      static public readonly new TypeInfo typeInfo = new TypeInfo("peripheral.GatewaySensorManager.Feedback:1.0.0", ValueObject.typeInfo);

      public Com.Raritan.Idl.peripheral.GatewaySensorManager.FeedbackObject.FeedbackState currentState = Com.Raritan.Idl.peripheral.GatewaySensorManager.FeedbackObject.FeedbackState.UNSPECIFIED;
      public System.Collections.Generic.IEnumerable<Com.Raritan.Idl.peripheral.GatewaySensorManager.FeedbackObject> infos = new System.Collections.Generic.List<Com.Raritan.Idl.peripheral.GatewaySensorManager.FeedbackObject>();
    }

    public class DeviceFeedback : Com.Raritan.Idl.peripheral.GatewaySensorManager.Feedback {
      static public readonly new TypeInfo typeInfo = new TypeInfo("peripheral.GatewaySensorManager.DeviceFeedback:1.0.0", Com.Raritan.Idl.peripheral.GatewaySensorManager.Feedback.typeInfo);

      public string packageId = "";
      public string deviceId = "";
    }

    public class SensorFeedback : Com.Raritan.Idl.peripheral.GatewaySensorManager.Feedback {
      static public readonly new TypeInfo typeInfo = new TypeInfo("peripheral.GatewaySensorManager.SensorFeedback:1.0.0", Com.Raritan.Idl.peripheral.GatewaySensorManager.Feedback.typeInfo);

      public string packageId = "";
      public string deviceId = "";
      public string sensorId = "";
    }

    public class GetFeedbackResult {
      public System.Collections.Generic.IEnumerable<Com.Raritan.Idl.peripheral.GatewaySensorManager.Feedback> _ret_;
    }

    public GetFeedbackResult getFeedback() {
      JsonObject _parameters = null;
      var _result = RpcCall("getFeedback", _parameters);
      var _ret = new GetFeedbackResult();
      _ret._ret_ = new System.Collections.Generic.List<Com.Raritan.Idl.peripheral.GatewaySensorManager.Feedback>(_result["_ret_"].AsJsonArray.Select(
        _value => ((Com.Raritan.Idl.peripheral.GatewaySensorManager.Feedback)ValueObjectCodec.DecodeAs(_value, agent, Com.Raritan.Idl.peripheral.GatewaySensorManager.Feedback.typeInfo))));
      return _ret;
    }

    public AsyncRequest getFeedback(AsyncRpcResponse<GetFeedbackResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getFeedback(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getFeedback(AsyncRpcResponse<GetFeedbackResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getFeedback", _parameters,
        _result => {
          try {
            var _ret = new GetFeedbackResult();
            _ret._ret_ = new System.Collections.Generic.List<Com.Raritan.Idl.peripheral.GatewaySensorManager.Feedback>(_result["_ret_"].AsJsonArray.Select(
              _value => ((Com.Raritan.Idl.peripheral.GatewaySensorManager.Feedback)ValueObjectCodec.DecodeAs(_value, agent, Com.Raritan.Idl.peripheral.GatewaySensorManager.Feedback.typeInfo))));
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class FeedbackChangedEvent : Com.Raritan.Idl.idl.Event {
      static public readonly new TypeInfo typeInfo = new TypeInfo("peripheral.GatewaySensorManager.FeedbackChangedEvent:1.0.0", Com.Raritan.Idl.idl.Event.typeInfo);

      public System.Collections.Generic.IEnumerable<Com.Raritan.Idl.peripheral.GatewaySensorManager.Feedback> feedback = new System.Collections.Generic.List<Com.Raritan.Idl.peripheral.GatewaySensorManager.Feedback>();
    }

  }
}
