// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// ModelsProvider models provider
//
// swagger:model models.Provider
type ModelsProvider struct {

	// URL of the API endpoints
	APIURI string `json:"api_uri,omitempty"`

	// oldest supported api version
	// deprecated: kept for backwards compatibility. Replaced by api_versions.
	APIVersion string `json:"api_version,omitempty"`

	// all API versions the provider supports
	APIVersions []string `json:"api_versions"`

	// Flag indicating whether to show regularly a donation reminder
	AskForDonations bool `json:"ask_for_donations,omitempty"`

	// fingerprint of CA cert used to setup TLS sessions during VPN setup (and up to API version 3 for API communication)
	// deprecated: kept for backwards compatibility
	CaCertFingerprint string `json:"ca_cert_fingerprint,omitempty"`

	// URL to fetch the CA cert used to setup TLS sessions during VPN setup (and up to API version 3 for API communication)
	// deprecated: kept for backwards compatibility
	CaCertURI string `json:"ca_cert_uri,omitempty"`

	// URL of a service that returns a country code for an ip address. If empty,
	// OONI backend is used
	CountryCodeLookupURL string `json:"country_code_lookup_url,omitempty"`

	// Default language this provider uses to show infos and provider messages
	DefaultLanguage string `json:"default_language,omitempty"`

	// Short description about the provider
	Description map[string]string `json:"description,omitempty"`

	// Domain of the provider
	Domain string `json:"domain,omitempty"`

	// Number of days until a donation reminder reappears
	DonatePeriod string `json:"donate_period,omitempty"`

	// URL to the donation website
	DonateURL string `json:"donate_url,omitempty"`

	// URL to general provider website
	InfoURL string `json:"info_url,omitempty"`

	// Languages the provider supports to show infos and provider messages
	Languages []string `json:"languages"`

	// URL to the message of the day service
	MotdURL string `json:"motd_url,omitempty"`

	// Provider name
	Name map[string]string `json:"name,omitempty"`

	// Operational properties which describe how the provider offers the service
	Service struct {
		ModelsProviderService
	} `json:"service,omitempty"`

	// List of services the provider offers, currently only openvpn
	Services []string `json:"services"`

	// list of STUN servers (format: ip/hostname:port) servers to get current ip address
	// can consist of self hosted STUN servers, public ones or a combination of both.
	// GeolocationLookup is only done when the list of STUNServers is not empty
	StunServers []string `json:"stun_servers"`

	// URL to Terms of Service website
	TosURL string `json:"tos_url,omitempty"`
}

// Validate validates this models provider
func (m *ModelsProvider) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateService(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ModelsProvider) validateService(formats strfmt.Registry) error {
	if swag.IsZero(m.Service) { // not required
		return nil
	}

	return nil
}

// ContextValidate validate this models provider based on the context it is used
func (m *ModelsProvider) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateService(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ModelsProvider) contextValidateService(ctx context.Context, formats strfmt.Registry) error {

	return nil
}

// MarshalBinary interface implementation
func (m *ModelsProvider) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ModelsProvider) UnmarshalBinary(b []byte) error {
	var res ModelsProvider
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
