# 2021-09-01 Triage Log

A very busy week with relatively even amounts of regressions and improvements (albeit with improvements outweighing regressions). The largest win was the use of profile-guided optimization (PGO) builds on x86_64 linux builds which brings fairly large improvements in real-world crates. There were 2 regressions that caused fairly large (~3.5%) regressions in real-world crates which need to be investigated.

Triage done by **@rylev**.
Revision range: [33fdb797f59421c7bbecaa4588ed5d7a31a9494a..fe37929e4cba2c5c21e6805805769630c736bc3d](https://perf.rust-lang.org/?start=33fdb797f59421c7bbecaa4588ed5d7a31a9494a&end=fe37929e4cba2c5c21e6805805769630c736bc3d&absolute=false&stat=instructions%3Au)

5 Regressions, 4 Improvements, 5 Mixed; 0 of them in rollups
56 comparisons made in total

#### Regressions

Get piece unchecked in `write` [#83302](https://github.com/rust-lang/rust/issues/83302)
- Large regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=a49e38e672c60da788360e088f00ad12353e3913&end=de42550d0ac525f44ec79300a1cb349ade181c1a&stat=instructions:u) (up to 3.5% on `incr-patched: b9b3e592dd cherry picked` builds of `style-servo`)
- This is a largely a change in std lib code, and we don't really have a good process for dealing with how std lib changes effect performance.
- This seems to be primarily affecting debug and check builds, but there doesn't seem to be a query that is clearly to blame here. Given the motivation of this PR is primarily performance, I think it deserves a closer look.
- Added a comment on the PR [here](https://github.com/rust-lang/rust/pull/83302#issuecomment-910058149).


Warn about unreachable code following an expression with an uninhabited type [#85556](https://github.com/rust-lang/rust/issues/85556)
- Very large regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=de42550d0ac525f44ec79300a1cb349ade181c1a&end=5ca596f486707ac1362edad717ad0e9f5b71d0a3&stat=instructions:u) (up to 9.0% on `incr-unchanged` builds of `webrender-wrench`)
- This regression seems to only be happening in one benchmark `webrender-wrench` and is consistently affecting the `extern_crate`, 
`incr_comp_intern_dep_graph_node`, and `metadata_decode_entry_extern_crate` queries. 
- Given the nature of the change which only impacts liveness checking, I'm unsure why this might be the case. However, given that the regressions are fairly large, I do think additional investigation is worth looking into.
- Left a comment on the PR [here](https://github.com/rust-lang/rust/pull/85556#issuecomment-910064890).


lazily "compute" anon const default substs [#87280](https://github.com/rust-lang/rust/issues/87280)
- Large regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=ad02dc46badee510bd3a2c093edf80fcaade91b1&end=517c28e421b0d601c6f8eb07ea6aafb8e16975ad&stat=instructions:u) (up to 4.8% on `full` builds of `ctfe-stress-4`)
- This is an important change for const generics, and the const generics team discussed whether the performance hit seemed worth it, and they reached this conclusion [that it was](https://github.com/rust-lang/rust/pull/87280#issuecomment-906288243).

Treat types in unnormalized function signatures as well-formed [#88312](https://github.com/rust-lang/rust/issues/88312)
- Large regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=66acdee9f7822ff2427f2b967e537215421eeb16&end=59ce76548484806ac4970c57c0bb6ad9e53b80f6&stat=instructions:u) (up to 3.4% on `full` builds of `serde`)
- This regression affects many real world crates in significant ways. The query affected by this seems to be additional calls to `implied_outlives_bounds` which I believe would be impacted by this change. 
- Left a comment on the PR [here](https://github.com/rust-lang/rust/pull/88312#issuecomment-910073037).


build llvm libunwind.a in rustbuild [#85600](https://github.com/rust-lang/rust/issues/85600)
- Small regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=42a2a53ec13b0e6e915acd09a2a9a963e5fa3b92&end=926f069950d7211a87fbd81778b420de420daad7&stat=instructions:u) (up to 0.3% on `incr-patched: println` builds of `regression-31157`)
- The performance change is rather small, but quite surprising since the change is just in how linunwind is being build which (presumably?) should mean that this is a perf noop. 
- Left a comment on the PR [here](https://github.com/rust-lang/rust/pull/85600#issuecomment-910075406), but noted that it didn't seem strictly necessary to investigate due to the rather small impact of the performance change.


#### Improvements

PGO for LLVM builds on x86_64-unknown-linux-gnu in CI [#88069](https://github.com/rust-lang/rust/issues/88069)
- Very large improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=0afc20860eb98a29d9bbeea80f2acc5be38c6bf3&end=c4be230b4a30eb74e3a3908455731ebc2f731d3d&stat=instructions:u) (up to -6.4% on `incr-patched: b9b3e592dd cherry picked` builds of `style-servo`)


Morph `layout_raw` query into `layout_of`. [#88308](https://github.com/rust-lang/rust/issues/88308)
- Very large improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=20997f6ad81721542e9ef97bb2f58190903a34d8&end=4b9f4b221b92193c7e95b1beb502c6eb32c3b613&stat=instructions:u) (up to -12.2% on `incr-full` builds of `ctfe-stress-4`)


Introduce `~const` [#88328](https://github.com/rust-lang/rust/issues/88328)
- Moderate improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=dfd84729d6b7060edcb66694e6e44aae9e2ac57d&end=ac50a53359328a5d7f2f558833e63d59d372e4f7&stat=instructions:u) (up to -0.8% on `incr-unchanged` builds of `derive`)


Cow'ify some pprust methods [#88262](https://github.com/rust-lang/rust/issues/88262)
- Moderate improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=daa4dc997c777676b0f0e48d0311cc5e7bde5f87&end=ae0b03bc6b4e1544f43b9a8053bdb0f0ed4a19e1&stat=instructions:u) (up to -0.6% on `incr-patched: println` builds of `html5ever`)


Don't use `guess_head_span` in `predicates_of` for foreign span [#88414](https://github.com/rust-lang/rust/issues/88414)
- Large improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=56ea5e0ee948999a916ff5f3d78ed79716d1006b&end=1e37e83dc05a7c359ebb88188b0a2179a8ec9067&stat=instructions:u) (up to -2.2% on `incr-unchanged` builds of `unify-linearly`)


#### Mixed

Normalize projections under binders [#85499](https://github.com/rust-lang/rust/issues/85499)
- Very large improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=7b0e554ee2c94e9b3865a8c2d24d720224512dec&end=0afc20860eb98a29d9bbeea80f2acc5be38c6bf3&stat=instructions:u) (up to -36.8% on `incr-unchanged` builds of `deeply-nested-async`)
- Small regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=7b0e554ee2c94e9b3865a8c2d24d720224512dec&end=0afc20860eb98a29d9bbeea80f2acc5be38c6bf3&stat=instructions:u) (up to 1.4% on `incr-patched: add static arr item` builds of `coercions`)
- The large wins are in the `deeply-nested-async` benchmark which due to being a stress test can often have big swings in performance.
- A perf run was run on the PR, and it was not labeled as a mixed result because of slightly different thresholds that were used back then. 
- The PR is a pretty important one and the perf results are largely neutral so need to ping the authors here.


Use undef for uninitialized bytes in constants [#83698](https://github.com/rust-lang/rust/issues/83698)
- Very large improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=3b3ce374d203445eb1d0dce50f4211f4aceb7db6&end=20997f6ad81721542e9ef97bb2f58190903a34d8&stat=instructions:u) (up to -10.3% on `full` builds of `ctfe-stress-4`)
- Small regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=3b3ce374d203445eb1d0dce50f4211f4aceb7db6&end=20997f6ad81721542e9ef97bb2f58190903a34d8&stat=instructions:u) (up to 0.6% on `incr-patched: println` builds of `coercions`)
- Largely a performance win albeit in ctf-stress-test which being a stress test can yield large changes in certain cases. 
- The regressions here are all very small, and overall despite this being technically a mixed result, the improvements outweigh the regressions.


`#[inline]` non-generic `pub fn`s in `rustc_target::abi` and `ty::layout`. [#88326](https://github.com/rust-lang/rust/issues/88326)
- Small improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=720a1b23c1eda3c78e28126362238a500eaa20d4&end=dfd6306d26af1a163aaaa1456b4594244ddd182f&stat=instructions:u) (up to -1.5% on `incr-patched: add static arr item` builds of `coercions`)
- Very small regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=720a1b23c1eda3c78e28126362238a500eaa20d4&end=dfd6306d26af1a163aaaa1456b4594244ddd182f&stat=instructions:u) (up to 0.3% on `full` builds of `ripgrep`)
- The PR author already noticed that this ended up being a bit of a wash in terms of [performance](https://github.com/rust-lang/rust/pull/88326#issuecomment-907122343). Given that improvements still outweigh regressions, there's no need to look into this (though I imagine the author will continue to do so).


Treat macros as HIR items [#88019](https://github.com/rust-lang/rust/issues/88019)
- Large improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=2031fd6e46fbe4da271bb23d55c211b2e16dd91f&end=05cccdc9b321e6565b3e62e8b52aec53d106ef2f&stat=instructions:u) (up to -3.2% on `incr-unchanged` builds of `tuple-stress`)
- Moderate regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=2031fd6e46fbe4da271bb23d55c211b2e16dd91f&end=05cccdc9b321e6565b3e62e8b52aec53d106ef2f&stat=instructions:u) (up to 0.8% on `incr-unchanged` builds of `wg-grammar`)
- The improvements here outweigh the regressions considerably, and this is a fairly important bug fix. This PR has already had its performance [justified](https://github.com/rust-lang/rust/pull/88019#issuecomment-901585864).


#### Untriaged Pull Requests

- [#87815 encode `generics_of` for fields and ty params](https://github.com/rust-lang/rust/pull/87815)
- [#87781 Remove box syntax from compiler and tools](https://github.com/rust-lang/rust/pull/87781)
- [#87640 Rollup of 9 pull requests](https://github.com/rust-lang/rust/pull/87640)
- [#87587 Various refactorings of the TAIT infrastructure](https://github.com/rust-lang/rust/pull/87587)
- [#87570 Upgrade to LLVM 13](https://github.com/rust-lang/rust/pull/87570)
- [#87244 Better diagnostics with mismatched types due to implicit static lifetime](https://github.com/rust-lang/rust/pull/87244)
- [#86898 Add fast path for Path::cmp that skips over long shared prefixes](https://github.com/rust-lang/rust/pull/86898)
- [#86777 Include terminators in instance size estimate](https://github.com/rust-lang/rust/pull/86777)
- [#86698 Move OnDiskCache to rustc_query_impl.](https://github.com/rust-lang/rust/pull/86698)
- [#86588 Rollup of 8 pull requests](https://github.com/rust-lang/rust/pull/86588)
- [#86034 Change entry point to 🛡️ against 💥 💥-payloads](https://github.com/rust-lang/rust/pull/86034)
- [#84560 Inline Iterator as IntoIterator.](https://github.com/rust-lang/rust/pull/84560)
- [#80357 Introduce `hir::ExprKind::Let` - Take 2](https://github.com/rust-lang/rust/pull/80357)

