# 2023-02-21 Triage Log

Overall a fairly positive week, with few noise-related regressions or
improvements and many benchmarks showing significant improvements. The one
large regression is limited to documentation builds and has at least a partial
fix already planned.

Other wins this week include an average [improvement][memopt] of around 1% in
maximum memory usage of optimized builds, and a 2% average [reduction][sizeopt]
in compiled binary sizes. These are fairly significant wins for these metrics.

[memopt]: https://perf.rust-lang.org/?start=9bb6e60d1f1360234aae90c97964c0fa5524f141&end=3fee48c161a48b0c142d3998fff56faee96bd56c&absolute=false&stat=max-rss&kind=percentfromfirst
[sizeopt]: https://perf.rust-lang.org/?start=9bb6e60d1f1360234aae90c97964c0fa5524f141&end=3fee48c161a48b0c142d3998fff56faee96bd56c&absolute=false&stat=size%3Alinked_artifact&kind=percentfromfirst

Triage done by **@simulacrum**.
Revision range: [9bb6e60..3fee48c1](https://perf.rust-lang.org/?start=9bb6e60d1f1360234aae90c97964c0fa5524f141&end=3fee48c161a48b0c142d3998fff56faee96bd56c&absolute=false&stat=instructions%3Au)

**Summary**:

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 9.0%  | [0.3%, 79.8%]  | 10    |
| Regressions ❌ <br /> (secondary)  | 0.9%  | [0.4%, 2.1%]   | 14    |
| Improvements ✅ <br /> (primary)   | -1.7% | [-5.0%, -0.2%] | 128   |
| Improvements ✅ <br /> (secondary) | -1.6% | [-5.2%, -0.2%] | 61    |
| All ❌✅ (primary)                 | -0.9% | [-5.0%, 79.8%] | 138   |


3 Regressions, 3 Improvements, 3 Mixed; 2 of them in rollups
45 artifact comparisons made in total

#### Regressions

Rollup of 10 pull requests [#108052](https://github.com/rust-lang/rust/pull/108052) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=9bb6e60d1f1360234aae90c97964c0fa5524f141&end=6e0115778b0aedc90b59e035476c38e1b8c5c29b&stat=instructions:u)

| (instructions:u)                   | mean | range         | count |
|:----------------------------------:|:----:|:-------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 9.5% | [0.3%, 80.7%] | 10    |
| Regressions ❌ <br /> (secondary)  | 2.7% | [2.7%, 2.7%]  | 1     |
| Improvements ✅ <br /> (primary)   | -    | -             | 0     |
| Improvements ✅ <br /> (secondary) | -    | -             | 0     |
| All ❌✅ (primary)                 | 9.5% | [0.3%, 80.7%] | 10    |

This regression is limited to doc builds and is likely caused by the tooltip
expansion in "rustdoc: add more tooltips to intra-doc links
[#108025](https://github.com/rust-lang/rust/pull/108025)". An initial reduction
in overhead is proposed in
[#108098](https://github.com/rust-lang/rust/pull/108098).

use semantic equality for const param type equality assertion  [#107940](https://github.com/rust-lang/rust/pull/107940) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=0416b1a6f6d5c42696494e1a3a33580fd3f669d8&end=068161ea483b1a80a959476cb3e31e6619a72737&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.3% | [0.2%, 0.5%] | 5     |
| Regressions ❌ <br /> (secondary)  | -    | -            | 0     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.3% | [0.2%, 0.5%] | 5     |

Relatively small significance threshold in a single benchmark -- likely a real
regression, but not worth intense scrutiny.

give the resolver access to TyCtxt [#105462](https://github.com/rust-lang/rust/pull/105462) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=8f55d6025fec5fb648948fbe4fb6dcb4184c67bc&end=2deff71719a32af76eb4493ddb1dc4653fb88cad&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.4% | [0.2%, 1.4%] | 94    |
| Regressions ❌ <br /> (secondary)  | 0.6% | [0.2%, 2.6%] | 25    |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.4% | [0.2%, 1.4%] | 94    |

Regressions are being pursued in follow-up PRs, this architectural change
benefits incremental compilation and in general is on the right path even if in
the short term we are seeing some regressions due to increased locking.

#### Improvements

Avoid accessing HIR when it can be avoided [#108006](https://github.com/rust-lang/rust/pull/108006) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=999ac5f7770bff68bd65f490990d32c3ec1faaa6&end=2d14db321b043ffc579a7461464c88d7e3f54f83&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.4% | [-0.4%, -0.4%] | 3     |
| Improvements ✅ <br /> (secondary) | -0.2% | [-0.2%, -0.2%] | 1     |
| All ❌✅ (primary)                 | -0.4% | [-0.4%, -0.4%] | 3     |


Rollup of 6 pull requests [#108211](https://github.com/rust-lang/rust/pull/108211) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=3701bdc6333145410f009c83bd03f424eca05009&end=3eb5c4581a386b13c414e8c8bd73846ef37236d1&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.2% | [-0.3%, -0.2%] | 3     |
| Improvements ✅ <br /> (secondary) | -0.3% | [-0.3%, -0.3%] | 1     |
| All ❌✅ (primary)                 | -0.2% | [-0.3%, -0.2%] | 3     |


Use `ThinVec` more in the AST [#104754](https://github.com/rust-lang/rust/pull/104754) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=f715e430aac0de131e2ad21804013ea405722a66&end=3fee48c161a48b0c142d3998fff56faee96bd56c&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.5%  | [0.4%, 0.6%]   | 9     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.5% | [-1.5%, -0.2%] | 80    |
| Improvements ✅ <br /> (secondary) | -0.8% | [-3.3%, -0.2%] | 44    |
| All ❌✅ (primary)                 | -0.4% | [-1.5%, 0.6%]  | 89    |


#### Mixed

Enable CopyProp [#107449](https://github.com/rust-lang/rust/pull/107449) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=dc7a676778706bde3b50ff6d4fe81e2955bd4847&end=639377ed737b25830ec44dc6acf93467c980316a&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.3%  | [0.3%, 0.4%]   | 2     |
| Regressions ❌ <br /> (secondary)  | 1.2%  | [0.1%, 2.7%]   | 5     |
| Improvements ✅ <br /> (primary)   | -1.4% | [-4.4%, -0.3%] | 151   |
| Improvements ✅ <br /> (secondary) | -1.7% | [-5.5%, -0.3%] | 57    |
| All ❌✅ (primary)                 | -1.4% | [-4.4%, 0.4%]  | 153   |

The improvements here massively outweigh the tiny number of regressions.

(https://github.com/rust-lang/rust/pull/107449#issuecomment-1432772163)

Factor query arena allocation out from query caches [#107833](https://github.com/rust-lang/rust/pull/107833) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=9a7cc6c32f1a690f86827e4724bcda85e506ef35&end=947b696ce0ce42c98b8fb82ffa0735ade051466c&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | 1.0%  | [0.2%, 1.9%]   | 4     |
| Improvements ✅ <br /> (primary)   | -0.3% | [-0.3%, -0.3%] | 1     |
| Improvements ✅ <br /> (secondary) | -0.3% | [-0.4%, -0.2%] | 3     |
| All ❌✅ (primary)                 | -0.3% | [-0.3%, -0.3%] | 1     |

Enable instcombine for mutable reborrows [#105274](https://github.com/rust-lang/rust/pull/105274) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=9aa5c24b7d763fb98d998819571128ff2eb8a3ca&end=231bcd131d109d41e5705f48b9c5a6e70c98ff80&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.6%  | [0.2%, 3.1%]   | 16    |
| Regressions ❌ <br /> (secondary)  | 0.4%  | [0.2%, 0.5%]   | 11    |
| Improvements ✅ <br /> (primary)   | -0.7% | [-2.3%, -0.3%] | 32    |
| Improvements ✅ <br /> (secondary) | -1.0% | [-1.7%, -0.3%] | 17    |
| All ❌✅ (primary)                 | -0.3% | [-2.3%, 3.1%]  | 48    |

This also provides significant wins for binary size, up to 8.8% in stm32f4.
