# 2025-05-12 Triage Log

Lot of changes this week. Overall result is positive, with one large win in type check.

Triage done by **@panstromek**.
Revision range: [62c5f58f..718ddf66](https://perf.rust-lang.org/?start=62c5f58f57670ce65e7fec34f8c4ba00c27da2d9&end=718ddf660e6a1802c39b4962cf7eaa4db57025ef&absolute=false&stat=instructions%3Au)

**Summary**:

| (instructions:u)                   | mean  | range           | count |
|:----------------------------------:|:-----:|:---------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.5%  | [0.2%, 1.4%]    | 113   |
| Regressions ❌ <br /> (secondary)  | 0.5%  | [0.1%, 1.5%]    | 54    |
| Improvements ✅ <br /> (primary)   | -2.5% | [-22.5%, -0.3%] | 45    |
| Improvements ✅ <br /> (secondary) | -0.9% | [-2.3%, -0.2%]  | 10    |
| All ❌✅ (primary)                 | -0.3% | [-22.5%, 1.4%]  | 158   |


8 Regressions, 5 Improvements, 3 Mixed; 6 of them in rollups
47 artifact comparisons made in total

#### Regressions

Don't name variables from external macros in borrow errors. [#140580](https://github.com/rust-lang/rust/pull/140580) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=62c5f58f57670ce65e7fec34f8c4ba00c27da2d9&end=ab62d56603293e9264b4d811d2d6f5b49a3264f9&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 1.7% | [1.7%, 1.7%] | 1     |
| Regressions ❌ <br /> (secondary)  | -    | -            | 0     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 1.7% | [1.7%, 1.7%] | 1     |

Within noise, triaged by Mark.

Weekly `cargo update` [#140353](https://github.com/rust-lang/rust/pull/140353) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=2958d8969cb3096a533927a566e72477c55d8653&end=cd55868a8db4b9394be64082a290f11b1e03b5d3&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.4% | [0.2%, 1.2%] | 8     |
| Regressions ❌ <br /> (secondary)  | 0.2% | [0.1%, 0.2%] | 11    |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.4% | [0.2%, 1.2%] | 8     |

Regressions are small, but look real, mostly in backend. Even with non-relevant results, this is almost all just regressions. Left a comment and we will see if this is worth more investigation.

Rollup of 4 pull requests [#140708](https://github.com/rust-lang/rust/pull/140708) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=1a95cc6f9d950992ba27746e45caf40118581cb1&end=27d6200a70601f6fcf419bf2f9e37989f3624ca4&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 1.1% | [1.1%, 1.1%] | 1     |
| Regressions ❌ <br /> (secondary)  | -    | -            | 0     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 1.1% | [1.1%, 1.1%] | 1     |

Small `nalgebra` regression, looks spurious. The benchmark returned to previous state afterwards and looks like it became bi-modal.

Use thread local dep graph encoding [#139758](https://github.com/rust-lang/rust/pull/139758) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=db0e836148accac8a22532e3596ac612b63c2d8e&end=3ef8e64ce9f72ee8d600d55bc43b36eed069b252&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.3% | [0.2%, 0.7%] | 90    |
| Regressions ❌ <br /> (secondary)  | 0.3% | [0.2%, 0.5%] | 12    |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.3% | [0.2%, 0.7%] | 90    |

Small regression on a lot of benchmarks, mostly tiny incremental-unchanged scenarios. This is supposed to improve incremental performance with parallel compiler, which is not yet covered by benchmarks.

borrowck nested items in dead code [#140590](https://github.com/rust-lang/rust/pull/140590) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=3ef8e64ce9f72ee8d600d55bc43b36eed069b252&end=e9f8103f93f8ce2fa2c15c0c6796ec821f8ae15d&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.3% | [0.2%, 0.5%] | 29    |
| Regressions ❌ <br /> (secondary)  | 0.6% | [0.2%, 1.5%] | 24    |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.3% | [0.2%, 0.5%] | 29    |

Fixes P-critical regression. Perf reggression is expected as this is doing more work, which will also be necessary to stabilize new solver.

Remove `Ident::empty` [#140252](https://github.com/rust-lang/rust/pull/140252) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=c8b7f32434c0306db5c1b974ee43443746098a92&end=a7b1b24587dcbebf12455c41ed828d9b486487be&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.3% | [0.1%, 1.1%] | 115   |
| Regressions ❌ <br /> (secondary)  | 0.4% | [0.2%, 0.7%] | 41    |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.3% | [0.1%, 1.1%] | 115   |

Caused by new `assert!`. Fixed by changing to `debug_assert!` in a followup [#140880](https://github.com/rust-lang/rust/pull/140880).

Bump version number to 1.89.0 [#140839](https://github.com/rust-lang/rust/pull/140839) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=da1e442ebde8d527f3872c0cac5b371ff6ea0cc7&end=dcecb99176edf2eec51613730937d21cdd5c8f6e&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 1.1% | [1.1%, 1.1%] | 1     |
| Regressions ❌ <br /> (secondary)  | 0.1% | [0.1%, 0.1%] | 2     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 1.1% | [1.1%, 1.1%] | 1     |

Regressions are spurious. `nalgebra` is bimodal and returned to previous state in following commit. Secondary regressions in `tt-muncher` also later recovered.

Update `backtrace` in Cargo.lock [#140705](https://github.com/rust-lang/rust/pull/140705) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=c6faa1b22e735494677a2410ee281ca5f646e747&end=bfb44c8155dc102358deeb27acef44abe030b30e&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 1.0% | [1.0%, 1.0%] | 1     |
| Regressions ❌ <br /> (secondary)  | -    | -            | 0     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 1.0% | [1.0%, 1.0%] | 1     |

Another `nalgebra` bimodality. Returned to previous state in following commit.

#### Improvements

Rollup of 6 pull requests [#140646](https://github.com/rust-lang/rust/pull/140646) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=13e87909494f2f31bce51bc106e2b629420d1235&end=2958d8969cb3096a533927a566e72477c55d8653&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -1.1% | [-1.1%, -1.1%] | 1     |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | -1.1% | [-1.1%, -1.1%] | 1     |


Rollup of 4 pull requests [#140702](https://github.com/rust-lang/rust/pull/140702) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=f5d3fe273b8b9e7125bf8856d44793b6cc4b6735&end=1a95cc6f9d950992ba27746e45caf40118581cb1&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -1.0% | [-1.0%, -1.0%] | 1     |
| Improvements ✅ <br /> (secondary) | -0.5% | [-0.5%, -0.5%] | 1     |
| All ❌✅ (primary)                 | -1.0% | [-1.0%, -1.0%] | 1     |


Rollup of 9 pull requests [#140726](https://github.com/rust-lang/rust/pull/140726) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=669c1ab9677ae8dc1d7db30b75fd173d06c0c75a&end=891b8525477f5c41a9e56d7b70d64b41e7c344e3&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.4% | [-1.0%, -0.2%] | 4     |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | -0.4% | [-1.0%, -0.2%] | 4     |


Rollup of 7 pull requests [#140869](https://github.com/rust-lang/rust/pull/140869) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=dcecb99176edf2eec51613730937d21cdd5c8f6e&end=fd9fad6dbcc1bae3cba2a8634339ffa620a49f28&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -1.0% | [-1.0%, -1.0%] | 1     |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | -1.0% | [-1.0%, -1.0%] | 1     |


Make the assertion in `Ident::new` debug-only. [#140880](https://github.com/rust-lang/rust/pull/140880) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=bfb44c8155dc102358deeb27acef44abe030b30e&end=7e432c456bf58ad436f3a92c2a3e3c27f399f14a&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.3% | [-1.1%, -0.1%] | 115   |
| Improvements ✅ <br /> (secondary) | -0.4% | [-0.7%, -0.2%] | 34    |
| All ❌✅ (primary)                 | -0.3% | [-1.1%, -0.1%] | 115   |

Fixes the `assert!` regression from above.

#### Mixed

Rollup of 4 pull requests [#140650](https://github.com/rust-lang/rust/pull/140650) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=cd55868a8db4b9394be64082a290f11b1e03b5d3&end=54d024e4bf462c77a86c4126d7e66d89b64f053a&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.7%  | [0.7%, 0.7%]   | 1     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.3% | [-0.3%, -0.3%] | 2     |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | 0.0%  | [-0.3%, 0.7%]  | 3     |

Regression in `image` looks real. It's mostly coming from backend, so it's probably some code shuffling that allows LLVM to do discover more optimizations. More detailed investigation is in the [PR comment](https://github.com/rust-lang/rust/pull/140650#issuecomment-2872386051)

Do not gather local all together at the beginning of typeck [#140561](https://github.com/rust-lang/rust/pull/140561) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=651e9cf327358b28db7e37a2ae61727f4a2ef232&end=f5d3fe273b8b9e7125bf8856d44793b6cc4b6735&stat=instructions:u)

| (instructions:u)                   | mean  | range           | count |
|:----------------------------------:|:-----:|:---------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.4%  | [0.4%, 0.4%]    | 1     |
| Regressions ❌ <br /> (secondary)  | 0.3%  | [0.2%, 0.4%]    | 3     |
| Improvements ✅ <br /> (primary)   | -1.8% | [-22.4%, -0.1%] | 73    |
| Improvements ✅ <br /> (secondary) | -0.9% | [-2.0%, -0.3%]  | 12    |
| All ❌✅ (primary)                 | -1.8% | [-22.4%, 0.4%]  | 74    |

Large improvements outweigh regresions. Regressions are spurious (all regressed crates returned back to previous state in following commit).

Merge typeck loop with static/const item eval loop [#140854](https://github.com/rust-lang/rust/pull/140854) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=7e432c456bf58ad436f3a92c2a3e3c27f399f14a&end=b10555674f355aca2bfe974e50a0b9ab48eb1d87&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.2%  | [0.2%, 0.3%]   | 3     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.4% | [-0.4%, -0.3%] | 3     |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | -0.1% | [-0.4%, 0.3%]  | 6     |

All changes in `unicode-normalization`. Incremental full improvements outweigh small non-incremental regressions. This matches results in pre-merge run, so I assume it's expected.
