// Copyright 2015, VIXL authors
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//   * Neither the name of ARM Limited nor the names of its contributors may be
//     used to endorse or promote products derived from this software without
//     specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


// ---------------------------------------------------------------------
// This file is auto generated using tools/generate_simulator_traces.py.
//
// PLEASE DO NOT EDIT.
// ---------------------------------------------------------------------

#ifndef VIXL_SIM_UCVTF_8H_2OPIMM_TRACE_AARCH64_H_
#define VIXL_SIM_UCVTF_8H_2OPIMM_TRACE_AARCH64_H_

const uint16_t kExpected_NEON_ucvtf_8H_2OPIMM[] = {
  0x78a0, 0x78a0, 0x78c0, 0x78e0, 0x7bfc, 0x7bfe, 0x7c00, 0x0000,
  0x74a0, 0x74a0, 0x74c0, 0x74e0, 0x77fc, 0x77fe, 0x7800, 0x0000,
  0x70a0, 0x70a0, 0x70c0, 0x70e0, 0x73fc, 0x73fe, 0x7400, 0x0000,
  0x6ca0, 0x6ca0, 0x6cc0, 0x6ce0, 0x6ffc, 0x6ffe, 0x7000, 0x0000,
  0x68a0, 0x68a0, 0x68c0, 0x68e0, 0x6bfc, 0x6bfe, 0x6c00, 0x0000,
  0x64a0, 0x64a0, 0x64c0, 0x64e0, 0x67fc, 0x67fe, 0x6800, 0x0000,
  0x60a0, 0x60a0, 0x60c0, 0x60e0, 0x63fc, 0x63fe, 0x6400, 0x0000,
  0x5ca0, 0x5ca0, 0x5cc0, 0x5ce0, 0x5ffc, 0x5ffe, 0x6000, 0x0000,
  0x58a0, 0x58a0, 0x58c0, 0x58e0, 0x5bfc, 0x5bfe, 0x5c00, 0x0000,
  0x54a0, 0x54a0, 0x54c0, 0x54e0, 0x57fc, 0x57fe, 0x5800, 0x0000,
  0x50a0, 0x50a0, 0x50c0, 0x50e0, 0x53fc, 0x53fe, 0x5400, 0x0000,
  0x4ca0, 0x4ca0, 0x4cc0, 0x4ce0, 0x4ffc, 0x4ffe, 0x5000, 0x0000,
  0x48a0, 0x48a0, 0x48c0, 0x48e0, 0x4bfc, 0x4bfe, 0x4c00, 0x0000,
  0x44a0, 0x44a0, 0x44c0, 0x44e0, 0x47fc, 0x47fe, 0x4800, 0x0000,
  0x40a0, 0x40a0, 0x40c0, 0x40e0, 0x43fc, 0x43fe, 0x4400, 0x0000,
  0x3ca0, 0x3ca0, 0x3cc0, 0x3ce0, 0x3ffc, 0x3ffe, 0x4000, 0x0000,
  0x38a0, 0x38a0, 0x38c0, 0x38e0, 0x3bfc, 0x3bfe, 0x3c00, 0x0000,
  0x78a0, 0x78c0, 0x78e0, 0x7bfc, 0x7bfe, 0x7c00, 0x0000, 0x3c00,
  0x74a0, 0x74c0, 0x74e0, 0x77fc, 0x77fe, 0x7800, 0x0000, 0x3800,
  0x70a0, 0x70c0, 0x70e0, 0x73fc, 0x73fe, 0x7400, 0x0000, 0x3400,
  0x6ca0, 0x6cc0, 0x6ce0, 0x6ffc, 0x6ffe, 0x7000, 0x0000, 0x3000,
  0x68a0, 0x68c0, 0x68e0, 0x6bfc, 0x6bfe, 0x6c00, 0x0000, 0x2c00,
  0x64a0, 0x64c0, 0x64e0, 0x67fc, 0x67fe, 0x6800, 0x0000, 0x2800,
  0x60a0, 0x60c0, 0x60e0, 0x63fc, 0x63fe, 0x6400, 0x0000, 0x2400,
  0x5ca0, 0x5cc0, 0x5ce0, 0x5ffc, 0x5ffe, 0x6000, 0x0000, 0x2000,
  0x58a0, 0x58c0, 0x58e0, 0x5bfc, 0x5bfe, 0x5c00, 0x0000, 0x1c00,
  0x54a0, 0x54c0, 0x54e0, 0x57fc, 0x57fe, 0x5800, 0x0000, 0x1800,
  0x50a0, 0x50c0, 0x50e0, 0x53fc, 0x53fe, 0x5400, 0x0000, 0x1400,
  0x4ca0, 0x4cc0, 0x4ce0, 0x4ffc, 0x4ffe, 0x5000, 0x0000, 0x1000,
  0x48a0, 0x48c0, 0x48e0, 0x4bfc, 0x4bfe, 0x4c00, 0x0000, 0x0c00,
  0x44a0, 0x44c0, 0x44e0, 0x47fc, 0x47fe, 0x4800, 0x0000, 0x0800,
  0x40a0, 0x40c0, 0x40e0, 0x43fc, 0x43fe, 0x4400, 0x0000, 0x0400,
  0x3ca0, 0x3cc0, 0x3ce0, 0x3ffc, 0x3ffe, 0x4000, 0x0000, 0x0200,
  0x38a0, 0x38c0, 0x38e0, 0x3bfc, 0x3bfe, 0x3c00, 0x0000, 0x0100,
  0x78c0, 0x78e0, 0x7bfc, 0x7bfe, 0x7c00, 0x0000, 0x3c00, 0x4000,
  0x74c0, 0x74e0, 0x77fc, 0x77fe, 0x7800, 0x0000, 0x3800, 0x3c00,
  0x70c0, 0x70e0, 0x73fc, 0x73fe, 0x7400, 0x0000, 0x3400, 0x3800,
  0x6cc0, 0x6ce0, 0x6ffc, 0x6ffe, 0x7000, 0x0000, 0x3000, 0x3400,
  0x68c0, 0x68e0, 0x6bfc, 0x6bfe, 0x6c00, 0x0000, 0x2c00, 0x3000,
  0x64c0, 0x64e0, 0x67fc, 0x67fe, 0x6800, 0x0000, 0x2800, 0x2c00,
  0x60c0, 0x60e0, 0x63fc, 0x63fe, 0x6400, 0x0000, 0x2400, 0x2800,
  0x5cc0, 0x5ce0, 0x5ffc, 0x5ffe, 0x6000, 0x0000, 0x2000, 0x2400,
  0x58c0, 0x58e0, 0x5bfc, 0x5bfe, 0x5c00, 0x0000, 0x1c00, 0x2000,
  0x54c0, 0x54e0, 0x57fc, 0x57fe, 0x5800, 0x0000, 0x1800, 0x1c00,
  0x50c0, 0x50e0, 0x53fc, 0x53fe, 0x5400, 0x0000, 0x1400, 0x1800,
  0x4cc0, 0x4ce0, 0x4ffc, 0x4ffe, 0x5000, 0x0000, 0x1000, 0x1400,
  0x48c0, 0x48e0, 0x4bfc, 0x4bfe, 0x4c00, 0x0000, 0x0c00, 0x1000,
  0x44c0, 0x44e0, 0x47fc, 0x47fe, 0x4800, 0x0000, 0x0800, 0x0c00,
  0x40c0, 0x40e0, 0x43fc, 0x43fe, 0x4400, 0x0000, 0x0400, 0x0800,
  0x3cc0, 0x3ce0, 0x3ffc, 0x3ffe, 0x4000, 0x0000, 0x0200, 0x0400,
  0x38c0, 0x38e0, 0x3bfc, 0x3bfe, 0x3c00, 0x0000, 0x0100, 0x0200,
  0x78e0, 0x7bfc, 0x7bfe, 0x7c00, 0x0000, 0x3c00, 0x4000, 0x4c00,
  0x74e0, 0x77fc, 0x77fe, 0x7800, 0x0000, 0x3800, 0x3c00, 0x4800,
  0x70e0, 0x73fc, 0x73fe, 0x7400, 0x0000, 0x3400, 0x3800, 0x4400,
  0x6ce0, 0x6ffc, 0x6ffe, 0x7000, 0x0000, 0x3000, 0x3400, 0x4000,
  0x68e0, 0x6bfc, 0x6bfe, 0x6c00, 0x0000, 0x2c00, 0x3000, 0x3c00,
  0x64e0, 0x67fc, 0x67fe, 0x6800, 0x0000, 0x2800, 0x2c00, 0x3800,
  0x60e0, 0x63fc, 0x63fe, 0x6400, 0x0000, 0x2400, 0x2800, 0x3400,
  0x5ce0, 0x5ffc, 0x5ffe, 0x6000, 0x0000, 0x2000, 0x2400, 0x3000,
  0x58e0, 0x5bfc, 0x5bfe, 0x5c00, 0x0000, 0x1c00, 0x2000, 0x2c00,
  0x54e0, 0x57fc, 0x57fe, 0x5800, 0x0000, 0x1800, 0x1c00, 0x2800,
  0x50e0, 0x53fc, 0x53fe, 0x5400, 0x0000, 0x1400, 0x1800, 0x2400,
  0x4ce0, 0x4ffc, 0x4ffe, 0x5000, 0x0000, 0x1000, 0x1400, 0x2000,
  0x48e0, 0x4bfc, 0x4bfe, 0x4c00, 0x0000, 0x0c00, 0x1000, 0x1c00,
  0x44e0, 0x47fc, 0x47fe, 0x4800, 0x0000, 0x0800, 0x0c00, 0x1800,
  0x40e0, 0x43fc, 0x43fe, 0x4400, 0x0000, 0x0400, 0x0800, 0x1400,
  0x3ce0, 0x3ffc, 0x3ffe, 0x4000, 0x0000, 0x0200, 0x0400, 0x1000,
  0x38e0, 0x3bfc, 0x3bfe, 0x3c00, 0x0000, 0x0100, 0x0200, 0x0c00,
  0x7bfc, 0x7bfe, 0x7c00, 0x0000, 0x3c00, 0x4000, 0x4c00, 0x57d0,
  0x77fc, 0x77fe, 0x7800, 0x0000, 0x3800, 0x3c00, 0x4800, 0x53d0,
  0x73fc, 0x73fe, 0x7400, 0x0000, 0x3400, 0x3800, 0x4400, 0x4fd0,
  0x6ffc, 0x6ffe, 0x7000, 0x0000, 0x3000, 0x3400, 0x4000, 0x4bd0,
  0x6bfc, 0x6bfe, 0x6c00, 0x0000, 0x2c00, 0x3000, 0x3c00, 0x47d0,
  0x67fc, 0x67fe, 0x6800, 0x0000, 0x2800, 0x2c00, 0x3800, 0x43d0,
  0x63fc, 0x63fe, 0x6400, 0x0000, 0x2400, 0x2800, 0x3400, 0x3fd0,
  0x5ffc, 0x5ffe, 0x6000, 0x0000, 0x2000, 0x2400, 0x3000, 0x3bd0,
  0x5bfc, 0x5bfe, 0x5c00, 0x0000, 0x1c00, 0x2000, 0x2c00, 0x37d0,
  0x57fc, 0x57fe, 0x5800, 0x0000, 0x1800, 0x1c00, 0x2800, 0x33d0,
  0x53fc, 0x53fe, 0x5400, 0x0000, 0x1400, 0x1800, 0x2400, 0x2fd0,
  0x4ffc, 0x4ffe, 0x5000, 0x0000, 0x1000, 0x1400, 0x2000, 0x2bd0,
  0x4bfc, 0x4bfe, 0x4c00, 0x0000, 0x0c00, 0x1000, 0x1c00, 0x27d0,
  0x47fc, 0x47fe, 0x4800, 0x0000, 0x0800, 0x0c00, 0x1800, 0x23d0,
  0x43fc, 0x43fe, 0x4400, 0x0000, 0x0400, 0x0800, 0x1400, 0x1fd0,
  0x3ffc, 0x3ffe, 0x4000, 0x0000, 0x0200, 0x0400, 0x1000, 0x1bd0,
  0x3bfc, 0x3bfe, 0x3c00, 0x0000, 0x0100, 0x0200, 0x0c00, 0x17d0,
  0x7bfe, 0x7c00, 0x0000, 0x3c00, 0x4000, 0x4c00, 0x57d0, 0x57e0,
  0x77fe, 0x7800, 0x0000, 0x3800, 0x3c00, 0x4800, 0x53d0, 0x53e0,
  0x73fe, 0x7400, 0x0000, 0x3400, 0x3800, 0x4400, 0x4fd0, 0x4fe0,
  0x6ffe, 0x7000, 0x0000, 0x3000, 0x3400, 0x4000, 0x4bd0, 0x4be0,
  0x6bfe, 0x6c00, 0x0000, 0x2c00, 0x3000, 0x3c00, 0x47d0, 0x47e0,
  0x67fe, 0x6800, 0x0000, 0x2800, 0x2c00, 0x3800, 0x43d0, 0x43e0,
  0x63fe, 0x6400, 0x0000, 0x2400, 0x2800, 0x3400, 0x3fd0, 0x3fe0,
  0x5ffe, 0x6000, 0x0000, 0x2000, 0x2400, 0x3000, 0x3bd0, 0x3be0,
  0x5bfe, 0x5c00, 0x0000, 0x1c00, 0x2000, 0x2c00, 0x37d0, 0x37e0,
  0x57fe, 0x5800, 0x0000, 0x1800, 0x1c00, 0x2800, 0x33d0, 0x33e0,
  0x53fe, 0x5400, 0x0000, 0x1400, 0x1800, 0x2400, 0x2fd0, 0x2fe0,
  0x4ffe, 0x5000, 0x0000, 0x1000, 0x1400, 0x2000, 0x2bd0, 0x2be0,
  0x4bfe, 0x4c00, 0x0000, 0x0c00, 0x1000, 0x1c00, 0x27d0, 0x27e0,
  0x47fe, 0x4800, 0x0000, 0x0800, 0x0c00, 0x1800, 0x23d0, 0x23e0,
  0x43fe, 0x4400, 0x0000, 0x0400, 0x0800, 0x1400, 0x1fd0, 0x1fe0,
  0x3ffe, 0x4000, 0x0000, 0x0200, 0x0400, 0x1000, 0x1bd0, 0x1be0,
  0x3bfe, 0x3c00, 0x0000, 0x0100, 0x0200, 0x0c00, 0x17d0, 0x17e0,
  0x7c00, 0x0000, 0x3c00, 0x4000, 0x4c00, 0x57d0, 0x57e0, 0x57f0,
  0x7800, 0x0000, 0x3800, 0x3c00, 0x4800, 0x53d0, 0x53e0, 0x53f0,
  0x7400, 0x0000, 0x3400, 0x3800, 0x4400, 0x4fd0, 0x4fe0, 0x4ff0,
  0x7000, 0x0000, 0x3000, 0x3400, 0x4000, 0x4bd0, 0x4be0, 0x4bf0,
  0x6c00, 0x0000, 0x2c00, 0x3000, 0x3c00, 0x47d0, 0x47e0, 0x47f0,
  0x6800, 0x0000, 0x2800, 0x2c00, 0x3800, 0x43d0, 0x43e0, 0x43f0,
  0x6400, 0x0000, 0x2400, 0x2800, 0x3400, 0x3fd0, 0x3fe0, 0x3ff0,
  0x6000, 0x0000, 0x2000, 0x2400, 0x3000, 0x3bd0, 0x3be0, 0x3bf0,
  0x5c00, 0x0000, 0x1c00, 0x2000, 0x2c00, 0x37d0, 0x37e0, 0x37f0,
  0x5800, 0x0000, 0x1800, 0x1c00, 0x2800, 0x33d0, 0x33e0, 0x33f0,
  0x5400, 0x0000, 0x1400, 0x1800, 0x2400, 0x2fd0, 0x2fe0, 0x2ff0,
  0x5000, 0x0000, 0x1000, 0x1400, 0x2000, 0x2bd0, 0x2be0, 0x2bf0,
  0x4c00, 0x0000, 0x0c00, 0x1000, 0x1c00, 0x27d0, 0x27e0, 0x27f0,
  0x4800, 0x0000, 0x0800, 0x0c00, 0x1800, 0x23d0, 0x23e0, 0x23f0,
  0x4400, 0x0000, 0x0400, 0x0800, 0x1400, 0x1fd0, 0x1fe0, 0x1ff0,
  0x4000, 0x0000, 0x0200, 0x0400, 0x1000, 0x1bd0, 0x1be0, 0x1bf0,
  0x3c00, 0x0000, 0x0100, 0x0200, 0x0c00, 0x17d0, 0x17e0, 0x17f0,
  0x0000, 0x3c00, 0x4000, 0x4c00, 0x57d0, 0x57e0, 0x57f0, 0x7266,
  0x0000, 0x3800, 0x3c00, 0x4800, 0x53d0, 0x53e0, 0x53f0, 0x6e66,
  0x0000, 0x3400, 0x3800, 0x4400, 0x4fd0, 0x4fe0, 0x4ff0, 0x6a66,
  0x0000, 0x3000, 0x3400, 0x4000, 0x4bd0, 0x4be0, 0x4bf0, 0x6666,
  0x0000, 0x2c00, 0x3000, 0x3c00, 0x47d0, 0x47e0, 0x47f0, 0x6266,
  0x0000, 0x2800, 0x2c00, 0x3800, 0x43d0, 0x43e0, 0x43f0, 0x5e66,
  0x0000, 0x2400, 0x2800, 0x3400, 0x3fd0, 0x3fe0, 0x3ff0, 0x5a66,
  0x0000, 0x2000, 0x2400, 0x3000, 0x3bd0, 0x3be0, 0x3bf0, 0x5666,
  0x0000, 0x1c00, 0x2000, 0x2c00, 0x37d0, 0x37e0, 0x37f0, 0x5266,
  0x0000, 0x1800, 0x1c00, 0x2800, 0x33d0, 0x33e0, 0x33f0, 0x4e66,
  0x0000, 0x1400, 0x1800, 0x2400, 0x2fd0, 0x2fe0, 0x2ff0, 0x4a66,
  0x0000, 0x1000, 0x1400, 0x2000, 0x2bd0, 0x2be0, 0x2bf0, 0x4666,
  0x0000, 0x0c00, 0x1000, 0x1c00, 0x27d0, 0x27e0, 0x27f0, 0x4266,
  0x0000, 0x0800, 0x0c00, 0x1800, 0x23d0, 0x23e0, 0x23f0, 0x3e66,
  0x0000, 0x0400, 0x0800, 0x1400, 0x1fd0, 0x1fe0, 0x1ff0, 0x3a66,
  0x0000, 0x0200, 0x0400, 0x1000, 0x1bd0, 0x1be0, 0x1bf0, 0x3666,
  0x0000, 0x0100, 0x0200, 0x0c00, 0x17d0, 0x17e0, 0x17f0, 0x3266,
  0x3c00, 0x4000, 0x4c00, 0x57d0, 0x57e0, 0x57f0, 0x7266, 0x7555,
  0x3800, 0x3c00, 0x4800, 0x53d0, 0x53e0, 0x53f0, 0x6e66, 0x7155,
  0x3400, 0x3800, 0x4400, 0x4fd0, 0x4fe0, 0x4ff0, 0x6a66, 0x6d55,
  0x3000, 0x3400, 0x4000, 0x4bd0, 0x4be0, 0x4bf0, 0x6666, 0x6955,
  0x2c00, 0x3000, 0x3c00, 0x47d0, 0x47e0, 0x47f0, 0x6266, 0x6555,
  0x2800, 0x2c00, 0x3800, 0x43d0, 0x43e0, 0x43f0, 0x5e66, 0x6155,
  0x2400, 0x2800, 0x3400, 0x3fd0, 0x3fe0, 0x3ff0, 0x5a66, 0x5d55,
  0x2000, 0x2400, 0x3000, 0x3bd0, 0x3be0, 0x3bf0, 0x5666, 0x5955,
  0x1c00, 0x2000, 0x2c00, 0x37d0, 0x37e0, 0x37f0, 0x5266, 0x5555,
  0x1800, 0x1c00, 0x2800, 0x33d0, 0x33e0, 0x33f0, 0x4e66, 0x5155,
  0x1400, 0x1800, 0x2400, 0x2fd0, 0x2fe0, 0x2ff0, 0x4a66, 0x4d55,
  0x1000, 0x1400, 0x2000, 0x2bd0, 0x2be0, 0x2bf0, 0x4666, 0x4955,
  0x0c00, 0x1000, 0x1c00, 0x27d0, 0x27e0, 0x27f0, 0x4266, 0x4555,
  0x0800, 0x0c00, 0x1800, 0x23d0, 0x23e0, 0x23f0, 0x3e66, 0x4155,
  0x0400, 0x0800, 0x1400, 0x1fd0, 0x1fe0, 0x1ff0, 0x3a66, 0x3d55,
  0x0200, 0x0400, 0x1000, 0x1bd0, 0x1be0, 0x1bf0, 0x3666, 0x3955,
  0x0100, 0x0200, 0x0c00, 0x17d0, 0x17e0, 0x17f0, 0x3266, 0x3555,
  0x4000, 0x4c00, 0x57d0, 0x57e0, 0x57f0, 0x7266, 0x7555, 0x7800,
  0x3c00, 0x4800, 0x53d0, 0x53e0, 0x53f0, 0x6e66, 0x7155, 0x7400,
  0x3800, 0x4400, 0x4fd0, 0x4fe0, 0x4ff0, 0x6a66, 0x6d55, 0x7000,
  0x3400, 0x4000, 0x4bd0, 0x4be0, 0x4bf0, 0x6666, 0x6955, 0x6c00,
  0x3000, 0x3c00, 0x47d0, 0x47e0, 0x47f0, 0x6266, 0x6555, 0x6800,
  0x2c00, 0x3800, 0x43d0, 0x43e0, 0x43f0, 0x5e66, 0x6155, 0x6400,
  0x2800, 0x3400, 0x3fd0, 0x3fe0, 0x3ff0, 0x5a66, 0x5d55, 0x6000,
  0x2400, 0x3000, 0x3bd0, 0x3be0, 0x3bf0, 0x5666, 0x5955, 0x5c00,
  0x2000, 0x2c00, 0x37d0, 0x37e0, 0x37f0, 0x5266, 0x5555, 0x5800,
  0x1c00, 0x2800, 0x33d0, 0x33e0, 0x33f0, 0x4e66, 0x5155, 0x5400,
  0x1800, 0x2400, 0x2fd0, 0x2fe0, 0x2ff0, 0x4a66, 0x4d55, 0x5000,
  0x1400, 0x2000, 0x2bd0, 0x2be0, 0x2bf0, 0x4666, 0x4955, 0x4c00,
  0x1000, 0x1c00, 0x27d0, 0x27e0, 0x27f0, 0x4266, 0x4555, 0x4800,
  0x0c00, 0x1800, 0x23d0, 0x23e0, 0x23f0, 0x3e66, 0x4155, 0x4400,
  0x0800, 0x1400, 0x1fd0, 0x1fe0, 0x1ff0, 0x3a66, 0x3d55, 0x4000,
  0x0400, 0x1000, 0x1bd0, 0x1be0, 0x1bf0, 0x3666, 0x3955, 0x3c00,
  0x0200, 0x0c00, 0x17d0, 0x17e0, 0x17f0, 0x3266, 0x3555, 0x3800,
  0x4c00, 0x57d0, 0x57e0, 0x57f0, 0x7266, 0x7555, 0x7800, 0x7800,
  0x4800, 0x53d0, 0x53e0, 0x53f0, 0x6e66, 0x7155, 0x7400, 0x7400,
  0x4400, 0x4fd0, 0x4fe0, 0x4ff0, 0x6a66, 0x6d55, 0x7000, 0x7000,
  0x4000, 0x4bd0, 0x4be0, 0x4bf0, 0x6666, 0x6955, 0x6c00, 0x6c00,
  0x3c00, 0x47d0, 0x47e0, 0x47f0, 0x6266, 0x6555, 0x6800, 0x6800,
  0x3800, 0x43d0, 0x43e0, 0x43f0, 0x5e66, 0x6155, 0x6400, 0x6400,
  0x3400, 0x3fd0, 0x3fe0, 0x3ff0, 0x5a66, 0x5d55, 0x6000, 0x6000,
  0x3000, 0x3bd0, 0x3be0, 0x3bf0, 0x5666, 0x5955, 0x5c00, 0x5c00,
  0x2c00, 0x37d0, 0x37e0, 0x37f0, 0x5266, 0x5555, 0x5800, 0x5800,
  0x2800, 0x33d0, 0x33e0, 0x33f0, 0x4e66, 0x5155, 0x5400, 0x5400,
  0x2400, 0x2fd0, 0x2fe0, 0x2ff0, 0x4a66, 0x4d55, 0x5000, 0x5000,
  0x2000, 0x2bd0, 0x2be0, 0x2bf0, 0x4666, 0x4955, 0x4c00, 0x4c00,
  0x1c00, 0x27d0, 0x27e0, 0x27f0, 0x4266, 0x4555, 0x4800, 0x4800,
  0x1800, 0x23d0, 0x23e0, 0x23f0, 0x3e66, 0x4155, 0x4400, 0x4400,
  0x1400, 0x1fd0, 0x1fe0, 0x1ff0, 0x3a66, 0x3d55, 0x4000, 0x4000,
  0x1000, 0x1bd0, 0x1be0, 0x1bf0, 0x3666, 0x3955, 0x3c00, 0x3c00,
  0x0c00, 0x17d0, 0x17e0, 0x17f0, 0x3266, 0x3555, 0x3800, 0x3800,
  0x57d0, 0x57e0, 0x57f0, 0x7266, 0x7555, 0x7800, 0x7800, 0x7800,
  0x53d0, 0x53e0, 0x53f0, 0x6e66, 0x7155, 0x7400, 0x7400, 0x7400,
  0x4fd0, 0x4fe0, 0x4ff0, 0x6a66, 0x6d55, 0x7000, 0x7000, 0x7000,
  0x4bd0, 0x4be0, 0x4bf0, 0x6666, 0x6955, 0x6c00, 0x6c00, 0x6c00,
  0x47d0, 0x47e0, 0x47f0, 0x6266, 0x6555, 0x6800, 0x6800, 0x6800,
  0x43d0, 0x43e0, 0x43f0, 0x5e66, 0x6155, 0x6400, 0x6400, 0x6400,
  0x3fd0, 0x3fe0, 0x3ff0, 0x5a66, 0x5d55, 0x6000, 0x6000, 0x6000,
  0x3bd0, 0x3be0, 0x3bf0, 0x5666, 0x5955, 0x5c00, 0x5c00, 0x5c00,
  0x37d0, 0x37e0, 0x37f0, 0x5266, 0x5555, 0x5800, 0x5800, 0x5800,
  0x33d0, 0x33e0, 0x33f0, 0x4e66, 0x5155, 0x5400, 0x5400, 0x5400,
  0x2fd0, 0x2fe0, 0x2ff0, 0x4a66, 0x4d55, 0x5000, 0x5000, 0x5000,
  0x2bd0, 0x2be0, 0x2bf0, 0x4666, 0x4955, 0x4c00, 0x4c00, 0x4c00,
  0x27d0, 0x27e0, 0x27f0, 0x4266, 0x4555, 0x4800, 0x4800, 0x4800,
  0x23d0, 0x23e0, 0x23f0, 0x3e66, 0x4155, 0x4400, 0x4400, 0x4400,
  0x1fd0, 0x1fe0, 0x1ff0, 0x3a66, 0x3d55, 0x4000, 0x4000, 0x4000,
  0x1bd0, 0x1be0, 0x1bf0, 0x3666, 0x3955, 0x3c00, 0x3c00, 0x3c00,
  0x17d0, 0x17e0, 0x17f0, 0x3266, 0x3555, 0x3800, 0x3800, 0x3800,
  0x57e0, 0x57f0, 0x7266, 0x7555, 0x7800, 0x7800, 0x7800, 0x7800,
  0x53e0, 0x53f0, 0x6e66, 0x7155, 0x7400, 0x7400, 0x7400, 0x7400,
  0x4fe0, 0x4ff0, 0x6a66, 0x6d55, 0x7000, 0x7000, 0x7000, 0x7000,
  0x4be0, 0x4bf0, 0x6666, 0x6955, 0x6c00, 0x6c00, 0x6c00, 0x6c00,
  0x47e0, 0x47f0, 0x6266, 0x6555, 0x6800, 0x6800, 0x6800, 0x6800,
  0x43e0, 0x43f0, 0x5e66, 0x6155, 0x6400, 0x6400, 0x6400, 0x6400,
  0x3fe0, 0x3ff0, 0x5a66, 0x5d55, 0x6000, 0x6000, 0x6000, 0x6000,
  0x3be0, 0x3bf0, 0x5666, 0x5955, 0x5c00, 0x5c00, 0x5c00, 0x5c00,
  0x37e0, 0x37f0, 0x5266, 0x5555, 0x5800, 0x5800, 0x5800, 0x5800,
  0x33e0, 0x33f0, 0x4e66, 0x5155, 0x5400, 0x5400, 0x5400, 0x5400,
  0x2fe0, 0x2ff0, 0x4a66, 0x4d55, 0x5000, 0x5000, 0x5000, 0x5000,
  0x2be0, 0x2bf0, 0x4666, 0x4955, 0x4c00, 0x4c00, 0x4c00, 0x4c00,
  0x27e0, 0x27f0, 0x4266, 0x4555, 0x4800, 0x4800, 0x4800, 0x4800,
  0x23e0, 0x23f0, 0x3e66, 0x4155, 0x4400, 0x4400, 0x4400, 0x4400,
  0x1fe0, 0x1ff0, 0x3a66, 0x3d55, 0x4000, 0x4000, 0x4000, 0x4000,
  0x1be0, 0x1bf0, 0x3666, 0x3955, 0x3c00, 0x3c00, 0x3c00, 0x3c00,
  0x17e0, 0x17f0, 0x3266, 0x3555, 0x3800, 0x3800, 0x3800, 0x3800,
  0x57f0, 0x7266, 0x7555, 0x7800, 0x7800, 0x7800, 0x7800, 0x7800,
  0x53f0, 0x6e66, 0x7155, 0x7400, 0x7400, 0x7400, 0x7400, 0x7400,
  0x4ff0, 0x6a66, 0x6d55, 0x7000, 0x7000, 0x7000, 0x7000, 0x7000,
  0x4bf0, 0x6666, 0x6955, 0x6c00, 0x6c00, 0x6c00, 0x6c00, 0x6c00,
  0x47f0, 0x6266, 0x6555, 0x6800, 0x6800, 0x6800, 0x6800, 0x6800,
  0x43f0, 0x5e66, 0x6155, 0x6400, 0x6400, 0x6400, 0x6400, 0x6400,
  0x3ff0, 0x5a66, 0x5d55, 0x6000, 0x6000, 0x6000, 0x6000, 0x6000,
  0x3bf0, 0x5666, 0x5955, 0x5c00, 0x5c00, 0x5c00, 0x5c00, 0x5c00,
  0x37f0, 0x5266, 0x5555, 0x5800, 0x5800, 0x5800, 0x5800, 0x5800,
  0x33f0, 0x4e66, 0x5155, 0x5400, 0x5400, 0x5400, 0x5400, 0x5400,
  0x2ff0, 0x4a66, 0x4d55, 0x5000, 0x5000, 0x5000, 0x5000, 0x5000,
  0x2bf0, 0x4666, 0x4955, 0x4c00, 0x4c00, 0x4c00, 0x4c00, 0x4c00,
  0x27f0, 0x4266, 0x4555, 0x4800, 0x4800, 0x4800, 0x4800, 0x4800,
  0x23f0, 0x3e66, 0x4155, 0x4400, 0x4400, 0x4400, 0x4400, 0x4400,
  0x1ff0, 0x3a66, 0x3d55, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000,
  0x1bf0, 0x3666, 0x3955, 0x3c00, 0x3c00, 0x3c00, 0x3c00, 0x3c00,
  0x17f0, 0x3266, 0x3555, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800,
  0x7266, 0x7555, 0x7800, 0x7800, 0x7800, 0x7800, 0x7800, 0x7955,
  0x6e66, 0x7155, 0x7400, 0x7400, 0x7400, 0x7400, 0x7400, 0x7555,
  0x6a66, 0x6d55, 0x7000, 0x7000, 0x7000, 0x7000, 0x7000, 0x7155,
  0x6666, 0x6955, 0x6c00, 0x6c00, 0x6c00, 0x6c00, 0x6c00, 0x6d55,
  0x6266, 0x6555, 0x6800, 0x6800, 0x6800, 0x6800, 0x6800, 0x6955,
  0x5e66, 0x6155, 0x6400, 0x6400, 0x6400, 0x6400, 0x6400, 0x6555,
  0x5a66, 0x5d55, 0x6000, 0x6000, 0x6000, 0x6000, 0x6000, 0x6155,
  0x5666, 0x5955, 0x5c00, 0x5c00, 0x5c00, 0x5c00, 0x5c00, 0x5d55,
  0x5266, 0x5555, 0x5800, 0x5800, 0x5800, 0x5800, 0x5800, 0x5955,
  0x4e66, 0x5155, 0x5400, 0x5400, 0x5400, 0x5400, 0x5400, 0x5555,
  0x4a66, 0x4d55, 0x5000, 0x5000, 0x5000, 0x5000, 0x5000, 0x5155,
  0x4666, 0x4955, 0x4c00, 0x4c00, 0x4c00, 0x4c00, 0x4c00, 0x4d55,
  0x4266, 0x4555, 0x4800, 0x4800, 0x4800, 0x4800, 0x4800, 0x4955,
  0x3e66, 0x4155, 0x4400, 0x4400, 0x4400, 0x4400, 0x4400, 0x4555,
  0x3a66, 0x3d55, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4155,
  0x3666, 0x3955, 0x3c00, 0x3c00, 0x3c00, 0x3c00, 0x3c00, 0x3d55,
  0x3266, 0x3555, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3955,
  0x7555, 0x7800, 0x7800, 0x7800, 0x7800, 0x7800, 0x7955, 0x7a66,
  0x7155, 0x7400, 0x7400, 0x7400, 0x7400, 0x7400, 0x7555, 0x7666,
  0x6d55, 0x7000, 0x7000, 0x7000, 0x7000, 0x7000, 0x7155, 0x7266,
  0x6955, 0x6c00, 0x6c00, 0x6c00, 0x6c00, 0x6c00, 0x6d55, 0x6e66,
  0x6555, 0x6800, 0x6800, 0x6800, 0x6800, 0x6800, 0x6955, 0x6a66,
  0x6155, 0x6400, 0x6400, 0x6400, 0x6400, 0x6400, 0x6555, 0x6666,
  0x5d55, 0x6000, 0x6000, 0x6000, 0x6000, 0x6000, 0x6155, 0x6266,
  0x5955, 0x5c00, 0x5c00, 0x5c00, 0x5c00, 0x5c00, 0x5d55, 0x5e66,
  0x5555, 0x5800, 0x5800, 0x5800, 0x5800, 0x5800, 0x5955, 0x5a66,
  0x5155, 0x5400, 0x5400, 0x5400, 0x5400, 0x5400, 0x5555, 0x5666,
  0x4d55, 0x5000, 0x5000, 0x5000, 0x5000, 0x5000, 0x5155, 0x5266,
  0x4955, 0x4c00, 0x4c00, 0x4c00, 0x4c00, 0x4c00, 0x4d55, 0x4e66,
  0x4555, 0x4800, 0x4800, 0x4800, 0x4800, 0x4800, 0x4955, 0x4a66,
  0x4155, 0x4400, 0x4400, 0x4400, 0x4400, 0x4400, 0x4555, 0x4666,
  0x3d55, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4155, 0x4266,
  0x3955, 0x3c00, 0x3c00, 0x3c00, 0x3c00, 0x3c00, 0x3d55, 0x3e66,
  0x3555, 0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3955, 0x3a66,
  0x7800, 0x7800, 0x7800, 0x7800, 0x7800, 0x7955, 0x7a66, 0x7bfc,
  0x7400, 0x7400, 0x7400, 0x7400, 0x7400, 0x7555, 0x7666, 0x77fc,
  0x7000, 0x7000, 0x7000, 0x7000, 0x7000, 0x7155, 0x7266, 0x73fc,
  0x6c00, 0x6c00, 0x6c00, 0x6c00, 0x6c00, 0x6d55, 0x6e66, 0x6ffc,
  0x6800, 0x6800, 0x6800, 0x6800, 0x6800, 0x6955, 0x6a66, 0x6bfc,
  0x6400, 0x6400, 0x6400, 0x6400, 0x6400, 0x6555, 0x6666, 0x67fc,
  0x6000, 0x6000, 0x6000, 0x6000, 0x6000, 0x6155, 0x6266, 0x63fc,
  0x5c00, 0x5c00, 0x5c00, 0x5c00, 0x5c00, 0x5d55, 0x5e66, 0x5ffc,
  0x5800, 0x5800, 0x5800, 0x5800, 0x5800, 0x5955, 0x5a66, 0x5bfc,
  0x5400, 0x5400, 0x5400, 0x5400, 0x5400, 0x5555, 0x5666, 0x57fc,
  0x5000, 0x5000, 0x5000, 0x5000, 0x5000, 0x5155, 0x5266, 0x53fc,
  0x4c00, 0x4c00, 0x4c00, 0x4c00, 0x4c00, 0x4d55, 0x4e66, 0x4ffc,
  0x4800, 0x4800, 0x4800, 0x4800, 0x4800, 0x4955, 0x4a66, 0x4bfc,
  0x4400, 0x4400, 0x4400, 0x4400, 0x4400, 0x4555, 0x4666, 0x47fc,
  0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4155, 0x4266, 0x43fc,
  0x3c00, 0x3c00, 0x3c00, 0x3c00, 0x3c00, 0x3d55, 0x3e66, 0x3ffc,
  0x3800, 0x3800, 0x3800, 0x3800, 0x3800, 0x3955, 0x3a66, 0x3bfc,
  0x7800, 0x7800, 0x7800, 0x7800, 0x7955, 0x7a66, 0x7bfc, 0x7bfc,
  0x7400, 0x7400, 0x7400, 0x7400, 0x7555, 0x7666, 0x77fc, 0x77fc,
  0x7000, 0x7000, 0x7000, 0x7000, 0x7155, 0x7266, 0x73fc, 0x73fc,
  0x6c00, 0x6c00, 0x6c00, 0x6c00, 0x6d55, 0x6e66, 0x6ffc, 0x6ffc,
  0x6800, 0x6800, 0x6800, 0x6800, 0x6955, 0x6a66, 0x6bfc, 0x6bfc,
  0x6400, 0x6400, 0x6400, 0x6400, 0x6555, 0x6666, 0x67fc, 0x67fc,
  0x6000, 0x6000, 0x6000, 0x6000, 0x6155, 0x6266, 0x63fc, 0x63fc,
  0x5c00, 0x5c00, 0x5c00, 0x5c00, 0x5d55, 0x5e66, 0x5ffc, 0x5ffc,
  0x5800, 0x5800, 0x5800, 0x5800, 0x5955, 0x5a66, 0x5bfc, 0x5bfc,
  0x5400, 0x5400, 0x5400, 0x5400, 0x5555, 0x5666, 0x57fc, 0x57fc,
  0x5000, 0x5000, 0x5000, 0x5000, 0x5155, 0x5266, 0x53fc, 0x53fc,
  0x4c00, 0x4c00, 0x4c00, 0x4c00, 0x4d55, 0x4e66, 0x4ffc, 0x4ffc,
  0x4800, 0x4800, 0x4800, 0x4800, 0x4955, 0x4a66, 0x4bfc, 0x4bfc,
  0x4400, 0x4400, 0x4400, 0x4400, 0x4555, 0x4666, 0x47fc, 0x47fc,
  0x4000, 0x4000, 0x4000, 0x4000, 0x4155, 0x4266, 0x43fc, 0x43fc,
  0x3c00, 0x3c00, 0x3c00, 0x3c00, 0x3d55, 0x3e66, 0x3ffc, 0x3ffc,
  0x3800, 0x3800, 0x3800, 0x3800, 0x3955, 0x3a66, 0x3bfc, 0x3bfc,
  0x7800, 0x7800, 0x7800, 0x7955, 0x7a66, 0x7bfc, 0x7bfc, 0x7bfc,
  0x7400, 0x7400, 0x7400, 0x7555, 0x7666, 0x77fc, 0x77fc, 0x77fc,
  0x7000, 0x7000, 0x7000, 0x7155, 0x7266, 0x73fc, 0x73fc, 0x73fc,
  0x6c00, 0x6c00, 0x6c00, 0x6d55, 0x6e66, 0x6ffc, 0x6ffc, 0x6ffc,
  0x6800, 0x6800, 0x6800, 0x6955, 0x6a66, 0x6bfc, 0x6bfc, 0x6bfc,
  0x6400, 0x6400, 0x6400, 0x6555, 0x6666, 0x67fc, 0x67fc, 0x67fc,
  0x6000, 0x6000, 0x6000, 0x6155, 0x6266, 0x63fc, 0x63fc, 0x63fc,
  0x5c00, 0x5c00, 0x5c00, 0x5d55, 0x5e66, 0x5ffc, 0x5ffc, 0x5ffc,
  0x5800, 0x5800, 0x5800, 0x5955, 0x5a66, 0x5bfc, 0x5bfc, 0x5bfc,
  0x5400, 0x5400, 0x5400, 0x5555, 0x5666, 0x57fc, 0x57fc, 0x57fc,
  0x5000, 0x5000, 0x5000, 0x5155, 0x5266, 0x53fc, 0x53fc, 0x53fc,
  0x4c00, 0x4c00, 0x4c00, 0x4d55, 0x4e66, 0x4ffc, 0x4ffc, 0x4ffc,
  0x4800, 0x4800, 0x4800, 0x4955, 0x4a66, 0x4bfc, 0x4bfc, 0x4bfc,
  0x4400, 0x4400, 0x4400, 0x4555, 0x4666, 0x47fc, 0x47fc, 0x47fc,
  0x4000, 0x4000, 0x4000, 0x4155, 0x4266, 0x43fc, 0x43fc, 0x43fc,
  0x3c00, 0x3c00, 0x3c00, 0x3d55, 0x3e66, 0x3ffc, 0x3ffc, 0x3ffc,
  0x3800, 0x3800, 0x3800, 0x3955, 0x3a66, 0x3bfc, 0x3bfc, 0x3bfc,
  0x7800, 0x7800, 0x7955, 0x7a66, 0x7bfc, 0x7bfc, 0x7bfc, 0x7bfc,
  0x7400, 0x7400, 0x7555, 0x7666, 0x77fc, 0x77fc, 0x77fc, 0x77fc,
  0x7000, 0x7000, 0x7155, 0x7266, 0x73fc, 0x73fc, 0x73fc, 0x73fc,
  0x6c00, 0x6c00, 0x6d55, 0x6e66, 0x6ffc, 0x6ffc, 0x6ffc, 0x6ffc,
  0x6800, 0x6800, 0x6955, 0x6a66, 0x6bfc, 0x6bfc, 0x6bfc, 0x6bfc,
  0x6400, 0x6400, 0x6555, 0x6666, 0x67fc, 0x67fc, 0x67fc, 0x67fc,
  0x6000, 0x6000, 0x6155, 0x6266, 0x63fc, 0x63fc, 0x63fc, 0x63fc,
  0x5c00, 0x5c00, 0x5d55, 0x5e66, 0x5ffc, 0x5ffc, 0x5ffc, 0x5ffc,
  0x5800, 0x5800, 0x5955, 0x5a66, 0x5bfc, 0x5bfc, 0x5bfc, 0x5bfc,
  0x5400, 0x5400, 0x5555, 0x5666, 0x57fc, 0x57fc, 0x57fc, 0x57fc,
  0x5000, 0x5000, 0x5155, 0x5266, 0x53fc, 0x53fc, 0x53fc, 0x53fc,
  0x4c00, 0x4c00, 0x4d55, 0x4e66, 0x4ffc, 0x4ffc, 0x4ffc, 0x4ffc,
  0x4800, 0x4800, 0x4955, 0x4a66, 0x4bfc, 0x4bfc, 0x4bfc, 0x4bfc,
  0x4400, 0x4400, 0x4555, 0x4666, 0x47fc, 0x47fc, 0x47fc, 0x47fc,
  0x4000, 0x4000, 0x4155, 0x4266, 0x43fc, 0x43fc, 0x43fc, 0x43fc,
  0x3c00, 0x3c00, 0x3d55, 0x3e66, 0x3ffc, 0x3ffc, 0x3ffc, 0x3ffc,
  0x3800, 0x3800, 0x3955, 0x3a66, 0x3bfc, 0x3bfc, 0x3bfc, 0x3bfc,
  0x7800, 0x7955, 0x7a66, 0x7bfc, 0x7bfc, 0x7bfc, 0x7bfc, 0x7c00,
  0x7400, 0x7555, 0x7666, 0x77fc, 0x77fc, 0x77fc, 0x77fc, 0x7800,
  0x7000, 0x7155, 0x7266, 0x73fc, 0x73fc, 0x73fc, 0x73fc, 0x7400,
  0x6c00, 0x6d55, 0x6e66, 0x6ffc, 0x6ffc, 0x6ffc, 0x6ffc, 0x7000,
  0x6800, 0x6955, 0x6a66, 0x6bfc, 0x6bfc, 0x6bfc, 0x6bfc, 0x6c00,
  0x6400, 0x6555, 0x6666, 0x67fc, 0x67fc, 0x67fc, 0x67fc, 0x6800,
  0x6000, 0x6155, 0x6266, 0x63fc, 0x63fc, 0x63fc, 0x63fc, 0x6400,
  0x5c00, 0x5d55, 0x5e66, 0x5ffc, 0x5ffc, 0x5ffc, 0x5ffc, 0x6000,
  0x5800, 0x5955, 0x5a66, 0x5bfc, 0x5bfc, 0x5bfc, 0x5bfc, 0x5c00,
  0x5400, 0x5555, 0x5666, 0x57fc, 0x57fc, 0x57fc, 0x57fc, 0x5800,
  0x5000, 0x5155, 0x5266, 0x53fc, 0x53fc, 0x53fc, 0x53fc, 0x5400,
  0x4c00, 0x4d55, 0x4e66, 0x4ffc, 0x4ffc, 0x4ffc, 0x4ffc, 0x5000,
  0x4800, 0x4955, 0x4a66, 0x4bfc, 0x4bfc, 0x4bfc, 0x4bfc, 0x4c00,
  0x4400, 0x4555, 0x4666, 0x47fc, 0x47fc, 0x47fc, 0x47fc, 0x4800,
  0x4000, 0x4155, 0x4266, 0x43fc, 0x43fc, 0x43fc, 0x43fc, 0x4400,
  0x3c00, 0x3d55, 0x3e66, 0x3ffc, 0x3ffc, 0x3ffc, 0x3ffc, 0x4000,
  0x3800, 0x3955, 0x3a66, 0x3bfc, 0x3bfc, 0x3bfc, 0x3bfc, 0x3c00,
  0x7955, 0x7a66, 0x7bfc, 0x7bfc, 0x7bfc, 0x7bfc, 0x7c00, 0x7c00,
  0x7555, 0x7666, 0x77fc, 0x77fc, 0x77fc, 0x77fc, 0x7800, 0x7800,
  0x7155, 0x7266, 0x73fc, 0x73fc, 0x73fc, 0x73fc, 0x7400, 0x7400,
  0x6d55, 0x6e66, 0x6ffc, 0x6ffc, 0x6ffc, 0x6ffc, 0x7000, 0x7000,
  0x6955, 0x6a66, 0x6bfc, 0x6bfc, 0x6bfc, 0x6bfc, 0x6c00, 0x6c00,
  0x6555, 0x6666, 0x67fc, 0x67fc, 0x67fc, 0x67fc, 0x6800, 0x6800,
  0x6155, 0x6266, 0x63fc, 0x63fc, 0x63fc, 0x63fc, 0x6400, 0x6400,
  0x5d55, 0x5e66, 0x5ffc, 0x5ffc, 0x5ffc, 0x5ffc, 0x6000, 0x6000,
  0x5955, 0x5a66, 0x5bfc, 0x5bfc, 0x5bfc, 0x5bfc, 0x5c00, 0x5c00,
  0x5555, 0x5666, 0x57fc, 0x57fc, 0x57fc, 0x57fc, 0x5800, 0x5800,
  0x5155, 0x5266, 0x53fc, 0x53fc, 0x53fc, 0x53fc, 0x5400, 0x5400,
  0x4d55, 0x4e66, 0x4ffc, 0x4ffc, 0x4ffc, 0x4ffc, 0x5000, 0x5000,
  0x4955, 0x4a66, 0x4bfc, 0x4bfc, 0x4bfc, 0x4bfc, 0x4c00, 0x4c00,
  0x4555, 0x4666, 0x47fc, 0x47fc, 0x47fc, 0x47fc, 0x4800, 0x4800,
  0x4155, 0x4266, 0x43fc, 0x43fc, 0x43fc, 0x43fc, 0x4400, 0x4400,
  0x3d55, 0x3e66, 0x3ffc, 0x3ffc, 0x3ffc, 0x3ffc, 0x4000, 0x4000,
  0x3955, 0x3a66, 0x3bfc, 0x3bfc, 0x3bfc, 0x3bfc, 0x3c00, 0x3c00,
  0x7a66, 0x7bfc, 0x7bfc, 0x7bfc, 0x7bfc, 0x7c00, 0x7c00, 0x7c00,
  0x7666, 0x77fc, 0x77fc, 0x77fc, 0x77fc, 0x7800, 0x7800, 0x7800,
  0x7266, 0x73fc, 0x73fc, 0x73fc, 0x73fc, 0x7400, 0x7400, 0x7400,
  0x6e66, 0x6ffc, 0x6ffc, 0x6ffc, 0x6ffc, 0x7000, 0x7000, 0x7000,
  0x6a66, 0x6bfc, 0x6bfc, 0x6bfc, 0x6bfc, 0x6c00, 0x6c00, 0x6c00,
  0x6666, 0x67fc, 0x67fc, 0x67fc, 0x67fc, 0x6800, 0x6800, 0x6800,
  0x6266, 0x63fc, 0x63fc, 0x63fc, 0x63fc, 0x6400, 0x6400, 0x6400,
  0x5e66, 0x5ffc, 0x5ffc, 0x5ffc, 0x5ffc, 0x6000, 0x6000, 0x6000,
  0x5a66, 0x5bfc, 0x5bfc, 0x5bfc, 0x5bfc, 0x5c00, 0x5c00, 0x5c00,
  0x5666, 0x57fc, 0x57fc, 0x57fc, 0x57fc, 0x5800, 0x5800, 0x5800,
  0x5266, 0x53fc, 0x53fc, 0x53fc, 0x53fc, 0x5400, 0x5400, 0x5400,
  0x4e66, 0x4ffc, 0x4ffc, 0x4ffc, 0x4ffc, 0x5000, 0x5000, 0x5000,
  0x4a66, 0x4bfc, 0x4bfc, 0x4bfc, 0x4bfc, 0x4c00, 0x4c00, 0x4c00,
  0x4666, 0x47fc, 0x47fc, 0x47fc, 0x47fc, 0x4800, 0x4800, 0x4800,
  0x4266, 0x43fc, 0x43fc, 0x43fc, 0x43fc, 0x4400, 0x4400, 0x4400,
  0x3e66, 0x3ffc, 0x3ffc, 0x3ffc, 0x3ffc, 0x4000, 0x4000, 0x4000,
  0x3a66, 0x3bfc, 0x3bfc, 0x3bfc, 0x3bfc, 0x3c00, 0x3c00, 0x3c00,
  0x7bfc, 0x7bfc, 0x7bfc, 0x7bfc, 0x7c00, 0x7c00, 0x7c00, 0x7c00,
  0x77fc, 0x77fc, 0x77fc, 0x77fc, 0x7800, 0x7800, 0x7800, 0x7800,
  0x73fc, 0x73fc, 0x73fc, 0x73fc, 0x7400, 0x7400, 0x7400, 0x7400,
  0x6ffc, 0x6ffc, 0x6ffc, 0x6ffc, 0x7000, 0x7000, 0x7000, 0x7000,
  0x6bfc, 0x6bfc, 0x6bfc, 0x6bfc, 0x6c00, 0x6c00, 0x6c00, 0x6c00,
  0x67fc, 0x67fc, 0x67fc, 0x67fc, 0x6800, 0x6800, 0x6800, 0x6800,
  0x63fc, 0x63fc, 0x63fc, 0x63fc, 0x6400, 0x6400, 0x6400, 0x6400,
  0x5ffc, 0x5ffc, 0x5ffc, 0x5ffc, 0x6000, 0x6000, 0x6000, 0x6000,
  0x5bfc, 0x5bfc, 0x5bfc, 0x5bfc, 0x5c00, 0x5c00, 0x5c00, 0x5c00,
  0x57fc, 0x57fc, 0x57fc, 0x57fc, 0x5800, 0x5800, 0x5800, 0x5800,
  0x53fc, 0x53fc, 0x53fc, 0x53fc, 0x5400, 0x5400, 0x5400, 0x5400,
  0x4ffc, 0x4ffc, 0x4ffc, 0x4ffc, 0x5000, 0x5000, 0x5000, 0x5000,
  0x4bfc, 0x4bfc, 0x4bfc, 0x4bfc, 0x4c00, 0x4c00, 0x4c00, 0x4c00,
  0x47fc, 0x47fc, 0x47fc, 0x47fc, 0x4800, 0x4800, 0x4800, 0x4800,
  0x43fc, 0x43fc, 0x43fc, 0x43fc, 0x4400, 0x4400, 0x4400, 0x4400,
  0x3ffc, 0x3ffc, 0x3ffc, 0x3ffc, 0x4000, 0x4000, 0x4000, 0x4000,
  0x3bfc, 0x3bfc, 0x3bfc, 0x3bfc, 0x3c00, 0x3c00, 0x3c00, 0x3c00,
  0x7bfc, 0x7bfc, 0x7bfc, 0x7c00, 0x7c00, 0x7c00, 0x7c00, 0x0000,
  0x77fc, 0x77fc, 0x77fc, 0x7800, 0x7800, 0x7800, 0x7800, 0x0000,
  0x73fc, 0x73fc, 0x73fc, 0x7400, 0x7400, 0x7400, 0x7400, 0x0000,
  0x6ffc, 0x6ffc, 0x6ffc, 0x7000, 0x7000, 0x7000, 0x7000, 0x0000,
  0x6bfc, 0x6bfc, 0x6bfc, 0x6c00, 0x6c00, 0x6c00, 0x6c00, 0x0000,
  0x67fc, 0x67fc, 0x67fc, 0x6800, 0x6800, 0x6800, 0x6800, 0x0000,
  0x63fc, 0x63fc, 0x63fc, 0x6400, 0x6400, 0x6400, 0x6400, 0x0000,
  0x5ffc, 0x5ffc, 0x5ffc, 0x6000, 0x6000, 0x6000, 0x6000, 0x0000,
  0x5bfc, 0x5bfc, 0x5bfc, 0x5c00, 0x5c00, 0x5c00, 0x5c00, 0x0000,
  0x57fc, 0x57fc, 0x57fc, 0x5800, 0x5800, 0x5800, 0x5800, 0x0000,
  0x53fc, 0x53fc, 0x53fc, 0x5400, 0x5400, 0x5400, 0x5400, 0x0000,
  0x4ffc, 0x4ffc, 0x4ffc, 0x5000, 0x5000, 0x5000, 0x5000, 0x0000,
  0x4bfc, 0x4bfc, 0x4bfc, 0x4c00, 0x4c00, 0x4c00, 0x4c00, 0x0000,
  0x47fc, 0x47fc, 0x47fc, 0x4800, 0x4800, 0x4800, 0x4800, 0x0000,
  0x43fc, 0x43fc, 0x43fc, 0x4400, 0x4400, 0x4400, 0x4400, 0x0000,
  0x3ffc, 0x3ffc, 0x3ffc, 0x4000, 0x4000, 0x4000, 0x4000, 0x0000,
  0x3bfc, 0x3bfc, 0x3bfc, 0x3c00, 0x3c00, 0x3c00, 0x3c00, 0x0000,
  0x7bfc, 0x7bfc, 0x7c00, 0x7c00, 0x7c00, 0x7c00, 0x0000, 0x3c00,
  0x77fc, 0x77fc, 0x7800, 0x7800, 0x7800, 0x7800, 0x0000, 0x3800,
  0x73fc, 0x73fc, 0x7400, 0x7400, 0x7400, 0x7400, 0x0000, 0x3400,
  0x6ffc, 0x6ffc, 0x7000, 0x7000, 0x7000, 0x7000, 0x0000, 0x3000,
  0x6bfc, 0x6bfc, 0x6c00, 0x6c00, 0x6c00, 0x6c00, 0x0000, 0x2c00,
  0x67fc, 0x67fc, 0x6800, 0x6800, 0x6800, 0x6800, 0x0000, 0x2800,
  0x63fc, 0x63fc, 0x6400, 0x6400, 0x6400, 0x6400, 0x0000, 0x2400,
  0x5ffc, 0x5ffc, 0x6000, 0x6000, 0x6000, 0x6000, 0x0000, 0x2000,
  0x5bfc, 0x5bfc, 0x5c00, 0x5c00, 0x5c00, 0x5c00, 0x0000, 0x1c00,
  0x57fc, 0x57fc, 0x5800, 0x5800, 0x5800, 0x5800, 0x0000, 0x1800,
  0x53fc, 0x53fc, 0x5400, 0x5400, 0x5400, 0x5400, 0x0000, 0x1400,
  0x4ffc, 0x4ffc, 0x5000, 0x5000, 0x5000, 0x5000, 0x0000, 0x1000,
  0x4bfc, 0x4bfc, 0x4c00, 0x4c00, 0x4c00, 0x4c00, 0x0000, 0x0c00,
  0x47fc, 0x47fc, 0x4800, 0x4800, 0x4800, 0x4800, 0x0000, 0x0800,
  0x43fc, 0x43fc, 0x4400, 0x4400, 0x4400, 0x4400, 0x0000, 0x0400,
  0x3ffc, 0x3ffc, 0x4000, 0x4000, 0x4000, 0x4000, 0x0000, 0x0200,
  0x3bfc, 0x3bfc, 0x3c00, 0x3c00, 0x3c00, 0x3c00, 0x0000, 0x0100,
  0x7bfc, 0x7c00, 0x7c00, 0x7c00, 0x7c00, 0x0000, 0x3c00, 0x6400,
  0x77fc, 0x7800, 0x7800, 0x7800, 0x7800, 0x0000, 0x3800, 0x6000,
  0x73fc, 0x7400, 0x7400, 0x7400, 0x7400, 0x0000, 0x3400, 0x5c00,
  0x6ffc, 0x7000, 0x7000, 0x7000, 0x7000, 0x0000, 0x3000, 0x5800,
  0x6bfc, 0x6c00, 0x6c00, 0x6c00, 0x6c00, 0x0000, 0x2c00, 0x5400,
  0x67fc, 0x6800, 0x6800, 0x6800, 0x6800, 0x0000, 0x2800, 0x5000,
  0x63fc, 0x6400, 0x6400, 0x6400, 0x6400, 0x0000, 0x2400, 0x4c00,
  0x5ffc, 0x6000, 0x6000, 0x6000, 0x6000, 0x0000, 0x2000, 0x4800,
  0x5bfc, 0x5c00, 0x5c00, 0x5c00, 0x5c00, 0x0000, 0x1c00, 0x4400,
  0x57fc, 0x5800, 0x5800, 0x5800, 0x5800, 0x0000, 0x1800, 0x4000,
  0x53fc, 0x5400, 0x5400, 0x5400, 0x5400, 0x0000, 0x1400, 0x3c00,
  0x4ffc, 0x5000, 0x5000, 0x5000, 0x5000, 0x0000, 0x1000, 0x3800,
  0x4bfc, 0x4c00, 0x4c00, 0x4c00, 0x4c00, 0x0000, 0x0c00, 0x3400,
  0x47fc, 0x4800, 0x4800, 0x4800, 0x4800, 0x0000, 0x0800, 0x3000,
  0x43fc, 0x4400, 0x4400, 0x4400, 0x4400, 0x0000, 0x0400, 0x2c00,
  0x3ffc, 0x4000, 0x4000, 0x4000, 0x4000, 0x0000, 0x0200, 0x2800,
  0x3bfc, 0x3c00, 0x3c00, 0x3c00, 0x3c00, 0x0000, 0x0100, 0x2400,
  0x7c00, 0x7c00, 0x7c00, 0x7c00, 0x0000, 0x3c00, 0x6400, 0x6401,
  0x7800, 0x7800, 0x7800, 0x7800, 0x0000, 0x3800, 0x6000, 0x6001,
  0x7400, 0x7400, 0x7400, 0x7400, 0x0000, 0x3400, 0x5c00, 0x5c01,
  0x7000, 0x7000, 0x7000, 0x7000, 0x0000, 0x3000, 0x5800, 0x5801,
  0x6c00, 0x6c00, 0x6c00, 0x6c00, 0x0000, 0x2c00, 0x5400, 0x5401,
  0x6800, 0x6800, 0x6800, 0x6800, 0x0000, 0x2800, 0x5000, 0x5001,
  0x6400, 0x6400, 0x6400, 0x6400, 0x0000, 0x2400, 0x4c00, 0x4c01,
  0x6000, 0x6000, 0x6000, 0x6000, 0x0000, 0x2000, 0x4800, 0x4801,
  0x5c00, 0x5c00, 0x5c00, 0x5c00, 0x0000, 0x1c00, 0x4400, 0x4401,
  0x5800, 0x5800, 0x5800, 0x5800, 0x0000, 0x1800, 0x4000, 0x4001,
  0x5400, 0x5400, 0x5400, 0x5400, 0x0000, 0x1400, 0x3c00, 0x3c01,
  0x5000, 0x5000, 0x5000, 0x5000, 0x0000, 0x1000, 0x3800, 0x3801,
  0x4c00, 0x4c00, 0x4c00, 0x4c00, 0x0000, 0x0c00, 0x3400, 0x3401,
  0x4800, 0x4800, 0x4800, 0x4800, 0x0000, 0x0800, 0x3000, 0x3001,
  0x4400, 0x4400, 0x4400, 0x4400, 0x0000, 0x0400, 0x2c00, 0x2c01,
  0x4000, 0x4000, 0x4000, 0x4000, 0x0000, 0x0200, 0x2800, 0x2801,
  0x3c00, 0x3c00, 0x3c00, 0x3c00, 0x0000, 0x0100, 0x2400, 0x2401,
  0x7c00, 0x7c00, 0x7c00, 0x0000, 0x3c00, 0x6400, 0x6401, 0x6476,
  0x7800, 0x7800, 0x7800, 0x0000, 0x3800, 0x6000, 0x6001, 0x6076,
  0x7400, 0x7400, 0x7400, 0x0000, 0x3400, 0x5c00, 0x5c01, 0x5c76,
  0x7000, 0x7000, 0x7000, 0x0000, 0x3000, 0x5800, 0x5801, 0x5876,
  0x6c00, 0x6c00, 0x6c00, 0x0000, 0x2c00, 0x5400, 0x5401, 0x5476,
  0x6800, 0x6800, 0x6800, 0x0000, 0x2800, 0x5000, 0x5001, 0x5076,
  0x6400, 0x6400, 0x6400, 0x0000, 0x2400, 0x4c00, 0x4c01, 0x4c76,
  0x6000, 0x6000, 0x6000, 0x0000, 0x2000, 0x4800, 0x4801, 0x4876,
  0x5c00, 0x5c00, 0x5c00, 0x0000, 0x1c00, 0x4400, 0x4401, 0x4476,
  0x5800, 0x5800, 0x5800, 0x0000, 0x1800, 0x4000, 0x4001, 0x4076,
  0x5400, 0x5400, 0x5400, 0x0000, 0x1400, 0x3c00, 0x3c01, 0x3c76,
  0x5000, 0x5000, 0x5000, 0x0000, 0x1000, 0x3800, 0x3801, 0x3876,
  0x4c00, 0x4c00, 0x4c00, 0x0000, 0x0c00, 0x3400, 0x3401, 0x3476,
  0x4800, 0x4800, 0x4800, 0x0000, 0x0800, 0x3000, 0x3001, 0x3076,
  0x4400, 0x4400, 0x4400, 0x0000, 0x0400, 0x2c00, 0x2c01, 0x2c76,
  0x4000, 0x4000, 0x4000, 0x0000, 0x0200, 0x2800, 0x2801, 0x2876,
  0x3c00, 0x3c00, 0x3c00, 0x0000, 0x0100, 0x2400, 0x2401, 0x2476,
  0x7c00, 0x7c00, 0x0000, 0x3c00, 0x6400, 0x6401, 0x6476, 0x6800,
  0x7800, 0x7800, 0x0000, 0x3800, 0x6000, 0x6001, 0x6076, 0x6400,
  0x7400, 0x7400, 0x0000, 0x3400, 0x5c00, 0x5c01, 0x5c76, 0x6000,
  0x7000, 0x7000, 0x0000, 0x3000, 0x5800, 0x5801, 0x5876, 0x5c00,
  0x6c00, 0x6c00, 0x0000, 0x2c00, 0x5400, 0x5401, 0x5476, 0x5800,
  0x6800, 0x6800, 0x0000, 0x2800, 0x5000, 0x5001, 0x5076, 0x5400,
  0x6400, 0x6400, 0x0000, 0x2400, 0x4c00, 0x4c01, 0x4c76, 0x5000,
  0x6000, 0x6000, 0x0000, 0x2000, 0x4800, 0x4801, 0x4876, 0x4c00,
  0x5c00, 0x5c00, 0x0000, 0x1c00, 0x4400, 0x4401, 0x4476, 0x4800,
  0x5800, 0x5800, 0x0000, 0x1800, 0x4000, 0x4001, 0x4076, 0x4400,
  0x5400, 0x5400, 0x0000, 0x1400, 0x3c00, 0x3c01, 0x3c76, 0x4000,
  0x5000, 0x5000, 0x0000, 0x1000, 0x3800, 0x3801, 0x3876, 0x3c00,
  0x4c00, 0x4c00, 0x0000, 0x0c00, 0x3400, 0x3401, 0x3476, 0x3800,
  0x4800, 0x4800, 0x0000, 0x0800, 0x3000, 0x3001, 0x3076, 0x3400,
  0x4400, 0x4400, 0x0000, 0x0400, 0x2c00, 0x2c01, 0x2c76, 0x3000,
  0x4000, 0x4000, 0x0000, 0x0200, 0x2800, 0x2801, 0x2876, 0x2c00,
  0x3c00, 0x3c00, 0x0000, 0x0100, 0x2400, 0x2401, 0x2476, 0x2800,
  0x7c00, 0x0000, 0x3c00, 0x6400, 0x6401, 0x6476, 0x6800, 0x6800,
  0x7800, 0x0000, 0x3800, 0x6000, 0x6001, 0x6076, 0x6400, 0x6400,
  0x7400, 0x0000, 0x3400, 0x5c00, 0x5c01, 0x5c76, 0x6000, 0x6000,
  0x7000, 0x0000, 0x3000, 0x5800, 0x5801, 0x5876, 0x5c00, 0x5c00,
  0x6c00, 0x0000, 0x2c00, 0x5400, 0x5401, 0x5476, 0x5800, 0x5800,
  0x6800, 0x0000, 0x2800, 0x5000, 0x5001, 0x5076, 0x5400, 0x5400,
  0x6400, 0x0000, 0x2400, 0x4c00, 0x4c01, 0x4c76, 0x5000, 0x5000,
  0x6000, 0x0000, 0x2000, 0x4800, 0x4801, 0x4876, 0x4c00, 0x4c00,
  0x5c00, 0x0000, 0x1c00, 0x4400, 0x4401, 0x4476, 0x4800, 0x4800,
  0x5800, 0x0000, 0x1800, 0x4000, 0x4001, 0x4076, 0x4400, 0x4400,
  0x5400, 0x0000, 0x1400, 0x3c00, 0x3c01, 0x3c76, 0x4000, 0x4000,
  0x5000, 0x0000, 0x1000, 0x3800, 0x3801, 0x3876, 0x3c00, 0x3c00,
  0x4c00, 0x0000, 0x0c00, 0x3400, 0x3401, 0x3476, 0x3800, 0x3800,
  0x4800, 0x0000, 0x0800, 0x3000, 0x3001, 0x3076, 0x3400, 0x3400,
  0x4400, 0x0000, 0x0400, 0x2c00, 0x2c01, 0x2c76, 0x3000, 0x3000,
  0x4000, 0x0000, 0x0200, 0x2800, 0x2801, 0x2876, 0x2c00, 0x2c00,
  0x3c00, 0x0000, 0x0100, 0x2400, 0x2401, 0x2476, 0x2800, 0x2800,
  0x0000, 0x3c00, 0x6400, 0x6401, 0x6476, 0x6800, 0x6800, 0x6a00,
  0x0000, 0x3800, 0x6000, 0x6001, 0x6076, 0x6400, 0x6400, 0x6600,
  0x0000, 0x3400, 0x5c00, 0x5c01, 0x5c76, 0x6000, 0x6000, 0x6200,
  0x0000, 0x3000, 0x5800, 0x5801, 0x5876, 0x5c00, 0x5c00, 0x5e00,
  0x0000, 0x2c00, 0x5400, 0x5401, 0x5476, 0x5800, 0x5800, 0x5a00,
  0x0000, 0x2800, 0x5000, 0x5001, 0x5076, 0x5400, 0x5400, 0x5600,
  0x0000, 0x2400, 0x4c00, 0x4c01, 0x4c76, 0x5000, 0x5000, 0x5200,
  0x0000, 0x2000, 0x4800, 0x4801, 0x4876, 0x4c00, 0x4c00, 0x4e00,
  0x0000, 0x1c00, 0x4400, 0x4401, 0x4476, 0x4800, 0x4800, 0x4a00,
  0x0000, 0x1800, 0x4000, 0x4001, 0x4076, 0x4400, 0x4400, 0x4600,
  0x0000, 0x1400, 0x3c00, 0x3c01, 0x3c76, 0x4000, 0x4000, 0x4200,
  0x0000, 0x1000, 0x3800, 0x3801, 0x3876, 0x3c00, 0x3c00, 0x3e00,
  0x0000, 0x0c00, 0x3400, 0x3401, 0x3476, 0x3800, 0x3800, 0x3a00,
  0x0000, 0x0800, 0x3000, 0x3001, 0x3076, 0x3400, 0x3400, 0x3600,
  0x0000, 0x0400, 0x2c00, 0x2c01, 0x2c76, 0x3000, 0x3000, 0x3200,
  0x0000, 0x0200, 0x2800, 0x2801, 0x2876, 0x2c00, 0x2c00, 0x2e00,
  0x0000, 0x0100, 0x2400, 0x2401, 0x2476, 0x2800, 0x2800, 0x2a00,
  0x3c00, 0x6400, 0x6401, 0x6476, 0x6800, 0x6800, 0x6a00, 0x6a00,
  0x3800, 0x6000, 0x6001, 0x6076, 0x6400, 0x6400, 0x6600, 0x6600,
  0x3400, 0x5c00, 0x5c01, 0x5c76, 0x6000, 0x6000, 0x6200, 0x6200,
  0x3000, 0x5800, 0x5801, 0x5876, 0x5c00, 0x5c00, 0x5e00, 0x5e00,
  0x2c00, 0x5400, 0x5401, 0x5476, 0x5800, 0x5800, 0x5a00, 0x5a00,
  0x2800, 0x5000, 0x5001, 0x5076, 0x5400, 0x5400, 0x5600, 0x5600,
  0x2400, 0x4c00, 0x4c01, 0x4c76, 0x5000, 0x5000, 0x5200, 0x5200,
  0x2000, 0x4800, 0x4801, 0x4876, 0x4c00, 0x4c00, 0x4e00, 0x4e00,
  0x1c00, 0x4400, 0x4401, 0x4476, 0x4800, 0x4800, 0x4a00, 0x4a00,
  0x1800, 0x4000, 0x4001, 0x4076, 0x4400, 0x4400, 0x4600, 0x4600,
  0x1400, 0x3c00, 0x3c01, 0x3c76, 0x4000, 0x4000, 0x4200, 0x4200,
  0x1000, 0x3800, 0x3801, 0x3876, 0x3c00, 0x3c00, 0x3e00, 0x3e00,
  0x0c00, 0x3400, 0x3401, 0x3476, 0x3800, 0x3800, 0x3a00, 0x3a00,
  0x0800, 0x3000, 0x3001, 0x3076, 0x3400, 0x3400, 0x3600, 0x3600,
  0x0400, 0x2c00, 0x2c01, 0x2c76, 0x3000, 0x3000, 0x3200, 0x3200,
  0x0200, 0x2800, 0x2801, 0x2876, 0x2c00, 0x2c00, 0x2e00, 0x2e00,
  0x0100, 0x2400, 0x2401, 0x2476, 0x2800, 0x2800, 0x2a00, 0x2a00,
  0x6400, 0x6401, 0x6476, 0x6800, 0x6800, 0x6a00, 0x6a00, 0x6c00,
  0x6000, 0x6001, 0x6076, 0x6400, 0x6400, 0x6600, 0x6600, 0x6800,
  0x5c00, 0x5c01, 0x5c76, 0x6000, 0x6000, 0x6200, 0x6200, 0x6400,
  0x5800, 0x5801, 0x5876, 0x5c00, 0x5c00, 0x5e00, 0x5e00, 0x6000,
  0x5400, 0x5401, 0x5476, 0x5800, 0x5800, 0x5a00, 0x5a00, 0x5c00,
  0x5000, 0x5001, 0x5076, 0x5400, 0x5400, 0x5600, 0x5600, 0x5800,
  0x4c00, 0x4c01, 0x4c76, 0x5000, 0x5000, 0x5200, 0x5200, 0x5400,
  0x4800, 0x4801, 0x4876, 0x4c00, 0x4c00, 0x4e00, 0x4e00, 0x5000,
  0x4400, 0x4401, 0x4476, 0x4800, 0x4800, 0x4a00, 0x4a00, 0x4c00,
  0x4000, 0x4001, 0x4076, 0x4400, 0x4400, 0x4600, 0x4600, 0x4800,
  0x3c00, 0x3c01, 0x3c76, 0x4000, 0x4000, 0x4200, 0x4200, 0x4400,
  0x3800, 0x3801, 0x3876, 0x3c00, 0x3c00, 0x3e00, 0x3e00, 0x4000,
  0x3400, 0x3401, 0x3476, 0x3800, 0x3800, 0x3a00, 0x3a00, 0x3c00,
  0x3000, 0x3001, 0x3076, 0x3400, 0x3400, 0x3600, 0x3600, 0x3800,
  0x2c00, 0x2c01, 0x2c76, 0x3000, 0x3000, 0x3200, 0x3200, 0x3400,
  0x2800, 0x2801, 0x2876, 0x2c00, 0x2c00, 0x2e00, 0x2e00, 0x3000,
  0x2400, 0x2401, 0x2476, 0x2800, 0x2800, 0x2a00, 0x2a00, 0x2c00,
  0x6401, 0x6476, 0x6800, 0x6800, 0x6a00, 0x6a00, 0x6c00, 0x6c00,
  0x6001, 0x6076, 0x6400, 0x6400, 0x6600, 0x6600, 0x6800, 0x6800,
  0x5c01, 0x5c76, 0x6000, 0x6000, 0x6200, 0x6200, 0x6400, 0x6400,
  0x5801, 0x5876, 0x5c00, 0x5c00, 0x5e00, 0x5e00, 0x6000, 0x6000,
  0x5401, 0x5476, 0x5800, 0x5800, 0x5a00, 0x5a00, 0x5c00, 0x5c00,
  0x5001, 0x5076, 0x5400, 0x5400, 0x5600, 0x5600, 0x5800, 0x5800,
  0x4c01, 0x4c76, 0x5000, 0x5000, 0x5200, 0x5200, 0x5400, 0x5400,
  0x4801, 0x4876, 0x4c00, 0x4c00, 0x4e00, 0x4e00, 0x5000, 0x5000,
  0x4401, 0x4476, 0x4800, 0x4800, 0x4a00, 0x4a00, 0x4c00, 0x4c00,
  0x4001, 0x4076, 0x4400, 0x4400, 0x4600, 0x4600, 0x4800, 0x4800,
  0x3c01, 0x3c76, 0x4000, 0x4000, 0x4200, 0x4200, 0x4400, 0x4400,
  0x3801, 0x3876, 0x3c00, 0x3c00, 0x3e00, 0x3e00, 0x4000, 0x4000,
  0x3401, 0x3476, 0x3800, 0x3800, 0x3a00, 0x3a00, 0x3c00, 0x3c00,
  0x3001, 0x3076, 0x3400, 0x3400, 0x3600, 0x3600, 0x3800, 0x3800,
  0x2c01, 0x2c76, 0x3000, 0x3000, 0x3200, 0x3200, 0x3400, 0x3400,
  0x2801, 0x2876, 0x2c00, 0x2c00, 0x2e00, 0x2e00, 0x3000, 0x3000,
  0x2401, 0x2476, 0x2800, 0x2800, 0x2a00, 0x2a00, 0x2c00, 0x2c00,
  0x6476, 0x6800, 0x6800, 0x6a00, 0x6a00, 0x6c00, 0x6c00, 0x6d00,
  0x6076, 0x6400, 0x6400, 0x6600, 0x6600, 0x6800, 0x6800, 0x6900,
  0x5c76, 0x6000, 0x6000, 0x6200, 0x6200, 0x6400, 0x6400, 0x6500,
  0x5876, 0x5c00, 0x5c00, 0x5e00, 0x5e00, 0x6000, 0x6000, 0x6100,
  0x5476, 0x5800, 0x5800, 0x5a00, 0x5a00, 0x5c00, 0x5c00, 0x5d00,
  0x5076, 0x5400, 0x5400, 0x5600, 0x5600, 0x5800, 0x5800, 0x5900,
  0x4c76, 0x5000, 0x5000, 0x5200, 0x5200, 0x5400, 0x5400, 0x5500,
  0x4876, 0x4c00, 0x4c00, 0x4e00, 0x4e00, 0x5000, 0x5000, 0x5100,
  0x4476, 0x4800, 0x4800, 0x4a00, 0x4a00, 0x4c00, 0x4c00, 0x4d00,
  0x4076, 0x4400, 0x4400, 0x4600, 0x4600, 0x4800, 0x4800, 0x4900,
  0x3c76, 0x4000, 0x4000, 0x4200, 0x4200, 0x4400, 0x4400, 0x4500,
  0x3876, 0x3c00, 0x3c00, 0x3e00, 0x3e00, 0x4000, 0x4000, 0x4100,
  0x3476, 0x3800, 0x3800, 0x3a00, 0x3a00, 0x3c00, 0x3c00, 0x3d00,
  0x3076, 0x3400, 0x3400, 0x3600, 0x3600, 0x3800, 0x3800, 0x3900,
  0x2c76, 0x3000, 0x3000, 0x3200, 0x3200, 0x3400, 0x3400, 0x3500,
  0x2876, 0x2c00, 0x2c00, 0x2e00, 0x2e00, 0x3000, 0x3000, 0x3100,
  0x2476, 0x2800, 0x2800, 0x2a00, 0x2a00, 0x2c00, 0x2c00, 0x2d00,
  0x6800, 0x6800, 0x6a00, 0x6a00, 0x6c00, 0x6c00, 0x6d00, 0x6d00,
  0x6400, 0x6400, 0x6600, 0x6600, 0x6800, 0x6800, 0x6900, 0x6900,
  0x6000, 0x6000, 0x6200, 0x6200, 0x6400, 0x6400, 0x6500, 0x6500,
  0x5c00, 0x5c00, 0x5e00, 0x5e00, 0x6000, 0x6000, 0x6100, 0x6100,
  0x5800, 0x5800, 0x5a00, 0x5a00, 0x5c00, 0x5c00, 0x5d00, 0x5d00,
  0x5400, 0x5400, 0x5600, 0x5600, 0x5800, 0x5800, 0x5900, 0x5900,
  0x5000, 0x5000, 0x5200, 0x5200, 0x5400, 0x5400, 0x5500, 0x5500,
  0x4c00, 0x4c00, 0x4e00, 0x4e00, 0x5000, 0x5000, 0x5100, 0x5100,
  0x4800, 0x4800, 0x4a00, 0x4a00, 0x4c00, 0x4c00, 0x4d00, 0x4d00,
  0x4400, 0x4400, 0x4600, 0x4600, 0x4800, 0x4800, 0x4900, 0x4900,
  0x4000, 0x4000, 0x4200, 0x4200, 0x4400, 0x4400, 0x4500, 0x4500,
  0x3c00, 0x3c00, 0x3e00, 0x3e00, 0x4000, 0x4000, 0x4100, 0x4100,
  0x3800, 0x3800, 0x3a00, 0x3a00, 0x3c00, 0x3c00, 0x3d00, 0x3d00,
  0x3400, 0x3400, 0x3600, 0x3600, 0x3800, 0x3800, 0x3900, 0x3900,
  0x3000, 0x3000, 0x3200, 0x3200, 0x3400, 0x3400, 0x3500, 0x3500,
  0x2c00, 0x2c00, 0x2e00, 0x2e00, 0x3000, 0x3000, 0x3100, 0x3100,
  0x2800, 0x2800, 0x2a00, 0x2a00, 0x2c00, 0x2c00, 0x2d00, 0x2d00,
  0x6800, 0x6a00, 0x6a00, 0x6c00, 0x6c00, 0x6d00, 0x6d00, 0x6e00,
  0x6400, 0x6600, 0x6600, 0x6800, 0x6800, 0x6900, 0x6900, 0x6a00,
  0x6000, 0x6200, 0x6200, 0x6400, 0x6400, 0x6500, 0x6500, 0x6600,
  0x5c00, 0x5e00, 0x5e00, 0x6000, 0x6000, 0x6100, 0x6100, 0x6200,
  0x5800, 0x5a00, 0x5a00, 0x5c00, 0x5c00, 0x5d00, 0x5d00, 0x5e00,
  0x5400, 0x5600, 0x5600, 0x5800, 0x5800, 0x5900, 0x5900, 0x5a00,
  0x5000, 0x5200, 0x5200, 0x5400, 0x5400, 0x5500, 0x5500, 0x5600,
  0x4c00, 0x4e00, 0x4e00, 0x5000, 0x5000, 0x5100, 0x5100, 0x5200,
  0x4800, 0x4a00, 0x4a00, 0x4c00, 0x4c00, 0x4d00, 0x4d00, 0x4e00,
  0x4400, 0x4600, 0x4600, 0x4800, 0x4800, 0x4900, 0x4900, 0x4a00,
  0x4000, 0x4200, 0x4200, 0x4400, 0x4400, 0x4500, 0x4500, 0x4600,
  0x3c00, 0x3e00, 0x3e00, 0x4000, 0x4000, 0x4100, 0x4100, 0x4200,
  0x3800, 0x3a00, 0x3a00, 0x3c00, 0x3c00, 0x3d00, 0x3d00, 0x3e00,
  0x3400, 0x3600, 0x3600, 0x3800, 0x3800, 0x3900, 0x3900, 0x3a00,
  0x3000, 0x3200, 0x3200, 0x3400, 0x3400, 0x3500, 0x3500, 0x3600,
  0x2c00, 0x2e00, 0x2e00, 0x3000, 0x3000, 0x3100, 0x3100, 0x3200,
  0x2800, 0x2a00, 0x2a00, 0x2c00, 0x2c00, 0x2d00, 0x2d00, 0x2e00,
  0x6a00, 0x6a00, 0x6c00, 0x6c00, 0x6d00, 0x6d00, 0x6e00, 0x6f00,
  0x6600, 0x6600, 0x6800, 0x6800, 0x6900, 0x6900, 0x6a00, 0x6b00,
  0x6200, 0x6200, 0x6400, 0x6400, 0x6500, 0x6500, 0x6600, 0x6700,
  0x5e00, 0x5e00, 0x6000, 0x6000, 0x6100, 0x6100, 0x6200, 0x6300,
  0x5a00, 0x5a00, 0x5c00, 0x5c00, 0x5d00, 0x5d00, 0x5e00, 0x5f00,
  0x5600, 0x5600, 0x5800, 0x5800, 0x5900, 0x5900, 0x5a00, 0x5b00,
  0x5200, 0x5200, 0x5400, 0x5400, 0x5500, 0x5500, 0x5600, 0x5700,
  0x4e00, 0x4e00, 0x5000, 0x5000, 0x5100, 0x5100, 0x5200, 0x5300,
  0x4a00, 0x4a00, 0x4c00, 0x4c00, 0x4d00, 0x4d00, 0x4e00, 0x4f00,
  0x4600, 0x4600, 0x4800, 0x4800, 0x4900, 0x4900, 0x4a00, 0x4b00,
  0x4200, 0x4200, 0x4400, 0x4400, 0x4500, 0x4500, 0x4600, 0x4700,
  0x3e00, 0x3e00, 0x4000, 0x4000, 0x4100, 0x4100, 0x4200, 0x4300,
  0x3a00, 0x3a00, 0x3c00, 0x3c00, 0x3d00, 0x3d00, 0x3e00, 0x3f00,
  0x3600, 0x3600, 0x3800, 0x3800, 0x3900, 0x3900, 0x3a00, 0x3b00,
  0x3200, 0x3200, 0x3400, 0x3400, 0x3500, 0x3500, 0x3600, 0x3700,
  0x2e00, 0x2e00, 0x3000, 0x3000, 0x3100, 0x3100, 0x3200, 0x3300,
  0x2a00, 0x2a00, 0x2c00, 0x2c00, 0x2d00, 0x2d00, 0x2e00, 0x2f00,
  0x6a00, 0x6c00, 0x6c00, 0x6d00, 0x6d00, 0x6e00, 0x6f00, 0x77f8,
  0x6600, 0x6800, 0x6800, 0x6900, 0x6900, 0x6a00, 0x6b00, 0x73f8,
  0x6200, 0x6400, 0x6400, 0x6500, 0x6500, 0x6600, 0x6700, 0x6ff8,
  0x5e00, 0x6000, 0x6000, 0x6100, 0x6100, 0x6200, 0x6300, 0x6bf8,
  0x5a00, 0x5c00, 0x5c00, 0x5d00, 0x5d00, 0x5e00, 0x5f00, 0x67f8,
  0x5600, 0x5800, 0x5800, 0x5900, 0x5900, 0x5a00, 0x5b00, 0x63f8,
  0x5200, 0x5400, 0x5400, 0x5500, 0x5500, 0x5600, 0x5700, 0x5ff8,
  0x4e00, 0x5000, 0x5000, 0x5100, 0x5100, 0x5200, 0x5300, 0x5bf8,
  0x4a00, 0x4c00, 0x4c00, 0x4d00, 0x4d00, 0x4e00, 0x4f00, 0x57f8,
  0x4600, 0x4800, 0x4800, 0x4900, 0x4900, 0x4a00, 0x4b00, 0x53f8,
  0x4200, 0x4400, 0x4400, 0x4500, 0x4500, 0x4600, 0x4700, 0x4ff8,
  0x3e00, 0x4000, 0x4000, 0x4100, 0x4100, 0x4200, 0x4300, 0x4bf8,
  0x3a00, 0x3c00, 0x3c00, 0x3d00, 0x3d00, 0x3e00, 0x3f00, 0x47f8,
  0x3600, 0x3800, 0x3800, 0x3900, 0x3900, 0x3a00, 0x3b00, 0x43f8,
  0x3200, 0x3400, 0x3400, 0x3500, 0x3500, 0x3600, 0x3700, 0x3ff8,
  0x2e00, 0x3000, 0x3000, 0x3100, 0x3100, 0x3200, 0x3300, 0x3bf8,
  0x2a00, 0x2c00, 0x2c00, 0x2d00, 0x2d00, 0x2e00, 0x2f00, 0x37f8,
  0x6c00, 0x6c00, 0x6d00, 0x6d00, 0x6e00, 0x6f00, 0x77f8, 0x77fc,
  0x6800, 0x6800, 0x6900, 0x6900, 0x6a00, 0x6b00, 0x73f8, 0x73fc,
  0x6400, 0x6400, 0x6500, 0x6500, 0x6600, 0x6700, 0x6ff8, 0x6ffc,
  0x6000, 0x6000, 0x6100, 0x6100, 0x6200, 0x6300, 0x6bf8, 0x6bfc,
  0x5c00, 0x5c00, 0x5d00, 0x5d00, 0x5e00, 0x5f00, 0x67f8, 0x67fc,
  0x5800, 0x5800, 0x5900, 0x5900, 0x5a00, 0x5b00, 0x63f8, 0x63fc,
  0x5400, 0x5400, 0x5500, 0x5500, 0x5600, 0x5700, 0x5ff8, 0x5ffc,
  0x5000, 0x5000, 0x5100, 0x5100, 0x5200, 0x5300, 0x5bf8, 0x5bfc,
  0x4c00, 0x4c00, 0x4d00, 0x4d00, 0x4e00, 0x4f00, 0x57f8, 0x57fc,
  0x4800, 0x4800, 0x4900, 0x4900, 0x4a00, 0x4b00, 0x53f8, 0x53fc,
  0x4400, 0x4400, 0x4500, 0x4500, 0x4600, 0x4700, 0x4ff8, 0x4ffc,
  0x4000, 0x4000, 0x4100, 0x4100, 0x4200, 0x4300, 0x4bf8, 0x4bfc,
  0x3c00, 0x3c00, 0x3d00, 0x3d00, 0x3e00, 0x3f00, 0x47f8, 0x47fc,
  0x3800, 0x3800, 0x3900, 0x3900, 0x3a00, 0x3b00, 0x43f8, 0x43fc,
  0x3400, 0x3400, 0x3500, 0x3500, 0x3600, 0x3700, 0x3ff8, 0x3ffc,
  0x3000, 0x3000, 0x3100, 0x3100, 0x3200, 0x3300, 0x3bf8, 0x3bfc,
  0x2c00, 0x2c00, 0x2d00, 0x2d00, 0x2e00, 0x2f00, 0x37f8, 0x37fc,
  0x6c00, 0x6d00, 0x6d00, 0x6e00, 0x6f00, 0x77f8, 0x77fc, 0x7800,
  0x6800, 0x6900, 0x6900, 0x6a00, 0x6b00, 0x73f8, 0x73fc, 0x7400,
  0x6400, 0x6500, 0x6500, 0x6600, 0x6700, 0x6ff8, 0x6ffc, 0x7000,
  0x6000, 0x6100, 0x6100, 0x6200, 0x6300, 0x6bf8, 0x6bfc, 0x6c00,
  0x5c00, 0x5d00, 0x5d00, 0x5e00, 0x5f00, 0x67f8, 0x67fc, 0x6800,
  0x5800, 0x5900, 0x5900, 0x5a00, 0x5b00, 0x63f8, 0x63fc, 0x6400,
  0x5400, 0x5500, 0x5500, 0x5600, 0x5700, 0x5ff8, 0x5ffc, 0x6000,
  0x5000, 0x5100, 0x5100, 0x5200, 0x5300, 0x5bf8, 0x5bfc, 0x5c00,
  0x4c00, 0x4d00, 0x4d00, 0x4e00, 0x4f00, 0x57f8, 0x57fc, 0x5800,
  0x4800, 0x4900, 0x4900, 0x4a00, 0x4b00, 0x53f8, 0x53fc, 0x5400,
  0x4400, 0x4500, 0x4500, 0x4600, 0x4700, 0x4ff8, 0x4ffc, 0x5000,
  0x4000, 0x4100, 0x4100, 0x4200, 0x4300, 0x4bf8, 0x4bfc, 0x4c00,
  0x3c00, 0x3d00, 0x3d00, 0x3e00, 0x3f00, 0x47f8, 0x47fc, 0x4800,
  0x3800, 0x3900, 0x3900, 0x3a00, 0x3b00, 0x43f8, 0x43fc, 0x4400,
  0x3400, 0x3500, 0x3500, 0x3600, 0x3700, 0x3ff8, 0x3ffc, 0x4000,
  0x3000, 0x3100, 0x3100, 0x3200, 0x3300, 0x3bf8, 0x3bfc, 0x3c00,
  0x2c00, 0x2d00, 0x2d00, 0x2e00, 0x2f00, 0x37f8, 0x37fc, 0x3800,
  0x6d00, 0x6d00, 0x6e00, 0x6f00, 0x77f8, 0x77fc, 0x7800, 0x7800,
  0x6900, 0x6900, 0x6a00, 0x6b00, 0x73f8, 0x73fc, 0x7400, 0x7400,
  0x6500, 0x6500, 0x6600, 0x6700, 0x6ff8, 0x6ffc, 0x7000, 0x7000,
  0x6100, 0x6100, 0x6200, 0x6300, 0x6bf8, 0x6bfc, 0x6c00, 0x6c00,
  0x5d00, 0x5d00, 0x5e00, 0x5f00, 0x67f8, 0x67fc, 0x6800, 0x6800,
  0x5900, 0x5900, 0x5a00, 0x5b00, 0x63f8, 0x63fc, 0x6400, 0x6400,
  0x5500, 0x5500, 0x5600, 0x5700, 0x5ff8, 0x5ffc, 0x6000, 0x6000,
  0x5100, 0x5100, 0x5200, 0x5300, 0x5bf8, 0x5bfc, 0x5c00, 0x5c00,
  0x4d00, 0x4d00, 0x4e00, 0x4f00, 0x57f8, 0x57fc, 0x5800, 0x5800,
  0x4900, 0x4900, 0x4a00, 0x4b00, 0x53f8, 0x53fc, 0x5400, 0x5400,
  0x4500, 0x4500, 0x4600, 0x4700, 0x4ff8, 0x4ffc, 0x5000, 0x5000,
  0x4100, 0x4100, 0x4200, 0x4300, 0x4bf8, 0x4bfc, 0x4c00, 0x4c00,
  0x3d00, 0x3d00, 0x3e00, 0x3f00, 0x47f8, 0x47fc, 0x4800, 0x4800,
  0x3900, 0x3900, 0x3a00, 0x3b00, 0x43f8, 0x43fc, 0x4400, 0x4400,
  0x3500, 0x3500, 0x3600, 0x3700, 0x3ff8, 0x3ffc, 0x4000, 0x4000,
  0x3100, 0x3100, 0x3200, 0x3300, 0x3bf8, 0x3bfc, 0x3c00, 0x3c00,
  0x2d00, 0x2d00, 0x2e00, 0x2f00, 0x37f8, 0x37fc, 0x3800, 0x3800,
  0x6d00, 0x6e00, 0x6f00, 0x77f8, 0x77fc, 0x7800, 0x7800, 0x7800,
  0x6900, 0x6a00, 0x6b00, 0x73f8, 0x73fc, 0x7400, 0x7400, 0x7400,
  0x6500, 0x6600, 0x6700, 0x6ff8, 0x6ffc, 0x7000, 0x7000, 0x7000,
  0x6100, 0x6200, 0x6300, 0x6bf8, 0x6bfc, 0x6c00, 0x6c00, 0x6c00,
  0x5d00, 0x5e00, 0x5f00, 0x67f8, 0x67fc, 0x6800, 0x6800, 0x6800,
  0x5900, 0x5a00, 0x5b00, 0x63f8, 0x63fc, 0x6400, 0x6400, 0x6400,
  0x5500, 0x5600, 0x5700, 0x5ff8, 0x5ffc, 0x6000, 0x6000, 0x6000,
  0x5100, 0x5200, 0x5300, 0x5bf8, 0x5bfc, 0x5c00, 0x5c00, 0x5c00,
  0x4d00, 0x4e00, 0x4f00, 0x57f8, 0x57fc, 0x5800, 0x5800, 0x5800,
  0x4900, 0x4a00, 0x4b00, 0x53f8, 0x53fc, 0x5400, 0x5400, 0x5400,
  0x4500, 0x4600, 0x4700, 0x4ff8, 0x4ffc, 0x5000, 0x5000, 0x5000,
  0x4100, 0x4200, 0x4300, 0x4bf8, 0x4bfc, 0x4c00, 0x4c00, 0x4c00,
  0x3d00, 0x3e00, 0x3f00, 0x47f8, 0x47fc, 0x4800, 0x4800, 0x4800,
  0x3900, 0x3a00, 0x3b00, 0x43f8, 0x43fc, 0x4400, 0x4400, 0x4400,
  0x3500, 0x3600, 0x3700, 0x3ff8, 0x3ffc, 0x4000, 0x4000, 0x4000,
  0x3100, 0x3200, 0x3300, 0x3bf8, 0x3bfc, 0x3c00, 0x3c00, 0x3c00,
  0x2d00, 0x2e00, 0x2f00, 0x37f8, 0x37fc, 0x3800, 0x3800, 0x3800,
  0x6e00, 0x6f00, 0x77f8, 0x77fc, 0x7800, 0x7800, 0x7800, 0x7820,
  0x6a00, 0x6b00, 0x73f8, 0x73fc, 0x7400, 0x7400, 0x7400, 0x7420,
  0x6600, 0x6700, 0x6ff8, 0x6ffc, 0x7000, 0x7000, 0x7000, 0x7020,
  0x6200, 0x6300, 0x6bf8, 0x6bfc, 0x6c00, 0x6c00, 0x6c00, 0x6c20,
  0x5e00, 0x5f00, 0x67f8, 0x67fc, 0x6800, 0x6800, 0x6800, 0x6820,
  0x5a00, 0x5b00, 0x63f8, 0x63fc, 0x6400, 0x6400, 0x6400, 0x6420,
  0x5600, 0x5700, 0x5ff8, 0x5ffc, 0x6000, 0x6000, 0x6000, 0x6020,
  0x5200, 0x5300, 0x5bf8, 0x5bfc, 0x5c00, 0x5c00, 0x5c00, 0x5c20,
  0x4e00, 0x4f00, 0x57f8, 0x57fc, 0x5800, 0x5800, 0x5800, 0x5820,
  0x4a00, 0x4b00, 0x53f8, 0x53fc, 0x5400, 0x5400, 0x5400, 0x5420,
  0x4600, 0x4700, 0x4ff8, 0x4ffc, 0x5000, 0x5000, 0x5000, 0x5020,
  0x4200, 0x4300, 0x4bf8, 0x4bfc, 0x4c00, 0x4c00, 0x4c00, 0x4c20,
  0x3e00, 0x3f00, 0x47f8, 0x47fc, 0x4800, 0x4800, 0x4800, 0x4820,
  0x3a00, 0x3b00, 0x43f8, 0x43fc, 0x4400, 0x4400, 0x4400, 0x4420,
  0x3600, 0x3700, 0x3ff8, 0x3ffc, 0x4000, 0x4000, 0x4000, 0x4020,
  0x3200, 0x3300, 0x3bf8, 0x3bfc, 0x3c00, 0x3c00, 0x3c00, 0x3c20,
  0x2e00, 0x2f00, 0x37f8, 0x37fc, 0x3800, 0x3800, 0x3800, 0x3820,
  0x6f00, 0x77f8, 0x77fc, 0x7800, 0x7800, 0x7800, 0x7820, 0x7820,
  0x6b00, 0x73f8, 0x73fc, 0x7400, 0x7400, 0x7400, 0x7420, 0x7420,
  0x6700, 0x6ff8, 0x6ffc, 0x7000, 0x7000, 0x7000, 0x7020, 0x7020,
  0x6300, 0x6bf8, 0x6bfc, 0x6c00, 0x6c00, 0x6c00, 0x6c20, 0x6c20,
  0x5f00, 0x67f8, 0x67fc, 0x6800, 0x6800, 0x6800, 0x6820, 0x6820,
  0x5b00, 0x63f8, 0x63fc, 0x6400, 0x6400, 0x6400, 0x6420, 0x6420,
  0x5700, 0x5ff8, 0x5ffc, 0x6000, 0x6000, 0x6000, 0x6020, 0x6020,
  0x5300, 0x5bf8, 0x5bfc, 0x5c00, 0x5c00, 0x5c00, 0x5c20, 0x5c20,
  0x4f00, 0x57f8, 0x57fc, 0x5800, 0x5800, 0x5800, 0x5820, 0x5820,
  0x4b00, 0x53f8, 0x53fc, 0x5400, 0x5400, 0x5400, 0x5420, 0x5420,
  0x4700, 0x4ff8, 0x4ffc, 0x5000, 0x5000, 0x5000, 0x5020, 0x5020,
  0x4300, 0x4bf8, 0x4bfc, 0x4c00, 0x4c00, 0x4c00, 0x4c20, 0x4c20,
  0x3f00, 0x47f8, 0x47fc, 0x4800, 0x4800, 0x4800, 0x4820, 0x4820,
  0x3b00, 0x43f8, 0x43fc, 0x4400, 0x4400, 0x4400, 0x4420, 0x4420,
  0x3700, 0x3ff8, 0x3ffc, 0x4000, 0x4000, 0x4000, 0x4020, 0x4020,
  0x3300, 0x3bf8, 0x3bfc, 0x3c00, 0x3c00, 0x3c00, 0x3c20, 0x3c20,
  0x2f00, 0x37f8, 0x37fc, 0x3800, 0x3800, 0x3800, 0x3820, 0x3820,
  0x77f8, 0x77fc, 0x7800, 0x7800, 0x7800, 0x7820, 0x7820, 0x7824,
  0x73f8, 0x73fc, 0x7400, 0x7400, 0x7400, 0x7420, 0x7420, 0x7424,
  0x6ff8, 0x6ffc, 0x7000, 0x7000, 0x7000, 0x7020, 0x7020, 0x7024,
  0x6bf8, 0x6bfc, 0x6c00, 0x6c00, 0x6c00, 0x6c20, 0x6c20, 0x6c24,
  0x67f8, 0x67fc, 0x6800, 0x6800, 0x6800, 0x6820, 0x6820, 0x6824,
  0x63f8, 0x63fc, 0x6400, 0x6400, 0x6400, 0x6420, 0x6420, 0x6424,
  0x5ff8, 0x5ffc, 0x6000, 0x6000, 0x6000, 0x6020, 0x6020, 0x6024,
  0x5bf8, 0x5bfc, 0x5c00, 0x5c00, 0x5c00, 0x5c20, 0x5c20, 0x5c24,
  0x57f8, 0x57fc, 0x5800, 0x5800, 0x5800, 0x5820, 0x5820, 0x5824,
  0x53f8, 0x53fc, 0x5400, 0x5400, 0x5400, 0x5420, 0x5420, 0x5424,
  0x4ff8, 0x4ffc, 0x5000, 0x5000, 0x5000, 0x5020, 0x5020, 0x5024,
  0x4bf8, 0x4bfc, 0x4c00, 0x4c00, 0x4c00, 0x4c20, 0x4c20, 0x4c24,
  0x47f8, 0x47fc, 0x4800, 0x4800, 0x4800, 0x4820, 0x4820, 0x4824,
  0x43f8, 0x43fc, 0x4400, 0x4400, 0x4400, 0x4420, 0x4420, 0x4424,
  0x3ff8, 0x3ffc, 0x4000, 0x4000, 0x4000, 0x4020, 0x4020, 0x4024,
  0x3bf8, 0x3bfc, 0x3c00, 0x3c00, 0x3c00, 0x3c20, 0x3c20, 0x3c24,
  0x37f8, 0x37fc, 0x3800, 0x3800, 0x3800, 0x3820, 0x3820, 0x3824,
  0x77fc, 0x7800, 0x7800, 0x7800, 0x7820, 0x7820, 0x7824, 0x7840,
  0x73fc, 0x7400, 0x7400, 0x7400, 0x7420, 0x7420, 0x7424, 0x7440,
  0x6ffc, 0x7000, 0x7000, 0x7000, 0x7020, 0x7020, 0x7024, 0x7040,
  0x6bfc, 0x6c00, 0x6c00, 0x6c00, 0x6c20, 0x6c20, 0x6c24, 0x6c40,
  0x67fc, 0x6800, 0x6800, 0x6800, 0x6820, 0x6820, 0x6824, 0x6840,
  0x63fc, 0x6400, 0x6400, 0x6400, 0x6420, 0x6420, 0x6424, 0x6440,
  0x5ffc, 0x6000, 0x6000, 0x6000, 0x6020, 0x6020, 0x6024, 0x6040,
  0x5bfc, 0x5c00, 0x5c00, 0x5c00, 0x5c20, 0x5c20, 0x5c24, 0x5c40,
  0x57fc, 0x5800, 0x5800, 0x5800, 0x5820, 0x5820, 0x5824, 0x5840,
  0x53fc, 0x5400, 0x5400, 0x5400, 0x5420, 0x5420, 0x5424, 0x5440,
  0x4ffc, 0x5000, 0x5000, 0x5000, 0x5020, 0x5020, 0x5024, 0x5040,
  0x4bfc, 0x4c00, 0x4c00, 0x4c00, 0x4c20, 0x4c20, 0x4c24, 0x4c40,
  0x47fc, 0x4800, 0x4800, 0x4800, 0x4820, 0x4820, 0x4824, 0x4840,
  0x43fc, 0x4400, 0x4400, 0x4400, 0x4420, 0x4420, 0x4424, 0x4440,
  0x3ffc, 0x4000, 0x4000, 0x4000, 0x4020, 0x4020, 0x4024, 0x4040,
  0x3bfc, 0x3c00, 0x3c00, 0x3c00, 0x3c20, 0x3c20, 0x3c24, 0x3c40,
  0x37fc, 0x3800, 0x3800, 0x3800, 0x3820, 0x3820, 0x3824, 0x3840,
  0x7800, 0x7800, 0x7800, 0x7820, 0x7820, 0x7824, 0x7840, 0x7840,
  0x7400, 0x7400, 0x7400, 0x7420, 0x7420, 0x7424, 0x7440, 0x7440,
  0x7000, 0x7000, 0x7000, 0x7020, 0x7020, 0x7024, 0x7040, 0x7040,
  0x6c00, 0x6c00, 0x6c00, 0x6c20, 0x6c20, 0x6c24, 0x6c40, 0x6c40,
  0x6800, 0x6800, 0x6800, 0x6820, 0x6820, 0x6824, 0x6840, 0x6840,
  0x6400, 0x6400, 0x6400, 0x6420, 0x6420, 0x6424, 0x6440, 0x6440,
  0x6000, 0x6000, 0x6000, 0x6020, 0x6020, 0x6024, 0x6040, 0x6040,
  0x5c00, 0x5c00, 0x5c00, 0x5c20, 0x5c20, 0x5c24, 0x5c40, 0x5c40,
  0x5800, 0x5800, 0x5800, 0x5820, 0x5820, 0x5824, 0x5840, 0x5840,
  0x5400, 0x5400, 0x5400, 0x5420, 0x5420, 0x5424, 0x5440, 0x5440,
  0x5000, 0x5000, 0x5000, 0x5020, 0x5020, 0x5024, 0x5040, 0x5040,
  0x4c00, 0x4c00, 0x4c00, 0x4c20, 0x4c20, 0x4c24, 0x4c40, 0x4c40,
  0x4800, 0x4800, 0x4800, 0x4820, 0x4820, 0x4824, 0x4840, 0x4840,
  0x4400, 0x4400, 0x4400, 0x4420, 0x4420, 0x4424, 0x4440, 0x4440,
  0x4000, 0x4000, 0x4000, 0x4020, 0x4020, 0x4024, 0x4040, 0x4040,
  0x3c00, 0x3c00, 0x3c00, 0x3c20, 0x3c20, 0x3c24, 0x3c40, 0x3c40,
  0x3800, 0x3800, 0x3800, 0x3820, 0x3820, 0x3824, 0x3840, 0x3840,
  0x7800, 0x7800, 0x7820, 0x7820, 0x7824, 0x7840, 0x7840, 0x7860,
  0x7400, 0x7400, 0x7420, 0x7420, 0x7424, 0x7440, 0x7440, 0x7460,
  0x7000, 0x7000, 0x7020, 0x7020, 0x7024, 0x7040, 0x7040, 0x7060,
  0x6c00, 0x6c00, 0x6c20, 0x6c20, 0x6c24, 0x6c40, 0x6c40, 0x6c60,
  0x6800, 0x6800, 0x6820, 0x6820, 0x6824, 0x6840, 0x6840, 0x6860,
  0x6400, 0x6400, 0x6420, 0x6420, 0x6424, 0x6440, 0x6440, 0x6460,
  0x6000, 0x6000, 0x6020, 0x6020, 0x6024, 0x6040, 0x6040, 0x6060,
  0x5c00, 0x5c00, 0x5c20, 0x5c20, 0x5c24, 0x5c40, 0x5c40, 0x5c60,
  0x5800, 0x5800, 0x5820, 0x5820, 0x5824, 0x5840, 0x5840, 0x5860,
  0x5400, 0x5400, 0x5420, 0x5420, 0x5424, 0x5440, 0x5440, 0x5460,
  0x5000, 0x5000, 0x5020, 0x5020, 0x5024, 0x5040, 0x5040, 0x5060,
  0x4c00, 0x4c00, 0x4c20, 0x4c20, 0x4c24, 0x4c40, 0x4c40, 0x4c60,
  0x4800, 0x4800, 0x4820, 0x4820, 0x4824, 0x4840, 0x4840, 0x4860,
  0x4400, 0x4400, 0x4420, 0x4420, 0x4424, 0x4440, 0x4440, 0x4460,
  0x4000, 0x4000, 0x4020, 0x4020, 0x4024, 0x4040, 0x4040, 0x4060,
  0x3c00, 0x3c00, 0x3c20, 0x3c20, 0x3c24, 0x3c40, 0x3c40, 0x3c60,
  0x3800, 0x3800, 0x3820, 0x3820, 0x3824, 0x3840, 0x3840, 0x3860,
  0x7800, 0x7820, 0x7820, 0x7824, 0x7840, 0x7840, 0x7860, 0x7860,
  0x7400, 0x7420, 0x7420, 0x7424, 0x7440, 0x7440, 0x7460, 0x7460,
  0x7000, 0x7020, 0x7020, 0x7024, 0x7040, 0x7040, 0x7060, 0x7060,
  0x6c00, 0x6c20, 0x6c20, 0x6c24, 0x6c40, 0x6c40, 0x6c60, 0x6c60,
  0x6800, 0x6820, 0x6820, 0x6824, 0x6840, 0x6840, 0x6860, 0x6860,
  0x6400, 0x6420, 0x6420, 0x6424, 0x6440, 0x6440, 0x6460, 0x6460,
  0x6000, 0x6020, 0x6020, 0x6024, 0x6040, 0x6040, 0x6060, 0x6060,
  0x5c00, 0x5c20, 0x5c20, 0x5c24, 0x5c40, 0x5c40, 0x5c60, 0x5c60,
  0x5800, 0x5820, 0x5820, 0x5824, 0x5840, 0x5840, 0x5860, 0x5860,
  0x5400, 0x5420, 0x5420, 0x5424, 0x5440, 0x5440, 0x5460, 0x5460,
  0x5000, 0x5020, 0x5020, 0x5024, 0x5040, 0x5040, 0x5060, 0x5060,
  0x4c00, 0x4c20, 0x4c20, 0x4c24, 0x4c40, 0x4c40, 0x4c60, 0x4c60,
  0x4800, 0x4820, 0x4820, 0x4824, 0x4840, 0x4840, 0x4860, 0x4860,
  0x4400, 0x4420, 0x4420, 0x4424, 0x4440, 0x4440, 0x4460, 0x4460,
  0x4000, 0x4020, 0x4020, 0x4024, 0x4040, 0x4040, 0x4060, 0x4060,
  0x3c00, 0x3c20, 0x3c20, 0x3c24, 0x3c40, 0x3c40, 0x3c60, 0x3c60,
  0x3800, 0x3820, 0x3820, 0x3824, 0x3840, 0x3840, 0x3860, 0x3860,
  0x7820, 0x7820, 0x7824, 0x7840, 0x7840, 0x7860, 0x7860, 0x7880,
  0x7420, 0x7420, 0x7424, 0x7440, 0x7440, 0x7460, 0x7460, 0x7480,
  0x7020, 0x7020, 0x7024, 0x7040, 0x7040, 0x7060, 0x7060, 0x7080,
  0x6c20, 0x6c20, 0x6c24, 0x6c40, 0x6c40, 0x6c60, 0x6c60, 0x6c80,
  0x6820, 0x6820, 0x6824, 0x6840, 0x6840, 0x6860, 0x6860, 0x6880,
  0x6420, 0x6420, 0x6424, 0x6440, 0x6440, 0x6460, 0x6460, 0x6480,
  0x6020, 0x6020, 0x6024, 0x6040, 0x6040, 0x6060, 0x6060, 0x6080,
  0x5c20, 0x5c20, 0x5c24, 0x5c40, 0x5c40, 0x5c60, 0x5c60, 0x5c80,
  0x5820, 0x5820, 0x5824, 0x5840, 0x5840, 0x5860, 0x5860, 0x5880,
  0x5420, 0x5420, 0x5424, 0x5440, 0x5440, 0x5460, 0x5460, 0x5480,
  0x5020, 0x5020, 0x5024, 0x5040, 0x5040, 0x5060, 0x5060, 0x5080,
  0x4c20, 0x4c20, 0x4c24, 0x4c40, 0x4c40, 0x4c60, 0x4c60, 0x4c80,
  0x4820, 0x4820, 0x4824, 0x4840, 0x4840, 0x4860, 0x4860, 0x4880,
  0x4420, 0x4420, 0x4424, 0x4440, 0x4440, 0x4460, 0x4460, 0x4480,
  0x4020, 0x4020, 0x4024, 0x4040, 0x4040, 0x4060, 0x4060, 0x4080,
  0x3c20, 0x3c20, 0x3c24, 0x3c40, 0x3c40, 0x3c60, 0x3c60, 0x3c80,
  0x3820, 0x3820, 0x3824, 0x3840, 0x3840, 0x3860, 0x3860, 0x3880,
  0x7820, 0x7824, 0x7840, 0x7840, 0x7860, 0x7860, 0x7880, 0x7880,
  0x7420, 0x7424, 0x7440, 0x7440, 0x7460, 0x7460, 0x7480, 0x7480,
  0x7020, 0x7024, 0x7040, 0x7040, 0x7060, 0x7060, 0x7080, 0x7080,
  0x6c20, 0x6c24, 0x6c40, 0x6c40, 0x6c60, 0x6c60, 0x6c80, 0x6c80,
  0x6820, 0x6824, 0x6840, 0x6840, 0x6860, 0x6860, 0x6880, 0x6880,
  0x6420, 0x6424, 0x6440, 0x6440, 0x6460, 0x6460, 0x6480, 0x6480,
  0x6020, 0x6024, 0x6040, 0x6040, 0x6060, 0x6060, 0x6080, 0x6080,
  0x5c20, 0x5c24, 0x5c40, 0x5c40, 0x5c60, 0x5c60, 0x5c80, 0x5c80,
  0x5820, 0x5824, 0x5840, 0x5840, 0x5860, 0x5860, 0x5880, 0x5880,
  0x5420, 0x5424, 0x5440, 0x5440, 0x5460, 0x5460, 0x5480, 0x5480,
  0x5020, 0x5024, 0x5040, 0x5040, 0x5060, 0x5060, 0x5080, 0x5080,
  0x4c20, 0x4c24, 0x4c40, 0x4c40, 0x4c60, 0x4c60, 0x4c80, 0x4c80,
  0x4820, 0x4824, 0x4840, 0x4840, 0x4860, 0x4860, 0x4880, 0x4880,
  0x4420, 0x4424, 0x4440, 0x4440, 0x4460, 0x4460, 0x4480, 0x4480,
  0x4020, 0x4024, 0x4040, 0x4040, 0x4060, 0x4060, 0x4080, 0x4080,
  0x3c20, 0x3c24, 0x3c40, 0x3c40, 0x3c60, 0x3c60, 0x3c80, 0x3c80,
  0x3820, 0x3824, 0x3840, 0x3840, 0x3860, 0x3860, 0x3880, 0x3880,
  0x7824, 0x7840, 0x7840, 0x7860, 0x7860, 0x7880, 0x7880, 0x78a0,
  0x7424, 0x7440, 0x7440, 0x7460, 0x7460, 0x7480, 0x7480, 0x74a0,
  0x7024, 0x7040, 0x7040, 0x7060, 0x7060, 0x7080, 0x7080, 0x70a0,
  0x6c24, 0x6c40, 0x6c40, 0x6c60, 0x6c60, 0x6c80, 0x6c80, 0x6ca0,
  0x6824, 0x6840, 0x6840, 0x6860, 0x6860, 0x6880, 0x6880, 0x68a0,
  0x6424, 0x6440, 0x6440, 0x6460, 0x6460, 0x6480, 0x6480, 0x64a0,
  0x6024, 0x6040, 0x6040, 0x6060, 0x6060, 0x6080, 0x6080, 0x60a0,
  0x5c24, 0x5c40, 0x5c40, 0x5c60, 0x5c60, 0x5c80, 0x5c80, 0x5ca0,
  0x5824, 0x5840, 0x5840, 0x5860, 0x5860, 0x5880, 0x5880, 0x58a0,
  0x5424, 0x5440, 0x5440, 0x5460, 0x5460, 0x5480, 0x5480, 0x54a0,
  0x5024, 0x5040, 0x5040, 0x5060, 0x5060, 0x5080, 0x5080, 0x50a0,
  0x4c24, 0x4c40, 0x4c40, 0x4c60, 0x4c60, 0x4c80, 0x4c80, 0x4ca0,
  0x4824, 0x4840, 0x4840, 0x4860, 0x4860, 0x4880, 0x4880, 0x48a0,
  0x4424, 0x4440, 0x4440, 0x4460, 0x4460, 0x4480, 0x4480, 0x44a0,
  0x4024, 0x4040, 0x4040, 0x4060, 0x4060, 0x4080, 0x4080, 0x40a0,
  0x3c24, 0x3c40, 0x3c40, 0x3c60, 0x3c60, 0x3c80, 0x3c80, 0x3ca0,
  0x3824, 0x3840, 0x3840, 0x3860, 0x3860, 0x3880, 0x3880, 0x38a0,
  0x7840, 0x7840, 0x7860, 0x7860, 0x7880, 0x7880, 0x78a0, 0x78a0,
  0x7440, 0x7440, 0x7460, 0x7460, 0x7480, 0x7480, 0x74a0, 0x74a0,
  0x7040, 0x7040, 0x7060, 0x7060, 0x7080, 0x7080, 0x70a0, 0x70a0,
  0x6c40, 0x6c40, 0x6c60, 0x6c60, 0x6c80, 0x6c80, 0x6ca0, 0x6ca0,
  0x6840, 0x6840, 0x6860, 0x6860, 0x6880, 0x6880, 0x68a0, 0x68a0,
  0x6440, 0x6440, 0x6460, 0x6460, 0x6480, 0x6480, 0x64a0, 0x64a0,
  0x6040, 0x6040, 0x6060, 0x6060, 0x6080, 0x6080, 0x60a0, 0x60a0,
  0x5c40, 0x5c40, 0x5c60, 0x5c60, 0x5c80, 0x5c80, 0x5ca0, 0x5ca0,
  0x5840, 0x5840, 0x5860, 0x5860, 0x5880, 0x5880, 0x58a0, 0x58a0,
  0x5440, 0x5440, 0x5460, 0x5460, 0x5480, 0x5480, 0x54a0, 0x54a0,
  0x5040, 0x5040, 0x5060, 0x5060, 0x5080, 0x5080, 0x50a0, 0x50a0,
  0x4c40, 0x4c40, 0x4c60, 0x4c60, 0x4c80, 0x4c80, 0x4ca0, 0x4ca0,
  0x4840, 0x4840, 0x4860, 0x4860, 0x4880, 0x4880, 0x48a0, 0x48a0,
  0x4440, 0x4440, 0x4460, 0x4460, 0x4480, 0x4480, 0x44a0, 0x44a0,
  0x4040, 0x4040, 0x4060, 0x4060, 0x4080, 0x4080, 0x40a0, 0x40a0,
  0x3c40, 0x3c40, 0x3c60, 0x3c60, 0x3c80, 0x3c80, 0x3ca0, 0x3ca0,
  0x3840, 0x3840, 0x3860, 0x3860, 0x3880, 0x3880, 0x38a0, 0x38a0,
  0x7840, 0x7860, 0x7860, 0x7880, 0x7880, 0x78a0, 0x78a0, 0x78c0,
  0x7440, 0x7460, 0x7460, 0x7480, 0x7480, 0x74a0, 0x74a0, 0x74c0,
  0x7040, 0x7060, 0x7060, 0x7080, 0x7080, 0x70a0, 0x70a0, 0x70c0,
  0x6c40, 0x6c60, 0x6c60, 0x6c80, 0x6c80, 0x6ca0, 0x6ca0, 0x6cc0,
  0x6840, 0x6860, 0x6860, 0x6880, 0x6880, 0x68a0, 0x68a0, 0x68c0,
  0x6440, 0x6460, 0x6460, 0x6480, 0x6480, 0x64a0, 0x64a0, 0x64c0,
  0x6040, 0x6060, 0x6060, 0x6080, 0x6080, 0x60a0, 0x60a0, 0x60c0,
  0x5c40, 0x5c60, 0x5c60, 0x5c80, 0x5c80, 0x5ca0, 0x5ca0, 0x5cc0,
  0x5840, 0x5860, 0x5860, 0x5880, 0x5880, 0x58a0, 0x58a0, 0x58c0,
  0x5440, 0x5460, 0x5460, 0x5480, 0x5480, 0x54a0, 0x54a0, 0x54c0,
  0x5040, 0x5060, 0x5060, 0x5080, 0x5080, 0x50a0, 0x50a0, 0x50c0,
  0x4c40, 0x4c60, 0x4c60, 0x4c80, 0x4c80, 0x4ca0, 0x4ca0, 0x4cc0,
  0x4840, 0x4860, 0x4860, 0x4880, 0x4880, 0x48a0, 0x48a0, 0x48c0,
  0x4440, 0x4460, 0x4460, 0x4480, 0x4480, 0x44a0, 0x44a0, 0x44c0,
  0x4040, 0x4060, 0x4060, 0x4080, 0x4080, 0x40a0, 0x40a0, 0x40c0,
  0x3c40, 0x3c60, 0x3c60, 0x3c80, 0x3c80, 0x3ca0, 0x3ca0, 0x3cc0,
  0x3840, 0x3860, 0x3860, 0x3880, 0x3880, 0x38a0, 0x38a0, 0x38c0,
  0x7860, 0x7860, 0x7880, 0x7880, 0x78a0, 0x78a0, 0x78c0, 0x78e0,
  0x7460, 0x7460, 0x7480, 0x7480, 0x74a0, 0x74a0, 0x74c0, 0x74e0,
  0x7060, 0x7060, 0x7080, 0x7080, 0x70a0, 0x70a0, 0x70c0, 0x70e0,
  0x6c60, 0x6c60, 0x6c80, 0x6c80, 0x6ca0, 0x6ca0, 0x6cc0, 0x6ce0,
  0x6860, 0x6860, 0x6880, 0x6880, 0x68a0, 0x68a0, 0x68c0, 0x68e0,
  0x6460, 0x6460, 0x6480, 0x6480, 0x64a0, 0x64a0, 0x64c0, 0x64e0,
  0x6060, 0x6060, 0x6080, 0x6080, 0x60a0, 0x60a0, 0x60c0, 0x60e0,
  0x5c60, 0x5c60, 0x5c80, 0x5c80, 0x5ca0, 0x5ca0, 0x5cc0, 0x5ce0,
  0x5860, 0x5860, 0x5880, 0x5880, 0x58a0, 0x58a0, 0x58c0, 0x58e0,
  0x5460, 0x5460, 0x5480, 0x5480, 0x54a0, 0x54a0, 0x54c0, 0x54e0,
  0x5060, 0x5060, 0x5080, 0x5080, 0x50a0, 0x50a0, 0x50c0, 0x50e0,
  0x4c60, 0x4c60, 0x4c80, 0x4c80, 0x4ca0, 0x4ca0, 0x4cc0, 0x4ce0,
  0x4860, 0x4860, 0x4880, 0x4880, 0x48a0, 0x48a0, 0x48c0, 0x48e0,
  0x4460, 0x4460, 0x4480, 0x4480, 0x44a0, 0x44a0, 0x44c0, 0x44e0,
  0x4060, 0x4060, 0x4080, 0x4080, 0x40a0, 0x40a0, 0x40c0, 0x40e0,
  0x3c60, 0x3c60, 0x3c80, 0x3c80, 0x3ca0, 0x3ca0, 0x3cc0, 0x3ce0,
  0x3860, 0x3860, 0x3880, 0x3880, 0x38a0, 0x38a0, 0x38c0, 0x38e0,
  0x7860, 0x7880, 0x7880, 0x78a0, 0x78a0, 0x78c0, 0x78e0, 0x7bfc,
  0x7460, 0x7480, 0x7480, 0x74a0, 0x74a0, 0x74c0, 0x74e0, 0x77fc,
  0x7060, 0x7080, 0x7080, 0x70a0, 0x70a0, 0x70c0, 0x70e0, 0x73fc,
  0x6c60, 0x6c80, 0x6c80, 0x6ca0, 0x6ca0, 0x6cc0, 0x6ce0, 0x6ffc,
  0x6860, 0x6880, 0x6880, 0x68a0, 0x68a0, 0x68c0, 0x68e0, 0x6bfc,
  0x6460, 0x6480, 0x6480, 0x64a0, 0x64a0, 0x64c0, 0x64e0, 0x67fc,
  0x6060, 0x6080, 0x6080, 0x60a0, 0x60a0, 0x60c0, 0x60e0, 0x63fc,
  0x5c60, 0x5c80, 0x5c80, 0x5ca0, 0x5ca0, 0x5cc0, 0x5ce0, 0x5ffc,
  0x5860, 0x5880, 0x5880, 0x58a0, 0x58a0, 0x58c0, 0x58e0, 0x5bfc,
  0x5460, 0x5480, 0x5480, 0x54a0, 0x54a0, 0x54c0, 0x54e0, 0x57fc,
  0x5060, 0x5080, 0x5080, 0x50a0, 0x50a0, 0x50c0, 0x50e0, 0x53fc,
  0x4c60, 0x4c80, 0x4c80, 0x4ca0, 0x4ca0, 0x4cc0, 0x4ce0, 0x4ffc,
  0x4860, 0x4880, 0x4880, 0x48a0, 0x48a0, 0x48c0, 0x48e0, 0x4bfc,
  0x4460, 0x4480, 0x4480, 0x44a0, 0x44a0, 0x44c0, 0x44e0, 0x47fc,
  0x4060, 0x4080, 0x4080, 0x40a0, 0x40a0, 0x40c0, 0x40e0, 0x43fc,
  0x3c60, 0x3c80, 0x3c80, 0x3ca0, 0x3ca0, 0x3cc0, 0x3ce0, 0x3ffc,
  0x3860, 0x3880, 0x3880, 0x38a0, 0x38a0, 0x38c0, 0x38e0, 0x3bfc,
  0x7880, 0x7880, 0x78a0, 0x78a0, 0x78c0, 0x78e0, 0x7bfc, 0x7bfe,
  0x7480, 0x7480, 0x74a0, 0x74a0, 0x74c0, 0x74e0, 0x77fc, 0x77fe,
  0x7080, 0x7080, 0x70a0, 0x70a0, 0x70c0, 0x70e0, 0x73fc, 0x73fe,
  0x6c80, 0x6c80, 0x6ca0, 0x6ca0, 0x6cc0, 0x6ce0, 0x6ffc, 0x6ffe,
  0x6880, 0x6880, 0x68a0, 0x68a0, 0x68c0, 0x68e0, 0x6bfc, 0x6bfe,
  0x6480, 0x6480, 0x64a0, 0x64a0, 0x64c0, 0x64e0, 0x67fc, 0x67fe,
  0x6080, 0x6080, 0x60a0, 0x60a0, 0x60c0, 0x60e0, 0x63fc, 0x63fe,
  0x5c80, 0x5c80, 0x5ca0, 0x5ca0, 0x5cc0, 0x5ce0, 0x5ffc, 0x5ffe,
  0x5880, 0x5880, 0x58a0, 0x58a0, 0x58c0, 0x58e0, 0x5bfc, 0x5bfe,
  0x5480, 0x5480, 0x54a0, 0x54a0, 0x54c0, 0x54e0, 0x57fc, 0x57fe,
  0x5080, 0x5080, 0x50a0, 0x50a0, 0x50c0, 0x50e0, 0x53fc, 0x53fe,
  0x4c80, 0x4c80, 0x4ca0, 0x4ca0, 0x4cc0, 0x4ce0, 0x4ffc, 0x4ffe,
  0x4880, 0x4880, 0x48a0, 0x48a0, 0x48c0, 0x48e0, 0x4bfc, 0x4bfe,
  0x4480, 0x4480, 0x44a0, 0x44a0, 0x44c0, 0x44e0, 0x47fc, 0x47fe,
  0x4080, 0x4080, 0x40a0, 0x40a0, 0x40c0, 0x40e0, 0x43fc, 0x43fe,
  0x3c80, 0x3c80, 0x3ca0, 0x3ca0, 0x3cc0, 0x3ce0, 0x3ffc, 0x3ffe,
  0x3880, 0x3880, 0x38a0, 0x38a0, 0x38c0, 0x38e0, 0x3bfc, 0x3bfe,
  0x7880, 0x78a0, 0x78a0, 0x78c0, 0x78e0, 0x7bfc, 0x7bfe, 0x7c00,
  0x7480, 0x74a0, 0x74a0, 0x74c0, 0x74e0, 0x77fc, 0x77fe, 0x7800,
  0x7080, 0x70a0, 0x70a0, 0x70c0, 0x70e0, 0x73fc, 0x73fe, 0x7400,
  0x6c80, 0x6ca0, 0x6ca0, 0x6cc0, 0x6ce0, 0x6ffc, 0x6ffe, 0x7000,
  0x6880, 0x68a0, 0x68a0, 0x68c0, 0x68e0, 0x6bfc, 0x6bfe, 0x6c00,
  0x6480, 0x64a0, 0x64a0, 0x64c0, 0x64e0, 0x67fc, 0x67fe, 0x6800,
  0x6080, 0x60a0, 0x60a0, 0x60c0, 0x60e0, 0x63fc, 0x63fe, 0x6400,
  0x5c80, 0x5ca0, 0x5ca0, 0x5cc0, 0x5ce0, 0x5ffc, 0x5ffe, 0x6000,
  0x5880, 0x58a0, 0x58a0, 0x58c0, 0x58e0, 0x5bfc, 0x5bfe, 0x5c00,
  0x5480, 0x54a0, 0x54a0, 0x54c0, 0x54e0, 0x57fc, 0x57fe, 0x5800,
  0x5080, 0x50a0, 0x50a0, 0x50c0, 0x50e0, 0x53fc, 0x53fe, 0x5400,
  0x4c80, 0x4ca0, 0x4ca0, 0x4cc0, 0x4ce0, 0x4ffc, 0x4ffe, 0x5000,
  0x4880, 0x48a0, 0x48a0, 0x48c0, 0x48e0, 0x4bfc, 0x4bfe, 0x4c00,
  0x4480, 0x44a0, 0x44a0, 0x44c0, 0x44e0, 0x47fc, 0x47fe, 0x4800,
  0x4080, 0x40a0, 0x40a0, 0x40c0, 0x40e0, 0x43fc, 0x43fe, 0x4400,
  0x3c80, 0x3ca0, 0x3ca0, 0x3cc0, 0x3ce0, 0x3ffc, 0x3ffe, 0x4000,
  0x3880, 0x38a0, 0x38a0, 0x38c0, 0x38e0, 0x3bfc, 0x3bfe, 0x3c00,
};
const unsigned kExpectedCount_NEON_ucvtf_8H_2OPIMM = 1020;

#endif  // VIXL_SIM_UCVTF_8H_2OPIMM_TRACE_AARCH64_H_
